/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.imports.MergeUtil;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.TranscriptionECVLoader;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import nl.mpi.util.FileUtility;

public class ImportTiersCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private List<TierImpl> tiersAdded;
    private List<LinguisticType> typesAdded;
    private List<ControlledVocabulary> cvsAdded;
    private List<LexiconLink> lexLinksAdded;
    private Map<String, Color> tierColorsAdded;
    private Map<String, Color> tierHighlightsAdded;
    private Map<String, Font> tierFontsAdded;
    private Map<String, Map<String, Map<String, Object>>> cvPrefsAdded;

    public ImportTiersCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.transcription == null) {
            ClientLogger.LOG.warning("The transcription is null.");
            return;
        }
        if (this.tiersAdded == null) {
            ClientLogger.LOG.warning("No tiers have been added.");
            return;
        }
        for (TierImpl t : this.tiersAdded) {
            this.transcription.removeTier(t);
        }
        for (LinguisticType lt : this.typesAdded) {
            this.transcription.removeLinguisticType(lt);
        }
        for (ControlledVocabulary cv : this.cvsAdded) {
            this.transcription.removeControlledVocabulary(cv);
        }
        for (LexiconLink ll : this.lexLinksAdded) {
            this.transcription.removeLexiconLink(ll);
        }
        this.removeImportedPreferences();
    }

    @Override
    public void redo() {
        if (this.transcription == null) {
            ClientLogger.LOG.warning("The transcription is null.");
            return;
        }
        if (this.tiersAdded == null) {
            ClientLogger.LOG.warning("No tiers can be added.");
            return;
        }
        for (LexiconLink ll : this.lexLinksAdded) {
            this.transcription.addLexiconLink(ll);
        }
        for (ControlledVocabulary cv : this.cvsAdded) {
            this.transcription.addControlledVocabulary(cv);
        }
        for (LinguisticType lt : this.typesAdded) {
            this.transcription.addLinguisticType(lt);
        }
        for (TierImpl t : this.tiersAdded) {
            this.transcription.addTier(t);
        }
        this.addImportedPreferences();
        Preferences.notifyListeners(this.transcription);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        String fileName = (String)arguments[0];
        if (fileName == null) {
            ClientLogger.LOG.warning("The filename is null");
            return;
        }
        fileName = FileUtility.pathToURLString(fileName).substring(5);
        TranscriptionImpl srcTrans = null;
        try {
            EAFSkeletonParser parser = new EAFSkeletonParser(fileName);
            parser.parse();
            List<TierImpl> tiers = parser.getTiers();
            List<String> tierOrder = parser.getTierOrder();
            List<LinguisticType> types = parser.getLinguisticTypes();
            List<ControlledVocabulary> cvs = parser.getControlledVocabularies();
            srcTrans = new TranscriptionImpl();
            srcTrans.setPathName(fileName);
            srcTrans.setLinguisticTypes(new ArrayList<LinguisticType>(types));
            for (int i = 0; i < tierOrder.size(); ++i) {
                String string = tierOrder.get(i);
                for (int j = 0; j < tiers.size(); ++j) {
                    TierImpl tierImpl = tiers.get(j);
                    if (!string.equals(tierImpl.getName())) continue;
                    srcTrans.addTier(tierImpl);
                }
            }
            for (ControlledVocabulary controlledVocabulary : cvs) {
                srcTrans.addControlledVocabulary(controlledVocabulary);
            }
        }
        catch (ParseException pe) {
            ClientLogger.LOG.warning(pe.getMessage());
            pe.printStackTrace();
            return;
        }
        ArrayList<TierImpl> currentTiers = new ArrayList<TierImpl>(this.transcription.getTiers());
        ArrayList<LinguisticType> currentTypes = new ArrayList<LinguisticType>(this.transcription.getLinguisticTypes());
        ArrayList<ControlledVocabulary> currentCvs = new ArrayList<ControlledVocabulary>(this.transcription.getControlledVocabularies());
        ArrayList currentLexLinks = new ArrayList(((HashMap)this.transcription.getLexiconLinks()).values());
        MergeUtil mergeUtil = new MergeUtil();
        List<TierImpl> tiersAddable = mergeUtil.getAddableTiers(srcTrans, this.transcription, null);
        if (tiersAddable == null || tiersAddable.size() == 0) {
            ClientLogger.LOG.warning("There are no tiers that can be imported");
            this.transcription.setNotifying(true);
            return;
        }
        tiersAddable = mergeUtil.sortTiers(tiersAddable);
        mergeUtil.addTiersTypesAndCVs(srcTrans, this.transcription, tiersAddable);
        this.tiersAdded = new ArrayList<TierImpl>();
        this.typesAdded = new ArrayList<LinguisticType>();
        this.cvsAdded = new ArrayList<ControlledVocabulary>();
        this.lexLinksAdded = new ArrayList<LexiconLink>();
        for (TierImpl t : this.transcription.getTiers()) {
            if (currentTiers.contains(t)) continue;
            this.tiersAdded.add(t);
        }
        for (LinguisticType lt : this.transcription.getLinguisticTypes()) {
            if (currentTypes.contains(lt)) continue;
            this.typesAdded.add(lt);
            if (lt.getLexiconQueryBundle() == null || currentLexLinks.contains(lt.getLexiconQueryBundle().getLink())) continue;
            this.transcription.addLexiconLink(lt.getLexiconQueryBundle().getLink());
            this.lexLinksAdded.add(lt.getLexiconQueryBundle().getLink());
        }
        TranscriptionECVLoader transcriptionECVLoader = new TranscriptionECVLoader();
        for (ControlledVocabulary controlledVocabulary : this.transcription.getControlledVocabularies()) {
            if (currentCvs.contains(controlledVocabulary)) continue;
            this.cvsAdded.add(controlledVocabulary);
            if (!(controlledVocabulary instanceof ExternalCV)) continue;
            transcriptionECVLoader.loadExternalCVs(this.transcription, null);
        }
        if (fileName.toLowerCase().endsWith(".etf")) {
            Preferences.importPreferences((Transcription)srcTrans, fileName.substring(0, fileName.lastIndexOf(46)) + ".pfsx");
        }
        if (!this.tiersAdded.isEmpty()) {
            Map<String, Font> map;
            Map<String, Color> map2;
            Map<String, Color> orgColors = Preferences.getMapOfColor("TierColors", srcTrans);
            if (orgColors != null) {
                for (TierImpl tierImpl : this.tiersAdded) {
                    Color c = orgColors.get(tierImpl.getName());
                    if (c == null) continue;
                    if (this.tierColorsAdded == null) {
                        this.tierColorsAdded = new HashMap<String, Color>(this.tiersAdded.size());
                    }
                    this.tierColorsAdded.put(tierImpl.getName(), c);
                }
            }
            if ((map2 = Preferences.getMapOfColor("TierHighlightColors", srcTrans)) != null) {
                for (TierImpl t : this.tiersAdded) {
                    Color c = map2.get(t.getName());
                    if (c == null) continue;
                    if (this.tierHighlightsAdded == null) {
                        this.tierHighlightsAdded = new HashMap<String, Color>(this.tiersAdded.size());
                    }
                    this.tierHighlightsAdded.put(t.getName(), c);
                }
            }
            if ((map = Preferences.getMapOfFont("TierFonts", srcTrans)) != null) {
                for (TierImpl t : this.tiersAdded) {
                    Font f = map.get(t.getName());
                    if (f == null) continue;
                    if (this.tierFontsAdded == null) {
                        this.tierFontsAdded = new HashMap<String, Font>(this.tiersAdded.size());
                    }
                    this.tierFontsAdded.put(t.getName(), f);
                }
            }
        }
        if (!this.cvsAdded.isEmpty()) {
            boolean bl;
            Map importPrefs = null;
            boolean bl2 = false;
            Object object = Preferences.get("CV.ML.Prefs", srcTrans);
            if (object instanceof Map) {
                importPrefs = (Map)object;
            } else {
                Object object2 = Preferences.get("CV.Prefs", srcTrans);
                if (object2 instanceof Map) {
                    importPrefs = (Map)object2;
                    bl = true;
                }
            }
            if (importPrefs != null) {
                for (ControlledVocabulary cv : this.cvsAdded) {
                    this.importPreferencesFor(importPrefs, cv, bl);
                }
            }
        }
        this.addImportedPreferences();
        Preferences.notifyListeners(this.transcription);
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void removeImportedPreferences() {
        HashMap cvPrefs;
        Map<String, Font> fonts;
        Map<String, Color> highlightColors;
        Iterator<String> tierIter;
        Map<String, Color> colors;
        if (this.tierColorsAdded != null && (colors = Preferences.getMapOfColor("TierColors", this.transcription)) != null) {
            tierIter = this.tierColorsAdded.keySet().iterator();
            while (tierIter.hasNext()) {
                colors.remove(tierIter.next());
            }
        }
        if (this.tierHighlightsAdded != null && (highlightColors = Preferences.getMapOfColor("TierHighlightColors", this.transcription)) != null) {
            tierIter = this.tierHighlightsAdded.keySet().iterator();
            while (tierIter.hasNext()) {
                highlightColors.remove(tierIter.next());
            }
        }
        if (this.tierFontsAdded != null && (fonts = Preferences.getMapOfFont("TierFonts", this.transcription)) != null) {
            tierIter = this.tierFontsAdded.keySet().iterator();
            while (tierIter.hasNext()) {
                fonts.remove(tierIter.next());
            }
        }
        if (this.cvPrefsAdded != null && (cvPrefs = (HashMap)Preferences.getMap("CV.ML.Prefs", this.transcription)) != null) {
            Iterator<String> cvPrefIter = this.cvPrefsAdded.keySet().iterator();
            while (cvPrefIter.hasNext()) {
                cvPrefs.remove(cvPrefIter.next());
            }
        }
        Preferences.notifyListeners(this.transcription);
    }

    private void addImportedPreferences() {
        if (this.tierColorsAdded != null) {
            Map<String, Color> colors = Preferences.getMapOfColor("TierColors", this.transcription);
            if (colors == null) {
                Preferences.set("TierColors", new HashMap<String, Color>(this.tierColorsAdded), (Transcription)this.transcription);
            } else {
                colors.putAll(this.tierColorsAdded);
            }
        }
        if (this.tierHighlightsAdded != null) {
            Map<String, Color> highlightColors = Preferences.getMapOfColor("TierHighlightColors", this.transcription);
            if (highlightColors == null) {
                Preferences.set("TierHighlightColors", new HashMap<String, Color>(this.tierHighlightsAdded), (Transcription)this.transcription);
            } else {
                highlightColors.putAll(this.tierHighlightsAdded);
            }
        }
        if (this.tierFontsAdded != null) {
            Map<String, Font> fonts = Preferences.getMapOfFont("TierFonts", this.transcription);
            if (fonts == null) {
                Preferences.set("TierFonts", new HashMap<String, Font>(this.tierFontsAdded), (Transcription)this.transcription);
            } else {
                fonts.putAll(this.tierFontsAdded);
            }
        }
        if (this.cvPrefsAdded != null) {
            HashMap<String, Map<String, Map<String, Object>>> cvPrefs = (HashMap<String, Map<String, Map<String, Object>>>)Preferences.getMap("CV.ML.Prefs", this.transcription);
            if (cvPrefs == null) {
                cvPrefs = new HashMap<String, Map<String, Map<String, Object>>>();
                Preferences.set("CV.ML.Prefs", cvPrefs, (Transcription)this.transcription);
            }
            cvPrefs.putAll(this.cvPrefsAdded);
        }
    }

    private void importPreferencesFor(Map<String, Object> importPrefs, ControlledVocabulary cv, boolean oldStylePrefs) {
        if (importPrefs != null && cv != null) {
            String color = "Color";
            String keyCode = "KeyCode";
            HashMap copyCVPref = new HashMap();
            HashMap copyEntPref = null;
            Map hm = (Map)importPrefs.get(cv.getName());
            if (hm != null) {
                for (CVEntry cve : cv) {
                    Object k;
                    String key = oldStylePrefs ? cve.getValue(0) : cve.getId();
                    Map entMap = (Map)hm.get(key);
                    if (entMap == null) continue;
                    Object c = entMap.get("Color");
                    if (c instanceof Color) {
                        cve.setPrefColor((Color)c);
                        if (copyEntPref == null) {
                            copyEntPref = new HashMap(3);
                        }
                        copyEntPref.put("Color", c);
                    }
                    if ((k = entMap.get("KeyCode")) instanceof Integer) {
                        cve.setShortcutKeyCode((Integer)k);
                        if (copyEntPref == null) {
                            copyEntPref = new HashMap(3);
                        }
                        copyEntPref.put("KeyCode", k);
                    }
                    if (copyEntPref == null) continue;
                    copyCVPref.put(cve.getId(), copyEntPref);
                }
                if (!copyCVPref.isEmpty()) {
                    if (this.cvPrefsAdded == null) {
                        this.cvPrefsAdded = new HashMap<String, Map<String, Map<String, Object>>>();
                    }
                    this.cvPrefsAdded.put(cv.getName(), copyCVPref);
                }
            }
        }
    }
}

