/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationDataRecordComparator;
import mpi.eudico.client.annotator.util.AnnotationValuesRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.TimeFormatter;

public class MergeTiersClasCommand
implements UndoableCommand {
    private List<ProgressListener> listeners;
    private String commandName;
    private TranscriptionImpl transcription;
    private TierImpl sourceTier1;
    private TierImpl sourceTier2;
    private TierImpl destTier;
    private boolean concatenate = true;
    private int timeFormat = 0;
    private boolean matchingValuesOnly = false;
    private boolean specificValueOnly = false;
    private String specificValue;
    private List<AnnotationValuesRecord> overlaps;
    private List<AnnotationDataRecord> annRecords;

    public MergeTiersClasCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        LinguisticType type;
        Integer tf;
        this.transcription = (TranscriptionImpl)receiver;
        String sourceName1 = (String)arguments[0];
        String sourceName2 = (String)arguments[1];
        Object destName = (String)arguments[2];
        String typeName = (String)arguments[3];
        Boolean ac = (Boolean)arguments[4];
        if (ac != null) {
            this.concatenate = ac;
        }
        if (arguments.length > 5 && (tf = (Integer)arguments[5]) != null) {
            this.timeFormat = tf;
        }
        if (arguments.length > 5 && arguments[6] instanceof Boolean) {
            this.matchingValuesOnly = (Boolean)arguments[6];
            if (this.matchingValuesOnly && arguments.length > 7) {
                this.specificValueOnly = (Boolean)arguments[7];
                this.specificValue = (String)arguments[8];
                if (this.specificValue == null) {
                    this.specificValue = "";
                }
            }
        }
        this.sourceTier1 = this.transcription.getTierWithId(sourceName1);
        this.sourceTier2 = this.transcription.getTierWithId(sourceName2);
        if (this.sourceTier1 == null || this.sourceTier2 == null) {
            this.progressInterrupt("One of the sourcetiers could not be found");
            return;
        }
        if (destName == null) {
            destName = "Overlap";
            ClientLogger.LOG.warning("Name of destination tier is null, changed to Overlap");
        }
        this.destTier = this.transcription.getTierWithId((String)destName);
        if (this.destTier != null) {
            int count = 1;
            String cName = (String)destName + "-";
            while (this.destTier != null) {
                cName = cName + count;
                this.destTier = this.transcription.getTierWithId(cName);
                ++count;
            }
            ClientLogger.LOG.warning("Tier " + (String)destName + " already exists, changed name to " + cName);
            destName = cName;
        }
        if ((type = this.transcription.getLinguisticTypeByName(typeName)) == null) {
            for (int i = 0; i < this.transcription.getLinguisticTypes().size(); ++i) {
                LinguisticType countType = this.transcription.getLinguisticTypes().get(i);
                if (countType.getConstraints() != null) continue;
                ClientLogger.LOG.warning("LinguisticType " + typeName + " could not be found, using " + countType.getLinguisticTypeName() + " instead.");
                type = countType;
                typeName = type.getLinguisticTypeName();
                break;
            }
        }
        this.destTier = new TierImpl(null, (String)destName, null, this.transcription, type);
        this.transcription.addTier(this.destTier);
        this.overlaps = new ArrayList<AnnotationValuesRecord>();
        this.progressUpdate(8, "Created tier: " + (String)destName);
        MergeThread calcThread = new MergeThread(MergeTiersClasCommand.class.getName());
        try {
            calcThread.start();
        }
        catch (Exception exc) {
            this.transcription.setNotifying(true);
            ClientLogger.LOG.severe("Exception in calculation of overlaps: " + exc.getMessage());
            this.progressInterrupt("An exception occurred: " + exc.getMessage());
        }
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.destTier != null) {
            this.setWaitCursor(true);
            this.transcription.removeTier(this.destTier);
            this.setWaitCursor(false);
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null && this.destTier != null) {
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.setWaitCursor(true);
            if (this.transcription.getTierWithId(this.destTier.getName()) == null) {
                this.transcription.addTier(this.destTier);
            }
            if (this.annRecords != null && this.annRecords.size() > 0) {
                this.transcription.setNotifying(false);
                for (int i = 0; i < this.annRecords.size(); ++i) {
                    AnnotationDataRecord record = this.annRecords.get(i);
                    Annotation ann = this.destTier.createAnnotation(record.getBeginTime(), record.getEndTime());
                    if (ann == null || record.getValue() == null) continue;
                    ann.setValue(record.getValue());
                }
                this.transcription.setNotifying(true);
            }
            this.setWaitCursor(false);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ProgressListener>(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressInterrupted(this, message);
            }
        }
    }

    private class MergeThread
    extends Thread {
        public MergeThread() {
        }

        public MergeThread(String name) {
            super(name);
        }

        @Override
        public void interrupt() {
            super.interrupt();
            MergeTiersClasCommand.this.progressInterrupt("Operation interrupted...");
        }

        @Override
        public void run() {
            MergeTiersClasCommand.this.transcription.setNotifying(false);
            int curPropMode = 0;
            curPropMode = MergeTiersClasCommand.this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                MergeTiersClasCommand.this.transcription.setTimeChangePropagationMode(0);
            }
            float perAnn = 50.0f;
            ArrayList<AbstractAnnotation> sourceAnns1 = new ArrayList<AbstractAnnotation>(MergeTiersClasCommand.this.sourceTier1.getAnnotations());
            int numAnns1 = sourceAnns1.size();
            ArrayList<AbstractAnnotation> sourceAnns2 = new ArrayList<AbstractAnnotation>(MergeTiersClasCommand.this.sourceTier2.getAnnotations());
            int numAnns2 = sourceAnns2.size();
            AbstractAnnotation ann1 = null;
            AnnotationValuesRecord curRecord = null;
            MergeTiersClasCommand.this.progressUpdate(10, "Merging annotations...");
            if (MergeTiersClasCommand.this.matchingValuesOnly) {
                AbstractAnnotation ann2 = null;
                int j = 0;
                if (numAnns1 > 0) {
                    perAnn /= (float)numAnns1;
                }
                for (int i = 0; i < numAnns1; ++i) {
                    ann1 = sourceAnns1.get(i);
                    long bt1 = ann1.getBeginTimeBoundary();
                    long et1 = ann1.getEndTimeBoundary();
                    while (j < numAnns2) {
                        ann2 = sourceAnns2.get(j);
                        long bt2 = ann2.getBeginTimeBoundary();
                        long et2 = ann2.getEndTimeBoundary();
                        if (et2 > bt1) {
                            if (bt2 >= et1) {
                                if (j <= 0) break;
                                --j;
                                break;
                            }
                            long obt = bt1 <= bt2 ? bt1 : bt2;
                            long oet = et1 <= et2 ? et2 : et1;
                            if (!MergeTiersClasCommand.this.specificValueOnly) {
                                if (ann1.getValue() == null && ann2.getValue() == null || ann1.getValue() != null && ann2.getValue() != null && ann1.getValue().length() == 0 && ann2.getValue().length() == 0 || ann1.getValue().equals(ann2.getValue())) {
                                    MergeTiersClasCommand.this.overlaps.add(new AnnotationValuesRecord(MergeTiersClasCommand.this.sourceTier1.getName(), ann1.getValue(), obt, oet));
                                }
                            } else if (ann1.getValue() != null && ann2.getValue() != null && ann1.getValue().equals(MergeTiersClasCommand.this.specificValue) && ann2.getValue().equals(MergeTiersClasCommand.this.specificValue)) {
                                MergeTiersClasCommand.this.overlaps.add(new AnnotationValuesRecord(MergeTiersClasCommand.this.sourceTier1.getName(), MergeTiersClasCommand.this.specificValue, obt, oet));
                            }
                        }
                        ++j;
                    }
                    MergeTiersClasCommand.this.progressUpdate((int)(10.0f + (float)i * perAnn), null);
                }
                Collections.sort(MergeTiersClasCommand.this.overlaps, new AnnotationDataRecordComparator());
                perAnn = 18.0f;
                if (MergeTiersClasCommand.this.overlaps.size() > 0) {
                    perAnn = 18.0f / (float)MergeTiersClasCommand.this.overlaps.size();
                }
                AnnotationValuesRecord prevRecord = null;
                for (int i = 0; i < MergeTiersClasCommand.this.overlaps.size(); ++i) {
                    curRecord = (AnnotationValuesRecord)MergeTiersClasCommand.this.overlaps.get(i);
                    if (prevRecord == null) {
                        prevRecord = curRecord;
                        continue;
                    }
                    if (curRecord.getBeginTime() < prevRecord.getEndTime()) {
                        if (prevRecord.getValue() != null && prevRecord.getValue().equals(prevRecord.getValue())) {
                            prevRecord.setEndTime(Math.max(prevRecord.getEndTime(), curRecord.getEndTime()));
                            MergeTiersClasCommand.this.overlaps.remove(i);
                            --i;
                        } else {
                            prevRecord.setEndTime(curRecord.getBeginTime());
                            if (prevRecord.getBeginTime() >= prevRecord.getEndTime()) {
                                MergeTiersClasCommand.this.overlaps.remove(prevRecord);
                                --i;
                            }
                            prevRecord = curRecord;
                        }
                    } else {
                        prevRecord = curRecord;
                    }
                    MergeTiersClasCommand.this.progressUpdate((int)(60.0f + (float)i * perAnn), null);
                }
            } else {
                int i;
                int annCount = 2 * (MergeTiersClasCommand.this.sourceTier1.getNumberOfAnnotations() + MergeTiersClasCommand.this.sourceTier2.getNumberOfAnnotations());
                if (annCount > 0) {
                    perAnn = 50.0f / (float)annCount;
                }
                int count = 0;
                for (i = 0; i < numAnns1; ++i) {
                    ann1 = sourceAnns1.get(i);
                    curRecord = new AnnotationValuesRecord(ann1);
                    MergeTiersClasCommand.this.overlaps.add(curRecord);
                    MergeTiersClasCommand.this.progressUpdate((int)(10.0f + (float)count++ * perAnn), null);
                }
                for (i = 0; i < numAnns2; ++i) {
                    ann1 = sourceAnns2.get(i);
                    curRecord = new AnnotationValuesRecord(ann1);
                    MergeTiersClasCommand.this.overlaps.add(curRecord);
                    MergeTiersClasCommand.this.progressUpdate((int)(10.0f + (float)count++ * perAnn), null);
                }
                Collections.sort(MergeTiersClasCommand.this.overlaps, new AnnotationDataRecordComparator());
                perAnn = 18.0f;
                if (MergeTiersClasCommand.this.overlaps.size() > 0) {
                    perAnn = 18.0f / (float)MergeTiersClasCommand.this.overlaps.size();
                }
                AnnotationValuesRecord prevRecord = null;
                for (int i2 = 0; i2 < MergeTiersClasCommand.this.overlaps.size(); ++i2) {
                    curRecord = (AnnotationValuesRecord)MergeTiersClasCommand.this.overlaps.get(i2);
                    if (prevRecord == null) {
                        prevRecord = curRecord;
                        continue;
                    }
                    if (curRecord.getBeginTime() < prevRecord.getEndTime()) {
                        prevRecord.setEndTime(Math.max(prevRecord.getEndTime(), curRecord.getEndTime()));
                        if (prevRecord.getNewLabelValue() == null) {
                            prevRecord.setNewLabelValue(prevRecord.getValue() + " " + curRecord.getValue());
                        } else {
                            prevRecord.setNewLabelValue(prevRecord.getNewLabelValue() + " " + curRecord.getValue());
                        }
                        MergeTiersClasCommand.this.overlaps.remove(i2);
                        --i2;
                    } else {
                        prevRecord = curRecord;
                    }
                    MergeTiersClasCommand.this.progressUpdate((int)(60.0f + (float)i2 * perAnn), null);
                }
            }
            MergeTiersClasCommand.this.progressUpdate(78, "Creating annotations...");
            MergeTiersClasCommand.this.annRecords = new ArrayList(MergeTiersClasCommand.this.overlaps.size());
            for (int i = 0; i < MergeTiersClasCommand.this.overlaps.size(); ++i) {
                curRecord = (AnnotationValuesRecord)MergeTiersClasCommand.this.overlaps.get(i);
                Annotation ann = MergeTiersClasCommand.this.destTier.createAnnotation(curRecord.getBeginTime(), curRecord.getEndTime());
                if (ann != null) {
                    if (MergeTiersClasCommand.this.concatenate) {
                        ann.setValue(curRecord.getNewLabelValue() != null ? curRecord.getNewLabelValue() : curRecord.getValue());
                    } else {
                        switch (MergeTiersClasCommand.this.timeFormat) {
                            case 102: {
                                ann.setValue(String.valueOf(curRecord.getEndTime() - curRecord.getBeginTime()));
                                break;
                            }
                            case 101: {
                                ann.setValue(TimeFormatter.toSSMSString(curRecord.getEndTime() - curRecord.getBeginTime()));
                                break;
                            }
                            case 100: {
                                ann.setValue(TimeFormatter.toString(curRecord.getEndTime() - curRecord.getBeginTime()));
                            }
                        }
                    }
                    MergeTiersClasCommand.this.annRecords.add(new AnnotationDataRecord(ann));
                }
                MergeTiersClasCommand.this.progressUpdate((int)(78.0f + (float)i * perAnn), null);
            }
            MergeTiersClasCommand.this.transcription.setTimeChangePropagationMode(curPropMode);
            MergeTiersClasCommand.this.transcription.setNotifying(true);
            MergeTiersClasCommand.this.progressComplete("Operation complete...");
        }
    }
}

