/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.Locale;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.tier.MergeTiers;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class MergeTiersUndoableCommand
extends MergeTiers
implements UndoableCommand {
    private String tierParentTier;
    private String tierParticipant;
    private String tierAnnotator;
    private String tierLingTypeName;
    private Locale tierDefaultLocale;
    private String tierLangRef;

    public MergeTiersUndoableCommand(String name) {
        super(name);
    }

    @Override
    public void redo() {
        if (this.transcription != null) {
            TierImpl dt = this.transcription.getTierWithId(this.destTierName);
            if (dt == null) {
                LinguisticType lType;
                TierImpl parent = null;
                if (this.tierParentTier != null) {
                    parent = this.transcription.getTierWithId(this.tierParentTier);
                }
                if ((lType = this.transcription.getLinguisticTypeByName(this.tierLingTypeName)) == null) {
                    ClientLogger.LOG.severe("Cannot find Linguistic Type '" + this.tierLingTypeName + "'to restore");
                    return;
                }
                TierImpl dTier = new TierImpl(parent, this.destTierName, this.tierParticipant, this.transcription, lType);
                dTier.setAnnotator(this.tierAnnotator);
                dTier.setDefaultLocale(this.tierDefaultLocale);
                dTier.setLangRef(this.tierLangRef);
                this.transcription.addTier(dTier);
                dt = dTier;
            }
            if (this.createdAnnos == null || this.createdAnnos.size() == 0) {
                ClientLogger.LOG.info("No annotations to restore");
                return;
            }
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.transcription.setNotifying(false);
            for (int i = 0; i < this.createdAnnos.size(); ++i) {
                AnnotationDataRecord record = (AnnotationDataRecord)this.createdAnnos.get(i);
                Annotation ann = dt.createAnnotation(record.getBeginTime(), record.getEndTime());
                if (ann != null && record.getValue() != null) {
                    ann.setValue(record.getValue());
                }
                if (record.getCvEntryId() == null) continue;
                ann.setCVEntryId(record.getCvEntryId());
            }
            this.transcription.setNotifying(true);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    @Override
    public void undo() {
        if (this.transcription != null) {
            if (this.destTierCreated) {
                TierImpl dt = this.transcription.getTierWithId(this.destTierName);
                if (dt != null) {
                    this.tierParentTier = dt.hasParentTier() ? dt.getParentTier().getName() : null;
                    this.tierParticipant = dt.getParticipant();
                    this.tierAnnotator = dt.getAnnotator();
                    this.tierLingTypeName = dt.getLinguisticType().getLinguisticTypeName();
                    this.tierLangRef = dt.getLangRef();
                    this.tierDefaultLocale = dt.getDefaultLocale();
                    this.transcription.removeTier(dt);
                }
            } else {
                TierImpl st = this.transcription.getTierWithId(this.destTierName);
                if (st != null && this.createdAnnos != null && this.createdAnnos.size() > 0) {
                    this.transcription.setNotifying(false);
                    for (int i = 0; i < this.createdAnnos.size(); ++i) {
                        AnnotationDataRecord record = (AnnotationDataRecord)this.createdAnnos.get(i);
                        Annotation ann = st.getAnnotationAtTime((record.getBeginTime() + record.getEndTime()) / 2L);
                        if (ann == null) continue;
                        st.removeAnnotation(ann);
                    }
                    this.transcription.setNotifying(true);
                }
            }
        }
    }
}

