/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.List;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;

public class NewAnnotationCA
extends CommandAction {
    private TierImpl receiver;
    private long beginTime;
    private long endTime;

    public NewAnnotationCA(ViewerManager2 viewerManager) {
        super(viewerManager, "Menu.Annotation.NewAnnotation");
    }

    public NewAnnotationCA(ViewerManager2 viewerManager, String commandName) {
        super(viewerManager, commandName);
    }

    @Override
    protected void newCommand() {
        this.command = null;
        if (this.checkState() && this.receiver != null) {
            Boolean val = Preferences.getBool("CreateDependingAnnotations", null);
            this.command = val != null ? (val.booleanValue() ? ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.Annotation.NewAnnotationRecursive") : ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.Annotation.NewAnnotation")) : ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.Annotation.NewAnnotation");
        }
    }

    @Override
    protected Object getReceiver() {
        return this.receiver;
    }

    @Override
    protected Object[] getArguments() {
        Object[] args = new Object[]{this.beginTime, this.endTime};
        return args;
    }

    protected boolean checkState() {
        this.receiver = null;
        this.beginTime = 0L;
        this.endTime = 0L;
        if (this.vm.getSelection() == null) {
            return false;
        }
        if (this.vm.getMultiTierControlPanel() != null && this.vm.getMultiTierControlPanel().getActiveTier() != null) {
            this.receiver = (TierImpl)this.vm.getMultiTierControlPanel().getActiveTier();
            if (this.vm.getSelection().getBeginTime() != this.vm.getSelection().getEndTime()) {
                this.beginTime = this.vm.getSelection().getBeginTime();
                this.endTime = this.vm.getSelection().getEndTime();
                if (this.receiver.isTimeAlignable()) {
                    return true;
                }
                Constraint c = null;
                if (this.receiver.getLinguisticType() != null) {
                    c = this.receiver.getLinguisticType().getConstraints();
                }
                if (this.receiver.getParentTier() != null && c != null && (c.getStereoType() == 4 || c.getStereoType() == 3)) {
                    long time = (this.beginTime + this.endTime) / 2L;
                    Annotation refA = this.receiver.getParentTier().getAnnotationAtTime(time);
                    Annotation curA = this.receiver.getAnnotationAtTime(time);
                    if (refA != null && curA == null) {
                        this.beginTime = time;
                        this.endTime = time;
                        return true;
                    }
                    if (refA != null) {
                        JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.vm.getTranscription()), ElanLocale.getString("Message.ExistingAnnotation"), ElanLocale.getString("Message.Warning"), 2);
                    } else {
                        JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.vm.getTranscription()), ElanLocale.getString("Message.NoParent"), ElanLocale.getString("Message.Warning"), 2);
                    }
                }
            } else if (this.vm.getActiveAnnotation() != null && this.vm.getActiveAnnotation().getAnnotation() != null) {
                long time;
                Annotation activeAnn = this.vm.getActiveAnnotation().getAnnotation();
                if (activeAnn.getTier() == this.receiver) {
                    return false;
                }
                List<TierImpl> depTiers = ((TierImpl)activeAnn.getTier()).getDependentTiers();
                if (depTiers == null || depTiers.isEmpty() || !depTiers.contains(this.receiver)) {
                    return false;
                }
                Constraint con = null;
                if (this.receiver.getLinguisticType() != null) {
                    con = this.receiver.getLinguisticType().getConstraints();
                }
                if (con != null && (con.getStereoType() == 4 || con.getStereoType() == 3) && this.receiver.getAnnotationAtTime(time = (activeAnn.getBeginTimeBoundary() + activeAnn.getEndTimeBoundary()) / 2L) == null) {
                    this.beginTime = time;
                    this.endTime = time;
                    return true;
                }
            }
        }
        this.receiver = null;
        return false;
    }
}

