/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.UrlOpener;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;

public class ShowInBrowserCommand
implements Command {
    private String commandName;

    public ShowInBrowserCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        block8: {
            Annotation annotation;
            if (arguments[0] instanceof Annotation && ShowInBrowserCommand.hasBrowserLinkInECV(annotation = (Annotation)arguments[0]).booleanValue()) {
                String entryId = annotation.getCVEntryId();
                if (entryId.startsWith("gloss")) {
                    entryId = entryId.substring(5);
                }
                String cvName = annotation.getTier().getLinguisticType().getControlledVocabularyName();
                ExternalCV ecv = (ExternalCV)annotation.getTier().getTranscription().getControlledVocabulary(cvName);
                CVEntry cvEntry = ecv.getEntrybyId(entryId);
                ExternalReference extRef = cvEntry.getExternalRef();
                if (extRef.getReferenceType() == 3) {
                    Object baseUrlString = extRef.getValue();
                    if (!((String)baseUrlString).endsWith("/")) {
                        baseUrlString = (String)baseUrlString + "/";
                    }
                    String urlString = (String)baseUrlString + entryId;
                    ClientLogger.LOG.info(urlString);
                    try {
                        new URL(urlString);
                        UrlOpener.openUrl(urlString);
                    }
                    catch (MalformedURLException e) {
                        if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                            ClientLogger.LOG.warning("The url " + urlString + " is malformed (" + e.getMessage() + ")");
                        }
                    }
                    catch (Exception e) {
                        if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block8;
                        ClientLogger.LOG.warning("The url " + urlString + " could not be opened (" + e.getMessage() + ")");
                    }
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    public static Boolean hasBrowserLinkInECV(Annotation annotation) {
        String baseUrlString;
        ExternalCV ecv;
        CVEntry cvEntry;
        ExternalReference extRef;
        ControlledVocabulary cv;
        String cvName = annotation.getTier().getLinguisticType().getControlledVocabularyName();
        if (cvName != null && (cv = annotation.getTier().getTranscription().getControlledVocabulary(cvName)) instanceof ExternalCV && (extRef = (cvEntry = (ecv = (ExternalCV)cv).getEntries()[0]).getExternalRef()) != null && extRef.getReferenceType() == 3 && (baseUrlString = extRef.getValue()) != null && !baseUrlString.equals("")) {
            return true;
        }
        return false;
    }
}

