/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.SaveAs27Preferences;
import mpi.eudico.client.annotator.commands.BackupCA;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.timeseries.io.TSConfigurationEncoder;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import nl.mpi.util.FileExtension;
import nl.mpi.util.FileUtility;

public class StoreCommand
implements Command {
    private String commandName;

    public StoreCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        boolean saveWillLose;
        boolean updateFileName;
        int f;
        TranscriptionImpl tr = (TranscriptionImpl)receiver;
        TranscriptionStore eafTranscriptionStore = (TranscriptionStore)arguments[0];
        boolean saveAsTemplate = (Boolean)arguments[1];
        boolean saveNewCopy = (Boolean)arguments[2];
        ArrayList<TierImpl> visibleTiers = arguments[3] != null ? (arguments[3] instanceof List ? (ArrayList<TierImpl>)arguments[3] : new ArrayList<TierImpl>(0)) : (ELANCommandFactory.getViewerManager(tr).getMultiTierControlPanel() != null ? ELANCommandFactory.getViewerManager(tr).getMultiTierControlPanel().getVisibleTiers() : new ArrayList<TierImpl>(0));
        int format = 0;
        if (arguments.length > 4 && ((f = ((Integer)arguments[4]).intValue()) == 0 || f == 4)) {
            format = f;
        }
        boolean bl = updateFileName = format == 0;
        if (format == 0) {
            format = SaveAs27Preferences.saveAsType(tr);
        }
        if (format == 4 && (saveWillLose = SaveAs27Preferences.savingWillLoseInformation(tr)) && !SaveAs27Preferences.askIfLosingInformationIsOk()) {
            return;
        }
        if (saveNewCopy) {
            FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(tr));
            if (saveAsTemplate) {
                chooser.createAndShowFileDialog(ElanLocale.getString("SaveDialog.Template.Title"), 1, FileExtension.TEMPLATE_EXT, "LastUsedEAFDir");
            } else {
                Object fileName = tr.getName();
                if (!((String)fileName).equals("aishug294879ryshfda9763afo8947a5gf")) {
                    String filePath = FileUtility.urlToAbsPath(tr.getFullPath());
                    chooser.setCurrentDirectory(filePath.substring(0, filePath.indexOf((String)fileName)));
                    int dotIndex = ((String)fileName).lastIndexOf(46);
                    fileName = dotIndex > 1 ? ((String)fileName).substring(0, dotIndex) + ".eaf" : (String)fileName + ".eaf";
                    chooser.createAndShowFileDialog(ElanLocale.getString("SaveDialog.Title"), 1, null, FileExtension.EAF_EXT, null, (String)fileName);
                } else {
                    chooser.createAndShowFileDialog(ElanLocale.getString("SaveDialog.Title"), 1, FileExtension.EAF_EXT, "LastUsedEAFDir");
                }
            }
            File f2 = chooser.getSelectedFile();
            if (f2 != null) {
                String pathName = f2.getAbsolutePath();
                if (saveAsTemplate) {
                    try {
                        eafTranscriptionStore.storeTranscriptionAsTemplateIn(tr, visibleTiers, pathName);
                        Integer currentMode = Preferences.getInt("LayoutManager.CurrentMode", tr);
                        Preferences.set("LayoutManager.CurrentMode", 1, (Transcription)tr);
                        this.storePreferences(tr, format, pathName);
                        if (currentMode != null) {
                            Preferences.set("LayoutManager.CurrentMode", currentMode, (Transcription)tr);
                        }
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(tr), "Unable to save the template file: (" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
                    }
                } else {
                    this.storePreferences(tr, format, pathName);
                    String oldPathName = tr.getPathName();
                    String name = pathName;
                    int lastSlashPos = name.lastIndexOf(System.getProperty("file.separator"));
                    if (lastSlashPos >= 0) {
                        name = name.substring(lastSlashPos + 1);
                    }
                    if (updateFileName) {
                        tr.setName(name);
                        if (tr instanceof TranscriptionImpl) {
                            tr.setPathName(pathName);
                            ((ElanFrame2)ELANCommandFactory.getRootFrame(tr)).setFrameTitle();
                            FrameManager.getInstance().updateFrameTitle(ELANCommandFactory.getRootFrame(tr), pathName);
                        } else {
                            ELANCommandFactory.getRootFrame(tr).setTitle("ELAN - " + name);
                        }
                    }
                    List<LinkedFileDescriptor> linkedFiles = tr.getLinkedFileDescriptors();
                    String svgExt = ".svg";
                    String confExt = "_tsconf.xml";
                    if (linkedFiles.size() > 0) {
                        for (int i = 0; i < linkedFiles.size(); ++i) {
                            String curExt = null;
                            LinkedFileDescriptor lfd = linkedFiles.get(i);
                            if (lfd.linkURL.toLowerCase().endsWith(confExt)) {
                                curExt = confExt;
                            } else if (lfd.linkURL.toLowerCase().endsWith(svgExt)) {
                                curExt = svgExt;
                            }
                            if (curExt == null) continue;
                            String url = pathName.substring(0, pathName.length() - 4) + curExt;
                            System.out.println("New conf: " + url);
                            try {
                                File source = null;
                                File dest = null;
                                source = lfd.linkURL.startsWith("file:") ? new File(lfd.linkURL.substring(5)) : new File(lfd.linkURL);
                                dest = url.startsWith("file:") ? new File(url.substring(5)) : new File(url);
                                if (source.exists() && source.compareTo(dest) != 0) {
                                    FileUtility.copyToFile(source, dest);
                                } else {
                                    TSConfigurationEncoder enc = new TSConfigurationEncoder();
                                    enc.encodeAndSave(tr, ELANCommandFactory.getTrackManager(tr).getConfigs());
                                }
                            }
                            catch (Exception ex) {
                                System.out.println("Could not copy the configuration file.");
                            }
                            lfd.linkURL = FileUtility.pathToURLString(url);
                            tr.setChanged();
                        }
                    }
                    String fullEAFURL = FileUtility.pathToURLString(pathName);
                    this.fixRelativePathsOfLinkedFiles(tr, fullEAFURL);
                    try {
                        eafTranscriptionStore.storeTranscriptionIn(tr, null, visibleTiers, pathName, format);
                        if (MonitoringLogger.isInitiated()) {
                            MonitoringLogger.getLogger(tr).log(MonitoringLogger.SAVE_FILE, new String[0]);
                        }
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(tr), "Unable to save the transcription file: (" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
                    }
                    FrameManager.getInstance().updateFileLock(ELANCommandFactory.getRootFrame(tr), oldPathName, pathName);
                    if (updateFileName) {
                        tr.setUnchanged();
                        if (tr instanceof TranscriptionImpl) {
                            ((BackupCA)ELANCommandFactory.getCommandAction(tr, "CommandActions.Backup")).setFilePath(pathName);
                        }
                    }
                }
            }
        } else if (tr.isChanged()) {
            String fullEAFURL = FileUtility.pathToURLString(tr.getFullPath());
            this.fixRelativePathsOfLinkedFiles(tr, fullEAFURL);
            try {
                eafTranscriptionStore.storeTranscription(tr, null, visibleTiers, format);
                if (MonitoringLogger.isInitiated()) {
                    MonitoringLogger.getLogger(tr).log(MonitoringLogger.SAVE_FILE, new String[0]);
                }
                if (ELANCommandFactory.getTrackManager(tr) != null) {
                    ELANCommandFactory.getTrackManager(tr).saveIfChanged();
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(tr), "Unable to save the transcription file: (" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
            }
            tr.setUnchanged();
        }
    }

    private void fixRelativePathsOfLinkedFiles(Transcription tr, String fullEAFURL) {
        String relUrl;
        List<MediaDescriptor> mediaDescriptors = tr.getMediaDescriptors();
        for (MediaDescriptor md : mediaDescriptors) {
            md.relativeMediaURL = relUrl = FileUtility.getRelativePath(fullEAFURL, md.mediaURL);
        }
        List<LinkedFileDescriptor> linkedFiles = tr.getLinkedFileDescriptors();
        for (LinkedFileDescriptor lfd : linkedFiles) {
            lfd.relativeLinkURL = relUrl = FileUtility.getRelativePath(fullEAFURL, lfd.linkURL);
        }
    }

    private void storePreferences(Transcription t, int format, String pathName) {
        String templatePrefPath = pathName.substring(0, pathName.length() - 3) + "pfsx";
        Object orig = SaveAs27Preferences.adjustPreferencesForSavingFormat(t, format);
        Preferences.exportPreferences(t, templatePrefPath);
        SaveAs27Preferences.restoreAdjustedPreferences(t, orig);
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

