/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableFrame;
import mpi.eudico.client.util.TierTree;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class TierDependenciesCA
extends CommandAction
implements ACMEditListener,
ActionListener {
    private JFrame dependencyFrame;
    private ActionHandler actionHandler;
    private JButton sortButton;
    private JButton reverseButton;
    private int locationX = -1;
    private int locationY = -1;
    private int sizeWidth = -1;
    private int sizeHeight = -1;
    private JTree tree;
    private TierTree tTree;
    private JScrollPane jScrollPane;
    private JPanel sortButtonPanel;

    public TierDependenciesCA(ViewerManager2 theVM) {
        super(theVM, "Menu.View.Dependencies");
        try {
            this.vm.getTranscription().addACMEditListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void newCommand() {
        this.command = ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.View.Dependencies");
    }

    @Override
    protected Object getReceiver() {
        return null;
    }

    @Override
    protected Object[] getArguments() {
        Object[] args = new Object[]{this.getDependencyFrame()};
        return args;
    }

    public JFrame getFrame() {
        return this.dependencyFrame;
    }

    private JFrame getDependencyFrame() {
        if (this.dependencyFrame == null) {
            Dimension dim;
            this.createDependencyFrame();
            Point p = Preferences.getPoint("DependenciesFrame.Location", null);
            if (p != null) {
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                int x = p.x <= screen.width - 50 ? p.x : screen.width - 50;
                int y = p.y <= screen.height - 50 ? p.y : screen.height - 50;
                this.dependencyFrame.setLocation(x, y);
            }
            if ((dim = Preferences.getDimension("DependenciesFrame.Size", null)) != null) {
                this.dependencyFrame.setSize(dim);
            }
        }
        return this.dependencyFrame;
    }

    private void createDependencyFrame() {
        try {
            this.tTree = new TierTree((TranscriptionImpl)this.vm.getTranscription());
            this.tree = this.initTree(this.tTree.getTree());
            this.dependencyFrame = new ClosableFrame(ElanLocale.getString("Tier Dependencies"));
            this.actionHandler = new ActionHandler();
            this.dependencyFrame.getContentPane().setLayout(new GridBagLayout());
            Insets insets = new Insets(2, 2, 2, 2);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = insets;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.jScrollPane = new JScrollPane(this.tree);
            this.dependencyFrame.getContentPane().add((Component)this.jScrollPane, gbc);
            this.createSortButtonPanel();
            gbc.gridy = 1;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            this.dependencyFrame.getContentPane().add((Component)this.sortButtonPanel, gbc);
            if (this.locationX != -1 && this.locationY != -1 && this.sizeWidth != -1 && this.sizeHeight != -1) {
                this.dependencyFrame.setLocation(this.locationX, this.locationY);
                this.dependencyFrame.setSize(this.sizeWidth, this.sizeHeight);
            }
            if (this.dependencyFrame.getHeight() < 100 || this.dependencyFrame.getWidth() < 133) {
                this.dependencyFrame.setSize(133, 200);
            }
            this.addCloseActions();
            this.updateLocale();
        }
        catch (Exception ex) {
            System.out.println("Couldn't create dependencyFrame.");
        }
    }

    private void createSortButtonPanel() {
        this.sortButtonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints sortButtonPanelGbc = new GridBagConstraints();
        sortButtonPanelGbc.gridx = 0;
        sortButtonPanelGbc.gridy = 0;
        sortButtonPanelGbc.insets = new Insets(2, 2, 2, 2);
        this.sortButton = new JButton(ElanLocale.getString("EditCVDialog.Button.SortAZ"));
        this.sortButtonPanel.add((Component)this.sortButton, sortButtonPanelGbc);
        this.sortButton.addActionListener(this.actionHandler);
        sortButtonPanelGbc.gridx = 1;
        this.reverseButton = new JButton(ElanLocale.getString("EditCVDialog.Button.SortZA"));
        this.sortButtonPanel.add((Component)this.reverseButton, sortButtonPanelGbc);
        this.reverseButton.addActionListener(this.actionHandler);
    }

    private JTree initTree(DefaultMutableTreeNode rootNode) {
        JTree tree = new JTree(rootNode);
        tree.setRootVisible(false);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        tree.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)tree.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setBackgroundNonSelectionColor(Constants.DEFAULTBACKGROUNDCOLOR);
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
        return tree;
    }

    private JTree redrawTree(DefaultMutableTreeNode rootNode) {
        JTree tree = new JTree(rootNode);
        tree.setRootVisible(false);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        tree.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)tree.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setBackgroundNonSelectionColor(Constants.DEFAULTBACKGROUNDCOLOR);
        return tree;
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public void updateLocale() {
        super.updateLocale();
        if (this.dependencyFrame != null) {
            this.dependencyFrame.setTitle(ElanLocale.getString("Menu.View.DependenciesDialog"));
            this.dependencyFrame.repaint();
        }
    }

    protected void addCloseActions() {
        if (this.dependencyFrame != null) {
            this.dependencyFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (e.getID() == 201) {
                        TierDependenciesCA.this.vm.getTranscription().removeACMEditListener(TierDependenciesCA.this);
                        Point p = TierDependenciesCA.this.dependencyFrame.getLocationOnScreen();
                        Dimension d = TierDependenciesCA.this.dependencyFrame.getSize();
                        Preferences.set("DependenciesFrame.Location", p, null, false, false);
                        Preferences.set("DependenciesFrame.Size", d, null, false, false);
                    } else {
                        System.err.println("DEBUG: TierDependenciesCA, window event not closing");
                    }
                }
            });
        }
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: 
            case 1: 
            case 2: {
                if (this.dependencyFrame == null) break;
                boolean bVisible = this.dependencyFrame.isVisible();
                this.locationX = (int)this.dependencyFrame.getLocation().getX();
                this.locationY = (int)this.dependencyFrame.getLocation().getY();
                this.sizeWidth = (int)this.dependencyFrame.getSize().getWidth();
                this.sizeHeight = (int)this.dependencyFrame.getSize().getHeight();
                this.dependencyFrame.dispose();
                this.createDependencyFrame();
                if (this.command == null || !bVisible) break;
                this.command.execute(this.getReceiver(), this.getArguments());
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            if ((ae.getSource() == TierDependenciesCA.this.sortButton || ae.getSource() == TierDependenciesCA.this.reverseButton) && TierDependenciesCA.this.dependencyFrame != null) {
                TreeModel model = TierDependenciesCA.this.tree.getModel();
                Object root = model.getRoot();
                Object[] path = new Object[]{root};
                TreePath pathRoot = new TreePath(path);
                Enumeration<TreePath> expandedDescendants = TierDependenciesCA.this.tree.getExpandedDescendants(pathRoot);
                TreePath[] selectedNodes = TierDependenciesCA.this.tree.getSelectionPaths();
                if (ae.getSource() == TierDependenciesCA.this.sortButton) {
                    TierDependenciesCA.this.tree = TierDependenciesCA.this.redrawTree(TierDependenciesCA.this.tTree.sortAlphabetically());
                } else if (ae.getSource() == TierDependenciesCA.this.reverseButton) {
                    TierDependenciesCA.this.tree = TierDependenciesCA.this.redrawTree(TierDependenciesCA.this.tTree.sortReverseAlphabetically());
                }
                Insets insets = new Insets(2, 2, 2, 2);
                TierDependenciesCA.this.dependencyFrame.getContentPane().removeAll();
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.insets = insets;
                gbc.fill = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                if (TierDependenciesCA.this.tree == null) {
                    System.err.println("DEBUG: JTree is null");
                }
                while (expandedDescendants.hasMoreElements()) {
                    TreePath pathToNode = expandedDescendants.nextElement();
                    TierDependenciesCA.this.tree.expandPath(pathToNode);
                }
                TierDependenciesCA.this.tree.setSelectionPaths(selectedNodes);
                TierDependenciesCA.this.jScrollPane = new JScrollPane(TierDependenciesCA.this.tree);
                TierDependenciesCA.this.dependencyFrame.getContentPane().add((Component)TierDependenciesCA.this.jScrollPane, gbc);
                gbc.gridy = 1;
                gbc.fill = 0;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                TierDependenciesCA.this.dependencyFrame.getContentPane().add((Component)TierDependenciesCA.this.sortButtonPanel, gbc);
                TierDependenciesCA.this.dependencyFrame.getContentPane().validate();
                TierDependenciesCA.this.dependencyFrame.getContentPane().repaint();
            }
        }
    }
}

