/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.gui.IndeterminateProgressMonitor;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class TokenizeCommand
implements UndoableCommand {
    private String commandName;
    private static final Logger LOG = Logger.getLogger(TokenizeCommand.class.getName());
    private TranscriptionImpl transcription;
    private TierImpl sourceTier;
    private TierImpl destTier;
    private String delimiter;
    private String tokens;
    private String splitTokens;
    private boolean preserve;
    private boolean createEmpty;
    private boolean returnDelims;
    private List<DefaultMutableTreeNode> existAnnotations;
    private List<List<AnnotationDataRecord>> newAnnotationsNodes;
    private List<AnnotationDataRecord> completedTokenizations;

    public TokenizeCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.transcription == null || this.sourceTier == null || this.destTier == null || this.completedTokenizations == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.transcription.setNotifying(false);
        this.setWaitCursor(true);
        if (this.completedTokenizations.size() > 0) {
            this.wipeTargetAnnotations();
        }
        if (!this.preserve && this.existAnnotations.size() > 0) {
            AnnotationRecreator.createAnnotationsSequentially(this.transcription, this.existAnnotations, true);
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    private void wipeTargetAnnotations() {
        boolean destTierIsRootTier = !this.destTier.hasParentTier();
        for (int i = 0; i < this.completedTokenizations.size(); ++i) {
            List<Annotation> childrenOnDest;
            AnnotationDataRecord srcRecord = this.completedTokenizations.get(i);
            if (destTierIsRootTier) {
                childrenOnDest = this.destTier.getOverlappingAnnotations(srcRecord.getBeginTime(), srcRecord.getEndTime());
            } else {
                AbstractAnnotation srcAnn = (AbstractAnnotation)this.sourceTier.getAnnotationAtTime(srcRecord.getBeginTime());
                childrenOnDest = srcAnn.getChildrenOnTier(this.destTier);
            }
            for (int j = 0; j < childrenOnDest.size(); ++j) {
                AbstractAnnotation destAnn = (AbstractAnnotation)childrenOnDest.get(j);
                this.destTier.removeAnnotation(destAnn);
            }
        }
    }

    @Override
    public void redo() {
        if (this.transcription == null || this.sourceTier == null || this.destTier == null || this.completedTokenizations == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.transcription.setNotifying(false);
        this.setWaitCursor(true);
        if (this.completedTokenizations.size() > 0) {
            if (!this.preserve) {
                this.wipeTargetAnnotations();
            }
            if (this.newAnnotationsNodes.size() > 0) {
                AnnotationRecreator.createAnnotationsSequentiallyDepthless(this.transcription, this.newAnnotationsNodes, true);
            }
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        String sourceName = (String)arguments[0];
        String destName = (String)arguments[1];
        this.delimiter = (String)arguments[2];
        this.preserve = (Boolean)arguments[3];
        this.createEmpty = (Boolean)arguments[4];
        this.tokens = (String)arguments[5];
        if (this.delimiter == null) {
            this.delimiter = " \t\n\r\f";
        }
        if (this.tokens == null || this.tokens.isEmpty()) {
            this.splitTokens = this.delimiter;
            this.returnDelims = false;
        } else {
            this.splitTokens = this.uniqueCharacters(this.delimiter, this.tokens);
            this.returnDelims = true;
        }
        this.sourceTier = this.transcription.getTierWithId(sourceName);
        this.destTier = this.transcription.getTierWithId(destName);
        if (this.transcription == null || this.sourceTier == null || this.destTier == null) {
            LOG.severe("Error in retrieving the transcription or one of the tiers.");
            return;
        }
        if (this.isParentOf(this.destTier, this.sourceTier)) {
            LOG.severe("Destination Tier is parent of source Tier.");
            return;
        }
        this.existAnnotations = new ArrayList<DefaultMutableTreeNode>();
        this.newAnnotationsNodes = new ArrayList<List<AnnotationDataRecord>>();
        this.completedTokenizations = new ArrayList<AnnotationDataRecord>();
        new TokenizeThread().start();
    }

    private String uniqueCharacters(String first, String second) {
        StringBuilder buffer = new StringBuilder(first);
        for (int i = 0; i < second.length(); ++i) {
            if (first.indexOf(second.charAt(i)) >= 0) continue;
            buffer.append(second.charAt(i));
        }
        return buffer.toString();
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean isParentOf(Tier parent, TierImpl child) {
        while ((child = child.getParentTier()) != null) {
            if (child != parent) continue;
            return true;
        }
        return false;
    }

    static Annotation createAnnotation(TierImpl t, Annotation prevAnn, long bt, long et, int numAnns, int seq) {
        LinguisticType lt = t.getLinguisticType();
        Constraint con = lt.getConstraints();
        int st = con == null ? -1 : con.getStereoType();
        Annotation curAnn = null;
        if (con == null || st == 1) {
            curAnn = TokenizeCommand.createSubperiodAnnotation(t, bt, et, numAnns, seq);
        } else if (st == 0) {
            curAnn = prevAnn != null ? t.createAnnotationAfter(prevAnn) : TokenizeCommand.createSubperiodAnnotation(t, bt, et, numAnns, seq);
        } else if (st == 3) {
            if (prevAnn != null) {
                curAnn = t.createAnnotationAfter(prevAnn);
            } else {
                long mid = (bt + et) / 2L;
                curAnn = t.createAnnotation(mid, mid);
            }
        } else if (st == 4 && prevAnn == null) {
            long mid = (bt + et) / 2L;
            curAnn = t.createAnnotation(mid, mid);
        }
        return curAnn;
    }

    private static Annotation createSubperiodAnnotation(TierImpl t, long bt, long et, int numAnns, int seq) {
        float perAnn = (float)(et - bt) / (float)numAnns;
        long start = bt + (long)((float)seq * perAnn);
        long end = seq + 1 == numAnns ? et : bt + (long)((float)(seq + 1) * perAnn);
        return t.createAnnotation(start, end);
    }

    private class TokenizeThread
    extends Thread {
        TokenizeThread() {
            super("Tokenize");
        }

        @Override
        public void run() {
            int curPropMode = 0;
            curPropMode = TokenizeCommand.this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                TokenizeCommand.this.transcription.setTimeChangePropagationMode(0);
            }
            final IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor(ELANCommandFactory.getRootFrame(TokenizeCommand.this.transcription), true, ElanLocale.getString("TokenizeDialog.Message.Tokenizing"), true, ElanLocale.getString("Button.Cancel"));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    monitor.show();
                }
            }, "Tokenize Monitor").start();
            List<AbstractAnnotation> sourceAnnos = TokenizeCommand.this.sourceTier.getAnnotations();
            if (sourceAnnos.size() <= 0) {
                monitor.close();
                return;
            }
            TokenizeCommand.this.transcription.setNotifying(false);
            ArrayList<Annotation> newAnnos = new ArrayList<Annotation>();
            boolean destTierIsRootTier = !TokenizeCommand.this.destTier.hasParentTier();
            for (AbstractAnnotation srcAnn : sourceAnnos) {
                AbstractAnnotation parentAnn;
                List<Annotation> childrenOnDest = srcAnn.getChildrenOnTier(TokenizeCommand.this.destTier);
                if (destTierIsRootTier) {
                    parentAnn = null;
                    childrenOnDest = TokenizeCommand.this.destTier.getOverlappingAnnotations(srcAnn.getBeginTimeBoundary(), srcAnn.getEndTimeBoundary());
                } else {
                    parentAnn = srcAnn;
                    childrenOnDest = srcAnn.getChildrenOnTier(TokenizeCommand.this.destTier);
                }
                if (childrenOnDest.size() > 0 && !TokenizeCommand.this.preserve) {
                    for (AbstractAnnotation abstractAnnotation : childrenOnDest) {
                        TokenizeCommand.this.existAnnotations.add(AnnotationRecreator.createTreeForAnnotation(abstractAnnotation));
                    }
                    Iterator<Annotation> childIt = childrenOnDest.iterator();
                    while (childIt.hasNext()) {
                        TokenizeCommand.this.destTier.removeAnnotation(childIt.next());
                    }
                }
                if (childrenOnDest.size() == 0 || !TokenizeCommand.this.preserve) {
                    Annotation ann;
                    String srcValue = srcAnn.getValue();
                    StringTokenizer tokenizer = new StringTokenizer(srcValue, TokenizeCommand.this.splitTokens, TokenizeCommand.this.returnDelims);
                    newAnnos.clear();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (tokenizer.hasMoreTokens()) {
                        String nextToken = tokenizer.nextToken();
                        if (TokenizeCommand.this.returnDelims && nextToken.length() == 1 && TokenizeCommand.this.delimiter.indexOf(nextToken.charAt(0)) >= 0) continue;
                        arrayList.add(nextToken);
                    }
                    Annotation prevAnn = null;
                    int seq = 0;
                    for (String nextToken : arrayList) {
                        prevAnn = TokenizeCommand.createAnnotation(TokenizeCommand.this.destTier, prevAnn, srcAnn.getBeginTimeBoundary(), srcAnn.getEndTimeBoundary(), arrayList.size(), seq);
                        ++seq;
                        if (prevAnn == null) continue;
                        prevAnn.setValue(nextToken);
                        newAnnos.add(prevAnn);
                    }
                    if (newAnnos.isEmpty() && TokenizeCommand.this.createEmpty && (ann = TokenizeCommand.createAnnotation(TokenizeCommand.this.destTier, null, srcAnn.getBeginTimeBoundary(), srcAnn.getEndTimeBoundary(), 1, 0)) != null) {
                        newAnnos.add(ann);
                    }
                    if (!newAnnos.isEmpty()) {
                        int size = newAnnos.size();
                        ArrayList<AnnotationDataRecord> siblings = new ArrayList<AnnotationDataRecord>(size);
                        for (int i = 0; i < size; ++i) {
                            siblings.add(new AnnotationDataRecord((Annotation)newAnnos.get(i)));
                        }
                        TokenizeCommand.this.newAnnotationsNodes.add(siblings);
                    }
                    TokenizeCommand.this.completedTokenizations.add(new AnnotationDataRecord(srcAnn));
                }
                if (!monitor.isCancelled()) continue;
                break;
            }
            TokenizeCommand.this.transcription.setNotifying(true);
            TokenizeCommand.this.transcription.setTimeChangePropagationMode(curPropMode);
            monitor.close();
        }
    }
}

