/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.IOException;
import mpi.eudico.client.annotator.commands.AbstractProgressCommand;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.MergeTranscriptionsByAddingCommand;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.webserviceclient.weblicht.TCFtoTranscription;
import mpi.eudico.webserviceclient.weblicht.WLServiceDescriptor;
import mpi.eudico.webserviceclient.weblicht.WebLichtWsClient;
import org.xml.sax.SAXException;

public class WebLichtTextBasedCommand
extends AbstractProgressCommand
implements UndoableCommand {
    private MergeTranscriptionsByAddingCommand mergeCommand;
    private Transcription transcription;
    private Transcription transcription2;
    private String inputText;
    private int sentenceDuration;
    private WLServiceDescriptor wlDescriptor;

    public WebLichtTextBasedCommand(String name) {
        super(name);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (Transcription)receiver;
        this.inputText = (String)arguments[0];
        this.sentenceDuration = (Integer)arguments[1];
        this.wlDescriptor = (WLServiceDescriptor)arguments[2];
        if (!this.cancelled) {
            new WLThread().start();
        } else {
            this.progressInterrupt("The process was cancelled");
        }
    }

    @Override
    public void undo() {
        if (this.mergeCommand != null) {
            this.mergeCommand.undo();
        }
    }

    @Override
    public void redo() {
        if (this.mergeCommand != null) {
            this.mergeCommand.redo();
        }
    }

    private class WLThread
    extends Thread {
        private WLThread() {
        }

        @Override
        public void run() {
            int perCycle = 30;
            WebLichtTextBasedCommand.this.progressUpdate(5, "Uploading text to WebLicht...");
            if (WebLichtTextBasedCommand.this.cancelled) {
                return;
            }
            WebLichtWsClient wsClient = new WebLichtWsClient();
            String tcfToParse = null;
            String tcf = null;
            try {
                tcf = wsClient.convertPlainText(WebLichtTextBasedCommand.this.inputText);
                WebLichtTextBasedCommand.this.progressUpdate(perCycle, "Converted input text to TCF format");
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Error converting text to TCF: " + ioe.getMessage());
                tcf = this.textInTCF(WebLichtTextBasedCommand.this.inputText);
                WebLichtTextBasedCommand.this.progressUpdate(perCycle, "An error occurred, converted input text to TCF format locally");
            }
            if (tcf != null) {
                if (WebLichtTextBasedCommand.this.cancelled) {
                    return;
                }
                tcfToParse = tcf;
                String tcf2 = null;
                try {
                    tcf2 = wsClient.callWithTCF(((WebLichtTextBasedCommand)WebLichtTextBasedCommand.this).wlDescriptor.fullURL, tcf);
                    WebLichtTextBasedCommand.this.progressUpdate(2 * perCycle, "Uploaded for tokenization of the sentences");
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Error while calling the tokenizer service: " + ioe.getMessage());
                    WebLichtTextBasedCommand.this.progressUpdate(2 * perCycle, "Error while calling the tokenizer service: " + ioe.getMessage());
                }
                if (tcf2 != null) {
                    if (WebLichtTextBasedCommand.this.cancelled) {
                        return;
                    }
                    tcfToParse = tcf2;
                } else {
                    WebLichtTextBasedCommand.this.progressUpdate(60, "Unable to get tokens, creating tiers...");
                }
                if (tcfToParse != null) {
                    if (WebLichtTextBasedCommand.this.cancelled) {
                        return;
                    }
                    WebLichtTextBasedCommand.this.progressUpdate(62, "Converting returned content to a transcription.");
                    TCFtoTranscription tctt = new TCFtoTranscription();
                    tctt.setDefaultDuration(WebLichtTextBasedCommand.this.sentenceDuration);
                    tctt.setTiersToInclude(true, false, false);
                    try {
                        WebLichtTextBasedCommand.this.transcription2 = tctt.createTranscription(tcfToParse);
                        this.updateTierNames(WebLichtTextBasedCommand.this.transcription, WebLichtTextBasedCommand.this.transcription2);
                        WebLichtTextBasedCommand.this.progressUpdate(70, "Created a transcription, starting to merge");
                        WebLichtTextBasedCommand.this.mergeCommand = (MergeTranscriptionsByAddingCommand)ELANCommandFactory.createCommand(WebLichtTextBasedCommand.this.transcription, "Menu.Options.WebServices.WebLicht");
                        WebLichtTextBasedCommand.this.mergeCommand.execute(WebLichtTextBasedCommand.this.transcription, new Object[]{WebLichtTextBasedCommand.this.transcription2, null, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE});
                        WebLichtTextBasedCommand.this.progressComplete("New tiers were added to the transcription");
                    }
                    catch (SAXException sax) {
                        ClientLogger.LOG.warning("Error parsing tcf file: " + sax.getMessage());
                        WebLichtTextBasedCommand.this.progressInterrupt("Error parsing tcf file: " + sax.getMessage());
                    }
                    catch (IOException ioe) {
                        ClientLogger.LOG.warning("Error parsing tcf file: " + ioe.getMessage());
                        WebLichtTextBasedCommand.this.progressInterrupt("Error parsing tcf file: " + ioe.getMessage());
                    }
                }
            } else {
                ClientLogger.LOG.warning("Unknown error converting text to TCF");
                WebLichtTextBasedCommand.this.progressInterrupt("Unknown error converting text to TCF");
            }
        }

        private String textInTCF(String inputText) {
            StringBuilder builder = new StringBuilder();
            builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            builder.append("<D-Spin xmlns=\"http://www.dspin.de/data\" version=\"0.4\">");
            builder.append("<MetaData xmlns=\"http://www.dspin.de/data/metadata\">");
            builder.append("<source></source>");
            builder.append("</MetaData>");
            builder.append("<TextCorpus xmlns=\"http://www.dspin.de/data/textcorpus\" lang=\"unknown\">");
            builder.append("<text>");
            builder.append(inputText);
            builder.append("</text>");
            builder.append("</TextCorpus>");
            builder.append("</D-Spin>");
            return builder.toString();
        }

        private void updateTierNames(Transcription refTrans, Transcription nextTrans) {
            int MAX_COUNT = 50;
            for (Tier tier : nextTrans.getTiers()) {
                String tierName = tier.getName();
                if (refTrans.getTierWithId(tierName) == null) continue;
                int count = 1;
                Object newName = tierName;
                while (refTrans.getTierWithId((String)(newName = tierName + "-" + count++)) != null && count < 50) {
                }
                if (count >= 50) continue;
                tier.setName((String)newName);
            }
        }
    }
}

