/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.ImportCSVDialog;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextDecoderInfo;
import nl.mpi.util.FileExtension;

public class ImportDelimitedTextMA
extends FrameMenuAction {
    public ImportDelimitedTextMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileChooser chooser = new FileChooser(this.frame);
        ArrayList<String[]> extensionList = new ArrayList<String[]>();
        extensionList.add(FileExtension.CSV_EXT);
        chooser.createAndShowFileDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, null, extensionList, FileExtension.CSV_EXT, true, "LastUsedCSVDir", 0, null);
        File csvFile = chooser.getSelectedFile();
        String fullPath = null;
        if (csvFile != null) {
            File fileTemp;
            fullPath = chooser.getSelectedFile().getAbsolutePath();
            csvFile = fileTemp = new File(fullPath);
            ImportCSVDialog dialog = new ImportCSVDialog((Frame)this.frame, fileTemp);
            Object value = dialog.showDialog();
            if (value == null || !(value instanceof DelimitedTextDecoderInfo)) {
                return;
            }
            DelimitedTextDecoderInfo decInfo = (DelimitedTextDecoderInfo)value;
            try {
                String path = fullPath;
                path = path.replace('\\', '/');
                path = decInfo.getSourceFilePath();
                TranscriptionImpl transcription = new TranscriptionImpl(path, decInfo);
                transcription.setChanged();
                FrameManager.getInstance().createFrame(transcription);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

