/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.io.CsvTierIO;
import mpi.eudico.client.annotator.recognizer.io.XmlTierIO;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import nl.mpi.util.FileExtension;

public class ImportRecognizerTiersMA
extends FrameMenuAction {
    public ImportRecognizerTiersMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String filePath = this.promptForTierFile();
        if (filePath == null) {
            return;
        }
        File f = new File(filePath);
        if (f.exists() && f.canRead()) {
            TranscriptionImpl transcription = new TranscriptionImpl();
            LinguisticType type = null;
            if (transcription.getLinguisticTypes().size() == 0) {
                type = new LinguisticType("recognizer");
                transcription.addLinguisticType(type);
                transcription.setChanged();
            }
            List<Segmentation> segm = null;
            if (filePath.endsWith("csv")) {
                CsvTierIO cio = new CsvTierIO();
                segm = cio.read(f);
            } else {
                XmlTierIO xio = new XmlTierIO(f);
                try {
                    segm = xio.parse();
                }
                catch (Exception exe) {
                    JOptionPane.showMessageDialog(this.frame, exe.getMessage(), ElanLocale.getString("Message.Error"), 0);
                }
            }
            if (segm != null && segm.size() > 0) {
                int numTiersCreated = 0;
                transcription.setNotifying(false);
                for (Segmentation s : segm) {
                    if (s == null) continue;
                    TierImpl t = new TierImpl(s.getName(), null, transcription, type);
                    transcription.addTier(t);
                    ++numTiersCreated;
                    ArrayList<RSelection> segments = s.getSegments();
                    for (RSelection sel : segments) {
                        AlignableAnnotation aa;
                        if (sel == null || (aa = (AlignableAnnotation)t.createAnnotation(sel.beginTime, sel.endTime)) == null || !(sel instanceof Segment) || ((Segment)sel).label == null) continue;
                        aa.setValue(((Segment)sel).label);
                    }
                }
                transcription.setNotifying(true);
                if (numTiersCreated > 0) {
                    FrameManager.getInstance().createFrame(transcription);
                } else {
                    JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.NoTiers"), ElanLocale.getString("Message.Error"), 2);
                }
            } else {
                JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.NoTiers"), ElanLocale.getString("Message.Error"), 2);
            }
        } else {
            JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.LoadFailed"), ElanLocale.getString("Message.Error"), 2);
        }
    }

    private String promptForTierFile() {
        ArrayList<String[]> extensions = new ArrayList<String[]>();
        extensions.add(FileExtension.CSV_EXT);
        FileChooser chooser = new FileChooser(this.frame);
        chooser.createAndShowFileDialog(null, 0, FileExtension.XML_EXT, "Recognizer.Path");
        File f = chooser.getSelectedFile();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }
}

