/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.ImportShoeboxWAC;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ImportToolboxMA
extends FrameMenuAction {
    public ImportToolboxMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object result = ImportShoeboxWAC.showDialog(this.frame, 2);
        if (result instanceof DecoderInfo) {
            String txtFileName = ((DecoderInfo)result).getSourceFilePath();
            try {
                int answer;
                TranscriptionImpl nextTranscription = new TranscriptionImpl(txtFileName, (DecoderInfo)result);
                nextTranscription.setChanged();
                txtFileName = txtFileName.replace('\\', '/');
                int lastSlash = txtFileName.lastIndexOf(47);
                String toolboxPath = txtFileName.substring(0, lastSlash);
                boolean validMedia = true;
                if (this.frame != null) {
                    validMedia = this.frame.checkMedia(nextTranscription, toolboxPath);
                }
                if (!validMedia && (answer = JOptionPane.showConfirmDialog(this.frame, ElanLocale.getString("Frame.ElanFrame.IncompleteMediaQuestion"), ElanLocale.getString("Frame.ElanFrame.IncompleteMediaAvailable"), 0)) != 0) {
                    return;
                }
                FrameManager.getInstance().createFrame(nextTranscription);
            }
            catch (Exception e) {
                String message = e.getMessage() != null ? e.getMessage() : e.getClass().getName();
                JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("ImportDialog.Message.UnknownError") + "\n" + message, ElanLocale.getString("Message.Error"), 0);
                e.printStackTrace();
            }
        }
    }
}

