/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.client.util.TranscriptionECVLoader;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.util.MediaDescriptorUtility;
import nl.mpi.util.FileUtility;

public class NewMA
extends FrameMenuAction {
    public NewMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<CallSite> fileNames = null;
        FileChooser chooser = new FileChooser(this.frame);
        chooser.createAndShowMultiFileDialog(ElanLocale.getString("Frame.ElanFrame.NewDialog.Title"), 1);
        Object[] files = chooser.getSelectedFiles();
        if (files != null) {
            if (files.length > 0) {
                fileNames = new ArrayList<CallSite>();
                for (Object file : files) {
                    if (fileNames.contains(file)) continue;
                    fileNames.add((CallSite)((Object)("" + file)));
                }
            }
            this.createNewFile(fileNames);
        }
    }

    public void createNewFile(List<String> fileNames) {
        ArrayList<MediaDescriptor> mediaDescriptors = new ArrayList();
        if (fileNames != null) {
            TranscriptionImpl nextTranscription;
            int fileNames_size = fileNames.size();
            for (int i = 0; i < fileNames_size; ++i) {
                String strFile = fileNames.get(i);
                if (FileUtility.isRemoteFile(strFile) || new File(strFile).exists()) continue;
                Object strMessage = ElanLocale.getString("Menu.Dialog.Message1");
                strMessage = (String)strMessage + new File(strFile).getName();
                strMessage = (String)strMessage + ElanLocale.getString("Menu.Dialog.Message2");
                String strError = ElanLocale.getString("Message.Error");
                JOptionPane.showMessageDialog(this.frame, strMessage, strError, 0);
                return;
            }
            String strTemplate = "";
            for (int i = fileNames_size - 1; i >= 0; --i) {
                String strFile = fileNames.get(i);
                if (strFile.toLowerCase().endsWith(".etf")) {
                    strTemplate = fileNames.get(i);
                    fileNames.remove(i);
                    continue;
                }
                if (!strFile.toLowerCase().endsWith(".eaf")) continue;
                if (fileNames.size() == 1 && !strTemplate.toLowerCase().endsWith(".etf")) {
                    this.frame.openEAF(strFile);
                    return;
                }
                fileNames.remove(i);
            }
            mediaDescriptors = MediaDescriptorUtility.createMediaDescriptors(fileNames);
            if (strTemplate.equals("")) {
                nextTranscription = new TranscriptionImpl();
                if (nextTranscription.getLinguisticTypes().size() == 0 && nextTranscription.getTiers().size() == 0) {
                    this.addInitialTierAndType(nextTranscription);
                }
            } else {
                nextTranscription = new TranscriptionImpl(new File(strTemplate).getAbsolutePath());
                nextTranscription.setName("aishug294879ryshfda9763afo8947a5gf");
                nextTranscription.setPathName("aishug294879ryshfda9763afo8947a5gf");
                if (nextTranscription.getControlledVocabularies().size() > 0) {
                    new TranscriptionECVLoader().loadExternalCVs(nextTranscription, this.frame);
                }
            }
            nextTranscription.setMediaDescriptors(mediaDescriptors);
            nextTranscription.setChanged();
            if (!strTemplate.equals("")) {
                String prefPath = strTemplate.substring(0, strTemplate.length() - 3) + "pfsx";
                try {
                    File pFile = new File(prefPath);
                    if (pFile.exists()) {
                        Preferences.importPreferences((Transcription)nextTranscription, prefPath);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.createFrame(nextTranscription);
        }
    }

    protected void createFrame(Transcription nextTranscription) {
        ElanFrame2 frame = FrameManager.getInstance().createFrame(nextTranscription);
        if (MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(null).log(MonitoringLogger.NEW_FILE, new String[0]);
            MonitoringLogger.getLogger(frame.getViewerManager().getTranscription()).log(MonitoringLogger.NEW_FILE, new String[0]);
        }
    }

    protected void addInitialTierAndType(TranscriptionImpl transcription) {
        LinguisticType type = new LinguisticType("default-lt");
        transcription.addLinguisticType(type);
        TierImpl tier = new TierImpl("default", "", transcription, type);
        transcription.addTier(tier);
        tier.setDefaultLocale(null);
    }
}

