/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.IndeterminateProgressMonitor;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.server.corpora.clomimpl.util.EAFValidator;
import mpi.eudico.server.corpora.util.ProcessReport;
import nl.mpi.util.FileExtension;

public class ValidateEAFMA
extends FrameMenuAction {
    public ValidateEAFMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileChooser chooser = new FileChooser(this.frame);
        chooser.createAndShowFileDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, FileExtension.EAF_EXT, "LastUsedEAFDir");
        File selEafFile = chooser.getSelectedFile();
        if (selEafFile == null) {
            return;
        }
        EAFValidator validator = new EAFValidator(selEafFile);
        new ValidationThread(validator).start();
    }

    private class ValidationThread
    extends Thread {
        EAFValidator validator;

        public ValidationThread(EAFValidator validator) {
            this.validator = validator;
        }

        @Override
        public void run() {
            if (this.validator != null) {
                IndeterminateProgressMonitor progMonitor = new IndeterminateProgressMonitor(null, false, ElanLocale.getString("Validation.Message.Busy"), false, null);
                progMonitor.setDecorated(true);
                progMonitor.show();
                this.validator.validate();
                progMonitor.close();
                ProcessReport report = this.validator.getReport();
                ReportDialog reportDlg = new ReportDialog((Frame)ValidateEAFMA.this.frame, report);
                reportDlg.setVisible(true);
            }
        }
    }
}

