/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.comments;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.XMLGregorianCalendar;
import mpi.eudico.util.TimeFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommentEnvelope
implements Comparable<CommentEnvelope>,
Cloneable {
    private String messageID = "";
    private String messageURL = "";
    private String initials = "";
    private String sender = "";
    private String recipient = "";
    private Date creationDate = defaultDate;
    private Date modificationDate = defaultDate;
    private String category = "unknown";
    private String status = "unknown";
    private String annotationFileType = "EAF";
    private String annotationFileURL = "";
    private String message = "";
    private String threadID = "";
    private URI annotationURIBase = URI.create("urn:unknown");
    private long startTime = -1L;
    private long endTime = -1L;
    private String tierName = "";
    private static DateFormat dateFormat;
    private static Date defaultDate;
    private transient boolean toBeSavedToFile = false;
    private transient boolean toBeSavedToServer = false;
    private transient XMLGregorianCalendar lastModifiedOnServer;
    private transient boolean readOnly = false;

    public CommentEnvelope clone() {
        try {
            return (CommentEnvelope)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getMessageID() {
        return this.messageID;
    }

    void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public void setMessageID() {
        this.setMessageID(UUID.randomUUID().toString());
    }

    public String getMessageURL() {
        return this.messageURL;
    }

    public void setMessageURL(String url) {
        this.messageURL = url;
    }

    public String getInitials() {
        return this.initials;
    }

    public void setInitials(String initials) {
        this.initials = initials;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void addRecipient(String recipient) {
        this.recipient = this.recipient == null || this.recipient.isEmpty() ? recipient : this.recipient + "," + recipient;
    }

    public String[] getRecipients() {
        return this.recipient.split("\\s*,\\s*");
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getCreationDateString() {
        return dateFormat.format(this.creationDate);
    }

    public void setCreationDate() {
        this.creationDate = this.nowRoundedToMilliSeconds();
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setCreationDate(String creationDate) {
        Calendar cal = DatatypeConverter.parseDateTime((String)creationDate);
        this.setCreationDate(cal.getTime());
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public String getModificationDateString() {
        return dateFormat.format(this.modificationDate);
    }

    private void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public void setModificationDate(String modificationDate) {
        Calendar cal = DatatypeConverter.parseDateTime((String)modificationDate);
        this.setModificationDate(cal.getTime());
    }

    public void setModificationDate() {
        this.setModificationDate(this.nowRoundedToMilliSeconds());
        this.setToBeSaved(true);
    }

    public String getAnnotationFileType() {
        return this.annotationFileType;
    }

    public void setAnnotationFileType(String annotationFileType) {
        this.annotationFileType = annotationFileType;
    }

    public String getAnnotationFileURL() {
        return this.annotationFileURL;
    }

    public void setAnnotationFileURL(String annotationFileURL) {
        this.annotationFileURL = annotationFileURL;
    }

    public String getAnnotationFile() {
        URI uri = CommentEnvelope.getTimeBasedURI(this.getAnnotationURIBase(), this.getStartTime(), this.getEndTime());
        Object fragment = uri.getFragment();
        if (this.tierName != null && !this.tierName.isEmpty()) {
            fragment = (String)fragment + ";tier=" + this.tierName;
        }
        try {
            return new URI(uri.getScheme(), uri.getSchemeSpecificPart(), (String)fragment).toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setAnnotationFile(String annotationFile) {
        try {
            URI uri = new URI(annotationFile);
            this.deriveFieldsFromAnnotationFile(uri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void setAnnotationFile(URI annotationFile) {
        this.deriveFieldsFromAnnotationFile(annotationFile);
    }

    private void deriveFieldsFromAnnotationFile(URI uri) {
        try {
            this.setAnnotationURIBase(new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTierName("");
        String fragment = uri.getFragment();
        if (fragment != null) {
            String[] parts;
            for (String p : parts = fragment.split(";")) {
                if (p.startsWith("t=")) {
                    p = p.substring(2);
                    String[] times = p.split("/");
                    long start = 0L;
                    long end = 0L;
                    if (times.length > 0) {
                        end = start = TimeFormatter.toMilliSeconds(times[0]);
                    }
                    if (times.length > 1) {
                        end = TimeFormatter.toMilliSeconds(times[1]);
                    }
                    this.setStartEndTime(start, end);
                    continue;
                }
                if (!p.startsWith("tier=")) continue;
                p = p.substring(5);
                this.setTierName(p);
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public URI getAnnotationURIBase() {
        return this.annotationURIBase;
    }

    public void setAnnotationURIBase(URI s) {
        this.annotationURIBase = s;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setStartEndTime(long s, long e) {
        this.startTime = s;
        this.endTime = e;
    }

    public String getTierName() {
        return this.tierName;
    }

    public void setTierName(String s) {
        this.tierName = s;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean getToBeSavedToFile() {
        return this.toBeSavedToFile;
    }

    public boolean getToBeSavedToServer() {
        return this.toBeSavedToServer;
    }

    public void setToBeSavedToFile(boolean flag) {
        this.toBeSavedToFile = flag;
    }

    public void setToBeSavedToServer(boolean flag) {
        this.toBeSavedToServer = flag;
    }

    public void setToBeSaved(boolean flag) {
        this.setToBeSavedToFile(flag);
        this.setToBeSavedToServer(flag);
    }

    private Date nowRoundedToMilliSeconds() {
        return new Date();
    }

    public void setLastModifiedOnServer(XMLGregorianCalendar xmlGregorianCalendar) {
        this.lastModifiedOnServer = xmlGregorianCalendar;
    }

    public XMLGregorianCalendar getLastModifiedOnServer() {
        return this.lastModifiedOnServer;
    }

    public String getThreadID() {
        return this.threadID;
    }

    public void setThreadID(String id) {
        this.threadID = id;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setServerModifiableFields(CommentEnvelope other) {
        this.setMessageURL(other.getMessageURL());
        this.setAnnotationFileURL(other.getAnnotationFileURL());
        this.setLastModifiedOnServer(other.getLastModifiedOnServer());
        this.setReadOnly(other.isReadOnly());
    }

    public void setUninterestingFields(CommentEnvelope other) {
        this.setModificationDate(other.getModificationDate());
    }

    public Element getElement(String nameSpaceURI, Document doc) {
        Element coltime = doc.createElementNS(nameSpaceURI, "ColTime");
        coltime.setAttribute("ColTimeMessageID", this.messageID);
        coltime.setAttribute("URL", this.messageURL);
        Element initials = doc.createElementNS(nameSpaceURI, "Initials");
        initials.appendChild(doc.createTextNode(this.initials));
        Element threadid = doc.createElementNS(nameSpaceURI, "ThreadID");
        threadid.appendChild(doc.createTextNode(this.threadID));
        Element sender = doc.createElementNS(nameSpaceURI, "Sender");
        sender.appendChild(doc.createTextNode(this.sender));
        Element creationdate = doc.createElementNS(nameSpaceURI, "CreationDate");
        creationdate.appendChild(doc.createTextNode(this.getCreationDateString()));
        Element modificationdate = doc.createElementNS(nameSpaceURI, "ModificationDate");
        modificationdate.appendChild(doc.createTextNode(this.getModificationDateString()));
        Element category = doc.createElementNS(nameSpaceURI, "Category");
        category.appendChild(doc.createTextNode(this.category));
        Element status = doc.createElementNS(nameSpaceURI, "Status");
        status.appendChild(doc.createTextNode(this.status));
        Element metadata = doc.createElementNS(nameSpaceURI, "Metadata");
        metadata.appendChild(initials);
        metadata.appendChild(threadid);
        metadata.appendChild(sender);
        String[] recipients = this.getRecipients();
        if (recipients != null) {
            for (String r : recipients) {
                Element recipient = doc.createElementNS(nameSpaceURI, "Recipient");
                recipient.appendChild(doc.createTextNode(r));
                metadata.appendChild(recipient);
            }
        }
        metadata.appendChild(creationdate);
        metadata.appendChild(modificationdate);
        metadata.appendChild(category);
        metadata.appendChild(status);
        Element annotationfile = doc.createElementNS(nameSpaceURI, "AnnotationFile");
        annotationfile.setAttribute("URL", this.annotationFileURL);
        annotationfile.setAttribute("type", this.annotationFileType);
        annotationfile.appendChild(doc.createTextNode(this.getAnnotationFile()));
        Element message = doc.createElementNS(nameSpaceURI, "Message");
        message.appendChild(doc.createTextNode(this.message));
        coltime.appendChild(metadata);
        coltime.appendChild(annotationfile);
        coltime.appendChild(message);
        return coltime;
    }

    public CommentEnvelope() {
    }

    public CommentEnvelope(Element e) {
        this();
        this.messageID = e.getAttribute("ColTimeMessageID");
        this.messageURL = e.getAttribute("URL");
        NodeList l1 = e.getChildNodes();
        for (int i1 = 0; i1 < l1.getLength(); ++i1) {
            Node n1 = l1.item(i1);
            if (!(n1 instanceof Element)) continue;
            Element e1 = (Element)n1;
            String name = e1.getLocalName();
            if ("Metadata".equals(name)) {
                NodeList l2 = e1.getChildNodes();
                for (int i2 = 0; i2 < l2.getLength(); ++i2) {
                    Node n2 = l2.item(i2);
                    if (!(n2 instanceof Element)) continue;
                    Element e2 = (Element)n2;
                    String name2 = e2.getLocalName();
                    if ("Initials".equals(name2)) {
                        this.initials = e2.getTextContent();
                        continue;
                    }
                    if ("ThreadID".equals(name2)) {
                        this.threadID = e2.getTextContent();
                        continue;
                    }
                    if ("Sender".equals(name2)) {
                        this.sender = e2.getTextContent();
                        continue;
                    }
                    if ("Recipient".equals(name2)) {
                        this.addRecipient(e2.getTextContent());
                        continue;
                    }
                    if ("CreationDate".equals(name2)) {
                        this.setCreationDate(e2.getTextContent());
                        continue;
                    }
                    if ("ModificationDate".equals(name2)) {
                        this.setModificationDate(e2.getTextContent());
                        continue;
                    }
                    if ("Category".equals(name2)) {
                        this.setCategory(e2.getTextContent());
                        continue;
                    }
                    if (!"Status".equals(name2)) continue;
                    this.setStatus(e2.getTextContent());
                }
                continue;
            }
            if ("AnnotationFile".equals(name)) {
                this.setAnnotationFile(e1.getTextContent());
                this.annotationFileURL = e1.getAttribute("URL");
                this.annotationFileType = e1.getAttribute("type");
                continue;
            }
            if (!"Message".equals(name)) continue;
            this.message = e1.getTextContent();
        }
    }

    @Override
    public int compareTo(CommentEnvelope other) {
        if (this.startTime < other.startTime) {
            return -1;
        }
        if (this.startTime > other.startTime) {
            return 1;
        }
        if (this.endTime < other.endTime) {
            return -1;
        }
        if (this.endTime > other.endTime) {
            return 1;
        }
        return 0;
    }

    public boolean isNewerThan(Date other) {
        return this.getModificationDate().after(other);
    }

    public boolean isNewerThan(CommentEnvelope other) {
        return this.getModificationDate().after(other.getModificationDate());
    }

    public boolean interestingValueEquals(CommentEnvelope other) {
        if (this == other) {
            return true;
        }
        return this.messageID.equals(other.messageID) && this.initials.equals(other.initials) && this.threadID.equals(other.threadID) && this.sender.equals(other.sender) && this.recipient.equals(other.recipient) && this.creationDate.equals(other.creationDate) && this.annotationFileType.equals(other.annotationFileType) && this.category.equals(other.category) && this.status.equals(other.status) && this.message.equals(other.message) && this.annotationURIBase.equals(other.annotationURIBase) && this.startTime == other.startTime && this.endTime == other.endTime && this.tierName.equals(other.tierName);
    }

    public boolean valueEquals(CommentEnvelope other) {
        return this.interestingValueEquals(other) && this.modificationDate.equals(other.modificationDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[CommentEnvelope: ");
        sb.append(" messageID=");
        sb.append(this.messageID);
        sb.append(",startTime=");
        sb.append(this.startTime);
        sb.append(",endTime=");
        sb.append(this.endTime);
        sb.append(",message=");
        sb.append(this.message);
        sb.append(",modificationDate=");
        sb.append(this.modificationDate.toString());
        sb.append("]");
        return sb.toString();
    }

    public static String fragmentEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getFragment() {
        StringBuilder sb = new StringBuilder();
        if (this.startTime >= 0L) {
            sb.append("t=");
            sb.append(TimeFormatter.toSSMSString(this.startTime));
            if (this.endTime >= 0L && this.endTime != this.startTime) {
                sb.append("/");
                sb.append(TimeFormatter.toSSMSString(this.endTime));
            }
        }
        if (this.tierName != null & !this.tierName.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append("tier=");
            sb.append(CommentEnvelope.fragmentEncode(this.tierName));
        }
        return sb.toString();
    }

    public static URI getTimeBasedURI(URI urn, long moment) {
        try {
            String fragment = "t=" + TimeFormatter.toSSMSString(moment);
            return new URI(urn.getScheme(), urn.getSchemeSpecificPart(), fragment);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URI getTimeBasedURI(URI urn, long from, long to) {
        if (to == from) {
            return CommentEnvelope.getTimeBasedURI(urn, from);
        }
        String fragment = "t=" + TimeFormatter.toSSMSString(from) + "/" + TimeFormatter.toSSMSString(to);
        try {
            return new URI(urn.getScheme(), urn.getSchemeSpecificPart(), fragment);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URI getTierTimeBasedURI(URI urn, String tier, long moment) {
        String fragment = "t=" + TimeFormatter.toSSMSString(moment) + ";tier=" + CommentEnvelope.fragmentEncode(tier);
        try {
            return new URI(urn.getScheme(), urn.getSchemeSpecificPart(), fragment);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URI getTierTimeBasedURI(URI urn, String tier, long from, long to) {
        String fragment = "t=" + TimeFormatter.toSSMSString(from) + "/" + TimeFormatter.toSSMSString(to) + ";tier=" + CommentEnvelope.fragmentEncode(tier);
        try {
            return new URI(urn.getScheme(), urn.getSchemeSpecificPart(), fragment);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        dateFormat.setTimeZone(tz);
        defaultDate = new Date();
    }
}

