/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.comments;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.comments.CommentTableModel;
import mpi.eudico.client.annotator.gui.ScrollFriendlyTable;
import mpi.eudico.client.annotator.viewer.TableColumnHider;
import mpi.eudico.server.corpora.clom.Transcription;

public class CommentTable
extends ScrollFriendlyTable {
    private static final String COLUMN_WIDTH_PREFS = ".Columns";
    private static final String COLUMN_ORDER_PREFS = ".Columns.Order";
    private static final String COLUMN_HIDDN_PREFS = ".Columns.Hidden";
    TableRowSorter<CommentTableModel> sorter;
    TableColumnHider hider;
    JScrollPane scrollCommentList;

    public CommentTable(CommentTableModel tableModel) {
        super(tableModel);
        this.setAutoResizeMode(0);
        this.getSelectionModel().setSelectionMode(2);
        this.sorter = new TableRowSorter<CommentTableModel>(tableModel);
        this.setRowSorter(this.sorter);
        this.setShowGrid(false);
        this.hider = new TableColumnHider(this);
        int ncols = tableModel.getColumnCount();
        String[] columnNames = new String[ncols];
        for (int i = 0; i < ncols; ++i) {
            columnNames[i] = tableModel.getColumnName(i);
        }
        JPopupMenu tablePopup = this.hider.newPopupMenu(columnNames);
        this.addMouseListener(this.hider);
    }

    public void setScrollPane(JScrollPane scrollCommentList) {
        this.scrollCommentList = scrollCommentList;
        scrollCommentList.addMouseListener(this.hider);
        scrollCommentList.getViewport().setBackground(this.getBackground());
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.scrollCommentList != null) {
            this.scrollCommentList.getViewport().setBackground(bg);
        }
    }

    public void setRowFilter(RowFilter<? super CommentTableModel, ? super Integer> f) {
        this.sorter.setRowFilter(f);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tip = null;
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        try {
            tip = this.getValueAt(rowIndex, colIndex).toString();
        }
        catch (RuntimeException e1) {
            return "";
        }
        int maxLength = 325;
        if (tip.length() < 325) {
            return tip;
        }
        return tip.substring(0, 325);
    }

    public void addListeners(Object l) {
        if (l instanceof MouseListener) {
            this.addMouseListener((MouseListener)l);
        }
        if (l instanceof ListSelectionListener) {
            this.getSelectionModel().addListSelectionListener((ListSelectionListener)l);
        }
        if (l instanceof KeyListener) {
            this.addKeyListener((KeyListener)l);
        }
    }

    public void savePreferences(String prefix, Transcription transcription) {
        HashMap<String, Integer> widthPrefs = new HashMap<String, Integer>();
        ArrayList<String> orderPrefs = new ArrayList<String>();
        TableColumnModel cm = this.getColumnModel();
        int num = this.getColumnCount();
        for (int i = 0; i < num; ++i) {
            TableColumn col = cm.getColumn(i);
            String name = (String)col.getHeaderValue();
            int width = cm.getColumn(i).getWidth();
            widthPrefs.put(name, width);
            orderPrefs.add(name);
        }
        Preferences.set(prefix + COLUMN_WIDTH_PREFS, widthPrefs, transcription, false, false);
        Preferences.set(prefix + COLUMN_ORDER_PREFS, orderPrefs, transcription, false, false);
        Preferences.set(prefix + COLUMN_HIDDN_PREFS, this.hider.getPreferences(), transcription, false, false);
    }

    public void applyPreferences(String prefix, Transcription transcription) {
        List<String> hiddenPref;
        List<String> orderPrefs;
        Map<String, Integer> widthPrefs = Preferences.getMapOfInt(prefix + COLUMN_WIDTH_PREFS, transcription);
        if (widthPrefs != null) {
            TableColumnModel cm = this.getColumnModel();
            int num = cm.getColumnCount();
            for (int i = 0; i < num; ++i) {
                TableColumn column = cm.getColumn(i);
                String name = (String)column.getHeaderValue();
                Integer width = widthPrefs.get(name);
                if (width == null) continue;
                column.setPreferredWidth(width);
                column.setWidth(width);
            }
        }
        if ((orderPrefs = Preferences.getListOfString(prefix + COLUMN_ORDER_PREFS, transcription)) != null) {
            TableColumnModel cm = this.getColumnModel();
            int numCols = this.getColumnCount();
            int num = orderPrefs.size();
            int to = 0;
            block1: for (int i = 0; i < num && to < numCols; ++i) {
                String name = orderPrefs.get(i);
                for (int from = to; from < numCols; ++from) {
                    TableColumn col = cm.getColumn(from);
                    if (!name.equals(col.getHeaderValue())) continue;
                    cm.moveColumn(from, to);
                    ++to;
                    continue block1;
                }
            }
        }
        if ((hiddenPref = Preferences.getListOfString(prefix + COLUMN_HIDDN_PREFS, transcription)) == null) {
            TableModel model = this.getModel();
            ArrayList<String> list = new ArrayList<String>(2);
            list.add(model.getColumnName(6));
            list.add(model.getColumnName(7));
            hiddenPref = list;
        }
        this.hider.applyPreferences(hiddenPref);
    }
}

