/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.dcr;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.LocalDCRConnector;
import mpi.dcr.isocat.RestDCRConnector;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.dcr.DCRCacheReaderWriter;
import mpi.eudico.client.annotator.dcr.ISOCATLanguageCodeMapping;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.LanguageCollection;

public class ELANLocalDCRConnector
extends LocalDCRConnector
implements PreferencesListener {
    private static ELANLocalDCRConnector connector;
    String cacheName = Constants.ELAN_DATA_DIR + File.separator + "DCSelection.xml";
    String cacheName2 = Constants.ELAN_DATA_DIR + File.separator + "DCSelection2.xml";
    private static final int INTERVAL_IN_DAYS = 30;
    private DCRCacheReaderWriter cacheRW;
    private String errorString;

    private ELANLocalDCRConnector() {
        this.name = "ELAN Local DCR Connector";
        try {
            this.cacheRW = new DCRCacheReaderWriter();
            this.cacheRW.setFilePath(this.cacheName2, true);
            this.readDCS();
            this.checkForUpdates();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public static ELANLocalDCRConnector getInstance() {
        if (connector == null) {
            connector = new ELANLocalDCRConnector();
            Preferences.addPreferencesListener(null, connector);
            connector.preferencesChanged();
        }
        return connector;
    }

    @Override
    protected void readDCS() {
        try {
            List<DCSmall> storedDCS = this.cacheRW.read();
            if (storedDCS != null && storedDCS.size() != 0) {
                DCSmall small1 = null;
                for (int i = 0; i < storedDCS.size(); ++i) {
                    small1 = storedDCS.get(i);
                    this.catList.add(small1);
                }
            }
        }
        catch (Exception ex) {
            if (this.cacheRW.getFilePath() == this.cacheName2) {
                this.cacheRW.setFilePath(this.cacheName);
                this.errorString = ex.getMessage();
                this.readDCS();
                this.cacheRW.setFilePath(this.cacheName2);
            }
            ClientLogger.LOG.warning("No data categories found in the cache...: " + this.errorString);
        }
    }

    @Override
    protected void saveDCS() {
        if (this.catList == null) {
            return;
        }
        if (this.cacheRW != null) {
            try {
                this.cacheRW.save(this.catList);
            }
            catch (ParserConfigurationException pce) {
                ClientLogger.LOG.warning("Could not save the DCR cache: " + pce.getMessage());
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Could not save the DCR cache: " + ioe.getMessage());
            }
        }
    }

    @Override
    public void preferencesChanged() {
        String lang = Preferences.getString("DefaultControlledVocabularyLanguage", null);
        if (lang != null && lang.length() != 2) {
            LangInfo info = LanguageCollection.getLanguageInfo(lang);
            if (info != null) {
                lang = LanguageCollection.getLanguageInfo(lang).getId();
            }
            if (lang != null && (lang = ISOCATLanguageCodeMapping.get2LetterLanguageCode(lang)) != null) {
                this.currentLanguage = lang;
            }
        } else {
            this.currentLanguage = lang;
        }
    }

    private void checkForUpdates() {
        RestDCRConnector rconn = new RestDCRConnector();
        ArrayList<DCSmall> dcUpdateList = new ArrayList<DCSmall>();
        DCSmall dcSmall = null;
        for (int i = 0; i < this.catList.size(); ++i) {
            long difference;
            long diffInDays;
            DCSmall dc = (DCSmall)this.catList.get(i);
            if (!dc.isLoaded() || (diffInDays = (difference = Calendar.getInstance().getTimeInMillis() - dc.getLastUpdated()) / 86400000L) < 30L) continue;
            try {
                dcSmall = rconn.getDataCategory(dc.getId());
                if (dcSmall == null) continue;
                dcUpdateList.add(dcSmall);
                continue;
            }
            catch (DCRConnectorException e) {
                ClientLogger.LOG.warning("Could not get data category: " + e.getMessage());
                break;
            }
        }
        if (dcUpdateList.size() > 0) {
            try {
                this.addDataCategories(dcUpdateList);
            }
            catch (DCRConnectorException e) {
                ClientLogger.LOG.warning("Could not add data categories to the DCR cache: " + e.getMessage());
            }
        }
    }
}

