/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.AbstractBasicExportDialog;
import mpi.eudico.client.annotator.gui.AbstractTierSortAndSelectPanel;
import mpi.eudico.client.annotator.gui.FilesTierSortAndSelectPanel;
import mpi.eudico.client.annotator.gui.TranscriptionTierSortAndSelectPanel;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public abstract class AbstractExtTierExportDialog
extends AbstractBasicExportDialog {
    protected final String NOT_SPECIFIED = "not specified";
    protected final JPanel tierSelectionPanel = new JPanel();
    protected final JCheckBox restrictCheckBox = new JCheckBox();
    protected final Selection selection;
    protected List<File> files;
    protected boolean multipleFileExport = false;
    protected List<String> allTierNames;
    protected AbstractTierSortAndSelectPanel tierSelectPanel;
    protected JPanel outerPanel;
    protected JScrollPane outerScrollPane;

    public AbstractExtTierExportDialog(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        super(parent, modal, transcription);
        this.selection = selection;
        this.allTierNames = new ArrayList<String>();
    }

    public AbstractExtTierExportDialog(Frame parent, boolean modal, List<File> files) {
        this(parent, modal, null, null);
        this.files = files;
        this.multipleFileExport = true;
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new GridBagLayout());
        this.outerScrollPane = new JScrollPane(this.outerPanel);
        this.outerScrollPane.setBorder(null);
        this.getContentPane().setLayout(new GridBagLayout());
        this.tierSelectPanel = !this.multipleFileExport ? new TranscriptionTierSortAndSelectPanel(this.transcription, this.getModeForExport()) : new FilesTierSortAndSelectPanel(this.files, this.getModeForExport());
        this.optionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.tierSelectionPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tierSelectionPanel.add((Component)this.tierSelectPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.getContentPane().add((Component)this.titleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = this.insets;
        this.outerPanel.add((Component)this.tierSelectionPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.outerPanel.add((Component)this.optionsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = this.insets;
        this.getContentPane().add((Component)this.outerScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = this.insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.addComponentListener(new SizeListener());
    }

    protected AbstractTierSortAndSelectPanel.Modes getModeForExport() {
        return AbstractTierSortAndSelectPanel.Modes.ALL_TIERS;
    }

    protected void extractTiers(boolean selectOnlyRootTiers) {
        this.multipleFileExport = false;
        this.allTierNames.clear();
        this.allTierNames.addAll(ELANCommandFactory.getViewerManager(this.transcription).getTierOrder().getTierOrder());
        this.tierSelectPanel.setTierOrder(this.allTierNames);
    }

    protected void extractTiersFromFiles() {
        this.multipleFileExport = true;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportDialog.Label.SelectTiers")));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportDialog.Label.Options")));
        this.restrictCheckBox.setText(ElanLocale.getString("ExportDialog.Restrict"));
    }

    protected List<String> getSelectedTiers() {
        return this.tierSelectPanel.getSelectedTiers();
    }

    protected List<String> getHiddenTiers() {
        return this.tierSelectPanel.getHiddenTiers();
    }

    protected String getSelectionMode() {
        return this.tierSelectPanel.getSelectionMode();
    }

    protected List<String> getSelectedItems() {
        return this.tierSelectPanel.getSelectedItems();
    }

    protected List<String> getUnselectedItems() {
        return this.tierSelectPanel.getUnselectedItems();
    }

    protected List<String> getTierOrder() {
        return this.tierSelectPanel.getTierOrder();
    }

    private void setHiddenTiers(List<String> hiddenTiers) {
        if (hiddenTiers == null) {
            return;
        }
        this.tierSelectPanel.setHiddenTiers(hiddenTiers);
    }

    protected void setSelectedTiers(List<String> selectedTiers) {
        this.tierSelectPanel.setSelectedTiers(selectedTiers);
    }

    protected void setSelectionMode(String mode) {
        this.tierSelectPanel.setSelectionMode(mode, null);
    }

    protected void setSelectedItems(List<String> items) {
        this.tierSelectPanel.setSelectedItems(items);
    }

    protected void setUnselectedItems(List<String> items) {
        this.tierSelectPanel.setUnselectedItems(items);
    }

    protected void setSelectedMode(String selectionMode, List<String> hiddenTiers) {
        if (selectionMode == null) {
            return;
        }
        this.tierSelectPanel.setSelectionMode(selectionMode, hiddenTiers);
    }

    protected void setTierOrder(List<String> storedTierOrder) {
        this.tierSelectPanel.setTierOrder(storedTierOrder);
    }

    protected void setRootTiersOnly(boolean rootsOnly) {
        this.tierSelectPanel.setRootTiersOnly(rootsOnly);
    }

    protected boolean isRootTiersOnly() {
        return this.tierSelectPanel.isRootTiersOnly();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
    }

    class SizeListener
    implements ComponentListener {
        SizeListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (AbstractExtTierExportDialog.this.outerScrollPane != null) {
                if (AbstractExtTierExportDialog.this.outerScrollPane.getHorizontalScrollBar().isVisible() || AbstractExtTierExportDialog.this.outerScrollPane.getVerticalScrollBar().isVisible()) {
                    if (AbstractExtTierExportDialog.this.outerScrollPane.getBorder() == null) {
                        AbstractExtTierExportDialog.this.outerScrollPane.setBorder(new LineBorder(Color.GRAY, 1));
                    }
                } else if (AbstractExtTierExportDialog.this.outerScrollPane.getBorder() != null) {
                    AbstractExtTierExportDialog.this.outerScrollPane.setBorder(null);
                }
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.componentResized(e);
        }
    }
}

