/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.ExportFilmStrip;
import mpi.eudico.client.annotator.export.ImageExporter;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.util.ProgressListener;

public class ExportFilmStripDialog
extends ClosableDialog
implements ActionListener,
ProgressListener {
    private JSpinner widthSpinner;
    private JSpinner skipSpinner;
    private JRadioButton everyRB;
    private JRadioButton skipRB;
    private JCheckBox includeFrameTC;
    private JCheckBox includeWavCB;
    private JLabel wavHeightLb;
    private JSpinner heightSpinner;
    private JCheckBox rulerVisCB;
    private JLabel stereoLb;
    private JRadioButton separateRB;
    private JRadioButton mergedRB;
    private JRadioButton blendedRB;
    private JProgressBar progressBar;
    private JButton closeButton;
    private JButton okButton;
    private ExportFilmStrip exporter;
    private ElanMediaPlayer[] players;
    private String waveFile;
    private Selection selection;
    private final int DEF_WIDTH = 120;
    private final int DEF_SKIP_FRAMES = 2;

    public ExportFilmStripDialog(Frame parent, ElanMediaPlayer[] players, String waveFile, Selection selection) throws HeadlessException {
        super(parent, true);
        if (selection == null || selection.getBeginTime() == selection.getEndTime()) {
            throw new IllegalArgumentException("No valid time selection has been specified");
        }
        this.players = players;
        this.waveFile = waveFile;
        this.selection = selection;
        this.initComponents();
        this.postInit();
    }

    public ExportFilmStripDialog(ElanMediaPlayer[] players, String waveFile, Selection selection) throws HeadlessException {
        super((Frame)null, true);
        if (selection == null || selection.getBeginTime() == selection.getEndTime()) {
            throw new IllegalArgumentException("No valid time selection has been specified");
        }
        this.players = players;
        this.waveFile = waveFile;
        this.selection = selection;
        this.initComponents();
        this.postInit();
    }

    private void postInit() {
        this.pack();
        int w = 460;
        int h = 400;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(4, 6, 4, 6);
        Dimension spinDim = new Dimension(100, 20);
        this.setTitle(ElanLocale.getString("ExportFilmStrip.Title"));
        JLabel titleLabel = new JLabel(ElanLocale.getString("ExportFilmStrip.Title"));
        titleLabel.setFont(titleLabel.getFont().deriveFont(16.0f));
        titleLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.getContentPane().add((Component)titleLabel, gbc);
        JPanel vidPanel = new JPanel(new GridBagLayout());
        vidPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportFilmStrip.Video")));
        JLabel videoWidthLabel = new JLabel(ElanLocale.getString("ExportFilmStrip.VideoFrameWidth"));
        this.widthSpinner = new JSpinner(new SpinnerNumberModel(120, 10, 2000, 5));
        this.widthSpinner.setPreferredSize(spinDim);
        JLabel includeLabel = new JLabel(ElanLocale.getString("ExportFilmStrip.IncludeFrames"));
        this.everyRB = new JRadioButton(ElanLocale.getString("ExportFilmStrip.EveryFrame"));
        this.everyRB.setSelected(true);
        this.skipRB = new JRadioButton(ElanLocale.getString("ExportFilmStrip.EveryNthFrame"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.everyRB);
        bg.add(this.skipRB);
        this.everyRB.addActionListener(this);
        this.skipRB.addActionListener(this);
        this.skipSpinner = new JSpinner(new SpinnerNumberModel(2, 1, 100, 1));
        this.skipSpinner.setPreferredSize(spinDim);
        this.skipSpinner.setEnabled(false);
        this.includeFrameTC = new JCheckBox(ElanLocale.getString("ExportFilmStrip.IncludeTimeCode"));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        vidPanel.add((Component)videoWidthLabel, gbc);
        gbc.gridx = 1;
        vidPanel.add((Component)this.widthSpinner, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        vidPanel.add((Component)includeLabel, gbc);
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 16, 0, 6);
        vidPanel.add((Component)this.everyRB, gbc);
        gbc.gridy = 3;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 16, 4, 6);
        vidPanel.add((Component)this.skipRB, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, 6, 4, 6);
        vidPanel.add((Component)this.skipSpinner, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = insets;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        vidPanel.add((Component)this.includeFrameTC, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.getContentPane().add((Component)vidPanel, gbc);
        JPanel audPanel = new JPanel(new GridBagLayout());
        audPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportFilmStrip.Waveform")));
        this.includeWavCB = new JCheckBox(ElanLocale.getString("ExportFilmStrip.Waveform.Include"));
        this.includeWavCB.setSelected(true);
        this.includeWavCB.addActionListener(this);
        this.wavHeightLb = new JLabel(ElanLocale.getString("ExportFilmStrip.Waveform.Height"));
        this.heightSpinner = new JSpinner(new SpinnerNumberModel(120, 20, 400, 5));
        this.heightSpinner.setPreferredSize(spinDim);
        this.rulerVisCB = new JCheckBox(ElanLocale.getString("TimeScaleBasedViewer.TimeRuler.Visible"));
        this.stereoLb = new JLabel(ElanLocale.getString("SignalViewer.Stereo"));
        this.separateRB = new JRadioButton(ElanLocale.getString("SignalViewer.Stereo.Separate"));
        this.separateRB.setSelected(true);
        this.mergedRB = new JRadioButton(ElanLocale.getString("SignalViewer.Stereo.Merged"));
        this.blendedRB = new JRadioButton(ElanLocale.getString("SignalViewer.Stereo.Blended"));
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.separateRB);
        bg2.add(this.mergedRB);
        bg2.add(this.blendedRB);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.gridwidth = 2;
        audPanel.add((Component)this.includeWavCB, gbc);
        Insets insets2 = new Insets(4, 16, 4, 6);
        gbc.gridy = 1;
        gbc.insets = insets2;
        audPanel.add((Component)this.rulerVisCB, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        audPanel.add((Component)this.wavHeightLb, gbc);
        gbc.gridx = 1;
        gbc.insets = insets;
        audPanel.add((Component)this.heightSpinner, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = insets2;
        audPanel.add((Component)this.stereoLb, gbc);
        gbc.gridy = 4;
        gbc.insets = new Insets(4, 26, 2, 6);
        audPanel.add((Component)this.separateRB, gbc);
        gbc.gridy = 5;
        gbc.insets = new Insets(0, 26, 0, 6);
        audPanel.add((Component)this.mergedRB, gbc);
        gbc.gridy = 6;
        gbc.insets = new Insets(2, 26, 4, 6);
        audPanel.add((Component)this.blendedRB, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.getContentPane().add((Component)audPanel, gbc);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 6, 10, 6);
        this.getContentPane().add((Component)this.progressBar, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 1, 6, 2));
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.closeButton = new JButton(ElanLocale.getString("Button.Close"));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.closeButton);
        this.okButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridy = 4;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 15;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.setPreferredSetting();
        if (this.waveFile == null) {
            this.includeWavCB.setSelected(false);
            this.enableWaveFormUI(false);
        }
    }

    private void enableButtons(boolean enable) {
        this.okButton.setEnabled(enable);
        this.closeButton.setEnabled(enable);
    }

    private void enableWaveFormUI(boolean enabled) {
        this.wavHeightLb.setEnabled(enabled);
        this.rulerVisCB.setEnabled(enabled);
        this.stereoLb.setEnabled(enabled);
        this.separateRB.setEnabled(enabled);
        this.mergedRB.setEnabled(enabled);
        this.blendedRB.setEnabled(enabled);
    }

    private void startExport() {
        this.savePreferences();
        int vidWidth = (Integer)this.widthSpinner.getValue();
        int framesStep = 1;
        if (this.skipRB.isSelected()) {
            framesStep = (Integer)this.skipSpinner.getValue();
        }
        boolean includeWav = this.includeWavCB.isSelected();
        if (this.waveFile == null) {
            includeWav = false;
        }
        boolean includeRuler = this.rulerVisCB.isSelected();
        int wavHeight = (Integer)this.heightSpinner.getValue();
        int stereoMode = 0;
        if (this.separateRB.isSelected()) {
            stereoMode = 1;
        } else if (this.mergedRB.isSelected()) {
            stereoMode = 2;
        } else if (this.blendedRB.isSelected()) {
            stereoMode = 3;
        }
        this.progressBar.setValue(0);
        this.exporter = new ExportFilmStrip(this.players, this.waveFile, vidWidth, framesStep, includeWav, wavHeight);
        this.exporter.setIncludeTimeCodeInFrames(this.includeFrameTC.isSelected());
        if (includeWav) {
            this.exporter.setTimeRulerVisible(includeRuler);
            this.exporter.setStereoMode(stereoMode);
        }
        this.exporter.addProgressListener(this);
        this.exporter.createImageInThread(this.selection.getBeginTime(), this.selection.getEndTime());
    }

    private void saveImage() {
        if (this.exporter != null) {
            Image img = this.exporter.getImage();
            if (img != null) {
                ImageExporter ie = new ImageExporter();
                ie.exportImage(img);
            } else {
                JOptionPane.showMessageDialog(this.getParent(), ElanLocale.getString("ExportFilmStrip.Error.NoImage"), ElanLocale.getString("Message.Warning"), 2);
            }
        }
        this.progressBar.setValue(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            if (this.exporter != null) {
                this.exporter.removeProgressListener(this);
            }
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.okButton) {
            this.enableButtons(false);
            this.startExport();
        } else if (e.getSource() == this.includeWavCB) {
            this.enableWaveFormUI(this.includeWavCB.isSelected());
        } else if (e.getSource() == this.everyRB || e.getSource() == this.skipRB) {
            this.skipSpinner.setEnabled(this.skipRB.isSelected());
        }
    }

    @Override
    public void progressCompleted(Object source, String message) {
        if (message != null) {
            this.progressBar.setValue(100);
            this.progressBar.setString(message);
        }
        this.enableButtons(true);
        this.saveImage();
    }

    @Override
    public void progressInterrupted(Object source, String message) {
        if (message != null) {
            this.progressBar.setString(message);
        }
        JOptionPane.showMessageDialog(this.getParent(), ElanLocale.getString("ExportFilmStrip.Error.Unknown") + " " + message, ElanLocale.getString("Message.Warning"), 2);
        this.progressBar.setValue(0);
        this.enableButtons(true);
    }

    @Override
    public void progressUpdated(Object source, int percent, String message) {
        if (message != null) {
            this.progressBar.setString(message);
        }
        this.progressBar.setValue(percent);
        if (percent == this.progressBar.getMaximum()) {
            this.enableButtons(true);
            this.saveImage();
        }
    }

    private void setPreferredSetting() {
        Integer intPref;
        Boolean boolPref = Preferences.getBool("ExportFilmStripDialog.everyRB", null);
        if (boolPref != null) {
            this.everyRB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportFilmStripDialog.skipRB", null)) != null) {
            this.skipRB.setSelected(boolPref);
        }
        this.skipSpinner.setEnabled(this.skipRB.isSelected());
        boolPref = Preferences.getBool("ExportFilmStripDialog.includeFrameTC", null);
        if (boolPref != null) {
            this.includeFrameTC.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportFilmStripDialog.includeWavCB", null)) != null) {
            this.includeWavCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportFilmStripDialog.rulerVisCB", null)) != null) {
            this.rulerVisCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportFilmStripDialog.separateRB", null)) != null) {
            this.separateRB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportFilmStripDialog.mergedRB", null)) != null) {
            this.mergedRB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportFilmStripDialog.blendedRB", null)) != null) {
            this.blendedRB.setSelected(boolPref);
        }
        if ((intPref = Preferences.getInt("ExportFilmStripDialog.VideoImageWidth", null)) != null) {
            this.widthSpinner.setValue(intPref);
        }
        if ((intPref = Preferences.getInt("ExportFilmStripDialog.EveryNthFrame", null)) != null) {
            this.skipSpinner.setValue(intPref);
        }
        if ((intPref = Preferences.getInt("ExportFilmStripDialog.WaveHeight", null)) != null) {
            this.heightSpinner.setValue(intPref);
        }
    }

    private void savePreferences() {
        Integer wavHeight;
        Integer skipFrames;
        Preferences.set("ExportFilmStripDialog.everyRB", this.everyRB.isSelected(), null);
        Preferences.set("ExportFilmStripDialog.skipRB", this.skipRB.isSelected(), null);
        Preferences.set("ExportFilmStripDialog.includeFrameTC", this.includeFrameTC.isSelected(), null);
        Preferences.set("ExportFilmStripDialog.includeWavCB", this.includeWavCB.isSelected(), null);
        Preferences.set("ExportFilmStripDialog.rulerVisCB", this.rulerVisCB.isSelected(), null);
        Preferences.set("ExportFilmStripDialog.separateRB", this.separateRB.isSelected(), null);
        Preferences.set("ExportFilmStripDialog.mergedRB", this.mergedRB.isSelected(), null);
        Preferences.set("ExportFilmStripDialog.blendedRB", this.blendedRB.isSelected(), null);
        Integer vidWidth = (Integer)this.widthSpinner.getValue();
        if (vidWidth != 120 || Preferences.getInt("ExportFilmStripDialog.VideoImageWidth", null) != null) {
            Preferences.set("ExportFilmStripDialog.VideoImageWidth", vidWidth, null);
        }
        if (this.skipRB.isSelected() && ((skipFrames = (Integer)this.skipSpinner.getValue()) != 2 || Preferences.getInt("ExportFilmStripDialog.EveryNthFrame", null) != null)) {
            Preferences.set("ExportFilmStripDialog.EveryNthFrame", skipFrames, null);
        }
        if (this.includeWavCB.isSelected() && ((wavHeight = (Integer)this.heightSpinner.getValue()) != 120 || Preferences.getInt("ExportFilmStripDialog.WaveHeight", null) != null)) {
            Preferences.set("ExportFilmStripDialog.WaveHeight", this.heightSpinner.getValue(), null);
        }
    }
}

