/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.util.TableSubHeaderObject;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.flex.FlexConstants;
import mpi.eudico.server.corpora.clomimpl.flex.FlexEncoderInfo;

public class ExportFlexStep3
extends StepPane {
    private TranscriptionImpl transcription;
    private final String SELECT_TYPE = ElanLocale.getString("TranscriptionManager.ComboBoxDefaultString");
    private final String SELECT_LANG = ElanLocale.getString("ExportFlexStep3.SelectLang");
    private FlexEncoderInfo encoderInfo;
    private JTable table;
    private DefaultTableModel model;
    private JRadioButton linTypeRB;
    private JRadioButton tierRB;
    private JRadioButton typeRB;
    private JRadioButton langRB;
    private JTextField addCustomValueTF;
    private JComboBox<String> removeValueCombo;
    private JButton addButton;
    private JButton removeButton;
    private HashMap<String, List<String>> tierMap;
    private HashMap<String, List<String>> linTypeMap;
    private HashMap<String, List<String>> tierTypeLangMap;
    private List<String> tierContentLanguages;
    protected Insets globalInset = new Insets(2, 4, 2, 4);
    private String DEL = "-";
    private List<String> typeList;
    private List<String> langList;
    private final String TIERS = "ExportFlex.LangTypeValue.BasedOnTiers";
    private final String TYPE_LANG = "ExportFlex.AddRemove.LangOrType";

    public ExportFlexStep3(MultiStepPane mp, TranscriptionImpl transcription) {
        super(mp);
        this.transcription = transcription;
        this.tierContentLanguages = new ArrayList<String>();
        this.tierTypeLangMap = new HashMap();
        this.tierMap = new HashMap();
        this.linTypeMap = new HashMap();
        this.typeList = new ArrayList<String>();
        for (String element : FlexConstants.DEFINED_TYPES) {
            this.typeList.add(element);
        }
        this.langList = new ArrayList<String>();
        this.initComponents();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("ExportFlexStep3.Title");
    }

    @Override
    public void enterStepForward() {
        this.encoderInfo = (FlexEncoderInfo)this.multiPane.getStepProperty("EncoderInfo");
        this.updateMapsForType("interlinear-text");
        this.updateMapsForType("phrase");
        this.updateMapsForType("word");
        this.updateMapsForType("morph");
        this.extractLanguagesFromNames();
        this.extractContentLanguages();
        this.updateTable();
        Collections.sort(this.typeList);
        Collections.sort(this.langList);
        this.updateRemoveValuesComboBoxItems();
        this.updateButtonStates();
    }

    private void updateMapsForType(String flextype) {
        ArrayList<TierImpl> tierImplList = new ArrayList<TierImpl>();
        tierImplList.addAll(this.encoderInfo.getMappingForElement(flextype));
        tierImplList.addAll(this.encoderInfo.getMappingForItem(flextype));
        ArrayList<String> typeList = new ArrayList<String>();
        ArrayList<String> tierList = new ArrayList<String>();
        for (int i = 0; i < tierImplList.size(); ++i) {
            String typeName = ((TierImpl)tierImplList.get(i)).getLinguisticType().getLinguisticTypeName();
            if (!typeList.contains(typeName)) {
                typeList.add(typeName);
            }
            String tierName = ((TierImpl)tierImplList.get(i)).getName();
            tierList.add(tierName);
        }
        this.linTypeMap.put(flextype, typeList);
        this.tierMap.put(flextype, tierList);
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        this.storePreferences();
        this.tierTypeLangMap.clear();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (this.table.getValueAt(i, 1) instanceof TableSubHeaderObject) continue;
            String name = (String)this.table.getValueAt(i, 0);
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.add((String)this.table.getValueAt(i, 1));
            valueList.add((String)this.table.getValueAt(i, 2));
            if (this.linTypeRB.isSelected()) {
                List<TierImpl> tiers = this.transcription.getTiersWithLinguisticType(name);
                for (int t = 0; t < tiers.size(); ++t) {
                    this.tierTypeLangMap.put(tiers.get(t).getName(), valueList);
                }
                continue;
            }
            this.tierTypeLangMap.put(name, valueList);
        }
        this.encoderInfo.setTypeLangMap(this.tierTypeLangMap);
        this.multiPane.putStepProperty("EncoderInfo", this.encoderInfo);
        return true;
    }

    public void updateButtonStates() {
        boolean next_Button = true;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (this.table.getValueAt(i, 1) instanceof TableSubHeaderObject) continue;
            Object val = this.table.getValueAt(i, 1);
            if (val == null || val.equals(this.SELECT_TYPE)) {
                next_Button = false;
                break;
            }
            val = this.table.getValueAt(i, 2);
            if (val != null && !val.equals(this.SELECT_LANG)) continue;
            next_Button = false;
            break;
        }
        this.multiPane.setButtonEnabled(1, next_Button);
        this.multiPane.setButtonEnabled(2, true);
    }

    private void loadPreferences() {
        Boolean boolPref = Preferences.getBool("ExportFlex.LangTypeValue.BasedOnTiers", null);
        if (boolPref != null) {
            this.tierRB.setSelected(boolPref);
            this.linTypeRB.setSelected(boolPref == false);
        }
        String stringPref = Preferences.getString("ExportFlex.AddRemove.LangOrType", null);
        if (boolPref != null && "language".equals(stringPref)) {
            this.langRB.setSelected(true);
        }
    }

    private void storePreferences() {
        Preferences.set("ExportFlex.LangTypeValue.BasedOnTiers", this.tierRB.isSelected(), null);
        Preferences.set("ExportFlex.AddRemove.LangOrType", this.typeRB.isSelected() ? "type" : "language", null);
    }

    @Override
    protected void initComponents() {
        ActionHandler actionHandler = new ActionHandler();
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column == 0) {
                    return false;
                }
                return this.getValueAt(row, column) instanceof String;
            }
        };
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer(){
            private Color DEF_LABEL_BG;
            {
                this.DEF_LABEL_BG = new Color(ExportFlexStep3.this.getBackground().getRed(), ExportFlexStep3.this.getBackground().getGreen(), ExportFlexStep3.this.getBackground().getBlue());
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    return cell;
                }
                if (value instanceof TableSubHeaderObject) {
                    cell.setFont(new Font(table.getFont().getName(), 1, table.getFont().getSize() + 1));
                    cell.setBackground(this.DEF_LABEL_BG);
                    cell.setForeground(Color.BLACK);
                } else if (value.equals(ExportFlexStep3.this.SELECT_TYPE) || value.equals(ExportFlexStep3.this.SELECT_LANG)) {
                    cell.setForeground(Color.GRAY);
                    cell.setBackground(Color.WHITE);
                } else {
                    cell.setForeground(Color.BLACK);
                    cell.setBackground(Color.WHITE);
                }
                return cell;
            }
        };
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(Object.class, tableRenderer);
        this.table.setDefaultEditor(Object.class, new TableCellEditor());
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.BLACK);
        this.table.setSelectionBackground(Color.WHITE);
        this.linTypeRB = new JRadioButton(ElanLocale.getString("ExportFlexStep3.LingType"));
        this.linTypeRB.addActionListener(actionHandler);
        this.tierRB = new JRadioButton(ElanLocale.getString("ExportFlexStep3.Tier"));
        this.tierRB.addActionListener(actionHandler);
        this.tierRB.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.tierRB);
        group.add(this.linTypeRB);
        this.typeRB = new JRadioButton("type");
        this.typeRB.addActionListener(actionHandler);
        this.langRB = new JRadioButton("language");
        this.langRB.addActionListener(actionHandler);
        this.typeRB.setSelected(true);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.typeRB);
        group1.add(this.langRB);
        this.addCustomValueTF = new JTextField();
        this.removeValueCombo = new JComboBox();
        this.addButton = new JButton(ElanLocale.getString("Button.Add"));
        this.removeButton = new JButton(ElanLocale.getString("Button.Remove"));
        this.addButton.addActionListener(actionHandler);
        this.removeButton.addActionListener(actionHandler);
        JPanel radioPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        radioPanel.add((Component)this.typeRB, gbc);
        gbc.gridx = 1;
        radioPanel.add((Component)this.langRB, gbc);
        JPanel configPanel = new JPanel();
        configPanel.setLayout(new GridBagLayout());
        configPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportFlexStep3.Title.Configuration")));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.anchor = 18;
        gbc.fill = 0;
        configPanel.add((Component)new JLabel(ElanLocale.getString("ExportFlexStep3.Label.AddRemove")), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        configPanel.add((Component)radioPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        configPanel.add((Component)new JLabel(ElanLocale.getString("ExportFlexStep3.Label.AddCustomVal")), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        configPanel.add((Component)this.addCustomValueTF, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        configPanel.add((Component)this.addButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        configPanel.add((Component)new JLabel(ElanLocale.getString("ExportFlexStep3.Label.RemoveVal")), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        configPanel.add(this.removeValueCombo, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        configPanel.add((Component)this.removeButton, gbc);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(new TitledBorder(ElanLocale.getString("ExportFlexStep3.Title.Specification")));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 20, 2, 4);
        panel.add((Component)this.tierRB, gbc);
        gbc.gridx = 1;
        gbc.insets = this.globalInset;
        panel.add((Component)this.linTypeRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel.add((Component)new JScrollPane(this.table), gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        this.add((Component)panel, gbc);
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)configPanel, gbc);
        this.loadPreferences();
    }

    private void updateTable() {
        HashMap<String, List<String>> map;
        while (this.table.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        if (this.tierRB.isSelected()) {
            this.model.setColumnIdentifiers(new String[]{"TierName", "type", "language"});
            map = this.tierMap;
        } else {
            this.model.setColumnIdentifiers(new String[]{"Linguistic Type Name", "type", "language"});
            map = this.linTypeMap;
        }
        this.addRowsFor("interlinear-text", map.get("interlinear-text"));
        this.addRowsFor("phrase", map.get("phrase"));
        this.addRowsFor("word", map.get("word"));
        this.addRowsFor("morph", map.get("morph"));
    }

    private void addRowsFor(String flexType, List<String> valList) {
        this.model.addRow(new Object[]{new TableSubHeaderObject(flexType), new TableSubHeaderObject(""), new TableSubHeaderObject("")});
        for (int i = 0; i < valList.size(); ++i) {
            String type = this.getTypeName(valList.get(i));
            String lang = this.getLanguage(valList.get(i));
            if (i == 0 && !flexType.equals("interlinear-text")) {
                if (type.equals(this.SELECT_TYPE)) {
                    type = "txt";
                }
                if (lang == null) {
                    lang = this.SELECT_LANG;
                }
            } else if (type.equals(this.SELECT_TYPE)) {
                lang = null;
            } else if (lang == null) {
                lang = this.SELECT_LANG;
            }
            if (!type.equals(this.SELECT_TYPE) && !this.typeList.contains(type)) {
                this.typeList.add(type);
            }
            if (lang != null && !lang.equals(this.SELECT_LANG) && !this.langList.contains(lang)) {
                this.langList.add(lang);
            }
            this.model.addRow(new String[]{valList.get(i), type, lang});
        }
    }

    private String getTypeName(String tierTypeName) {
        String type = null;
        if (tierTypeName.startsWith("interlinear-text")) {
            tierTypeName = tierTypeName.substring("interlinear-text".length());
        }
        for (String cl : this.tierContentLanguages) {
            int li;
            if (!tierTypeName.endsWith(cl) || (li = tierTypeName.lastIndexOf(cl)) <= 0 || tierTypeName.charAt(li - 1) != this.DEL.charAt(0)) continue;
            int fi = (tierTypeName = tierTypeName.substring(0, li - 1)).indexOf(this.DEL);
            if (fi > -1 && fi < tierTypeName.length() - 1) {
                return tierTypeName.substring(fi + 1);
            }
            return tierTypeName;
        }
        String[] compsArray = tierTypeName.split(this.DEL);
        if (compsArray.length == 3) {
            type = compsArray[1];
        } else if (compsArray.length > 3) {
            type = tierTypeName.substring(tierTypeName.indexOf(this.DEL) + 1, tierTypeName.lastIndexOf(this.DEL));
        } else if (compsArray.length == 2) {
            type = compsArray[0];
        }
        if (type == null || type.equals("item")) {
            type = this.SELECT_TYPE;
        }
        return type;
    }

    private String getLanguage(String tierTypeName) {
        TierImpl t;
        for (String cl : this.tierContentLanguages) {
            int li;
            if (!tierTypeName.endsWith(cl) || (li = tierTypeName.lastIndexOf(cl)) <= 0 || tierTypeName.charAt(li - 1) != this.DEL.charAt(0)) continue;
            return tierTypeName.substring(li);
        }
        String lang = this.getLanguageFromName(tierTypeName);
        if (lang == null && (t = this.transcription.getTierWithId(tierTypeName)) != null && t.getLangRef() != null && !t.getLangRef().isEmpty()) {
            return t.getLangRef();
        }
        return lang;
    }

    private void validateRowValues() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (this.table.getValueAt(i, 1) instanceof TableSubHeaderObject) continue;
            String type = (String)this.table.getValueAt(i, 1);
            String language = (String)this.table.getValueAt(i, 2);
            if (!this.typeList.contains(type)) {
                this.table.setValueAt(this.SELECT_TYPE, i, 1);
                this.table.setValueAt(null, i, 2);
                continue;
            }
            if (this.langList.contains(language)) continue;
            this.table.setValueAt(this.SELECT_LANG, i, 2);
        }
    }

    private void updateRemoveValuesComboBoxItems() {
        this.removeValueCombo.removeAllItems();
        this.removeValueCombo.addItem("<select>");
        if (this.typeRB.isSelected()) {
            for (int i = 0; i < this.typeList.size(); ++i) {
                this.removeValueCombo.addItem(this.typeList.get(i));
            }
        } else {
            for (int i = 0; i < this.langList.size(); ++i) {
                this.removeValueCombo.addItem(this.langList.get(i));
            }
        }
    }

    private void extractContentLanguages() {
        this.tierContentLanguages.clear();
        for (TierImpl tier : this.transcription.getTiers()) {
            String langRef = tier.getLangRef();
            if (langRef == null || langRef.isEmpty() || this.tierContentLanguages.contains(langRef)) continue;
            this.tierContentLanguages.add(langRef);
        }
        if (this.tierContentLanguages.size() == 0) {
            return;
        }
        int i = this.tierContentLanguages.size() - 1;
        int count = 0;
        while (i >= 0) {
            String s1 = this.tierContentLanguages.get(i);
            for (int j = 0; j <= i && j != i; ++j) {
                String s2 = this.tierContentLanguages.get(j);
                if (s1.length() <= s2.length()) continue;
                this.tierContentLanguages.remove(s1);
                this.tierContentLanguages.add(j, s1);
                ++i;
                break;
            }
            if (count == this.tierContentLanguages.size() - 1) break;
            --i;
            ++count;
        }
        for (String cl : this.tierContentLanguages) {
            if (this.langList.contains(cl)) continue;
            this.langList.add(cl);
        }
    }

    private void extractLanguagesFromNames() {
        String name;
        this.langList.clear();
        for (List<String> typeList : this.linTypeMap.values()) {
            for (String typeName : typeList) {
                name = this.getLanguageFromName(typeName);
                if (name == null || this.langList.contains(name)) continue;
                this.langList.add(name);
            }
        }
        for (List<String> tierList : this.tierMap.values()) {
            for (String tierName : tierList) {
                name = this.getLanguageFromName(tierName);
                if (name == null || this.langList.contains(name)) continue;
                this.langList.add(name);
            }
        }
    }

    private String getLanguageFromName(String tierTypeName) {
        if (tierTypeName == null || tierTypeName.isEmpty()) {
            return null;
        }
        String lang = null;
        if (tierTypeName.startsWith("interlinear-text")) {
            tierTypeName = tierTypeName.substring("interlinear-text".length());
        }
        int delCount = 0;
        int ci = -1;
        int si = 0;
        do {
            if ((ci = tierTypeName.indexOf(this.DEL, si)) <= -1) continue;
            ++delCount;
            si = ci + 1;
        } while (ci > -1 && ci < tierTypeName.length());
        if (delCount == 1 || delCount == 2) {
            int lindex = tierTypeName.lastIndexOf(this.DEL);
            if (lindex > -1 && lindex < tierTypeName.length() - 2) {
                lang = tierTypeName.substring(lindex + 1);
            }
        } else if (delCount > 2 && (ci = tierTypeName.indexOf(this.DEL, (si = tierTypeName.indexOf(this.DEL)) + 1)) > -1 && ci < tierTypeName.length() - 2) {
            lang = tierTypeName.substring(ci + 1);
        }
        return lang;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value;
            Object source = e.getSource();
            if (source.equals(ExportFlexStep3.this.linTypeRB) || source.equals(ExportFlexStep3.this.tierRB)) {
                ExportFlexStep3.this.updateTable();
                ExportFlexStep3.this.updateButtonStates();
            } else if (source instanceof JRadioButton) {
                List values = source.equals(ExportFlexStep3.this.typeRB) ? ExportFlexStep3.this.typeList : ExportFlexStep3.this.langList;
                ExportFlexStep3.this.removeValueCombo.removeAllItems();
                ExportFlexStep3.this.removeValueCombo.addItem("<select>");
                for (int i = 0; i < values.size(); ++i) {
                    ExportFlexStep3.this.removeValueCombo.addItem((String)values.get(i));
                }
            } else if (source.equals(ExportFlexStep3.this.addButton)) {
                String value2 = ExportFlexStep3.this.addCustomValueTF.getText().trim();
                if (ExportFlexStep3.this.typeRB.isSelected()) {
                    if (!ExportFlexStep3.this.typeList.contains(value2)) {
                        ExportFlexStep3.this.typeList.add(value2);
                        Collections.sort(ExportFlexStep3.this.typeList);
                        ExportFlexStep3.this.updateRemoveValuesComboBoxItems();
                        if (ExportFlexStep3.this.table.getCellEditor() != null && ExportFlexStep3.this.table.getEditingColumn() == 1) {
                            ExportFlexStep3.this.table.getCellEditor().cancelCellEditing();
                        }
                    }
                } else if (!ExportFlexStep3.this.langList.contains(value2)) {
                    ExportFlexStep3.this.langList.add(value2);
                    Collections.sort(ExportFlexStep3.this.langList);
                    ExportFlexStep3.this.updateRemoveValuesComboBoxItems();
                    if (ExportFlexStep3.this.table.getCellEditor() != null && ExportFlexStep3.this.table.getEditingColumn() == 2) {
                        ExportFlexStep3.this.table.getCellEditor().cancelCellEditing();
                    }
                }
                ExportFlexStep3.this.addCustomValueTF.setText("");
            } else if (source.equals(ExportFlexStep3.this.removeButton) && (value = (String)ExportFlexStep3.this.removeValueCombo.getSelectedItem()) != null) {
                if (ExportFlexStep3.this.typeRB.isSelected()) {
                    ExportFlexStep3.this.typeList.remove(value);
                } else {
                    ExportFlexStep3.this.langList.remove(value);
                }
                ExportFlexStep3.this.removeValueCombo.removeItem(value);
                ExportFlexStep3.this.removeValueCombo.setSelectedIndex(0);
                ExportFlexStep3.this.validateRowValues();
            }
        }
    }

    private class TableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private int startEditInOneClick;
        private JComboBox<String> comboBox;
        private int row;
        private int column;
        private Object value;
        private String participant;

        public TableCellEditor() {
            super(new JComboBox());
            this.startEditInOneClick = 1;
            this.setClickCountToStart(this.startEditInOneClick);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.column = column;
            this.value = value;
            ArrayList<String> usedValues = new ArrayList<String>();
            List values = null;
            if (column == 1) {
                values = ExportFlexStep3.this.typeList;
            } else if (column == 2) {
                Object val;
                values = ExportFlexStep3.this.langList;
                this.participant = ExportFlexStep3.this.tierRB.isSelected() ? this.getParticipantFor(ExportFlexStep3.this.transcription.getTierWithId(table.getValueAt(row, 0).toString())) : null;
                String typeVal = (String)table.getValueAt(row, 1);
                for (int index = row - 1; index > -1 && !((val = table.getValueAt(index, 2)) instanceof TableSubHeaderObject); --index) {
                    String par = ExportFlexStep3.this.tierRB.isSelected() ? this.getParticipantFor(ExportFlexStep3.this.transcription.getTierWithId(table.getValueAt(index, 0).toString())) : null;
                    String type = (String)table.getValueAt(index, 1);
                    if (!type.equals(typeVal) || val.toString().equals(ExportFlexStep3.this.SELECT_LANG) || this.participant != null && !this.participant.equals(par)) continue;
                    usedValues.add(val.toString());
                }
            }
            this.comboBox = new JComboBox();
            String selectItem = null;
            for (int i = 0; i < values.size(); ++i) {
                if (!usedValues.contains(values.get(i)) && value != null && ((String)values.get(i)).equals(value)) {
                    selectItem = value.toString();
                }
                this.comboBox.addItem((String)values.get(i));
            }
            this.comboBox.setSelectedItem(selectItem);
            this.comboBox.addActionListener(this);
            return this.comboBox;
        }

        private String getParticipantFor(TierImpl tier) {
            String par = tier.getParticipant();
            if (par == null || par.trim().length() == 0) {
                par = tier.getRootTier().getParticipant();
            }
            return par;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.comboBox.getSelectedIndex() == -1) {
                return this.value;
            }
            return this.comboBox.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportFlexStep3.this.table.editingStopped(new ChangeEvent(this));
            if (this.value.equals(this.comboBox.getSelectedItem())) {
                return;
            }
            if (this.column == 1) {
                String typeVal = (String)this.comboBox.getSelectedItem();
                Object langVal = ExportFlexStep3.this.table.getValueAt(this.row, 2);
                if (langVal == null || langVal.toString().equals(ExportFlexStep3.this.SELECT_LANG)) {
                    ExportFlexStep3.this.table.setValueAt(ExportFlexStep3.this.SELECT_LANG, this.row, 2);
                } else {
                    int index;
                    for (index = this.row - 1; index > -1 && !(ExportFlexStep3.this.table.getValueAt(index, 0) instanceof TableSubHeaderObject); --index) {
                    }
                    if (this.row == ++index) {
                        ++index;
                    }
                    Object obj = ExportFlexStep3.this.table.getValueAt(index, 2);
                    while (obj != null && !(obj instanceof TableSubHeaderObject)) {
                        String type = (String)ExportFlexStep3.this.table.getValueAt(index, 1);
                        String par = ExportFlexStep3.this.tierRB.isSelected() ? ExportFlexStep3.this.transcription.getTierWithId(ExportFlexStep3.this.table.getValueAt(index, 0).toString()).getParticipant() : null;
                        if (type.equals(typeVal) && (this.participant == null || par.equals(this.participant)) && langVal.toString().equals(obj.toString())) {
                            if (this.row > index) {
                                ExportFlexStep3.this.table.setValueAt(ExportFlexStep3.this.SELECT_LANG, this.row, 2);
                            } else {
                                ExportFlexStep3.this.table.setValueAt(ExportFlexStep3.this.SELECT_LANG, index, 2);
                            }
                        }
                        if (this.row == ++index) {
                            ++index;
                        }
                        if (index < ExportFlexStep3.this.table.getRowCount()) {
                            obj = ExportFlexStep3.this.table.getValueAt(index, 2);
                            continue;
                        }
                        obj = null;
                    }
                }
            } else if (this.column == 2) {
                Object langVal = this.comboBox.getSelectedItem();
                String typeVal = (String)ExportFlexStep3.this.table.getValueAt(this.row, 1);
                int index = this.row + 1;
                if (index < ExportFlexStep3.this.table.getRowCount()) {
                    do {
                        Object obj = ExportFlexStep3.this.table.getValueAt(index, 1);
                        Object lang = ExportFlexStep3.this.table.getValueAt(index, 2);
                        if (obj instanceof TableSubHeaderObject) break;
                        if (!obj.toString().equals(typeVal) || lang == null || !lang.equals(langVal)) continue;
                        ExportFlexStep3.this.table.setValueAt(ExportFlexStep3.this.SELECT_LANG, index, 2);
                    } while (++index != ExportFlexStep3.this.table.getRowCount());
                }
            }
            ExportFlexStep3.this.updateButtonStates();
        }
    }
}

