/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ELAN;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.TranscriptionTierSortAndSelectPanel;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.json.JSONWAEncoder;
import mpi.eudico.server.corpora.clomimpl.json.JSONWAEncoderInfo;
import nl.mpi.util.FileExtension;

public class ExportJSONDialog
extends ClosableDialog
implements ActionListener {
    private Transcription transcription;
    private Selection selection;
    private JSONWAEncoderInfo encoderInfo;
    private JButton buttonClose;
    private JButton buttonExport;
    private JButton buttonUpdate;
    private JTextArea textMain;
    private JCheckBox checkLimitSelection;
    private JCheckBox checkPurpose;
    private JCheckBox checkSingleTarget;
    private JRadioButton radioIncrementalID;
    private JRadioButton radioElanID;
    private JRadioButton radioFragment;
    private JRadioButton radioSelector;
    private JRadioButton radioTextPlain;
    private JRadioButton radioTextHtml;
    private TranscriptionTierSortAndSelectPanel tiersPanel = null;

    public ExportJSONDialog(Frame owner, Transcription transcription, Selection selection) throws HeadlessException {
        super(owner, true);
        this.transcription = transcription;
        this.selection = selection;
        this.initComponents();
        if (selection == null || Math.abs(selection.getBeginTime() - selection.getEndTime()) <= 10L) {
            this.checkLimitSelection.setEnabled(false);
        }
        this.checkPurpose.setSelected(true);
        this.radioElanID.setSelected(true);
        this.radioFragment.setSelected(true);
        this.radioTextPlain.setSelected(true);
        this.loadPreferences();
        this.applySettings();
        this.textMain.setText(new JSONWAEncoder().createJSONText(transcription, this.encoderInfo));
        this.setTitle(ElanLocale.getString("ExportJSONDialog.Title"));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel titleLabel = new JLabel(ElanLocale.getString("ExportJSONDialog.Title"));
        titleLabel.setFont(titleLabel.getFont().deriveFont(16.0f));
        titleLabel.setHorizontalAlignment(0);
        Insets insets = new Insets(2, 4, 2, 4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        this.getContentPane().add((Component)titleLabel, gbc);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 3;
        this.getContentPane().add((Component)this.createTextArea(), gbc);
        gbc.gridx = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        this.getContentPane().add((Component)this.createTiersPanel(), gbc);
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.getContentPane().add((Component)this.createControlsPanel(), gbc);
        gbc.gridy = 3;
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        this.getContentPane().add((Component)this.createButtonPanel(), gbc);
    }

    private JPanel createControlsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(ElanLocale.getString("Menu.Options")));
        GridBagConstraints gc = new GridBagConstraints();
        Insets insets = new Insets(4, 6, 4, 6);
        Insets indent = new Insets(0, 22, 2, 6);
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.insets = insets;
        this.checkLimitSelection = new JCheckBox(ElanLocale.getString("ExportJSONDialog.Limit.Selection"));
        panel.add((Component)this.checkLimitSelection, gc);
        ++gc.gridy;
        this.checkPurpose = new JCheckBox(ElanLocale.getString("ExportJSONDialog.Add.Purpose"));
        panel.add((Component)this.checkPurpose, gc);
        ++gc.gridy;
        this.checkSingleTarget = new JCheckBox(ElanLocale.getString("ExportJSONDialog.Single.Target"));
        panel.add((Component)this.checkSingleTarget, gc);
        this.radioIncrementalID = new JRadioButton(ElanLocale.getString("ExportJSONDialog.Incremental.ID"));
        this.radioElanID = new JRadioButton(ElanLocale.getString("ExportJSONDialog.ELAN.ID"));
        ButtonGroup idGroup = new ButtonGroup();
        idGroup.add(this.radioIncrementalID);
        idGroup.add(this.radioElanID);
        JLabel idLabel = new JLabel(ElanLocale.getString("ExportJSONDialog.Format.ID"));
        ++gc.gridy;
        panel.add((Component)idLabel, gc);
        ++gc.gridy;
        gc.insets = indent;
        panel.add((Component)this.radioElanID, gc);
        ++gc.gridy;
        panel.add((Component)this.radioIncrementalID, gc);
        this.radioFragment = new JRadioButton(ElanLocale.getString("ExportJSONDialog.Begin.End"));
        this.radioSelector = new JRadioButton(ElanLocale.getString("ExportJSONDialog.Selector"));
        ButtonGroup timeGroup = new ButtonGroup();
        timeGroup.add(this.radioFragment);
        timeGroup.add(this.radioSelector);
        JLabel timeLabel = new JLabel(ElanLocale.getString("ExportJSONDialog.Format.Timespan"));
        ++gc.gridy;
        gc.insets = insets;
        panel.add((Component)timeLabel, gc);
        ++gc.gridy;
        gc.insets = indent;
        panel.add((Component)this.radioFragment, gc);
        ++gc.gridy;
        panel.add((Component)this.radioSelector, gc);
        this.radioTextPlain = new JRadioButton(ElanLocale.getString("ExportJSONDialog.Text.Plain"));
        this.radioTextHtml = new JRadioButton(ElanLocale.getString("ExportJSONDialog.Text.HTML"));
        ButtonGroup typeGroup = new ButtonGroup();
        typeGroup.add(this.radioTextPlain);
        typeGroup.add(this.radioTextHtml);
        JLabel typeLabel = new JLabel(ElanLocale.getString("ExportJSONDialog.Encode.Type"));
        ++gc.gridy;
        gc.insets = insets;
        panel.add((Component)typeLabel, gc);
        ++gc.gridy;
        gc.insets = indent;
        panel.add((Component)this.radioTextPlain, gc);
        ++gc.gridy;
        panel.add((Component)this.radioTextHtml, gc);
        return panel;
    }

    private JPanel createTiersPanel() {
        this.tiersPanel = new TranscriptionTierSortAndSelectPanel((TranscriptionImpl)this.transcription);
        this.tiersPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportTiersDialog.Tab1")));
        return this.tiersPanel;
    }

    private JScrollPane createTextArea() {
        this.textMain = new JTextArea(20, 40);
        this.textMain.setEditable(false);
        JScrollPane scrollpane = new JScrollPane(this.textMain);
        scrollpane.setVerticalScrollBarPolicy(22);
        return scrollpane;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 4, 2));
        this.buttonUpdate = new JButton(ElanLocale.getString("ExportJSONDialog.Update"));
        this.buttonUpdate.addActionListener(this);
        this.buttonExport = new JButton(ElanLocale.getString("ExportJSONDialog.Export"));
        this.buttonExport.addActionListener(this);
        this.buttonClose = new JButton(ElanLocale.getString("ExportJSONDialog.Close"));
        this.buttonClose.addActionListener(this);
        panel.add(this.buttonUpdate);
        panel.add(this.buttonExport);
        panel.add(this.buttonClose);
        return panel;
    }

    private void exportToFile() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("ExportJSONDialog.Export.Location"), 1, FileExtension.JSON_EXT, "ExportJSONDialog.Current.Directory");
        if (chooser.getSelectedFile() != null) {
            this.applySettings();
            try {
                new JSONWAEncoder().encodeAndSave(this.transcription, this.encoderInfo, null, chooser.getSelectedFile().getAbsolutePath());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportJSONDialog.Error") + " " + chooser.getSelectedFile().getName(), ElanLocale.getString("Message.Warning"), 2);
            }
        }
    }

    private void applySettings() {
        if (this.encoderInfo == null) {
            this.encoderInfo = new JSONWAEncoderInfo();
            this.encoderInfo.setGenerator("ELAN Multimedia Annotator " + ELAN.getVersionString());
            this.encoderInfo.setIndentationLevel(2);
        }
        this.encoderInfo.setSelectedTiers(this.tiersPanel.getSelectedTiers());
        this.encoderInfo.setIncrementalIDs(this.radioIncrementalID.isSelected());
        this.encoderInfo.setFragmentSelector(this.radioSelector.isSelected());
        this.encoderInfo.setBodyFormat(this.radioTextHtml.isSelected() ? "text/html" : "text/plain");
        if (this.checkPurpose.isSelected()) {
            this.encoderInfo.setPurpose("transcribing");
        } else {
            this.encoderInfo.setPurpose(null);
        }
        if (this.selection != null && this.checkLimitSelection.isSelected()) {
            this.encoderInfo.setBeginTime(this.selection.getBeginTime());
            this.encoderInfo.setEndTime(this.selection.getEndTime());
        }
        this.encoderInfo.setSingleTargetExport(this.checkSingleTarget.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.buttonUpdate) {
            this.applySettings();
            this.textMain.setText(new JSONWAEncoder().createJSONText(this.transcription, this.encoderInfo));
        } else if (evt.getSource() == this.buttonClose) {
            this.doClose();
        } else if (evt.getSource() == this.buttonExport) {
            this.exportToFile();
        }
    }

    private void doClose() {
        this.savePreferences();
        this.setVisible(false);
    }

    private void savePreferences() {
        Preferences.set("ExportJSON.LimitSelection", this.checkLimitSelection.isSelected(), null, false, false);
        Preferences.set("ExportJSON.AddPurpose", this.checkPurpose.isSelected(), null, false, false);
        Preferences.set("ExportJSON.ELAN.ID", this.radioElanID.isSelected(), null, false, false);
        Preferences.set("ExportJSON.MediaFragment", this.radioFragment.isSelected(), null, false, false);
        Preferences.set("ExportJSON.TextPlain", this.radioTextPlain.isSelected(), null, false, false);
        List<String> selNames = this.tiersPanel.getSelectedItems();
        List<String> hidNames = this.tiersPanel.getHiddenTiers();
        String selTab = this.tiersPanel.getSelectionMode();
        if (selNames != null && !selNames.isEmpty()) {
            Preferences.set("ExportJSON.SelectedItems", selNames, this.transcription, false, false);
            Preferences.set("ExportJSON.HiddenTiers", hidNames, this.transcription, false, false);
            Preferences.set("ExportJSON.SelectedMode", selTab, this.transcription, false, false);
        }
        Preferences.set("ExportJSON.SingleTarget", this.checkSingleTarget.isSelected(), null, false, true);
    }

    private void loadPreferences() {
        Boolean boolPref = Preferences.getBool("ExportJSON.LimitSelection", null);
        if (boolPref != null) {
            this.checkLimitSelection.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportJSON.AddPurpose", null)) != null) {
            this.checkPurpose.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportJSON.ELAN.ID", null)) != null) {
            if (boolPref.booleanValue()) {
                this.radioElanID.setSelected(true);
            } else {
                this.radioIncrementalID.setSelected(true);
            }
        }
        if ((boolPref = Preferences.getBool("ExportJSON.MediaFragment", null)) != null) {
            if (boolPref.booleanValue()) {
                this.radioFragment.setSelected(true);
            } else {
                this.radioSelector.setSelected(true);
            }
        }
        if ((boolPref = Preferences.getBool("ExportJSON.TextPlain", null)) != null) {
            if (boolPref.booleanValue()) {
                this.radioTextPlain.setSelected(true);
            } else {
                this.radioTextHtml.setSelected(true);
            }
        }
        Object selItemsObj = Preferences.get("ExportJSON.SelectedItems", this.transcription);
        String tabName = Preferences.getString("ExportJSON.SelectedMode", this.transcription);
        Object hidNamesObj = Preferences.get("ExportJSON.HiddenTiers", this.transcription);
        if (tabName != null) {
            this.tiersPanel.setSelectionMode(tabName, null);
        }
        if (selItemsObj != null && tabName != null) {
            List nameList = (List)selItemsObj;
            ArrayList<String> hidNames = null;
            hidNames = hidNamesObj != null ? (ArrayList<String>)hidNamesObj : new ArrayList<String>(0);
            this.tiersPanel.setSelectionMode(tabName, hidNames);
            this.tiersPanel.setSelectedItems(nameList);
        }
        if ((boolPref = Preferences.getBool("ExportJSON.SingleTarget", null)) != null) {
            this.checkSingleTarget.setSelected(boolPref);
        }
    }
}

