/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.io.RecTierWriter;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeRelation;
import nl.mpi.util.FileExtension;

public class ExportRecogTiersDialog
extends AbstractExtTierExportDialog
implements ItemListener {
    private JCheckBox newFormatCB;
    final String prefSelectedTiers = "ExportRecogTiersDialog.selectedTiers";
    final String prefTierOrder = "ExportRecogTiersDialog.TierOrder";
    final String prefParentTierOrder = "ExportRecogTiersDialog.ParentTierOrder";
    final String prefSelectTiersMode = "ExportRecogTiersDialog.SelectTiersMode";
    final String prefLastSelectedItems = "ExportRecogTiersDialog.LastSelectedItems";
    final String prefHiddenTiers = "ExportRecogTiersDialog.HiddenTiers";
    final String prefRootTiersOnly = "ExportRecogTiersDialog.ShowOnlyRootTiers";
    final String prefSelectionOnly = "ExportRecogTiersDialog.SelectionOnly";
    final String prefNewFormat = "ExportRecogTiersDialog.NewFormatXML";

    public ExportRecogTiersDialog(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.postInit();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        this.extractTiers();
    }

    protected void extractTiers() {
        String stringPref;
        List<String> stringsPref = Preferences.getListOfString("ExportRecogTiersDialog.TierOrder", this.transcription);
        if (stringsPref != null) {
            this.setTierOrder(stringsPref);
        } else {
            super.extractTiers(true);
        }
        stringsPref = Preferences.getListOfString("ExportRecogTiersDialog.selectedTiers", this.transcription);
        if (stringsPref != null) {
            this.setSelectedTiers(stringsPref);
        }
        if ((stringPref = Preferences.getString(this.prefSelectTiersMode, this.transcription)) != null) {
            List<String> selItems;
            this.setSelectionMode(stringPref);
            if (!"Tier".equals(stringPref) && (selItems = Preferences.getListOfString("ExportRecogTiersDialog.LastSelectedItems", this.transcription)) instanceof List) {
                this.setSelectedItems(selItems);
            }
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.newFormatCB = new JCheckBox();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.restrictCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.optionsPanel.add((Component)this.newFormatCB, gridBagConstraints);
        this.setPreferredSetting();
        this.updateLocale();
    }

    @Override
    protected boolean startExport() throws IOException {
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        String fileName = this.promptForFileName();
        if (fileName == null) {
            return false;
        }
        File tf = new File(fileName);
        try {
            int answer;
            if (tf.exists() && (answer = JOptionPane.showConfirmDialog(this, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0, 2)) == 1) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        long begin = 0L;
        long end = Long.MAX_VALUE;
        if (this.restrictCheckBox.isSelected() && this.selection != null && this.selection.getBeginTime() < this.selection.getEndTime()) {
            begin = this.selection.getBeginTime();
            end = this.selection.getEndTime();
        }
        ArrayList<Segmentation> segmentations = new ArrayList<Segmentation>(selectedTiers.size());
        for (String name : selectedTiers) {
            TierImpl ti = this.transcription.getTierWithId(name);
            if (ti == null) continue;
            List<AbstractAnnotation> anns = ti.getAnnotations();
            ArrayList<RSelection> segments = new ArrayList<RSelection>(anns.size());
            for (AbstractAnnotation aa : anns) {
                if (TimeRelation.overlaps(aa, begin, end)) {
                    segments.add(new Segment(aa.getBeginTimeBoundary(), aa.getEndTimeBoundary(), aa.getValue()));
                }
                if (aa.getBeginTimeBoundary() <= end) continue;
                break;
            }
            Segmentation segmentation = new Segmentation(name, segments, "");
            segmentations.add(segmentation);
        }
        try {
            RecTierWriter xTierWriter = new RecTierWriter();
            xTierWriter.setNewTierFormat(this.newFormatCB.isSelected());
            xTierWriter.write(tf, segmentations, this.transcription);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportDialog.RecogTiers.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportDialog.RecogTiers.Title"));
        this.newFormatCB.setText(ElanLocale.getString("ExportDialog.RecogTiers.NewXmlFormat"));
    }

    protected String promptForFileName() {
        ArrayList<String[]> extensions = new ArrayList<String[]>();
        extensions.add(FileExtension.XML_EXT);
        extensions.add(FileExtension.CSV_EXT);
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(null, 1, extensions, FileExtension.XML_EXT, "Recognizer.Path", null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private void setPreferredSetting() {
        this.extractTiers();
        Boolean boolPref = Preferences.getBool("ExportRecogTiersDialog.ShowOnlyRootTiers", null);
        if (boolPref == null) {
            boolPref = Preferences.getBool("ExportRecogTiersDialog.rootTiersCB", null);
            Preferences.set("ExportRecogTiersDialog.rootTiersCB", null, null);
        }
        if (boolPref != null) {
            this.setRootTiersOnly(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportRecogTiersDialog.SelectionOnly", null)) == null) {
            boolPref = Preferences.getBool("ExportRecogTiersDialog.selectionCB", null);
            Preferences.set("ExportRecogTiersDialog.selectionCB", null, null);
        }
        if (boolPref != null) {
            this.restrictCheckBox.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportRecogTiersDialog.NewFormatXML", null)) != null) {
            this.newFormatCB.setSelected(boolPref);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportRecogTiersDialog.ShowOnlyRootTiers", this.isRootTiersOnly(), null);
        Preferences.set("ExportRecogTiersDialog.SelectionOnly", this.restrictCheckBox.isSelected(), null);
        Preferences.set("ExportRecogTiersDialog.NewFormatXML", this.newFormatCB.isSelected(), null);
        Preferences.set("ExportRecogTiersDialog.selectedTiers", this.getSelectedTiers(), (Transcription)this.transcription);
        Preferences.set("ExportRecogTiersDialog.SelectTiersMode", this.getSelectionMode(), (Transcription)this.transcription);
        if (this.getSelectionMode() != "Tier") {
            Preferences.set("ExportRecogTiersDialog.LastSelectedItems", this.getSelectedItems(), (Transcription)this.transcription);
        }
        Preferences.set(this.prefHiddenTiers, this.getHiddenTiers(), (Transcription)this.transcription);
        List<String> tierOrder = this.getTierOrder();
        Preferences.set(this.prefTierOrder, tierOrder, (Transcription)this.transcription);
    }
}

