/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.SaveAs27Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.search.result.model.ElanMatch;
import mpi.eudico.client.annotator.search.result.viewer.EAFResultViewerTableModel;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.TierTree;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.IncludedIn;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import nl.mpi.util.FileExtension;

public class ExportResultTableAsEAF {
    private ProgressMonitor monitor;

    public void exportTableAsEAF(final AnnotationTable table) {
        if (table == null || table.getRowCount() == 0) {
            return;
        }
        final String fileName = this.promptForFileName();
        if (fileName == null) {
            return;
        }
        this.monitor = new ProgressMonitor(null, ElanLocale.getString("SaveDialog.Message.Title"), "", 0, 100);
        this.monitor.setMillisToDecideToPopup(10);
        this.monitor.setMillisToPopup(10);
        new Thread(){

            @Override
            public void run() {
                int i;
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                TranscriptionImpl transcription = null;
                EAFResultViewerTableModel dataModel = (EAFResultViewerTableModel)table.getModel();
                AnnotationCore anc = null;
                Annotation ann = null;
                AlignableAnnotation aa = null;
                anc = dataModel.getAnnotationCore(0);
                if (anc instanceof Annotation) {
                    ann = (Annotation)anc;
                    transcription = (TranscriptionImpl)ann.getTier().getTranscription();
                }
                if (transcription == null) {
                    ClientLogger.LOG.warning("Could not retrieve the transcription, no results exported");
                    ExportResultTableAsEAF.this.progressUpdate(null, 100);
                    return;
                }
                ExportResultTableAsEAF.this.progressUpdate(null, 10);
                if (ExportResultTableAsEAF.this.isCancelled()) {
                    return;
                }
                ArrayList<AlignableAnnotation> topAnnos = new ArrayList<AlignableAnnotation>();
                ArrayList<Tier> topTiers = new ArrayList<Tier>();
                int annColumn = -1;
                for (i = 0; i < dataModel.getColumnCount(); ++i) {
                    if (!dataModel.getColumnName(i).equals("ColumnAnnotation")) continue;
                    annColumn = i;
                    break;
                }
                if (annColumn < 0) {
                    ClientLogger.LOG.warning("Could not find the matches column in the table");
                    ExportResultTableAsEAF.this.progressUpdate(null, 100);
                    return;
                }
                for (i = 0; i < dataModel.getRowCount(); ++i) {
                    Object val = dataModel.getValueAt(i, annColumn);
                    if (val instanceof ElanMatch) {
                        ElanMatch match = (ElanMatch)val;
                        if (match.getParent() != null) continue;
                        ann = match.getAnnotation();
                        aa = ExportResultTableAsEAF.this.rootAnnotationOf(ann);
                        if (aa != null && !topAnnos.contains(aa)) {
                            topAnnos.add(aa);
                        }
                        if (aa != null && !topTiers.contains(aa.getTier())) {
                            topTiers.add(aa.getTier());
                        }
                        ExportResultTableAsEAF.this.extractSubMatches(match, topAnnos, topTiers);
                        continue;
                    }
                    anc = dataModel.getAnnotationCore(i);
                    if (!(anc instanceof Annotation)) continue;
                    ann = (Annotation)anc;
                    aa = ExportResultTableAsEAF.this.rootAnnotationOf(ann);
                    if (aa != null && !topAnnos.contains(aa)) {
                        topAnnos.add(aa);
                    }
                    if (topTiers.contains(aa.getTier())) continue;
                    topTiers.add(aa.getTier());
                }
                TranscriptionImpl nextTrans = new TranscriptionImpl();
                nextTrans.setNotifying(false);
                ExportResultTableAsEAF.this.progressUpdate(null, 15);
                if (ExportResultTableAsEAF.this.isCancelled()) {
                    return;
                }
                ExportResultTableAsEAF.this.copyDescriptors(transcription, nextTrans);
                if (ExportResultTableAsEAF.this.isCancelled()) {
                    return;
                }
                ExportResultTableAsEAF.this.copyTiersTypesCvs(transcription, nextTrans, topTiers);
                if (ExportResultTableAsEAF.this.isCancelled()) {
                    return;
                }
                ExportResultTableAsEAF.this.copyAnnotations(transcription, nextTrans, topAnnos);
                ExportResultTableAsEAF.this.progressUpdate(null, 90);
                if (ExportResultTableAsEAF.this.isCancelled()) {
                    return;
                }
                TranscriptionStore store = ACMTranscriptionStore.getCurrentTranscriptionStore();
                int saveAsType = SaveAs27Preferences.saveAsTypeWithCheck(nextTrans);
                try {
                    store.storeTranscription(nextTrans, null, new ArrayList<TierImpl>(), fileName, saveAsType);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(transcription), "Unable to save the file: (" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
                }
                ExportResultTableAsEAF.this.progressUpdate(null, 100);
            }
        }.start();
    }

    private void extractSubMatches(ElanMatch match, ArrayList<Annotation> topAnnos, ArrayList<Tier> topTiers) {
        for (int j = 0; j < match.getChildCount(); ++j) {
            ElanMatch chMatch = (ElanMatch)match.getChildAt(j);
            Annotation ann = chMatch.getAnnotation();
            if ((ann = this.rootAnnotationOf(ann)) != null && !topAnnos.contains(ann)) {
                topAnnos.add(ann);
            }
            if (ann != null && !topTiers.contains(ann.getTier())) {
                topTiers.add(ann.getTier());
            }
            if (chMatch.isLeaf()) continue;
            this.extractSubMatches(chMatch, topAnnos, topTiers);
        }
    }

    private void copyDescriptors(TranscriptionImpl transcription, TranscriptionImpl nextTrans) {
        if (transcription == null || nextTrans == null) {
            return;
        }
        List<MediaDescriptor> mds = transcription.getMediaDescriptors();
        ArrayList<MediaDescriptor> cmds = new ArrayList<MediaDescriptor>(mds.size());
        for (int i = 0; i < mds.size(); ++i) {
            MediaDescriptor md = mds.get(i);
            cmds.add((MediaDescriptor)md.clone());
        }
        nextTrans.setMediaDescriptors(cmds);
        List<LinkedFileDescriptor> lfds = transcription.getLinkedFileDescriptors();
        ArrayList<LinkedFileDescriptor> clfds = new ArrayList<LinkedFileDescriptor>(lfds.size());
        for (int i = 0; i < lfds.size(); ++i) {
            LinkedFileDescriptor lfd = lfds.get(i);
            clfds.add((LinkedFileDescriptor)lfd.clone());
        }
        nextTrans.setLinkedFileDescriptors(clfds);
        this.progressUpdate(null, 20);
    }

    private void copyTiersTypesCvs(TranscriptionImpl transcription, TranscriptionImpl nextTrans, List<Tier> topTiers) {
        LinguisticType lt2;
        LinguisticType lt1;
        TierImpl tier;
        if (transcription == null || nextTrans == null || topTiers == null) {
            return;
        }
        ArrayList<TierImpl> tiersToCopy = new ArrayList<TierImpl>();
        for (int i = 0; i < topTiers.size(); ++i) {
            tier = (TierImpl)topTiers.get(i);
            tiersToCopy.add(tier);
            tiersToCopy.addAll(tier.getDependentTiers());
        }
        ArrayList<LinguisticType> typesToCopy = new ArrayList<LinguisticType>();
        ArrayList<ControlledVocabulary> cvsToCopy = new ArrayList<ControlledVocabulary>();
        for (int i = 0; i < tiersToCopy.size(); ++i) {
            String cvName;
            ControlledVocabulary cv;
            tier = (TierImpl)tiersToCopy.get(i);
            if (typesToCopy.contains(tier.getLinguisticType())) continue;
            typesToCopy.add(tier.getLinguisticType());
            if (!tier.getLinguisticType().isUsingControlledVocabulary() || (cv = transcription.getControlledVocabulary(cvName = tier.getLinguisticType().getControlledVocabularyName())) == null || cvsToCopy.contains(cv)) continue;
            cvsToCopy.add(cv);
        }
        ArrayList<ControlledVocabulary> cvc = new ArrayList<ControlledVocabulary>(cvsToCopy.size());
        for (int i = 0; i < cvsToCopy.size(); ++i) {
            ControlledVocabulary cv1 = (ControlledVocabulary)cvsToCopy.get(i);
            ControlledVocabulary cv2 = new ControlledVocabulary(cv1.getName());
            cv2.cloneStructure(cv1);
            for (CVEntry ent1 : cv1) {
                CVEntry ent2 = new CVEntry(cv2, ent1);
                cv2.addEntry(ent2);
            }
            cvc.add(cv2);
        }
        nextTrans.setControlledVocabularies(cvc);
        ArrayList<LinguisticType> typc = new ArrayList<LinguisticType>(typesToCopy.size());
        ConstraintImpl con2 = null;
        for (int i = 0; i < typesToCopy.size(); ++i) {
            lt1 = (LinguisticType)typesToCopy.get(i);
            lt2 = new LinguisticType(lt1.getLinguisticTypeName());
            lt2.setTimeAlignable(lt1.isTimeAlignable());
            lt2.setControlledVocabularyName(lt1.getControlledVocabularyName());
            Constraint con1 = lt1.getConstraints();
            if (con1 != null) {
                switch (con1.getStereoType()) {
                    case 0: {
                        con2 = new TimeSubdivision();
                        break;
                    }
                    case 3: {
                        con2 = new SymbolicSubdivision();
                        break;
                    }
                    case 4: {
                        con2 = new SymbolicAssociation();
                        break;
                    }
                    case 1: {
                        con2 = new IncludedIn();
                    }
                }
                lt2.addConstraint(con2);
            }
            typc.add(lt2);
        }
        nextTrans.setLinguisticTypes(typc);
        TierTree tree = new TierTree(transcription);
        DefaultMutableTreeNode root = tree.getTree();
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        en.nextElement();
        while (en.hasMoreElements()) {
            TierImpl copyTier = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            String name = (String)node.getUserObject();
            TierImpl t1 = transcription.getTierWithId(name);
            if (!tiersToCopy.contains(t1)) continue;
            if (t1 != null) {
                lt1 = t1.getLinguisticType();
                lt2 = nextTrans.getLinguisticTypeByName(lt1.getLinguisticTypeName());
                if (lt2 != null) {
                    if (t1.hasParentTier()) {
                        String parentName = t1.getParentTier().getName();
                        TierImpl t2 = nextTrans.getTierWithId(parentName);
                        if (t2 != null) {
                            copyTier = new TierImpl(t2, name, t1.getParticipant(), nextTrans, lt2);
                            copyTier.setDefaultLocale(t1.getDefaultLocale());
                            copyTier.setAnnotator(t1.getAnnotator());
                            copyTier.setLangRef(t1.getLangRef());
                        } else {
                            ClientLogger.LOG.warning("The parent tier: " + parentName + " for tier: " + name + " was not found in the destination transcription");
                        }
                    } else {
                        copyTier = new TierImpl(name, t1.getParticipant(), nextTrans, lt2);
                        copyTier.setDefaultLocale(t1.getDefaultLocale());
                        copyTier.setAnnotator(t1.getAnnotator());
                        copyTier.setLangRef(t1.getLangRef());
                    }
                } else {
                    ClientLogger.LOG.warning("Could not add tier: " + name + " because the Linguistic Type was not found in the destination transcription.");
                }
            }
            if (copyTier == null) continue;
            nextTrans.addTier(copyTier);
        }
        this.progressUpdate(null, 30);
    }

    private void copyAnnotations(Transcription transcription, Transcription nextTrans, ArrayList<Annotation> topAnnos) {
        if (transcription == null || nextTrans == null || topAnnos == null) {
            return;
        }
        int tp = 60;
        float incr = (float)tp / (float)Math.max(topAnnos.size(), 1);
        for (int i = 0; i < topAnnos.size(); ++i) {
            AlignableAnnotation aa = (AlignableAnnotation)topAnnos.get(i);
            DefaultMutableTreeNode record = AnnotationRecreator.createTreeForAnnotation(aa);
            AlignableAnnotation copyAnn = (AlignableAnnotation)AnnotationRecreator.createAnnotationFromTree(nextTrans, record);
            if (copyAnn == null) {
                ClientLogger.LOG.warning("Could not copy annotation: " + aa.getValue() + " (" + aa.getBeginTimeBoundary() + " - " + aa.getEndTimeBoundary() + ")");
            }
            this.progressUpdate(null, 30 + (int)((float)i * incr));
            if (!this.isCancelled()) continue;
            return;
        }
    }

    private AlignableAnnotation rootAnnotationOf(Annotation ann) {
        if (ann == null) {
            return null;
        }
        TierImpl tier = (TierImpl)ann.getTier();
        if (tier.hasParentTier()) {
            tier = tier.getRootTier();
            return (AlignableAnnotation)tier.getAnnotationAtTime((ann.getBeginTimeBoundary() + ann.getEndTimeBoundary()) / 2L);
        }
        return (AlignableAnnotation)ann;
    }

    private String promptForFileName() {
        FileChooser chooser = new FileChooser(null);
        chooser.createAndShowFileDialog(ElanLocale.getString("SaveDialog.Title"), 1, FileExtension.EAF_EXT, "LastUsedEAFDir");
        File exportFile = chooser.getSelectedFile();
        if (exportFile != null) {
            return exportFile.getAbsolutePath();
        }
        return null;
    }

    private void progressUpdate(String note, int progress) {
        if (this.monitor != null) {
            if (note != null) {
                this.monitor.setNote(note);
            }
            this.monitor.setProgress(progress);
        }
    }

    private boolean isCancelled() {
        if (this.monitor != null) {
            return this.monitor.isCanceled();
        }
        return false;
    }
}

