/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.export.ExportTabdelimited;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.util.Transcription2TabDelimitedText;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextEncoderInfoFiles;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextEncoderInfoTrans;
import mpi.eudico.util.TimeFormatter;
import nl.mpi.util.FileExtension;

public class ExportTabDialog
extends AbstractExtTierExportDialog
implements ChangeListener {
    private JCheckBox btCheckBox;
    private JCheckBox correctTimesCB;
    private JCheckBox suppressNamesCB;
    private JCheckBox suppressParticipantsCB;
    private JCheckBox colPerTierCB;
    private JCheckBox repeatValuesCB;
    private JCheckBox repeatOnlyWithinCB;
    private JCheckBox durCheckBox;
    private JCheckBox etCheckBox;
    private JCheckBox hhmmssmsCheckBox;
    private JCheckBox msCheckBox;
    private JCheckBox ssmsCheckBox;
    private JCheckBox timecodeCB;
    private JLabel timeCodesLabel;
    private JLabel timeFormatLabel;
    private JRadioButton ntscTimecodeRB;
    private JRadioButton palTimecodeRB;
    private JRadioButton pal50TimecodeRB;
    private JCheckBox includeFileNameCB;
    private JCheckBox includeFilePathCB;
    private JCheckBox includeCVEntryDesCB;
    private JCheckBox includeMediaHeaderCB;
    private JCheckBox fileNameInRowCB;
    private JCheckBox slicedOutputCB;
    private JCheckBox includeAnnotationIdCB;
    private Insets insets = new Insets(2, 4, 2, 4);

    public ExportTabDialog(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    public ExportTabDialog(Frame parent, boolean modal, List<File> files) {
        super(parent, modal, files);
        this.makeLayout();
        this.extractTiersFromFiles();
        this.postInit();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.timecodeCB) {
            this.palTimecodeRB.setEnabled(this.timecodeCB.isSelected());
            this.pal50TimecodeRB.setEnabled(this.timecodeCB.isSelected());
            this.ntscTimecodeRB.setEnabled(this.timecodeCB.isSelected());
        } else if (ce.getSource() == this.colPerTierCB) {
            this.repeatValuesCB.setEnabled(this.colPerTierCB.isSelected() && !this.slicedOutputCB.isSelected());
            this.suppressNamesCB.setEnabled(!this.colPerTierCB.isSelected());
            this.suppressParticipantsCB.setEnabled(!this.colPerTierCB.isSelected());
            if (!this.colPerTierCB.isSelected()) {
                this.repeatOnlyWithinCB.setEnabled(false);
            }
            this.includeCVEntryDesCB.setEnabled(!this.colPerTierCB.isSelected());
            this.slicedOutputCB.setEnabled(this.colPerTierCB.isSelected());
            this.includeAnnotationIdCB.setEnabled(this.colPerTierCB.isSelected());
        } else if (ce.getSource() == this.repeatValuesCB) {
            this.repeatOnlyWithinCB.setEnabled(this.repeatValuesCB.isSelected());
            this.includeAnnotationIdCB.setEnabled(this.repeatValuesCB.isSelected() || this.includeAnnotationIdCB.isSelected());
        } else if (ce.getSource() == this.slicedOutputCB) {
            this.repeatValuesCB.setEnabled(!this.slicedOutputCB.isSelected());
            this.repeatOnlyWithinCB.setEnabled(!this.slicedOutputCB.isSelected() && this.repeatValuesCB.isSelected());
            this.includeAnnotationIdCB.setEnabled(this.repeatValuesCB.isSelected() || this.includeAnnotationIdCB.isSelected());
        }
    }

    protected void extractTiers() {
        String stringPref;
        List<String> stringsPref = Preferences.getListOfString("ExportTabDialog.TierOrder", this.transcription);
        if (stringsPref != null) {
            this.setTierOrder(stringsPref);
        }
        if ((stringsPref = Preferences.getListOfString("ExportTabDialog.selectedTiers", this.transcription)) != null) {
            this.setSelectedTiers(stringsPref);
        }
        if ((stringPref = Preferences.getString("ExportTabDialog.SelectTiersMode", this.transcription)) != null) {
            List<String> selItems;
            this.setSelectionMode(stringPref);
            if (!"Tier".equals(stringPref) && (selItems = Preferences.getListOfString("ExportTabDialog.LastSelectedItems", this.transcription)) != null) {
                this.setSelectedItems(selItems);
            }
        }
    }

    @Override
    protected void extractTiersFromFiles() {
        super.extractTiersFromFiles();
        String useTyp = Preferences.getString("ExportTabDialog.SelectTiersMode", null);
        if (useTyp != null) {
            this.setSelectionMode(useTyp);
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.timeCodesLabel = new JLabel();
        this.timeFormatLabel = new JLabel();
        this.btCheckBox = new JCheckBox();
        this.etCheckBox = new JCheckBox();
        this.durCheckBox = new JCheckBox();
        this.hhmmssmsCheckBox = new JCheckBox();
        this.ssmsCheckBox = new JCheckBox();
        this.msCheckBox = new JCheckBox();
        this.timecodeCB = new JCheckBox();
        this.palTimecodeRB = new JRadioButton();
        this.pal50TimecodeRB = new JRadioButton();
        this.ntscTimecodeRB = new JRadioButton();
        this.includeFileNameCB = new JCheckBox();
        this.includeFilePathCB = new JCheckBox();
        this.includeCVEntryDesCB = new JCheckBox();
        this.includeMediaHeaderCB = new JCheckBox();
        this.fileNameInRowCB = new JCheckBox();
        this.slicedOutputCB = new JCheckBox();
        this.slicedOutputCB.addChangeListener(this);
        this.includeAnnotationIdCB = new JCheckBox();
        ButtonGroup group = new ButtonGroup();
        this.correctTimesCB = new JCheckBox();
        this.suppressNamesCB = new JCheckBox();
        this.suppressParticipantsCB = new JCheckBox();
        this.colPerTierCB = new JCheckBox();
        this.repeatValuesCB = new JCheckBox();
        this.colPerTierCB.addChangeListener(this);
        this.repeatValuesCB.setSelected(true);
        this.repeatValuesCB.setEnabled(false);
        this.repeatValuesCB.addChangeListener(this);
        this.repeatOnlyWithinCB = new JCheckBox();
        this.repeatOnlyWithinCB.setSelected(false);
        this.repeatOnlyWithinCB.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.restrictCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.correctTimesCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.includeMediaHeaderCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.suppressNamesCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.suppressParticipantsCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.colPerTierCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 22, 2, 4);
        this.optionsPanel.add((Component)this.repeatValuesCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 22, 2, 4);
        this.optionsPanel.add((Component)this.repeatOnlyWithinCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 22, 2, 4);
        this.optionsPanel.add((Component)this.slicedOutputCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 22, 2, 4);
        this.optionsPanel.add((Component)this.includeAnnotationIdCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.includeCVEntryDesCB, gridBagConstraints);
        if (!this.multipleFileExport) {
            JPanel fill = new JPanel();
            Dimension fillDim = new Dimension(30, 10);
            fill.setPreferredSize(fillDim);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)fill, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 12;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.timeCodesLabel, gridBagConstraints);
            JPanel filler = new JPanel();
            filler.setPreferredSize(fillDim);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 12;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)filler, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 12;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.timeFormatLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 13;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.btCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 13;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.hhmmssmsCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 14;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.etCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 14;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.ssmsCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 15;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.durCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 15;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.msCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 16;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.timecodeCB, gridBagConstraints);
            JPanel smptePanel = new JPanel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 17;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            this.optionsPanel.add((Component)smptePanel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            smptePanel.add((Component)this.palTimecodeRB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            smptePanel.add((Component)this.pal50TimecodeRB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            smptePanel.add((Component)this.ntscTimecodeRB, gridBagConstraints);
        } else {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.includeFileNameCB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 12;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.includeFilePathCB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 13;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.fileNameInRowCB, gridBagConstraints);
            JPanel fill = new JPanel();
            Dimension fillDim = new Dimension(30, 10);
            fill.setPreferredSize(fillDim);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 14;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)fill, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 15;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.timeCodesLabel, gridBagConstraints);
            JPanel filler = new JPanel();
            filler.setPreferredSize(fillDim);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 15;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)filler, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 15;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.timeFormatLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 16;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.btCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 16;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.hhmmssmsCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 17;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.etCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 17;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.ssmsCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 18;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.durCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 18;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.msCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 19;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.timecodeCB, gridBagConstraints);
            JPanel smptePanel = new JPanel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 20;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            this.optionsPanel.add((Component)smptePanel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            smptePanel.add((Component)this.palTimecodeRB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            smptePanel.add((Component)this.pal50TimecodeRB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            smptePanel.add((Component)this.ntscTimecodeRB, gridBagConstraints);
        }
        group.add(this.palTimecodeRB);
        group.add(this.pal50TimecodeRB);
        group.add(this.ntscTimecodeRB);
        this.timecodeCB.addChangeListener(this);
        this.setPreferencesOrDefaultSettings();
        if (this.transcription == null) {
            this.restrictCheckBox.setEnabled(false);
        }
        this.updateLocale();
    }

    @Override
    protected boolean startExport() throws IOException {
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        ArrayList<String[]> formats = new ArrayList<String[]>(2);
        formats.add(FileExtension.TEXT_EXT);
        formats.add(FileExtension.CSV_EXT);
        File exportFile = this.promptForFile(ElanLocale.getString("ExportTabDialog.Title"), formats, FileExtension.TEXT_EXT, true);
        if (exportFile == null) {
            return false;
        }
        boolean csvExport = exportFile.getName().toLowerCase().endsWith(FileExtension.CSV_EXT[0]);
        long selectionBT = 0L;
        long selectionET = Long.MAX_VALUE;
        if (this.transcription != null) {
            if (this.restrictCheckBox.isSelected()) {
                selectionBT = this.selection.getBeginTime();
                selectionET = this.selection.getEndTime();
            }
            DelimitedTextEncoderInfoTrans encInfoTrans = new DelimitedTextEncoderInfoTrans(this.transcription);
            encInfoTrans.setTierNames(selectedTiers);
            encInfoTrans.setExportFile(exportFile);
            encInfoTrans.setExportCSVFormat(csvExport);
            encInfoTrans.setCharEncoding(this.encoding);
            encInfoTrans.setBeginTime(selectionBT);
            encInfoTrans.setEndTime(selectionET);
            encInfoTrans.setAddMasterMediaOffset(this.correctTimesCB.isSelected());
            encInfoTrans.setIncludeCVDescription(this.includeCVEntryDesCB.isSelected());
            encInfoTrans.setIncludeBeginTime(this.btCheckBox.isSelected());
            encInfoTrans.setIncludeEndTime(this.etCheckBox.isSelected());
            encInfoTrans.setIncludeDuration(this.durCheckBox.isSelected());
            encInfoTrans.setIncludeHHMM(this.hhmmssmsCheckBox.isSelected());
            encInfoTrans.setIncludeSSMS(this.ssmsCheckBox.isSelected());
            encInfoTrans.setIncludeMS(this.msCheckBox.isSelected());
            encInfoTrans.setIncludeSMPTE(this.timecodeCB.isSelected());
            encInfoTrans.setPalFormat(this.palTimecodeRB.isSelected());
            encInfoTrans.setPal50Format(this.pal50TimecodeRB.isSelected());
            encInfoTrans.setIncludeNames(!this.suppressNamesCB.isSelected());
            encInfoTrans.setIncludeParticipants(!this.suppressParticipantsCB.isSelected());
            encInfoTrans.setIncludeAnnotationId(this.includeAnnotationIdCB.isSelected());
            if (this.includeMediaHeaderCB.isSelected()) {
                encInfoTrans.setMediaHeaderLines(this.getMediaHeaderLines(this.transcription));
            }
            if (this.colPerTierCB.isSelected()) {
                if (this.slicedOutputCB.isSelected()) {
                    ExportTabdelimited et = new ExportTabdelimited();
                    et.exportTiersSliced(encInfoTrans);
                } else if (!this.repeatValuesCB.isSelected()) {
                    Transcription2TabDelimitedText tdt = new Transcription2TabDelimitedText();
                    tdt.exportTiersColumnPerTier(encInfoTrans);
                } else {
                    ExportTabdelimited et = new ExportTabdelimited();
                    encInfoTrans.setRepeatValues(true);
                    encInfoTrans.setCombineBlocks(!this.repeatOnlyWithinCB.isSelected());
                    et.exportTiersColumnPerTier(encInfoTrans);
                }
            } else {
                Transcription2TabDelimitedText tdt = new Transcription2TabDelimitedText();
                tdt.exportTiers(encInfoTrans);
            }
        } else {
            DelimitedTextEncoderInfoFiles encInfoFiles = new DelimitedTextEncoderInfoFiles(this.files);
            encInfoFiles.setTierNames(selectedTiers);
            encInfoFiles.setExportFile(exportFile);
            encInfoFiles.setExportCSVFormat(csvExport);
            encInfoFiles.setCharEncoding(this.encoding);
            encInfoFiles.setIncludeCVDescription(this.includeCVEntryDesCB.isSelected());
            encInfoFiles.setIncludeBeginTime(this.btCheckBox.isSelected());
            encInfoFiles.setIncludeEndTime(this.etCheckBox.isSelected());
            encInfoFiles.setIncludeDuration(this.durCheckBox.isSelected());
            encInfoFiles.setIncludeHHMM(this.hhmmssmsCheckBox.isSelected());
            encInfoFiles.setIncludeSSMS(this.ssmsCheckBox.isSelected());
            encInfoFiles.setIncludeMS(this.msCheckBox.isSelected());
            encInfoFiles.setIncludeSMPTE(this.timecodeCB.isSelected());
            encInfoFiles.setPalFormat(this.palTimecodeRB.isSelected());
            encInfoFiles.setPal50Format(this.pal50TimecodeRB.isSelected());
            encInfoFiles.setIncludeNames(!this.suppressNamesCB.isSelected());
            encInfoFiles.setIncludeParticipants(!this.suppressParticipantsCB.isSelected());
            encInfoFiles.setIncludeFileName(this.includeFileNameCB.isSelected());
            encInfoFiles.setIncludeFilePath(this.includeFilePathCB.isSelected());
            encInfoFiles.setAddMasterMediaOffset(this.correctTimesCB.isSelected());
            encInfoFiles.setFileNameInRow(this.fileNameInRowCB.isSelected());
            encInfoFiles.setIncludeMediaHeaders(this.includeMediaHeaderCB.isSelected());
            encInfoFiles.setIncludeAnnotationId(this.includeAnnotationIdCB.isSelected());
            if (this.colPerTierCB.isSelected()) {
                if (this.slicedOutputCB.isSelected()) {
                    ExportTabdelimited et = new ExportTabdelimited();
                    et.exportTiersSlicedForFiles(encInfoFiles);
                } else if (!this.repeatValuesCB.isSelected()) {
                    Transcription2TabDelimitedText tdt = new Transcription2TabDelimitedText();
                    tdt.exportTiersColumnPerTierFromFiles(encInfoFiles);
                } else {
                    ExportTabdelimited et = new ExportTabdelimited();
                    encInfoFiles.setRepeatValues(true);
                    encInfoFiles.setCombineBlocks(!this.repeatOnlyWithinCB.isSelected());
                    et.exportTiersColumnPerTierForFiles(encInfoFiles);
                }
            } else {
                Transcription2TabDelimitedText tdt = new Transcription2TabDelimitedText();
                tdt.exportTiersFromFiles(encInfoFiles);
            }
        }
        return true;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportTabDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportTabDialog.TitleLabel"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.suppressNamesCB.setText(ElanLocale.getString("ExportTabDialog.Label.SuppressNames"));
        this.suppressParticipantsCB.setText(ElanLocale.getString("ExportTabDialog.Label.SuppressParticipants"));
        this.colPerTierCB.setText(ElanLocale.getString("ExportTabDialog.Label.ColPerTier"));
        this.repeatValuesCB.setText(ElanLocale.getString("ExportTabDialog.Label.RepeatValues"));
        this.repeatOnlyWithinCB.setText(ElanLocale.getString("ExportTabDialog.Label.RepeatWithinBlock"));
        this.includeFileNameCB.setText(ElanLocale.getString("ExportTabDialog.Label.IncludeFileName"));
        this.includeFilePathCB.setText(ElanLocale.getString("ExportTabDialog.Label.IncludeFilePath"));
        this.timeCodesLabel.setText(ElanLocale.getString("ExportTabDialog.Label.Columns"));
        this.timeFormatLabel.setText(ElanLocale.getString("ExportTabDialog.Label.Formats"));
        this.btCheckBox.setText(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime"));
        this.etCheckBox.setText(ElanLocale.getString("Frame.GridFrame.ColumnEndTime"));
        this.durCheckBox.setText(ElanLocale.getString("Frame.GridFrame.ColumnDuration"));
        this.hhmmssmsCheckBox.setText(ElanLocale.getString("TimeCodeFormat.TimeCode"));
        this.ssmsCheckBox.setText(ElanLocale.getString("TimeCodeFormat.Seconds"));
        this.msCheckBox.setText(ElanLocale.getString("TimeCodeFormat.MilliSec"));
        this.timecodeCB.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE"));
        this.ntscTimecodeRB.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC"));
        this.palTimecodeRB.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL"));
        this.pal50TimecodeRB.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL50"));
        this.includeCVEntryDesCB.setText(ElanLocale.getString("ExportTabDialog.Label.IncludeCVDescription"));
        this.includeMediaHeaderCB.setText(ElanLocale.getString("ExportTabDialog.Label.IncludeMediaInfoHeader"));
        this.fileNameInRowCB.setText(ElanLocale.getString("ExportTabDialog.Label.FileNameInRow"));
        this.slicedOutputCB.setText(ElanLocale.getString("ExportTabDialog.Label.SlicedOutput"));
        this.includeAnnotationIdCB.setText(ElanLocale.getString("ExportTabDialog.Label.IncludeAnnotationID"));
    }

    private List<String> getMediaHeaderLines(TranscriptionImpl trans) {
        if (trans.getMediaDescriptors() != null && !trans.getMediaDescriptors().isEmpty()) {
            ArrayList<String> headers = new ArrayList<String>(trans.getMediaDescriptors().size());
            ViewerManager2 vm = ELANCommandFactory.getViewerManager(trans);
            ElanMediaPlayer pl = vm.getMasterMediaPlayer();
            if (!(pl instanceof EmptyMediaPlayer)) {
                headers.add(this.getMediaHeaderString(pl));
                for (ElanMediaPlayer spl : vm.getConnectedMediaPlayers()) {
                    if (spl == null || spl.getMediaDescriptor() == null) continue;
                    headers.add(this.getMediaHeaderString(spl));
                }
            } else {
                for (MediaDescriptor md : trans.getMediaDescriptors()) {
                    headers.add("\"#" + md.mediaURL + " -- offset: " + md.timeOrigin + "\"");
                }
            }
            return headers;
        }
        return null;
    }

    private String getMediaHeaderString(ElanMediaPlayer pl) {
        StringBuilder sb = new StringBuilder("\"#" + pl.getMediaDescriptor().mediaURL);
        sb.append(" -- offset: " + pl.getOffset());
        sb.append(", duration: ");
        sb.append(TimeFormatter.toString(pl.getMediaDuration()));
        sb.append(" / ");
        sb.append(TimeFormatter.toSSMSString(pl.getMediaDuration()));
        sb.append(" / ");
        sb.append(pl.getMediaDuration());
        if (pl.getVisualComponent() != null) {
            sb.append(", ms per sample: " + pl.getMilliSecondsPerSample());
        }
        sb.append("\"");
        return sb.toString();
    }

    private void setPreferencesOrDefaultSettings() {
        Boolean boolPref = Preferences.getBool("ExportTabDialog.restrictCheckBox", null);
        if (boolPref != null) {
            this.restrictCheckBox.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.correctTimesCB", null)) != null) {
            this.correctTimesCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.includeMediaHeaderCB", null)) != null) {
            this.includeMediaHeaderCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.suppressNamesCB", null)) != null) {
            this.suppressNamesCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.suppressParticipantsCB", null)) != null) {
            this.suppressParticipantsCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.colPerTierCB", null)) != null) {
            this.colPerTierCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.repeatValuesCB", null)) != null) {
            this.repeatValuesCB.setSelected(boolPref);
        } else {
            this.repeatValuesCB.setSelected(true);
        }
        boolPref = Preferences.getBool("ExportTabDialog.repeatOnlyWithinCB", null);
        if (boolPref != null) {
            this.repeatOnlyWithinCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.btCheckBox", null)) != null) {
            this.btCheckBox.setSelected(boolPref);
        } else {
            this.btCheckBox.setSelected(true);
        }
        boolPref = Preferences.getBool("ExportTabDialog.etCheckBox", null);
        if (boolPref != null) {
            this.etCheckBox.setSelected(boolPref);
        } else {
            this.etCheckBox.setSelected(true);
        }
        boolPref = Preferences.getBool("ExportTabDialog.durCheckBox", null);
        if (boolPref != null) {
            this.durCheckBox.setSelected(boolPref);
        } else {
            this.durCheckBox.setSelected(true);
        }
        boolPref = Preferences.getBool("ExportTabDialog.hhmmssmsCheckBox", null);
        if (boolPref != null) {
            this.hhmmssmsCheckBox.setSelected(boolPref);
        } else {
            this.hhmmssmsCheckBox.setSelected(true);
        }
        boolPref = Preferences.getBool("ExportTabDialog.ssmsCheckBox", null);
        if (boolPref != null) {
            this.ssmsCheckBox.setSelected(boolPref);
        } else {
            this.ssmsCheckBox.setSelected(true);
        }
        boolPref = Preferences.getBool("ExportTabDialog.msCheckBox", null);
        if (boolPref != null) {
            this.msCheckBox.setSelected(boolPref);
        } else {
            this.msCheckBox.setSelected(false);
        }
        boolPref = Preferences.getBool("ExportTabDialog.timecodeCB", null);
        if (boolPref != null) {
            this.timecodeCB.setSelected(boolPref);
        } else {
            this.timecodeCB.setSelected(false);
        }
        boolPref = Preferences.getBool("ExportTabDialog.ntscTimecodeRB", null);
        if (boolPref != null) {
            this.ntscTimecodeRB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.pal50TimecodeRB", null)) != null) {
            this.pal50TimecodeRB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.palTimecodeRB", null)) != null) {
            this.palTimecodeRB.setSelected(boolPref);
        } else {
            this.palTimecodeRB.setSelected(true);
        }
        boolPref = Preferences.getBool("ExportTabDialog.includeFileNameCB", null);
        if (boolPref != null) {
            this.includeFileNameCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.IncludeCVDescription", null)) != null) {
            this.includeCVEntryDesCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.includeFilePathCB", null)) != null) {
            this.includeFilePathCB.setSelected(boolPref);
        } else {
            this.includeFilePathCB.setSelected(true);
        }
        boolPref = Preferences.getBool("ExportTabDialog.fileNameInRowCB", null);
        if (boolPref != null) {
            this.fileNameInRowCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.slicedOutputCB", null)) != null) {
            this.slicedOutputCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTabDialog.includeAnnotationIDCB", null)) != null) {
            this.includeAnnotationIdCB.setSelected(boolPref);
        }
        if (this.timecodeCB.isSelected()) {
            this.palTimecodeRB.setEnabled(true);
            this.pal50TimecodeRB.setEnabled(true);
            this.ntscTimecodeRB.setEnabled(true);
        } else {
            this.palTimecodeRB.setEnabled(false);
            this.pal50TimecodeRB.setEnabled(false);
            this.ntscTimecodeRB.setEnabled(false);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportTabDialog.restrictCheckBox", this.restrictCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.correctTimesCB", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportTabDialog.suppressNamesCB", this.suppressNamesCB.isSelected(), null);
        Preferences.set("ExportTabDialog.suppressParticipantsCB", this.suppressParticipantsCB.isSelected(), null);
        Preferences.set("ExportTabDialog.colPerTierCB", this.colPerTierCB.isSelected(), null);
        Preferences.set("ExportTabDialog.repeatValuesCB", this.repeatValuesCB.isSelected(), null);
        Preferences.set("ExportTabDialog.repeatOnlyWithinCB", this.repeatOnlyWithinCB.isSelected(), null);
        Preferences.set("ExportTabDialog.btCheckBox", this.btCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.etCheckBox", this.etCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.durCheckBox", this.durCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.hhmmssmsCheckBox", this.hhmmssmsCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.ssmsCheckBox", this.ssmsCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.msCheckBox", this.msCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.timecodeCB", this.timecodeCB.isSelected(), null);
        Preferences.set("ExportTabDialog.ntscTimecodeRB", this.ntscTimecodeRB.isSelected(), null);
        Preferences.set("ExportTabDialog.palTimecodeRB", this.palTimecodeRB.isSelected(), null);
        Preferences.set("ExportTabDialog.pal50TimecodeRB", this.pal50TimecodeRB.isSelected(), null);
        Preferences.set("ExportTabDialog.includeFileNameCB", this.includeFileNameCB.isSelected(), null);
        Preferences.set("ExportTabDialog.includeFilePathCB", this.includeFilePathCB.isSelected(), null);
        Preferences.set("ExportTabDialog.fileNameInRowCB", this.fileNameInRowCB.isSelected(), null);
        Preferences.set("ExportTabDialog.IncludeCVDescription", this.includeCVEntryDesCB.isSelected(), null);
        Preferences.set("ExportTabDialog.includeMediaHeaderCB", this.includeMediaHeaderCB.isSelected(), null);
        Preferences.set("ExportTabDialog.slicedOutputCB", this.slicedOutputCB.isSelected(), null);
        Preferences.set("ExportTabDialog.includeAnnotationIDCB", this.includeAnnotationIdCB.isSelected(), null);
        if (!this.multipleFileExport) {
            Preferences.set("ExportTabDialog.selectedTiers", this.getSelectedTiers(), (Transcription)this.transcription);
            Preferences.set("ExportTabDialog.SelectTiersMode", this.getSelectionMode(), (Transcription)this.transcription);
            if (this.getSelectionMode() != "Tier") {
                Preferences.set("ExportTabDialog.LastSelectedItems", this.getSelectedItems(), (Transcription)this.transcription);
            }
            Preferences.set("ExportTabDialog.HiddenTiers", this.getHiddenTiers(), (Transcription)this.transcription);
            List<String> tierOrder = this.getTierOrder();
            Preferences.set("ExportTabDialog.TierOrder", tierOrder, (Transcription)this.transcription);
        } else {
            Preferences.set("ExportTabDialog.SelectTiersMode", this.getSelectionMode(), null);
        }
    }
}

