/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeFormatter;
import mpi.eudico.util.TimeRelation;
import nl.mpi.util.FileExtension;

public class ExportTradTranscript
extends AbstractExtTierExportDialog
implements ItemListener {
    private final String TIME_SEP = " - ";
    private final char NL_CHAR = (char)10;
    private final char SPACE_CHAR = (char)32;
    private final int LABEL_VALUE_MARGIN = 3;
    private final int NUM_CHARS = 80;
    private final int LABEL_WIDTH = 5;
    private final int MERGE_DUR = 50;
    private final int MIN_SILENCE = 20;
    private JCheckBox tierLabelsCB;
    private JCheckBox participantLabelsCB;
    private JCheckBox suppressRepeatedLabelsCB;
    private JCheckBox labelWidthCB;
    private JCheckBox selectionCB;
    private JCheckBox timeCodeCB;
    private JCheckBox silenceCB;
    private JCheckBox wrapLinesCB;
    private JCheckBox emptyLineCB;
    private JCheckBox numberAnnotationsCB;
    private JCheckBox numberLinesCB;
    private JCheckBox mergeAnnCB;
    private JCheckBox useJeffersonCB;
    private JTextField minDurSilTF;
    private JTextField labelWidthTF;
    private JTextField numCharTF;
    private JTextField mergeDurTF;
    private JLabel minDurSilLabel;
    private JLabel silDecimalLabel;
    private JLabel charPerLineLabel;
    private JLabel mergeDurLabel;
    private JComboBox silenceDecimalComboBox;
    private boolean includeTimeCodes;
    private boolean includeLabels;
    private boolean suppressRepeatedLabels;
    private Map<String, String> marginStrings;
    private Map<String, String> untruncatedLabels;
    private boolean includeSilence;
    private static final String EMPTY_LABEL = "EMPTY_LABEL-Beic1quepeev7ov1uDi1ohbeeyaebein";
    private static final String NUMBERED_EMPTY_LABEL = "NUMBERED_EMPTY_LABEL-vaib2agaud9shaeg8Lai7ohvoht6ut8w";
    private static final String TC_LABEL = "TC-ieh8Ku0saewi0Au0oash6eileij8Yeit";
    private boolean insertEmptyLine;
    private boolean wrapLines;
    private boolean numberAnnotations;
    private boolean numberAnnotationLines;
    private String numberFieldSpaces = "";
    private String numberFieldFormat = "%4d ";
    private int lineNumber;
    private boolean useParticipantLabel;
    private boolean useJefferson;
    ArrayList<String> indentList = null;
    ArrayList<Long> indentBegin = null;
    ArrayList<Long> indentEnd = null;
    ArrayList<Integer> indentApplied = null;
    ArrayList<Integer> indentRefers = null;
    private String prevTierLabel;
    private NumberFormat formatter;

    public ExportTradTranscript(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.postInit();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getSource();
        if (source == this.wrapLinesCB) {
            if (this.wrapLinesCB.isSelected()) {
                this.numCharTF.setEnabled(true);
                this.numCharTF.setBackground(Constants.SHAREDCOLOR4);
                if (this.numCharTF.getText() != null || this.numCharTF.getText().length() == 0) {
                    this.numCharTF.setText("80");
                }
                this.numCharTF.requestFocus();
            } else {
                this.numCharTF.setEnabled(false);
                this.numCharTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        } else if (source == this.silenceCB) {
            if (this.silenceCB.isSelected()) {
                this.minDurSilTF.setEnabled(true);
                this.minDurSilTF.setBackground(Constants.SHAREDCOLOR4);
                this.silenceDecimalComboBox.setEnabled(true);
                if (this.minDurSilTF.getText() == null || this.minDurSilTF.getText().isEmpty()) {
                    this.minDurSilTF.setText("20");
                }
                this.minDurSilTF.requestFocus();
            } else {
                this.minDurSilTF.setEnabled(false);
                this.silenceDecimalComboBox.setEnabled(false);
                this.minDurSilTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        } else if (source == this.tierLabelsCB || source == this.participantLabelsCB) {
            boolean tierSelected = this.tierLabelsCB.isSelected();
            boolean participantSelected = this.participantLabelsCB.isSelected();
            if (((JCheckBox)source).isSelected()) {
                JCheckBox other = source == this.tierLabelsCB ? this.participantLabelsCB : this.tierLabelsCB;
                other.setSelected(false);
            }
            boolean enableSubOptions = tierSelected || participantSelected;
            this.labelWidthCB.setEnabled(enableSubOptions);
            this.suppressRepeatedLabelsCB.setEnabled(enableSubOptions);
            if (enableSubOptions) {
                if (this.labelWidthCB.isSelected()) {
                    this.labelWidthTF.setEnabled(true);
                    this.labelWidthTF.setBackground(Constants.SHAREDCOLOR4);
                    if (this.labelWidthTF.getText() == null || this.labelWidthTF.getText().isEmpty()) {
                        this.labelWidthTF.setText("5");
                    }
                    this.labelWidthTF.requestFocus();
                } else {
                    this.labelWidthTF.setEnabled(false);
                    this.labelWidthTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
                }
            } else {
                this.labelWidthTF.setEnabled(false);
                this.labelWidthTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        } else if (source == this.labelWidthCB) {
            if (this.labelWidthCB.isSelected() && this.labelWidthCB.isEnabled()) {
                this.labelWidthTF.setEnabled(true);
                this.labelWidthTF.setBackground(Constants.SHAREDCOLOR4);
                if (this.labelWidthTF.getText() == null || this.labelWidthTF.getText().isEmpty()) {
                    this.labelWidthTF.setText("5");
                }
                this.labelWidthTF.requestFocus();
            } else {
                this.labelWidthTF.setEnabled(false);
                this.labelWidthTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        } else if (source == this.mergeAnnCB) {
            if (this.mergeAnnCB.isSelected()) {
                this.mergeDurTF.setEnabled(true);
                this.mergeDurTF.setBackground(Constants.SHAREDCOLOR4);
                if (this.mergeDurTF.getText() == null || this.mergeDurTF.getText().isEmpty()) {
                    this.mergeDurTF.setText("50");
                }
                this.mergeDurTF.requestFocus();
            } else {
                this.mergeDurTF.setEnabled(false);
                this.mergeDurTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        }
        if (source == this.wrapLinesCB || source == this.numberAnnotationsCB) {
            this.numberLinesCB.setEnabled(this.wrapLinesCB.isSelected() && this.numberAnnotationsCB.isSelected());
        }
    }

    protected void extractTiers() {
        String stringPref;
        List<String> stringsPref = Preferences.getListOfString("ExportTradTranscript.TierOrder", this.transcription);
        if (stringsPref != null) {
            this.setTierOrder(stringsPref);
        } else {
            super.extractTiers(true);
        }
        stringsPref = Preferences.getListOfString("ExportTradTranscript.selectedTiers", this.transcription);
        if (stringsPref instanceof List) {
            this.setSelectedTiers(stringsPref);
        }
        if ((stringPref = Preferences.getString("ExportTradTranscript.SelectTiersMode", this.transcription)) != null) {
            List<String> selItems;
            this.setSelectionMode(stringPref);
            if (!"Tier".equals(stringPref) && (selItems = Preferences.getListOfString("ExportTradTranscript.LastSelectedItems", this.transcription)) != null) {
                this.setSelectedItems(selItems);
            }
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.charPerLineLabel = new JLabel();
        this.minDurSilLabel = new JLabel();
        this.silDecimalLabel = new JLabel();
        this.mergeDurLabel = new JLabel();
        this.wrapLinesCB = new JCheckBox();
        this.timeCodeCB = new JCheckBox();
        this.silenceCB = new JCheckBox();
        this.tierLabelsCB = new JCheckBox();
        this.labelWidthCB = new JCheckBox();
        this.participantLabelsCB = new JCheckBox();
        this.suppressRepeatedLabelsCB = new JCheckBox();
        this.selectionCB = new JCheckBox();
        this.emptyLineCB = new JCheckBox();
        this.mergeAnnCB = new JCheckBox();
        this.numberAnnotationsCB = new JCheckBox();
        this.numberLinesCB = new JCheckBox();
        this.useJeffersonCB = new JCheckBox();
        this.numCharTF = new JTextField(4);
        this.minDurSilTF = new JTextField(4);
        this.labelWidthTF = new JTextField(4);
        this.mergeDurTF = new JTextField(4);
        this.silenceDecimalComboBox = new JComboBox();
        this.silenceDecimalComboBox.addItem(1);
        this.silenceDecimalComboBox.addItem(2);
        this.silenceDecimalComboBox.addItem(3);
        this.silenceDecimalComboBox.setSelectedItem(2);
        this.optionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = this.insets;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.optionsPanel.add((Component)this.selectionCB, gbc);
        this.wrapLinesCB.addItemListener(this);
        ++gbc.gridy;
        this.optionsPanel.add((Component)this.wrapLinesCB, gbc);
        JPanel fill = new JPanel();
        Dimension fillDim = new Dimension(30, 10);
        fill.setPreferredSize(fillDim);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        this.optionsPanel.add((Component)fill, gbc);
        this.numCharTF.setEnabled(false);
        this.numCharTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.numCharTF, gbc);
        gbc.gridx = 2;
        this.optionsPanel.add((Component)this.charPerLineLabel, gbc);
        this.mergeAnnCB.addItemListener(this);
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        ++gbc.gridy;
        this.optionsPanel.add((Component)this.mergeAnnCB, gbc);
        this.mergeDurTF.setEnabled(false);
        this.mergeDurTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        ++gbc.gridy;
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        this.optionsPanel.add((Component)this.mergeDurTF, gbc);
        gbc.gridx = 2;
        this.optionsPanel.add((Component)this.mergeDurLabel, gbc);
        this.numberAnnotationsCB.addItemListener(this);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.optionsPanel.add((Component)this.horizontal(this.numberAnnotationsCB, this.numberLinesCB), gbc);
        this.tierLabelsCB.addItemListener(this);
        this.participantLabelsCB.addItemListener(this);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.optionsPanel.add((Component)this.horizontal(this.tierLabelsCB, this.participantLabelsCB), gbc);
        this.labelWidthCB.addItemListener(this);
        this.labelWidthCB.setEnabled(false);
        ++gbc.gridy;
        gbc.gridx = 1;
        gbc.gridwidth = 0;
        this.optionsPanel.add((Component)this.horizontal(this.labelWidthCB, this.labelWidthTF), gbc);
        ++gbc.gridy;
        this.optionsPanel.add((Component)this.suppressRepeatedLabelsCB, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.optionsPanel.add((Component)this.timeCodeCB, gbc);
        this.silenceCB.addItemListener(this);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.optionsPanel.add((Component)this.silenceCB, gbc);
        this.minDurSilTF.setEnabled(false);
        this.minDurSilTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        ++gbc.gridy;
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        this.optionsPanel.add((Component)this.minDurSilTF, gbc);
        gbc.gridx = 2;
        this.optionsPanel.add((Component)this.minDurSilLabel, gbc);
        ++gbc.gridy;
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.silenceDecimalComboBox, gbc);
        gbc.gridx = 2;
        this.optionsPanel.add((Component)this.silDecimalLabel, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.optionsPanel.add((Component)this.emptyLineCB, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        this.optionsPanel.add((Component)this.useJeffersonCB, gbc);
        this.setPreferredSetting();
        this.updateLocale();
    }

    private JPanel horizontal(JComponent ... components) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        for (JComponent comp : components) {
            panel.add((Component)comp, gbc);
        }
        return panel;
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    @Override
    protected boolean startExport() throws IOException {
        File exportFile;
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        int charsPerLine = Integer.MAX_VALUE;
        if (this.wrapLinesCB.isSelected()) {
            String textValue = this.numCharTF.getText().trim();
            try {
                charsPerLine = Integer.parseInt(textValue);
                if (charsPerLine <= 10) {
                    this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber"));
                    this.numCharTF.selectAll();
                    this.numCharTF.requestFocus();
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber"));
                this.numCharTF.selectAll();
                this.numCharTF.requestFocus();
                return false;
            }
        }
        int labelWidth = 5;
        if ((this.tierLabelsCB.isSelected() || this.participantLabelsCB.isSelected()) && this.labelWidthCB.isSelected()) {
            String textValue = this.labelWidthTF.getText().trim();
            try {
                labelWidth = Integer.parseInt(textValue);
                if (labelWidth <= 0) {
                    this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber3"));
                    this.labelWidthTF.selectAll();
                    this.labelWidthTF.requestFocus();
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber3"));
                this.labelWidthTF.selectAll();
                this.labelWidthTF.requestFocus();
                return false;
            }
        }
        int mergeValue = 50;
        if (this.mergeAnnCB.isSelected()) {
            String textValue = this.mergeDurTF.getText().trim();
            try {
                mergeValue = Integer.parseInt(textValue);
                if (mergeValue <= 0) {
                    this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber4"));
                    this.mergeDurTF.selectAll();
                    this.mergeDurTF.requestFocus();
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber4"));
                this.mergeDurTF.selectAll();
                this.mergeDurTF.requestFocus();
                return false;
            }
        }
        int minSilence = 20;
        if (this.silenceCB.isSelected()) {
            String textValue = this.minDurSilTF.getText().trim();
            try {
                minSilence = Integer.parseInt(textValue);
                if (minSilence < 0) {
                    this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber2"));
                    this.minDurSilTF.selectAll();
                    this.minDurSilTF.requestFocus();
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber2"));
                this.minDurSilTF.selectAll();
                this.minDurSilTF.requestFocus();
                return false;
            }
        }
        if ((exportFile = this.promptForFile(ElanLocale.getString("ExportTradTranscript.Title"), null, FileExtension.TEXT_EXT, true)) == null) {
            return false;
        }
        return this.doExport(exportFile, selectedTiers, charsPerLine, minSilence, mergeValue, labelWidth);
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportTradTranscript.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportTradTranscript.Title"));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportDialog.Label.Options")));
        this.wrapLinesCB.setText(ElanLocale.getString("ExportTradTranscript.Label.WrapLines"));
        this.charPerLineLabel.setText(ElanLocale.getString("ExportTradTranscript.Label.NumberChars"));
        this.timeCodeCB.setText(ElanLocale.getString("ExportTradTranscript.Label.IncludeTimeCode"));
        this.tierLabelsCB.setText(ElanLocale.getString("ExportTradTranscript.Label.IncludeTierLabels"));
        this.participantLabelsCB.setText(ElanLocale.getString("ExportTradTranscript.Label.IncludeParticipantLabels"));
        this.suppressRepeatedLabelsCB.setText(ElanLocale.getString("ExportTradTranscript.Label.SuppressRepeatedLabels"));
        this.numberAnnotationsCB.setText(ElanLocale.getString("ExportTradTranscript.Label.NumberAnnos"));
        this.numberLinesCB.setText(ElanLocale.getString("ExportTradTranscript.Label.NumberLines"));
        this.silenceCB.setText(ElanLocale.getString("ExportTradTranscript.Label.IncludeSilence"));
        this.minDurSilLabel.setText(ElanLocale.getString("ExportTradTranscript.Label.MinSilenceDuration"));
        this.selectionCB.setText(ElanLocale.getString("ExportDialog.Restrict"));
        this.silDecimalLabel.setText(ElanLocale.getString("InterlinearizerOptionsDlg.NumberofDigits"));
        this.emptyLineCB.setText(ElanLocale.getString("ExportTradTranscript.Label.IncludeEmptyLines"));
        this.labelWidthCB.setText(ElanLocale.getString("ExportTradTranscript.Label.MaxLabelWidth"));
        this.mergeAnnCB.setText(ElanLocale.getString("ExportTradTranscript.Label.MergeAnnotations"));
        this.mergeDurLabel.setText(ElanLocale.getString("ExportTradTranscript.Label.MergeDuration"));
        this.useJeffersonCB.setText(ElanLocale.getString("ExportTradTranscript.Label.UseJefferson"));
        this.validate();
    }

    private String getMarginString(String name, int fixedLabelWidth, int numchars) {
        int nameLength = 0;
        if (name.length() > fixedLabelWidth) {
            name = name.substring(0, fixedLabelWidth);
        }
        nameLength = name.length();
        StringBuilder bf = new StringBuilder(name);
        for (int i = numchars - nameLength; i > 0; --i) {
            bf.append(' ');
        }
        return bf.toString();
    }

    private String[] breakValue(String val, int maxAnnotationLength) {
        if (val == null) {
            return new String[0];
        }
        if (val.indexOf(32) < 0 || val.length() < maxAnnotationLength) {
            return new String[]{val};
        }
        ArrayList<String> vals = new ArrayList<String>();
        String sub = null;
        while (val.length() > maxAnnotationLength) {
            sub = val.substring(0, maxAnnotationLength);
            int breakSpace = sub.lastIndexOf(32);
            if (breakSpace < 0) {
                breakSpace = val.indexOf(32);
                if (breakSpace < 0) {
                    vals.add(val);
                    break;
                }
                vals.add(val.substring(0, breakSpace));
                val = val.substring(breakSpace + 1);
            } else {
                vals.add(sub.substring(0, breakSpace));
                val = val.substring(breakSpace + 1);
            }
            if (val.length() > maxAnnotationLength) continue;
            vals.add(val);
            break;
        }
        return vals.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private boolean doExport(File exportFile, List<String> orderedTiers, int charsPerLine, int minSilence, int mergeValue, int fixedLabelWidth) {
        int numberFieldWidth;
        boolean selectionOnly = this.selectionCB.isSelected();
        boolean mergeAnn = this.mergeAnnCB.isSelected();
        this.useJefferson = this.useJeffersonCB.isSelected();
        Object annotList = null;
        this.wrapLines = this.wrapLinesCB.isSelected();
        this.includeTimeCodes = this.timeCodeCB.isSelected();
        this.includeLabels = this.tierLabelsCB.isSelected() || this.participantLabelsCB.isSelected();
        this.useParticipantLabel = this.participantLabelsCB.isSelected();
        this.suppressRepeatedLabels = this.includeLabels && this.suppressRepeatedLabelsCB.isSelected();
        this.includeSilence = this.silenceCB.isSelected();
        this.insertEmptyLine = this.emptyLineCB.isSelected();
        this.numberAnnotations = this.numberAnnotationsCB.isSelected();
        this.numberAnnotationLines = this.wrapLines && this.numberAnnotations && this.numberLinesCB.isSelected();
        int labelMargin = 0;
        int labelWidth = 0;
        this.untruncatedLabels = null;
        this.marginStrings = null;
        this.lineNumber = 1;
        if (this.includeLabels) {
            String name;
            int i;
            this.untruncatedLabels = new HashMap<String, String>();
            this.marginStrings = new HashMap<String, String>();
            if (this.labelWidthCB.isSelected()) {
                labelWidth = fixedLabelWidth;
                labelMargin = labelWidth + 3;
            } else {
                for (i = 0; i < orderedTiers.size(); ++i) {
                    name = orderedTiers.get(i);
                    if (name.length() <= labelMargin) continue;
                    labelMargin = name.length();
                }
                labelWidth = labelMargin;
                labelMargin += 3;
            }
            for (i = 0; i < orderedTiers.size(); ++i) {
                String value;
                name = orderedTiers.get(i);
                if (this.useParticipantLabel) {
                    TierImpl tier = this.transcription.getTierWithId(name);
                    value = tier.getParticipant();
                    if (value == null || value.isEmpty()) {
                        value = name;
                    }
                } else {
                    value = name;
                }
                this.untruncatedLabels.put(name, value);
                this.marginStrings.put(name, this.getMarginString(value, labelWidth, labelMargin));
            }
            if (this.includeTimeCodes) {
                this.marginStrings.put(TC_LABEL, this.getMarginString("", labelWidth, labelMargin));
            }
            this.marginStrings.put(EMPTY_LABEL, this.getMarginString("", labelWidth, labelMargin));
            this.marginStrings.put(NUMBERED_EMPTY_LABEL, this.getMarginString("", labelWidth, labelMargin));
        }
        long bb = 0L;
        long eb = Long.MAX_VALUE;
        if (selectionOnly && this.selection != null) {
            bb = this.selection.getBeginTime();
            eb = this.selection.getEndTime();
        }
        TreeSet<IndexedExportRecord> records = new TreeSet<IndexedExportRecord>();
        block6: for (int i = 0; i < orderedTiers.size(); ++i) {
            String tierName = orderedTiers.get(i);
            TierImpl t = this.transcription.getTierWithId(tierName);
            if (t == null) continue;
            for (Annotation annotation : t.getAnnotations()) {
                if (TimeRelation.overlaps(annotation, bb, eb)) {
                    records.add(new IndexedExportRecord(annotation, i));
                }
                if (annotation.getBeginTimeBoundary() <= eb) continue;
                continue block6;
            }
        }
        if (this.includeSilence) {
            IndexedExportRecord prev = null;
            long prevEndTime = 0L;
            for (IndexedExportRecord indexedExportRecord : records) {
                long dur;
                if (prev != null && (dur = indexedExportRecord.getBeginTime() - prevEndTime) >= (long)minSilence) {
                    prev.setSilenceAfter(dur);
                }
                if (prevEndTime < indexedExportRecord.getEndTime()) {
                    prevEndTime = indexedExportRecord.getEndTime();
                }
                prev = indexedExportRecord;
            }
        }
        if (this.numberAnnotations) {
            int estimatedLineNumbers = 0;
            if (this.numberAnnotationLines) {
                int estimatedLineLength = charsPerLine - labelMargin - 10;
                for (IndexedExportRecord indexedExportRecord : records) {
                    int len = indexedExportRecord.getValue().length();
                    estimatedLineNumbers += 1 + len / estimatedLineLength;
                }
            } else {
                estimatedLineNumbers = records.size();
            }
            int numDigits = estimatedLineNumbers == 0 ? 1 : 1 + (int)Math.floor(Math.log10(estimatedLineNumbers));
            numberFieldWidth = numDigits + 1;
            char[] spaces = new char[numberFieldWidth];
            Arrays.fill(spaces, ' ');
            this.numberFieldSpaces = new String(spaces);
            this.numberFieldFormat = "%0" + numDigits + "d ";
        } else {
            numberFieldWidth = 0;
        }
        int maxAnnotationLength = charsPerLine - labelMargin - numberFieldWidth;
        if (this.useJefferson) {
            this.indentList = new ArrayList();
            this.indentBegin = new ArrayList();
            this.indentEnd = new ArrayList();
            this.indentApplied = new ArrayList();
            this.indentRefers = new ArrayList();
            for (int i = 0; i < records.size(); ++i) {
                this.indentApplied.add(0);
                this.indentRefers.add(0);
            }
        }
        try {
            void var21_40;
            BufferedWriter writer = null;
            FileOutputStream out = new FileOutputStream(exportFile);
            Object var21_37 = null;
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)out, this.encoding);
            }
            catch (UnsupportedCharsetException uce) {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter((Writer)var21_40);
            if (mergeAnn) {
                Iterator recIter = records.iterator();
                if (recIter.hasNext()) {
                    IndexedExportRecord record = (IndexedExportRecord)recIter.next();
                    Object val = record.getValue();
                    IndexedExportRecord beginRecord = record;
                    int index = 0;
                    while (recIter.hasNext()) {
                        IndexedExportRecord nextRec = (IndexedExportRecord)recIter.next();
                        long silDur = record.getSilenceAfter();
                        if (record.getTierName().equals(nextRec.getTierName()) && silDur >= 0L && silDur <= (long)mergeValue) {
                            if (this.includeSilence) {
                                val = (String)val + " (" + this.formatSilenceString(silDur) + ")";
                            }
                            val = (String)val + " " + nextRec.getValue();
                            record = nextRec;
                        } else {
                            this.maybeWriteTierLabel(writer, record);
                            this.writeAnnotationBlock(writer, (String)val, maxAnnotationLength, beginRecord.getBeginTime(), record.getEndTime());
                            this.writeTimeCodeSilenceBlock(writer, beginRecord, record);
                            record = nextRec;
                            val = record.getValue();
                            beginRecord = record;
                        }
                        ++index;
                    }
                    this.maybeWriteTierLabel(writer, record);
                    this.writeAnnotationBlock(writer, (String)val, maxAnnotationLength, beginRecord.getBeginTime(), record.getEndTime());
                    this.writeTimeCodeSilenceBlock(writer, beginRecord, record);
                }
            } else {
                int index = 0;
                for (IndexedExportRecord record : records) {
                    String val = record.getValue();
                    this.maybeWriteTierLabel(writer, record);
                    this.writeAnnotationBlock(writer, val, maxAnnotationLength, record.getBeginTime(), record.getEndTime());
                    this.writeTimeCodeSilenceBlock(writer, record, record);
                    ++index;
                }
            }
            writer.flush();
            writer.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error"), ElanLocale.getString("Message.Warning"), 2);
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private String addSpaces(int n) {
        Object s = "";
        for (int i = 0; i < n; ++i) {
            s = (String)s + " ";
        }
        return s;
    }

    private String mergeString(String[] a) {
        Object s = "";
        for (int i = 0; i < a.length; ++i) {
            s = (String)s + a[i] + "\n";
        }
        return s;
    }

    private int findNthIndexOf(String s, int n) {
        int index = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '[') {
                if (n == 0) {
                    return index;
                }
                --n;
            }
            if (s.charAt(i) == '\n') {
                index = 0;
                continue;
            }
            ++index;
        }
        return -1;
    }

    private int computeIndent(String s, long b, long e) {
        int indent = 0;
        if (s.length() == 0 || s.charAt(0) != '[') {
            return 0;
        }
        for (int i = 0; i < this.indentList.size(); ++i) {
            if (this.indentBegin.get(i) > b || b > this.indentEnd.get(i)) continue;
            indent = this.findNthIndexOf(this.indentList.get(i), this.indentRefers.get(i));
            if (indent != -1) {
                int refers = this.indentRefers.get(i);
                this.indentRefers.set(i, refers + 1);
                break;
            }
            indent = 0;
        }
        if (indent == 0) {
            return 0;
        }
        this.indentApplied.set(this.indentList.size(), indent);
        this.indentRefers.set(this.indentList.size(), 1);
        return indent;
    }

    private void writeAnnotationBlock(BufferedWriter writer, String val, int maxAnnotationLength, long beginTime, long endTime) throws IOException {
        val = ((String)val).replace('\n', ' ');
        if (this.useJefferson) {
            val = this.addSpaces(this.computeIndent((String)val, beginTime, endTime)) + (String)val;
        }
        if (!this.wrapLines || ((String)val).length() <= maxAnnotationLength) {
            writer.write((String)val);
            writer.newLine();
            if (this.useJefferson) {
                this.indentList.add((String)val);
                this.indentBegin.add(beginTime);
                this.indentEnd.add(endTime);
            }
        } else {
            String[] valLines = this.breakValue((String)val, maxAnnotationLength);
            String wrappedLineLabel = this.numberAnnotationLines ? NUMBERED_EMPTY_LABEL : EMPTY_LABEL;
            for (int i = 0; i < valLines.length; ++i) {
                if (i != 0) {
                    this.maybeWriteLabel(writer, wrappedLineLabel);
                }
                writer.write(valLines[i]);
                writer.newLine();
            }
            if (this.useJefferson) {
                this.indentList.add(this.mergeString(valLines));
                this.indentBegin.add(beginTime);
                this.indentEnd.add(endTime);
            }
        }
    }

    private void writeTimeCodeSilenceBlock(BufferedWriter writer, IndexedExportRecord beginRecord, IndexedExportRecord endRecord) throws IOException {
        long silenceAfter;
        if (this.includeTimeCodes) {
            this.maybeWriteLabel(writer, TC_LABEL);
            writer.write(TimeFormatter.toString(beginRecord.getBeginTime()));
            writer.write(" - ");
            writer.write(TimeFormatter.toString(endRecord.getEndTime()));
            writer.newLine();
        }
        if (this.includeSilence && (silenceAfter = endRecord.getSilenceAfter()) >= 0L) {
            this.maybeWriteLabel(writer, EMPTY_LABEL);
            writer.write("(" + this.formatSilenceString(silenceAfter) + ")");
            writer.newLine();
        }
        if (this.insertEmptyLine) {
            writer.newLine();
        }
    }

    private void maybeWriteTierLabel(BufferedWriter writer, IndexedExportRecord record) throws IOException {
        String tierName = record.getTierName();
        if (this.suppressRepeatedLabels) {
            String untruncatedLabel = this.untruncatedLabels.get(tierName);
            if (untruncatedLabel.equals(this.prevTierLabel)) {
                tierName = NUMBERED_EMPTY_LABEL;
            } else {
                this.prevTierLabel = untruncatedLabel;
            }
        }
        this.maybeWriteLabel(writer, tierName);
    }

    private void maybeWriteLabel(BufferedWriter writer, String tierName) throws IOException {
        if (this.numberAnnotations) {
            if (tierName == EMPTY_LABEL || tierName == TC_LABEL) {
                writer.write(this.numberFieldSpaces);
            } else {
                writer.write(String.format(this.numberFieldFormat, this.lineNumber));
                ++this.lineNumber;
            }
        }
        if (this.includeLabels) {
            writer.write(this.marginStrings.get(tierName));
        }
    }

    private String formatSilenceString(long dur) {
        if (dur < 0L) {
            return "";
        }
        if (this.formatter == null) {
            int decimal = (Integer)this.silenceDecimalComboBox.getSelectedItem();
            this.formatter = NumberFormat.getInstance();
            this.formatter.setMinimumFractionDigits(decimal);
            this.formatter.setMaximumFractionDigits(decimal);
        }
        return this.formatter.format((float)dur / 1000.0f);
    }

    private void setPreferredSetting() {
        Integer intPref;
        String stringPref;
        this.extractTiers();
        Boolean boolPref = Preferences.getBool("ExportTradTranscript.rootTiersCB", null);
        if (boolPref != null) {
            this.setRootTiersOnly(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.wrapLinesCB", null)) != null) {
            this.wrapLinesCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.minimalDurTF", null)) != null) {
            Preferences.set("ExportTradTranscript.numCharPerLine", boolPref.toString(), null);
            Preferences.set("ExportTradTranscript.minimalDurTF", null, null);
        }
        if ((stringPref = Preferences.getString("ExportTradTranscript.numCharPerLine", null)) != null) {
            this.numCharTF.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.timeCodeCB", null)) != null) {
            this.timeCodeCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.MergeAnnotations", null)) != null) {
            this.mergeAnnCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("ExportTradTranscript.MergeDurationValue", null)) != null) {
            this.mergeDurTF.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.tierLabelsCB", null)) != null) {
            this.tierLabelsCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.participantLabelsCB", null)) != null) {
            this.participantLabelsCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.suppressRepeatedLabelsCB", null)) != null) {
            this.suppressRepeatedLabelsCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.FixedLabelWidth", null)) != null) {
            this.labelWidthCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("ExportTradTranscript.FixedLabelWidthValue", null)) != null) {
            this.labelWidthTF.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.numberAnnosCB", null)) != null) {
            this.numberAnnotationsCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.numberLinesCB", null)) != null) {
            this.numberLinesCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.IncludeEmptyLines", null)) != null) {
            this.emptyLineCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.silenceCB", null)) != null) {
            this.silenceCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("ExportTradTranscript.minDurSilTF", null)) != null) {
            this.minDurSilTF.setText(stringPref);
        }
        if ((intPref = Preferences.getInt("NumberOfDecimalDigits", null)) != null) {
            this.silenceDecimalComboBox.setSelectedItem((int)intPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.selectionCB", null)) != null) {
            this.selectionCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTradTranscript.useJeffersonCB", null)) != null) {
            this.useJeffersonCB.setSelected(boolPref);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportTradTranscript.rootTiersCB", this.isRootTiersOnly(), null, false, false);
        Preferences.set("ExportTradTranscript.wrapLinesCB", this.wrapLinesCB.isSelected(), null, false, false);
        if (this.numCharTF.getText() != null) {
            Preferences.set("ExportTradTranscript.numCharPerLine", this.numCharTF.getText().trim(), null, false, false);
        }
        Preferences.set("ExportTradTranscript.timeCodeCB", this.timeCodeCB.isSelected(), null, false, false);
        Preferences.set("ExportTradTranscript.MergeAnnotations", this.mergeAnnCB.isSelected(), null, false, false);
        if (this.mergeDurTF.getText() != null) {
            Preferences.set("ExportTradTranscript.MergeDurationValue", this.mergeDurTF.getText(), null, false, false);
        }
        Preferences.set("ExportTradTranscript.tierLabelsCB", this.tierLabelsCB.isSelected(), null, false, false);
        Preferences.set("ExportTradTranscript.participantLabelsCB", this.participantLabelsCB.isSelected(), null, false, false);
        Preferences.set("ExportTradTranscript.FixedLabelWidth", this.labelWidthCB.isSelected(), null, false, false);
        Preferences.set("ExportTradTranscript.suppressRepeatedLabelsCB", this.suppressRepeatedLabelsCB.isSelected(), null, false, false);
        if (this.labelWidthTF.getText() != null) {
            Preferences.set("ExportTradTranscript.FixedLabelWidthValue", this.labelWidthTF.getText().trim(), null, false, false);
        }
        Preferences.set("ExportTradTranscript.numberAnnosCB", this.numberAnnotationsCB.isSelected(), null, false, false);
        Preferences.set("ExportTradTranscript.numberLinesCB", this.numberLinesCB.isSelected(), null, false, false);
        Preferences.set("ExportTradTranscript.IncludeEmptyLines", this.emptyLineCB.isSelected(), null, false, false);
        Preferences.set("ExportTradTranscript.silenceCB", this.silenceCB.isSelected(), null, false, false);
        if (this.minDurSilTF.getText() != null) {
            Preferences.set("ExportTradTranscript.minDurSilTF", this.minDurSilTF.getText().trim(), null, false, false);
        }
        Preferences.set("NumberOfDecimalDigits", this.silenceDecimalComboBox.getSelectedItem(), null, false, false);
        Preferences.set("ExportTradTranscript.selectionCB", this.selectionCB.isSelected(), null, false, false);
        Preferences.set("ExportTradTranscript.selectedTiers", this.getSelectedTiers(), this.transcription, false, false);
        Preferences.set("ExportTradTranscript.SelectTiersMode", this.getSelectionMode(), this.transcription, false, false);
        if (this.getSelectionMode() != "Tier") {
            Preferences.set("ExportTradTranscript.LastSelectedItems", this.getSelectedItems(), this.transcription, false, false);
        }
        Preferences.set("ExportTradTranscript.HiddenTiers", this.getHiddenTiers(), this.transcription, false, false);
        List<String> tierOrder = this.getTierOrder();
        Preferences.set("ExportTradTranscript.TierOrder", tierOrder, this.transcription, false, true);
        Preferences.set("ExportTradTranscript.useJeffersonCB", this.useJeffersonCB.isSelected(), null, false, false);
    }

    private class IndexedExportRecord
    extends AnnotationDataRecord
    implements Comparable<IndexedExportRecord> {
        private int index;
        private long silAfter;

        IndexedExportRecord(Annotation annotation, int index) {
            super(annotation);
            this.silAfter = -1L;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setSilenceAfter(long value) {
            this.silAfter = value;
        }

        public long getSilenceAfter() {
            return this.silAfter;
        }

        @Override
        public int compareTo(IndexedExportRecord other) {
            TierImpl otherTier;
            TierImpl thisTier;
            if (this.getBeginTime() < other.getBeginTime()) {
                return -1;
            }
            if (this.getBeginTime() > other.getBeginTime()) {
                return 1;
            }
            if (this.getEndTime() == other.getEndTime()) {
                if (this.index < other.getIndex()) {
                    return -1;
                }
                if (this.index > other.getIndex()) {
                    return 1;
                }
            }
            if (this.areParentAndChild(thisTier = ExportTradTranscript.this.transcription.getTierWithId(this.getTierName()), otherTier = ExportTradTranscript.this.transcription.getTierWithId(other.getTierName()))) {
                return -1;
            }
            if (this.areParentAndChild(otherTier, thisTier)) {
                return 1;
            }
            if (this.getEndTime() < other.getEndTime()) {
                return -1;
            }
            if (this.getEndTime() > other.getEndTime()) {
                return 1;
            }
            return 0;
        }

        private boolean areParentAndChild(Tier parent, Tier child) {
            while (child != null) {
                Tier childsParent = child.getParentTier();
                if (childsParent == parent) {
                    return true;
                }
                child = childsParent;
            }
            return false;
        }
    }
}

