/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.AbstractTierSortAndSelectPanel;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.FilesTierSortAndSelectPanel;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.gui.TranscriptionTierSortAndSelectPanel;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import nl.mpi.util.FileExtension;

public abstract class AbstractFilesAndTierSelectionStepPane
extends StepPane
implements TableModelListener {
    protected TranscriptionImpl transcription;
    protected JRadioButton currentlyOpenedFileRB;
    protected JRadioButton selectedFilesFromDiskRB;
    protected JRadioButton filesFromDomainRB;
    protected JPanel fileSelectionPanel;
    protected JPanel tierSelectionPanel;
    protected ButtonGroup buttonGroup;
    protected JButton selectFilesBtn;
    protected JButton selectDomainBtn;
    protected AbstractTierSortAndSelectPanel tierSelectPanel;
    protected JTextArea textArea;
    private List<String> openedFileList;
    protected Insets globalInset = new Insets(2, 4, 2, 4);

    public AbstractFilesAndTierSelectionStepPane(MultiStepPane mp, TranscriptionImpl transcription) {
        super(mp);
        this.transcription = transcription;
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        this.initFileSelectionPanel();
        this.initTierSelectionPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = this.globalInset;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        this.add((Component)this.fileSelectionPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        this.add((Component)this.tierSelectionPanel, gbc);
    }

    @Override
    public abstract String getStepTitle();

    @Override
    public void enterStepForward() {
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        this.multiPane.putStepProperty("SelectedTiers", this.tierSelectPanel.getSelectedTiers());
        this.multiPane.putStepProperty("OpenedFiles", this.openedFileList);
        return true;
    }

    protected void initFileSelectionPanel() {
        this.fileSelectionPanel = new JPanel(new GridBagLayout());
        this.fileSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("MultiFileExport.Panel.Title.FileSelection")));
        RadioButtonHandler radioButtonListener = new RadioButtonHandler();
        this.currentlyOpenedFileRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.CurrentlyOpenedFile"));
        this.currentlyOpenedFileRB.addActionListener(radioButtonListener);
        this.selectedFilesFromDiskRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.FilesFromFileBrowser"));
        this.selectedFilesFromDiskRB.addActionListener(radioButtonListener);
        this.filesFromDomainRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.FilesFromDomain"));
        this.filesFromDomainRB.addActionListener(radioButtonListener);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.currentlyOpenedFileRB);
        this.buttonGroup.add(this.selectedFilesFromDiskRB);
        this.buttonGroup.add(this.filesFromDomainRB);
        ButtonHandler buttonHandler = new ButtonHandler();
        this.selectFilesBtn = new JButton(ElanLocale.getString("Button.Browse"));
        this.selectFilesBtn.addActionListener(buttonHandler);
        this.selectDomainBtn = new JButton(ElanLocale.getString("FileAndTierSelectionStepPane.Button.Domain"));
        this.selectDomainBtn.addActionListener(buttonHandler);
        this.selectDomainBtn.setEnabled(false);
        if (this.transcription == null) {
            this.currentlyOpenedFileRB.setEnabled(false);
            this.selectedFilesFromDiskRB.setEnabled(true);
            this.selectedFilesFromDiskRB.setSelected(true);
            this.selectFilesBtn.setEnabled(true);
        } else {
            this.selectedFilesFromDiskRB.setEnabled(false);
            this.filesFromDomainRB.setEnabled(false);
            this.selectFilesBtn.setEnabled(false);
            this.selectDomainBtn.setEnabled(false);
            this.currentlyOpenedFileRB.setSelected(true);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = this.globalInset;
        this.fileSelectionPanel.add((Component)this.currentlyOpenedFileRB, gbc);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.fileSelectionPanel.add((Component)this.selectedFilesFromDiskRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.fileSelectionPanel.add((Component)this.selectFilesBtn, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        this.fileSelectionPanel.add((Component)this.filesFromDomainRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.fileSelectionPanel.add((Component)this.selectDomainBtn, gbc);
    }

    protected void initTierSelectionPanel() {
        this.tierSelectionPanel = new JPanel(new GridBagLayout());
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("MultiFileExport.Panel.Title.TierSelection")));
        if (this.transcription != null) {
            this.tierSelectPanel = new TranscriptionTierSortAndSelectPanel(this.transcription, this.getTierMode());
        } else {
            this.textArea = new JTextArea(ElanLocale.getString("FileAndTierSelectionStepPane.Message1"));
            this.textArea.setEditable(false);
            this.textArea.setBorder(new LineBorder(Color.LIGHT_GRAY));
            this.selectFilesBtn.setEnabled(true);
            this.selectDomainBtn.setEnabled(false);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.globalInset;
        this.tierSelectionPanel.add((Component)this.textArea, gbc);
    }

    protected AbstractTierSortAndSelectPanel.Modes getTierMode() {
        return AbstractTierSortAndSelectPanel.Modes.ALL_TIERS;
    }

    protected List<String> showMultiFileChooser() {
        ArrayList<CallSite> fileNames = null;
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowMultiFileDialog(ElanLocale.getString("ExportDialog.Multi"), 0, FileExtension.EAF_EXT, "LastUsedEAFDir");
        Object[] objects = chooser.getSelectedFiles();
        if (objects != null && objects.length > 0) {
            fileNames = new ArrayList<CallSite>();
            for (Object object : objects) {
                if (fileNames.contains(object)) continue;
                fileNames.add((CallSite)((Object)("" + object)));
            }
        }
        return fileNames;
    }

    public void updateButtonStates() {
        if (this.tierSelectPanel != null && this.tierSelectPanel.getSelectedTiers().size() > 0) {
            this.multiPane.setButtonEnabled(1, true);
        } else {
            this.multiPane.setButtonEnabled(1, false);
        }
        this.multiPane.setButtonEnabled(2, false);
    }

    protected void initializeTierSelectPanel(ArrayList<File> files) {
        if (this.tierSelectPanel != null) {
            this.tierSelectionPanel.remove(this.tierSelectPanel);
        } else {
            this.tierSelectionPanel.remove(this.textArea);
        }
        this.tierSelectPanel = new FilesTierSortAndSelectPanel(files, this.getTierMode()){

            @Override
            protected void initTables() {
                super.initTables();
                this.model.addTableModelListener(this);
                this.typeModel.addTableModelListener(this);
                this.partModel.addTableModelListener(this);
                this.annotModel.addTableModelListener(this);
                this.langModel.addTableModelListener(this);
            }
        };
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.globalInset;
        this.tierSelectionPanel.add((Component)this.tierSelectPanel, gbc);
        this.updateButtonStates();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            this.updateButtonStates();
        }
    }

    protected ArrayList<File> getMultipleFiles(List<String> fileNames) {
        if (fileNames == null) {
            return null;
        }
        if (fileNames.size() > 0) {
            ArrayList<File> files = new ArrayList<File>();
            for (int i = 0; i < fileNames.size(); ++i) {
                File f = new File(fileNames.get(i));
                if (f.isFile() && f.canRead()) {
                    files.add(f);
                    continue;
                }
                if (!f.isDirectory() || !f.canRead()) continue;
                this.addFiles(f, files);
            }
            if (files.size() > 0) {
                return files;
            }
        }
        return null;
    }

    protected void addFiles(File dir, ArrayList<File> files) {
        if (dir == null && files == null) {
            return;
        }
        File[] allSubs = dir.listFiles();
        for (int i = 0; i < allSubs.length; ++i) {
            if (allSubs[i].isDirectory() && allSubs[i].canRead()) {
                this.addFiles(allSubs[i], files);
                continue;
            }
            if (!allSubs[i].canRead() || !allSubs[i].getName().toLowerCase().endsWith(FileExtension.EAF_EXT[0]) || files.contains(allSubs[i])) continue;
            files.add(allSubs[i]);
        }
    }

    protected void addFileNames(File dir, List<String> files) {
        if (dir == null && files == null) {
            return;
        }
        File[] allSubs = dir.listFiles();
        for (int i = 0; i < allSubs.length; ++i) {
            if (allSubs[i].isDirectory() && allSubs[i].canRead()) {
                this.addFileNames(allSubs[i], files);
                continue;
            }
            if (!allSubs[i].canRead() || !allSubs[i].getName().toLowerCase().endsWith(FileExtension.EAF_EXT[0]) || files.contains(allSubs[i].getAbsolutePath())) continue;
            files.add(allSubs[i].getAbsolutePath());
        }
    }

    protected void checkForOpenedFiles(List<String> fileNames) {
        FrameManager manager = FrameManager.getInstance();
        ArrayList<String> openedFileNames = new ArrayList<String>();
        for (String fileName : fileNames) {
            ElanFrame2 frame = manager.getFrameFor(fileName, false);
            if (frame == null) continue;
            openedFileNames.add(fileName);
        }
        if (openedFileNames.size() > 0) {
            String message = null;
            String lineSep = System.getProperty("line.separator");
            for (int i = 0; i < openedFileNames.size(); ++i) {
                message = i == 0 ? (String)openedFileNames.get(i) + lineSep : message + (String)openedFileNames.get(i) + lineSep;
            }
            message = message + lineSep + ElanLocale.getString("MultiFileExport.FilesAndTierSelectionPane.Message.Part1") + lineSep + lineSep + ElanLocale.getString("MultiFileExport.FilesAndTierSelectionPane.Message.Part2") + lineSep + lineSep + ElanLocale.getString("FileAndTierSelectionStepPane.Message3.Part3");
            JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2, null);
        }
    }

    private class RadioButtonHandler
    implements ActionListener {
        private JRadioButton previouslySelectedRadioButton;

        private RadioButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton rb = (JRadioButton)e.getSource();
            if (rb == AbstractFilesAndTierSelectionStepPane.this.currentlyOpenedFileRB) {
                if (this.previouslySelectedRadioButton != rb) {
                    AbstractFilesAndTierSelectionStepPane.this.openedFileList = null;
                    this.previouslySelectedRadioButton = rb;
                }
                AbstractFilesAndTierSelectionStepPane.this.selectFilesBtn.setEnabled(false);
                AbstractFilesAndTierSelectionStepPane.this.selectDomainBtn.setEnabled(false);
            } else if (rb == AbstractFilesAndTierSelectionStepPane.this.selectedFilesFromDiskRB) {
                if (this.previouslySelectedRadioButton != rb) {
                    AbstractFilesAndTierSelectionStepPane.this.openedFileList = null;
                    this.previouslySelectedRadioButton = rb;
                }
                AbstractFilesAndTierSelectionStepPane.this.selectFilesBtn.setEnabled(true);
                AbstractFilesAndTierSelectionStepPane.this.selectDomainBtn.setEnabled(false);
            } else if (rb == AbstractFilesAndTierSelectionStepPane.this.filesFromDomainRB) {
                if (this.previouslySelectedRadioButton != rb) {
                    AbstractFilesAndTierSelectionStepPane.this.openedFileList = null;
                    this.previouslySelectedRadioButton = rb;
                }
                AbstractFilesAndTierSelectionStepPane.this.selectFilesBtn.setEnabled(false);
                AbstractFilesAndTierSelectionStepPane.this.selectDomainBtn.setEnabled(true);
            }
            AbstractFilesAndTierSelectionStepPane.this.updateButtonStates();
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractFilesAndTierSelectionStepPane.this.updateButtonStates();
            if (e != null) {
                JButton button = (JButton)e.getSource();
                if (button == AbstractFilesAndTierSelectionStepPane.this.selectFilesBtn) {
                    List<String> filenames = AbstractFilesAndTierSelectionStepPane.this.showMultiFileChooser();
                    if (filenames != null && !filenames.isEmpty()) {
                        AbstractFilesAndTierSelectionStepPane.this.initializeTierSelectPanel(AbstractFilesAndTierSelectionStepPane.this.getMultipleFiles(filenames));
                        AbstractFilesAndTierSelectionStepPane.this.openedFileList = filenames;
                        if (filenames.size() > 0) {
                            AbstractFilesAndTierSelectionStepPane.this.checkForOpenedFiles(filenames);
                        }
                    }
                } else if (button == AbstractFilesAndTierSelectionStepPane.this.selectDomainBtn) {
                    MFDomainDialog domainDialog = new MFDomainDialog(ELANCommandFactory.getRootFrame(null), ElanLocale.getString("ExportDialog.Multi"), true);
                    domainDialog.setVisible(true);
                    List<String> searchPaths = domainDialog.getSearchPaths();
                    List<String> searchDirs = domainDialog.getSearchDirs();
                    ArrayList<String> filenames = new ArrayList<String>();
                    ArrayList<File> files = null;
                    if (!searchPaths.isEmpty()) {
                        if (files == null) {
                            files = AbstractFilesAndTierSelectionStepPane.this.getMultipleFiles(searchPaths);
                        } else {
                            files.addAll(AbstractFilesAndTierSelectionStepPane.this.getMultipleFiles(searchPaths));
                        }
                        filenames.addAll(searchPaths);
                    }
                    if (!searchDirs.isEmpty()) {
                        if (files == null) {
                            files = AbstractFilesAndTierSelectionStepPane.this.getMultipleFiles(searchDirs);
                        } else {
                            files.addAll(AbstractFilesAndTierSelectionStepPane.this.getMultipleFiles(searchDirs));
                        }
                        for (int i = 0; i < searchDirs.size(); ++i) {
                            File f = new File(searchDirs.get(i));
                            if (f.isFile() && f.canRead()) {
                                if (filenames.contains(searchDirs.get(i))) continue;
                                filenames.add(searchDirs.get(i));
                                continue;
                            }
                            if (!f.isDirectory() || !f.canRead()) continue;
                            AbstractFilesAndTierSelectionStepPane.this.addFileNames(f, filenames);
                        }
                    }
                    if (files != null) {
                        AbstractFilesAndTierSelectionStepPane.this.initializeTierSelectPanel(files);
                    }
                    if (filenames.size() > 0) {
                        AbstractFilesAndTierSelectionStepPane.this.checkForOpenedFiles(filenames);
                        AbstractFilesAndTierSelectionStepPane.this.openedFileList = filenames;
                    }
                }
            }
        }
    }
}

