/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.export.multiplefiles.AbstractMultiFileExportSaveSettingsStepPane;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import nl.mpi.util.FileExtension;

public class MultipleFileThemeExportStep2
extends AbstractMultiFileExportSaveSettingsStepPane {
    private JCheckBox useCVForVvtCB;
    private JCheckBox useTierNameAsActorCB;
    private String useCVForVVT;
    private String useTierNameAsActor;

    public MultipleFileThemeExportStep2(MultiStepPane multiStepPane) {
        super(multiStepPane);
    }

    @Override
    protected void setPreferenceStrings() {
        this.saveWithOriginalNames = "MultiFileExportThemeDialog.saveWithOriginalNames";
        this.saveInOriginalFolder = "MultiFileExportThemeDialog.saveInOriginalFolder";
        this.saveInRelativeFolder = "MultiFileExportThemeDialog.saveInRelativeFolder";
        this.saveInRelativeFolderName = "MultiFileExportThemeDialog.saveInRelativeFolderName";
        this.saveInSameFolderName = "MultiFileExportThemeDialog.saveInSameFolderName";
        this.dontCreateEmptyFiles = null;
        this.useCVForVVT = "MultiFileExportThemeDialog.useCVForVVT";
        this.useTierNameAsActor = "MultiFileExportThemeDialog.tierNameAsActor";
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MultiFileExportPraat.Title.Step2Title");
    }

    @Override
    protected String[] getExportExtensions() {
        return FileExtension.TEXT_EXT;
    }

    @Override
    public boolean leaveStepForward() {
        this.multiPane.putStepProperty("UseCVForVVT", this.useCVForVvtCB.isSelected());
        this.multiPane.putStepProperty("TierNameAsActor", this.useTierNameAsActorCB.isSelected());
        return super.leaveStepForward();
    }

    @Override
    protected void initFileNameOptionsPanel() {
        super.initFileNameOptionsPanel();
        this.fileExtComboBox.setEnabled(false);
    }

    @Override
    protected void initOtherOptionsPanel() {
        this.otherOptionsPanel = new JPanel(new GridBagLayout());
        this.otherOptionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportTiersDialog.Label.OtherOptions")));
        this.useCVForVvtCB = new JCheckBox(ElanLocale.getString("MultiFileExportTheme.Label.UseCV"), false);
        this.useTierNameAsActorCB = new JCheckBox(ElanLocale.getString("MultiFileExportTheme.Label.TierAsActor"), true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = this.insets;
        gbc.weightx = 1.0;
        this.otherOptionsPanel.add((Component)this.useCVForVvtCB, gbc);
        gbc.gridy = 1;
        this.otherOptionsPanel.add((Component)this.useTierNameAsActorCB, gbc);
    }

    @Override
    protected void savePreferences() {
        super.savePreferences();
        if (this.useCVForVVT != null) {
            Preferences.set(this.useCVForVVT, this.useCVForVvtCB.isSelected(), null);
        }
        if (this.useTierNameAsActor != null) {
            Preferences.set(this.useTierNameAsActor, this.useTierNameAsActorCB.isSelected(), null);
        }
    }

    @Override
    protected void loadPreferences() {
        Boolean prefValue;
        super.loadPreferences();
        if (this.useCVForVVT != null && (prefValue = Preferences.getBool(this.useCVForVVT, null)) != null) {
            this.useCVForVvtCB.setSelected(prefValue);
        }
        if (this.useTierNameAsActor != null && (prefValue = Preferences.getBool(this.useTierNameAsActor, null)) != null) {
            this.useTierNameAsActorCB.setSelected(prefValue);
        }
    }
}

