/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.tier.AbstractFileAndTierSelectionStepPane;
import mpi.eudico.client.annotator.tier.DisplayableContentTableModel;
import mpi.eudico.client.annotator.tier.SelectableContentTableModel;
import mpi.eudico.client.util.SelectableObject;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.util.MediaDescriptorUtility;

public class MultipleFileToolBoxExportStep1
extends AbstractFileAndTierSelectionStepPane
implements ItemListener {
    private JCheckBox blankLineCB;
    private List<String> recordMarkerList;
    Map<String, String> recordMarkerMap;
    Map<String, List<String>> tiersMap;
    private final String elanBeginLabel = "ELANBegin";
    private final String elanEndLabel = "ELANEnd";
    private final String elanParticipantLabel = "ELANParticipant";
    private boolean bothMediaDetected = false;
    private boolean mediaDetected = false;
    private ButtonHandler buttonHandler;

    public MultipleFileToolBoxExportStep1(MultiStepPane multiPane) {
        super(multiPane, null);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MultiFileExportToolbox.Title.Step1Title");
    }

    @Override
    public boolean leaveStepForward() {
        SelectableContentTableModel model = (SelectableContentTableModel)this.tierTable.getModel();
        List<Object> tiers = model.getSelectedValues();
        ArrayList<String> selectedTiers = new ArrayList<String>();
        for (Object t : tiers) {
            SelectableObject sob = (SelectableObject)t;
            selectedTiers.add((String)sob.getValue());
        }
        this.multiPane.putStepProperty("SelectedTiers", selectedTiers);
        this.multiPane.putStepProperty("OpenedFiles", this.openedFileList);
        this.multiPane.putStepProperty("TierListMap", this.tiersMap);
        this.multiPane.putStepProperty("RecordMarkersList", this.recordMarkerList);
        this.multiPane.putStepProperty("RecordMarkersMap", this.recordMarkerMap);
        this.multiPane.putStepProperty("MarkersWithBlankLinesList", this.getMarkersWithBlankLines());
        this.multiPane.putStepProperty("BothMediaDetected", this.bothMediaDetected);
        this.multiPane.putStepProperty("EnableMediaMarker", this.mediaDetected);
        return true;
    }

    private List<String> getMarkersWithBlankLines() {
        ArrayList<String> mbl = new ArrayList<String>();
        for (int i = 0; i < this.tierTable.getModel().getRowCount(); ++i) {
            SelectableObject sob = (SelectableObject)this.tierTable.getModel().getValueAt(i, 1);
            if (!sob.isSelected()) continue;
            mbl.add((String)sob.getValue());
        }
        return mbl;
    }

    @Override
    protected void initFileSelectionPanel() {
        super.initFileSelectionPanel();
        this.buttonHandler = new ButtonHandler();
        this.selectFilesBtn.removeActionListener(((AbstractFileAndTierSelectionStepPane)this).buttonHandler);
        this.selectDomainBtn.removeActionListener(((AbstractFileAndTierSelectionStepPane)this).buttonHandler);
        this.selectFilesBtn.addActionListener(this.buttonHandler);
        this.selectDomainBtn.addActionListener(this.buttonHandler);
    }

    @Override
    protected void initTierSelectionPanel() {
        Insets insets;
        super.initTierSelectionPanel();
        this.tierSelectionPanel.removeAll();
        this.blankLineCB = new JCheckBox(ElanLocale.getString("ExportShoebox.Button.BlankLineAfter"));
        this.blankLineCB.addItemListener(this);
        this.blankLineCB.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.globalInset;
        this.tierSelectionPanel.add((Component)this.tierTableScrollPane, gbc);
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.insets = insets = new Insets(0, this.globalInset.left, 0, this.globalInset.right);
        this.tierSelectionPanel.add((Component)this.buttonPanel, gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.insets = insets;
        this.tierSelectionPanel.add((Component)this.blankLineCB, gbc);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object val;
        int row;
        if (ie.getSource() == this.blankLineCB && (row = this.tierTable.getSelectedRow()) > -1 && (val = this.tierTable.getValueAt(row, 1)) instanceof SelectableObject) {
            ((SelectableObject)val).setSelected(this.blankLineCB.isSelected());
            this.tierTable.repaint();
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultipleFileToolBoxExportStep1.this.updateButtonStates();
            if (e != null) {
                JButton button = (JButton)e.getSource();
                if (button == MultipleFileToolBoxExportStep1.this.selectFilesBtn) {
                    List filenames = MultipleFileToolBoxExportStep1.this.showMultiFileChooser();
                    if (filenames != null && !filenames.isEmpty()) {
                        OpenFiles t = new OpenFiles((List<String>)filenames, MultipleFileToolBoxExportStep1.this.tierTable, (TableModelListener)new AbstractFileAndTierSelectionStepPane.ModelChangedHandler());
                        t.start();
                    }
                } else if (button == MultipleFileToolBoxExportStep1.this.selectDomainBtn) {
                    MFDomainDialog domainDialog = new MFDomainDialog((Frame)ELANCommandFactory.getRootFrame(MultipleFileToolBoxExportStep1.this.transcription), true);
                    domainDialog.setVisible(true);
                    List<String> searchPaths = domainDialog.getSearchPaths();
                    List<String> searchDirs = domainDialog.getSearchDirs();
                    for (int i = 0; i < searchDirs.size(); ++i) {
                        String fileName = searchDirs.get(i);
                        File f = new File(fileName);
                        if (f.isFile() && f.canRead() && !searchPaths.contains(fileName)) {
                            searchPaths.add(fileName);
                            continue;
                        }
                        if (!f.isDirectory() || !f.canRead()) continue;
                        MultipleFileToolBoxExportStep1.this.addFileNames(f, searchPaths);
                    }
                    if (!searchPaths.isEmpty()) {
                        OpenFiles t = new OpenFiles(searchPaths, MultipleFileToolBoxExportStep1.this.tierTable, (TableModelListener)new AbstractFileAndTierSelectionStepPane.ModelChangedHandler());
                        t.start();
                    }
                }
            }
        }
    }

    class MarkerCellRenderer
    extends DefaultTableCellRenderer {
        MarkerCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof SelectableObject) {
                if (((SelectableObject)value).isSelected()) {
                    c.setForeground(Constants.ACTIVEANNOTATIONCOLOR);
                } else if (!isSelected) {
                    c.setForeground(table.getForeground());
                }
            }
            return c;
        }
    }

    class SelectableObjectComparator
    implements Comparator<SelectableObject<String>> {
        SelectableObjectComparator() {
        }

        @Override
        public int compare(SelectableObject<String> o1, SelectableObject<String> o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    }

    protected class OpenFiles
    extends AbstractFileAndTierSelectionStepPane.OpenFilesThread
    implements ListSelectionListener {
        public OpenFiles(List<String> filenames, JTable tierTable, TableModelListener listener) {
            super(filenames, tierTable, listener);
        }

        @Override
        public void run() {
            MultipleFileToolBoxExportStep1.this.tierSet = new TreeSet();
            TreeSet<SelectableObject<String>> selectableObjectSet = new TreeSet<SelectableObject<String>>(new SelectableObjectComparator());
            MultipleFileToolBoxExportStep1.this.openedFileList = new ArrayList();
            MultipleFileToolBoxExportStep1.this.recordMarkerList = new ArrayList();
            MultipleFileToolBoxExportStep1.this.recordMarkerMap = new HashMap<String, String>();
            MultipleFileToolBoxExportStep1.this.tiersMap = new HashMap<String, List<String>>();
            FrameManager manager = FrameManager.getInstance();
            for (int i = 0; i < this.filenames.size(); ++i) {
                TranscriptionImpl transImpl = null;
                ElanFrame2 frame = manager.getFrameFor((String)this.filenames.get(i), false);
                String message = null;
                if (frame != null) {
                    message = "' " + (String)this.filenames.get(i) + ElanLocale.getString("FileAndTierSelectionStepPane.Message3.Part1");
                    if (frame.getViewerManager().getTranscription().isChanged()) {
                        message = message + "\n" + ElanLocale.getString("FileAndTierSelectionStepPane.Message3.Part2");
                    }
                    message = message + "\n" + ElanLocale.getString("FileAndTierSelectionStepPane.Message3.Part3");
                    JOptionPane.showMessageDialog(MultipleFileToolBoxExportStep1.this, message, ElanLocale.getString("Message.Warning"), 2, null);
                }
                if (transImpl == null) {
                    transImpl = new TranscriptionImpl((String)this.filenames.get(i));
                }
                MultipleFileToolBoxExportStep1.this.openedFileList.add((String)this.filenames.get(i));
                this.checkForMediaFiles(transImpl);
                List<TierImpl> tiersInFile = transImpl.getTiers();
                ArrayList<String> markersInthisFile = new ArrayList<String>();
                ArrayList<String> rootTiers = new ArrayList<String>(5);
                for (TierImpl t : tiersInFile) {
                    String tName = t.getName();
                    int atIndex = tName.indexOf(64);
                    if (atIndex > -1) {
                        String markName = tName.substring(0, atIndex);
                        if (!MultipleFileToolBoxExportStep1.this.tierSet.contains(markName)) {
                            if (MultipleFileToolBoxExportStep1.this.tierSet.size() == 1) {
                                MultipleFileToolBoxExportStep1.this.tierSet.add("ELANBegin");
                                selectableObjectSet.add(new SelectableObject<String>("ELANBegin", false));
                                MultipleFileToolBoxExportStep1.this.tierSet.add("ELANEnd");
                                selectableObjectSet.add(new SelectableObject<String>("ELANEnd", false));
                                MultipleFileToolBoxExportStep1.this.tierSet.add("ELANParticipant");
                                selectableObjectSet.add(new SelectableObject<String>("ELANParticipant", false));
                            }
                            MultipleFileToolBoxExportStep1.this.tierSet.add(markName);
                            selectableObjectSet.add(new SelectableObject<String>(markName, false));
                        }
                        if (!markersInthisFile.contains(markName)) {
                            markersInthisFile.add(markName);
                        }
                        if (t.hasParentTier() || rootTiers.contains(markName)) continue;
                        rootTiers.add(markName);
                        continue;
                    }
                    if (MultipleFileToolBoxExportStep1.this.tierSet.size() == 1) {
                        MultipleFileToolBoxExportStep1.this.tierSet.add("ELANBegin");
                        selectableObjectSet.add(new SelectableObject<String>("ELANBegin", false));
                        MultipleFileToolBoxExportStep1.this.tierSet.add("ELANEnd");
                        selectableObjectSet.add(new SelectableObject<String>("ELANEnd", false));
                        MultipleFileToolBoxExportStep1.this.tierSet.add("ELANParticipant");
                        selectableObjectSet.add(new SelectableObject<String>("ELANParticipant", false));
                    }
                    selectableObjectSet.add(new SelectableObject<String>(tName, false));
                    MultipleFileToolBoxExportStep1.this.tierSet.add(tName);
                    markersInthisFile.add(tName);
                    if (t.hasParentTier()) continue;
                    rootTiers.add(tName);
                }
                MultipleFileToolBoxExportStep1.this.tiersMap.put((String)this.filenames.get(i), markersInthisFile);
                if (rootTiers.size() == 1) {
                    String recordMarker = (String)rootTiers.get(0);
                    MultipleFileToolBoxExportStep1.this.recordMarkerMap.put((String)this.filenames.get(i), recordMarker);
                    if (!MultipleFileToolBoxExportStep1.this.recordMarkerList.contains(recordMarker)) {
                        MultipleFileToolBoxExportStep1.this.recordMarkerList.add(recordMarker);
                    }
                }
                this.model.updateMessage(1, i + 1 + " " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part2") + " " + this.filenames.size() + " " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part3") + " (" + Math.round((float)(i + 1) / (float)this.filenames.size() * 100.0f) + "%)");
            }
            if (MultipleFileToolBoxExportStep1.this.tierSet.isEmpty()) {
                MultipleFileToolBoxExportStep1.this.openedFileList.clear();
                DisplayableContentTableModel model = (DisplayableContentTableModel)this.tierTable.getModel();
                model.setValueAt(ElanLocale.getString("FileAndTierSelectionStepPane.Message3"), 0, 0);
            } else {
                if (MultipleFileToolBoxExportStep1.this.tierSet.size() == 1) {
                    MultipleFileToolBoxExportStep1.this.tierSet.add("ELANBegin");
                    selectableObjectSet.add(new SelectableObject<String>("ELANBegin", true));
                    MultipleFileToolBoxExportStep1.this.tierSet.add("ELANEnd");
                    selectableObjectSet.add(new SelectableObject<String>("ELANEnd", true));
                    MultipleFileToolBoxExportStep1.this.tierSet.add("ELANParticipant");
                    selectableObjectSet.add(new SelectableObject<String>("ELANParticipant", true));
                }
                SelectableContentTableModel model = new SelectableContentTableModel(selectableObjectSet);
                model.addTableModelListener(this.listener);
                model.selectAll();
                this.tierTable.setModel(model);
                this.tierTable.getSelectionModel().setSelectionMode(0);
                this.tierTable.getSelectionModel().addListSelectionListener(this);
                this.tierTable.getColumnModel().getColumn(0).setHeaderValue(null);
                this.tierTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.TierName"));
                this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
                this.tierTable.getColumnModel().getColumn(1).setCellRenderer(new MarkerCellRenderer());
                this.tierTable.repaint();
                MultipleFileToolBoxExportStep1.this.blankLineCB.setEnabled(true);
                MultipleFileToolBoxExportStep1.this.updateButtonStates();
            }
        }

        private void checkForMediaFiles(TranscriptionImpl transcription) {
            if (MultipleFileToolBoxExportStep1.this.bothMediaDetected) {
                return;
            }
            List<MediaDescriptor> mds = transcription.getMediaDescriptors();
            boolean video = false;
            boolean audio = false;
            if (mds != null && mds.size() > 0) {
                MediaDescriptor md = null;
                for (int i = 0; i < mds.size(); ++i) {
                    if (video && audio) {
                        MultipleFileToolBoxExportStep1.this.mediaDetected = true;
                        MultipleFileToolBoxExportStep1.this.bothMediaDetected = true;
                        break;
                    }
                    md = mds.get(i);
                    if (MediaDescriptorUtility.isVideoType(md)) {
                        video = true;
                        MultipleFileToolBoxExportStep1.this.mediaDetected = true;
                        continue;
                    }
                    if (md.mimeType == null || !md.mimeType.equals("audio/*") && !md.mimeType.equals("audio/x-wav")) continue;
                    audio = true;
                    MultipleFileToolBoxExportStep1.this.mediaDetected = true;
                }
            }
            if (video && audio) {
                MultipleFileToolBoxExportStep1.this.mediaDetected = true;
                MultipleFileToolBoxExportStep1.this.bothMediaDetected = true;
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            if (this.model != null && lse.getValueIsAdjusting()) {
                int col = 0;
                int row = this.tierTable.getSelectedRow();
                if (row > -1) {
                    Object val;
                    if (this.tierTable.isRowSelected(row)) {
                        this.tierTable.setValueAt(Boolean.TRUE, row, col);
                    }
                    if ((val = this.tierTable.getValueAt(row, 1)) instanceof SelectableObject) {
                        MultipleFileToolBoxExportStep1.this.blankLineCB.setSelected(((SelectableObject)val).isSelected());
                    }
                }
            }
        }
    }
}

