/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.grid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.grid.GridEditor;
import mpi.eudico.client.annotator.grid.GridViewerTableModel;
import mpi.eudico.server.corpora.clom.Annotation;

public class AnnotationTable
extends JTable {
    private static int MIN_COLUMN_WIDTH = 15;
    private int width = -1;
    private Map<Object, Font> prefTierFonts = new HashMap<Object, Font>();
    private static Map<String, Integer> preferredWidths = new HashMap<String, Integer>();
    private static Map<String, Integer> maxWidths = new HashMap<String, Integer>();
    private boolean deselectCommits = false;
    private Map<String, Map<String, Color>> annColorsMap;

    public AnnotationTable(GridViewerTableModel dataModel) {
        super(dataModel);
        this.setFont(Constants.DEFAULTFONT);
        this.setSelectionMode(1);
        this.setAutoResizeMode(2);
        for (int i = 0; i < dataModel.getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            String columnName = dataModel.getColumnName(i);
            column.setIdentifier(columnName);
            this.setColumnVisible(columnName, true);
        }
        this.getColumn("ColumnTriangle").setResizable(false);
        this.getColumn("ColumnCount").setResizable(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (AnnotationTable.this.getWidth() > 0) {
                    AnnotationTable.this.getParent().addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentResized(ComponentEvent e) {
                            if (AnnotationTable.this.getParent().getWidth() != AnnotationTable.this.width) {
                                AnnotationTable.this.width = AnnotationTable.this.getParent().getWidth();
                                AnnotationTable.this.adjustAnnotationColumns();
                            }
                        }
                    });
                    AnnotationTable.this.removeComponentListener(this);
                    AnnotationTable.this.adjustAnnotationColumns();
                }
            }
        });
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(640, 200);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        if (this.deselectCommits && e.getSource() instanceof GridEditor) {
            ((GridEditor)e.getSource()).commitEdit();
        }
        super.editingStopped(e);
        this.setRowHeight(this.getRowHeight());
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        super.editingCanceled(e);
        this.setRowHeight(this.getRowHeight());
    }

    public void setColumnVisible(String columnName, boolean visible) {
        TableColumn column = null;
        try {
            column = this.getColumn(columnName);
            if (visible) {
                column.setResizable(true);
                column.setMaxWidth(this.getDefaultMaxWidth(columnName));
                column.setMinWidth(MIN_COLUMN_WIDTH);
                column.setPreferredWidth(this.getDefaultPreferredWidth(columnName));
            } else {
                column.setMinWidth(0);
                column.setMaxWidth(0);
                column.setResizable(false);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println("Warning : no column with name " + columnName);
        }
    }

    protected void adjustAnnotationColumns() {
        if (this.getParent() != null) {
            HashSet<TableColumn> visibleAnnotationColumns = new HashSet<TableColumn>();
            int sumOfOtherWidths = 0;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                if (!preferredWidths.containsKey(column.getIdentifier()) && column.getMaxWidth() > 0) {
                    visibleAnnotationColumns.add(column);
                    continue;
                }
                sumOfOtherWidths += column.getPreferredWidth();
            }
            int remainingSpace = this.getParent().getWidth() - sumOfOtherWidths;
            if (remainingSpace > 0) {
                Iterator iter = visibleAnnotationColumns.iterator();
                while (iter.hasNext()) {
                    ((TableColumn)iter.next()).setPreferredWidth(remainingSpace / visibleAnnotationColumns.size());
                }
            }
        }
    }

    public boolean isColumnVisible(String columnName) {
        TableColumn column = null;
        try {
            column = this.getColumn(columnName);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Warning : no column with name " + columnName);
        }
        return column != null ? column.getWidth() > 0 : false;
    }

    private int getDefaultPreferredWidth(String columnName) {
        return preferredWidths.containsKey(columnName) ? preferredWidths.get(columnName) : MIN_COLUMN_WIDTH;
    }

    private int getDefaultMaxWidth(String columnName) {
        return maxWidths.containsKey(columnName) ? maxWidths.get(columnName) : Integer.MAX_VALUE;
    }

    public void updateLocale() {
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            int index = this.getColumnModel().getColumnIndex(this.dataModel.getColumnName(i));
            this.getColumnModel().getColumn(index).setHeaderValue(ElanLocale.getString("Frame.GridFrame." + this.dataModel.getColumnName(i)));
        }
    }

    public void setFontSize(int fontSize) {
        this.setFont(Constants.DEFAULTFONT.deriveFont((float)fontSize));
        int maxFontExtent = fontSize + 2 < 16 ? 16 : fontSize + 3;
        FontMetrics fm = this.getGraphics().getFontMetrics(this.getFont());
        if (fm != null) {
            maxFontExtent = fm.getMaxAscent() + fm.getMaxDescent() + 2;
        }
        if (this.prefTierFonts.size() > 0) {
            for (Object key : this.prefTierFonts.keySet()) {
                int mfe;
                Font f = this.prefTierFonts.get(key);
                if (f == null) continue;
                this.prefTierFonts.put(key, f.deriveFont((float)fontSize));
                fm = this.getGraphics().getFontMetrics(this.prefTierFonts.get(key));
                if (fm == null || (mfe = fm.getMaxAscent() + fm.getMaxDescent() + 2) <= maxFontExtent) continue;
                maxFontExtent = mfe;
            }
        }
        this.setRowHeight(maxFontExtent);
    }

    public int getFontSize() {
        return this.getFont().getSize();
    }

    public void setFontsForTiers(Map<String, String> fontNames) {
        this.prefTierFonts.clear();
        if (fontNames != null) {
            for (Map.Entry<String, String> e : fontNames.entrySet()) {
                String key = e.getKey();
                String fn = e.getValue();
                if (fn == null) continue;
                this.prefTierFonts.put(key, new Font(fn, 0, this.getFontSize()));
            }
        }
    }

    public Font getFontForColumn(int column) {
        if (this.dataModel instanceof GridViewerTableModel && this.prefTierFonts.size() > 0) {
            String name = ((GridViewerTableModel)this.dataModel).getColumnName(column);
            Font f = this.prefTierFonts.get(name);
            if (f == null) {
                return this.getFont();
            }
            return f;
        }
        return this.getFont();
    }

    public void setColorsForAnnotations(Map<String, Map<String, Color>> cMap) {
        this.annColorsMap = cMap;
    }

    public Color getColorForAnnotation(Annotation a) {
        String tierName;
        Map<String, Color> colors;
        String cveId = a.getCVEntryId();
        if (cveId == null || cveId.isEmpty()) {
            return null;
        }
        if (this.annColorsMap != null && this.annColorsMap.size() > 0 && (colors = this.annColorsMap.get(tierName = a.getTier().getName())) != null) {
            return colors.get(cveId);
        }
        return null;
    }

    public void toggleTimeFormat() {
        if (this.dataModel instanceof GridViewerTableModel) {
            String timeFormat = "TIMECODE".equals(((GridViewerTableModel)this.dataModel).getTimeFormat()) ? "MILLISECONDS" : "TIMECODE";
            ((GridViewerTableModel)this.dataModel).setTimeFormat(timeFormat);
            this.repaint();
        }
    }

    public void setTimeFormat(String format) {
        if (format != null) {
            ((GridViewerTableModel)this.dataModel).setTimeFormat(format);
            this.repaint();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        this.adjustAnnotationColumns();
    }

    public void setDeselectCommits(boolean deselectCommits) {
        this.deselectCommits = deselectCommits;
    }

    @Override
    public GridViewerTableModel getModel() {
        return (GridViewerTableModel)super.getModel();
    }

    static {
        preferredWidths.put("ColumnTriangle", 15);
        preferredWidths.put("ColumnCount", 40);
        preferredWidths.put("ColumnFileName", 100);
        preferredWidths.put("ColumnTierName", 80);
        preferredWidths.put("ColumnLeftContext", 100);
        preferredWidths.put("ColumnRightContext", 100);
        preferredWidths.put("ColumnParentTier", 100);
        preferredWidths.put("ColumnChildTier", 100);
        preferredWidths.put("ColumnBeginTime", 80);
        preferredWidths.put("ColumnEndTime", 80);
        preferredWidths.put("ColumnDuration", 80);
        maxWidths.put("ColumnTriangle", 15);
        maxWidths.put("ColumnCount", 40);
        maxWidths.put("ColumnBeginTime", 120);
        maxWidths.put("ColumnEndTime", 120);
        maxWidths.put("ColumnDuration", 120);
    }
}

