/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.grid;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumn;
import mpi.eudico.client.annotator.InlineEditBoxListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.grid.AbstractEditableGridViewer;
import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.grid.GridViewerTableModel;
import mpi.eudico.client.annotator.tiersets.TierSetUtil;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AnnotationCoreImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.ConcatAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;

public class GridViewer
extends AbstractEditableGridViewer
implements SingleTierViewer,
ActionListener,
InlineEditBoxListener {
    public static final int SINGLE_TIER_MODE = 0;
    public static final int MULTI_TIER_ASSOCIATION_MODE = 1;
    public static final int MULTI_TIER_SUBDIVISION_MODE = 2;
    public static final int MULTI_TIER_MODE = 1;
    private int mode = 0;
    private static final AnnotationCore EMPTY = new AnnotationCoreImpl("", -1L, -1L);
    private TierImpl tier;
    private List<TierImpl> childTiers = new ArrayList<TierImpl>();
    private Map<TierImpl, String> childTierNames = new HashMap<TierImpl, String>();
    private Set<Object> storedInvisibleColumns = new HashSet<Object>();

    public GridViewer() {
        super(new AnnotationTable(new GridViewerTableModel()));
        if (this.popup != null) {
            this.popup.addActionListener(this);
        }
        this.storedInvisibleColumns.add("ColumnBeginTime");
        this.storedInvisibleColumns.add("ColumnEndTime");
        this.storedInvisibleColumns.add("ColumnDuration");
    }

    @Override
    public void updateDataModel(List<? extends AnnotationCore> annotations) {
        this.removeChildrenColumns();
        this.childTiers.clear();
        this.childTierNames.clear();
        super.updateDataModel(annotations);
    }

    @Override
    public void isClosing() {
        if (this.table != null && this.table.isEditing() && this.gridEditor != null) {
            Boolean val = Preferences.getBool("InlineEdit.DeselectCommits", null);
            if (val != null && !val.booleanValue()) {
                this.gridEditor.cancelCellEditing();
            } else {
                this.gridEditor.commitEdit();
            }
        }
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        if (this.tier == null) {
            return;
        }
        switch (e.getOperation()) {
            case 3: {
                if (this.isCreatingAnnotation) {
                    this.isCreatingAnnotation = false;
                    return;
                }
            }
            case 4: 
            case 5: 
            case 7: {
                this.annotationsChanged(null);
                break;
            }
            case 6: 
            case 14: {
                this.annotationsChanged(null);
                break;
            }
            case 2: {
                TierImpl invalTier = (TierImpl)e.getInvalidatedObject();
                this.tierChanged(invalTier);
                break;
            }
            case 0: 
            case 1: {
                TierImpl ti = (TierImpl)e.getModification();
                this.tierChanged(ti);
                break;
            }
            default: {
                super.ACMEdited(e);
            }
        }
    }

    private void tierChanged(TierImpl changedTier) {
        if (this.mode == 0) {
            if (changedTier == this.tier) {
                this.setTier(changedTier);
            }
        } else {
            this.setTier(this.tier);
        }
    }

    @Override
    public void setTier(Tier tier) {
        this.gridEditor.cancelCellEditing();
        this.tier = (TierImpl)tier;
        if (tier == null) {
            this.updateDataModel(new ArrayList());
            this.table.setFontsForTiers(null);
            this.setPreference("GridViewer.TierName", tier, this.getViewerManager().getTranscription());
        } else {
            List<AbstractAnnotation> annotations = null;
            try {
                annotations = this.tier.getAnnotations();
            }
            catch (Exception ex) {
                LOG.warning("Could not get the annotations: " + ex.getMessage());
            }
            this.updateDataModel(annotations);
            if (this.mode == 1) {
                this.extractChildTiers(this.tier, 4);
                this.addExtraColumns();
            }
            if (this.mode == 2) {
                this.extractChildTiers(this.tier, 3);
                this.addExtraColumns();
            }
            this.setPreference("GridViewer.TierName", tier.getName(), this.getViewerManager().getTranscription());
            this.preferencesChanged();
        }
        this.updateSelection();
        this.doUpdate();
    }

    protected void extractChildTiers(TierImpl tier, int constraint) {
        if (tier != null) {
            List<TierImpl> depTiers = tier.getDependentTiers();
            Boolean workWithTierSetsPref = Preferences.getBool("WorkwithTierSets", null);
            Boolean workWithTierSets = false;
            if (workWithTierSetsPref != null) {
                workWithTierSets = workWithTierSetsPref;
            }
            List<String> tiersInTierSets = TierSetUtil.getTierSetUtilInstance().getVisibleTiers();
            for (TierImpl t : depTiers) {
                if (t.getParentTier() != tier || workWithTierSets.booleanValue() && !tiersInTierSets.contains(t.getName()) || t.getLinguisticType().getConstraints().getStereoType() != constraint) continue;
                this.childTiers.add(t);
                this.childTierNames.put(t, t.getName());
                this.extractChildTiers(t, constraint);
            }
        }
    }

    @Override
    public void updateActiveAnnotation() {
        if (this.tier == null) {
            return;
        }
        if (this.getActiveAnnotation() == null) {
            this.repaint();
            return;
        }
        if (this.mode == 0) {
            super.updateActiveAnnotation();
        } else if (this.getActiveAnnotation().getTier() != this.tier && !this.childTiers.contains(this.getActiveAnnotation().getTier())) {
            this.repaint();
            return;
        }
        this.doUpdate();
    }

    protected void addExtraColumns() {
        if (this.childTiers.size() == 0) {
            return;
        }
        Tier tierChild = null;
        int vecChildren_size = this.childTiers.size();
        for (int i = 0; i < vecChildren_size; ++i) {
            tierChild = this.childTiers.get(i);
            this.handleExtraColumn(tierChild);
        }
    }

    private void handleExtraColumn(Tier childTier) {
        try {
            List<AnnotationCore> v = null;
            if (this.mode == 1) {
                v = this.createChildAnnotationList(childTier);
            } else if (this.mode == 2) {
                v = this.createChildAnnotationListS(childTier);
            }
            String name = childTier.getName();
            this.dataModel.addChildTier(name, v);
            int columnIndex = this.dataModel.findColumn(name);
            TableColumn tc = new TableColumn();
            tc.setHeaderValue(name);
            tc.setIdentifier(name);
            this.table.addColumn(tc);
            int curIndex = this.table.getColumnModel().getColumnIndex(name);
            this.table.moveColumn(curIndex, columnIndex);
            this.updateColumnModelIndices();
            this.table.setColumnVisible(name, true);
        }
        catch (Exception ex) {
            LOG.warning("Could not handle the extra column for the child tier: " + ex.getMessage());
        }
    }

    private List<AnnotationCore> createChildAnnotationListS(Tier childTier) {
        ArrayList<AnnotationCore> cv = new ArrayList<AnnotationCore>(this.dataModel.getRowCount());
        List<AbstractAnnotation> existingChildren = ((TierImpl)childTier).getAnnotations();
        ArrayList<AnnotationCore> annotationList = new ArrayList<AnnotationCore>();
        int k = 0;
        for (int j = 0; j < this.dataModel.getRowCount(); ++j) {
            AnnotationCore annotation = this.dataModel.getAnnotationCore(j);
            long begin = annotation.getBeginTimeBoundary();
            long end = annotation.getEndTimeBoundary();
            while (k < existingChildren.size()) {
                AnnotationCore child = existingChildren.get(k);
                if (child.getBeginTimeBoundary() >= begin && child.getEndTimeBoundary() <= end) {
                    annotationList.add(child);
                } else if (child.getBeginTimeBoundary() >= end) {
                    if (annotationList.size() > 0) {
                        cv.add(new ConcatAnnotation(annotationList));
                        annotationList.clear();
                        break;
                    }
                    cv.add(EMPTY);
                    break;
                }
                ++k;
            }
            if (k == existingChildren.size() && annotationList.size() > 0) {
                cv.add(new ConcatAnnotation(annotationList));
                annotationList.clear();
            }
            if (cv.size() >= j) continue;
            cv.add(EMPTY);
        }
        return cv;
    }

    private List<AnnotationCore> createChildAnnotationList(Tier childTier) {
        ArrayList<AnnotationCore> cv = new ArrayList<AnnotationCore>(this.dataModel.getRowCount());
        List<AbstractAnnotation> existingChildren = ((TierImpl)childTier).getAnnotations();
        int j = 0;
        for (int i = 0; i < this.dataModel.getRowCount(); ++i) {
            AnnotationCore annotation = this.dataModel.getAnnotationCore(i);
            long begin = annotation.getBeginTimeBoundary();
            if (j < existingChildren.size()) {
                AnnotationCore childAnnotation = existingChildren.get(j);
                if (childAnnotation.getBeginTimeBoundary() == begin) {
                    cv.add(childAnnotation);
                    ++j;
                    continue;
                }
                cv.add(EMPTY);
                continue;
            }
            cv.add(EMPTY);
        }
        return cv;
    }

    public void setMode(int mode) {
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        Set<Object> invisibleColumns = this.getInvisibleColumns();
        this.setInvisibleColumns(this.storedInvisibleColumns);
        this.storedInvisibleColumns = invisibleColumns;
        this.setPreference("GridViewer.MultiTierMode", mode == 1 || mode == 2, this.getViewerManager().getTranscription());
        if (mode == 2) {
            this.setPreference("GridViewer.MultiTierMode.Subdivision", Boolean.TRUE, this.getViewerManager().getTranscription());
        } else if (mode == 1) {
            this.setPreference("GridViewer.MultiTierMode.Subdivision", Boolean.FALSE, this.getViewerManager().getTranscription());
        }
    }

    public void setModeFromPref(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    protected Set<Object> getInvisibleColumns() {
        HashSet<Object> invisibleColumns = new HashSet<Object>();
        invisibleColumns.clear();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tc = this.table.getColumnModel().getColumn(i);
            if (this.table.isColumnVisible((String)tc.getIdentifier())) continue;
            invisibleColumns.add(tc.getIdentifier());
        }
        return invisibleColumns;
    }

    protected void setInvisibleColumns(Set<Object> invisibleColumns) {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tc = this.table.getColumnModel().getColumn(i);
            this.table.setColumnVisible(this.dataModel.getColumnName(i), !invisibleColumns.contains(tc.getIdentifier()));
        }
    }

    protected void annotationsChanged(TierImpl invTier) {
        if (invTier == null || invTier == this.tier || invTier.getDependentTiers().contains(this.tier) || this.childTiers.contains(invTier)) {
            List<AbstractAnnotation> annotations = this.tier.getAnnotations();
            this.dataModel.updateAnnotations(annotations);
            for (int i = 0; i < this.childTiers.size(); ++i) {
                Tier childTier = this.childTiers.get(i);
                List<AnnotationCore> vec = null;
                if (this.mode == 1) {
                    vec = this.createChildAnnotationList(childTier);
                } else if (this.mode == 2) {
                    vec = this.createChildAnnotationListS(childTier);
                }
                this.dataModel.addChildTier(childTier.getName(), vec);
            }
            this.updateSelection();
            this.doUpdate();
        }
    }

    private void removeChildrenColumns() {
        if (this.childTiers.size() > 0) {
            for (int i = 0; i < this.childTiers.size(); ++i) {
                TierImpl t = this.childTiers.get(i);
                String columnID = this.childTierNames.get(t);
                try {
                    this.table.removeColumn(this.table.getColumn(columnID));
                    this.updateColumnModelIndices();
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    LOG.warning("Column not found: " + iae.getMessage());
                }
            }
        }
    }

    private void updateColumnModelIndices() {
        Enumeration<TableColumn> ten = this.table.getColumnModel().getColumns();
        TableColumn tabcol = null;
        while (ten.hasMoreElements()) {
            tabcol = ten.nextElement();
            int tableIndex = this.table.getColumnModel().getColumnIndex(tabcol.getIdentifier());
            tabcol.setModelIndex(tableIndex);
        }
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    @Override
    public void preferencesChanged() {
        boolean futVis;
        boolean curVis;
        Boolean boolPref;
        Map<String, Font> foMap;
        super.preferencesChanged();
        Transcription transcription = this.getViewerManager().getTranscription();
        Integer fontSi = Preferences.getInt("GridViewer.FontSize", transcription);
        if (fontSi != null) {
            this.setFontSize(fontSi);
        }
        if ((foMap = Preferences.getMapOfFont("TierFonts", transcription)) != null && this.tier != null) {
            HashMap<String, String> gridMap = new HashMap<String, String>(5);
            for (Map.Entry<String, Font> e : foMap.entrySet()) {
                String key = e.getKey();
                Font ft = e.getValue();
                if (key == null || ft == null) continue;
                if (key.equals(this.tier.getName())) {
                    gridMap.put("ColumnAnnotation", ft.getName());
                }
                gridMap.put(key, ft.getName());
            }
            this.table.setFontsForTiers(gridMap);
        }
        if ((boolPref = Preferences.getBool("InlineEdit.EnterCommits", null)) != null) {
            this.gridEditor.setEnterCommits(boolPref);
        }
        if ((boolPref = Preferences.getBool("InlineEdit.DeselectCommits", null)) != null) {
            this.table.setDeselectCommits(boolPref);
        } else {
            this.table.setDeselectCommits(true);
        }
        String stringPref = Preferences.getString("GridViewer.TimeFormat", transcription);
        if (stringPref != null) {
            this.table.setTimeFormat(stringPref);
            if (this.popup != null) {
                this.popup.setTimeFormat(stringPref);
            }
        }
        if ((boolPref = Preferences.getBool("GridViewer.ColumnBeginTime.Visible", transcription)) != null && (curVis = this.table.isColumnVisible("ColumnBeginTime")) != (futVis = boolPref.booleanValue())) {
            this.table.setColumnVisible("ColumnBeginTime", futVis);
        }
        if ((boolPref = Preferences.getBool("GridViewer.ColumnEndTime.Visible", transcription)) != null && (curVis = this.table.isColumnVisible("ColumnEndTime")) != (futVis = boolPref.booleanValue())) {
            this.table.setColumnVisible("ColumnEndTime", futVis);
        }
        if ((boolPref = Preferences.getBool("GridViewer.ColumnDuration.Visible", transcription)) != null && (curVis = this.table.isColumnVisible("ColumnDuration")) != (futVis = boolPref.booleanValue())) {
            this.table.setColumnVisible("ColumnDuration", futVis);
        }
        this.doLayout();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("TOGGLETIMEFORMAT")) {
            if (this.dataModel instanceof GridViewerTableModel) {
                String timeFormat = this.dataModel.getTimeFormat();
                if ("TIMECODE".equals(timeFormat)) {
                    this.setPreference("GridViewer.TimeFormat", "hh:mm:ss.ms", this.getViewerManager().getTranscription());
                } else if ("MILLISECONDS".equals(timeFormat)) {
                    this.setPreference("GridViewer.TimeFormat", "ms", this.getViewerManager().getTranscription());
                } else {
                    this.setPreference("GridViewer.TimeFormat", null, this.getViewerManager().getTranscription());
                }
            }
        } else if (e.getActionCommand().equals("hh:mm:ss.ms")) {
            this.setPreference("GridViewer.TimeFormat", "hh:mm:ss.ms", this.getViewerManager().getTranscription());
        } else if (e.getActionCommand().equals("PAL")) {
            this.setPreference("GridViewer.TimeFormat", "PAL", this.getViewerManager().getTranscription());
        } else if (e.getActionCommand().equals("NTSC")) {
            this.setPreference("GridViewer.TimeFormat", "NTSC", this.getViewerManager().getTranscription());
        } else if (e.getActionCommand().equals("ms")) {
            this.setPreference("GridViewer.TimeFormat", "ms", this.getViewerManager().getTranscription());
        } else if (e.getActionCommand().equals("ss.ms")) {
            this.setPreference("GridViewer.TimeFormat", "ss.ms", this.getViewerManager().getTranscription());
        } else if (e.getActionCommand().equals("ColumnBeginTime")) {
            if (e.getSource() instanceof AbstractButton) {
                boolean selected = ((AbstractButton)e.getSource()).isSelected();
                this.setPreference("GridViewer.ColumnBeginTime.Visible", selected, this.getViewerManager().getTranscription());
            }
        } else if (e.getActionCommand().equals("ColumnEndTime")) {
            if (e.getSource() instanceof AbstractButton) {
                boolean selected = ((AbstractButton)e.getSource()).isSelected();
                this.setPreference("GridViewer.ColumnEndTime.Visible", selected, this.getViewerManager().getTranscription());
            }
        } else if (e.getActionCommand().equals("ColumnDuration")) {
            if (e.getSource() instanceof AbstractButton) {
                boolean selected = ((AbstractButton)e.getSource()).isSelected();
                this.setPreference("GridViewer.ColumnDuration.Visible", selected, this.getViewerManager().getTranscription());
            }
        } else if (e.getActionCommand().indexOf("font") != -1) {
            this.setPreference("GridViewer.FontSize", this.table.getFontSize(), this.getViewerManager().getTranscription());
        }
    }

    public void setKeyStrokesNotToBeConsumed(List<KeyStroke> ksList) {
        this.gridEditor.setKeyStrokesNotToBeConsumed(ksList);
    }

    @Override
    public void editingCommitted() {
        if (this.table != null && this.table.isEditing()) {
            this.table.editingStopped(new ChangeEvent(this));
        }
    }

    @Override
    public void editingCancelled() {
        if (this.table != null && this.table.isEditing()) {
            this.table.editingCanceled(new ChangeEvent(this));
        }
    }
}

