/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.MonitoringLogger;

public class ActivityMonitoringDialog
extends ClosableDialog
implements ActionListener,
ChangeListener {
    private JButton startButton;
    private JButton stopButton;
    private JButton advancedOptionsButton;
    private JPanel advancedOptionsPanel;
    private JPanel buttonsPanel;
    private JCheckBox setLocationCB;
    private JCheckBox filesPerSessionCB;
    private JCheckBox appendToFileCB;
    private JCheckBox alwaysMonitorCB;
    private JTextField pathTextField;
    private JButton browseButton;
    private static ActivityMonitoringDialog dialog;
    private final ImageIcon triangleUp = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/triangle_up.gif"));
    private final ImageIcon triangleDown = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/triangle_down.gif"));
    private final int minWidth = 275;
    private final int minHeight = 75;

    private ActivityMonitoringDialog() {
        this.initComponents();
        this.postInit();
    }

    public static ActivityMonitoringDialog getInstance() {
        if (dialog == null) {
            dialog = new ActivityMonitoringDialog();
        }
        return dialog;
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setSize(this.getSize().width < 275 ? 275 : this.getSize().width, this.getSize().height < 75 ? 75 : this.getSize().height);
        this.setResizable(true);
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("Menu.Options.ActivityMonitoring"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.startButton = new JButton(ElanLocale.getString("Button.Start"));
        this.stopButton = new JButton(ElanLocale.getString("Button.Stop"));
        this.stopButton.setEnabled(false);
        if (MonitoringLogger.isInitiated()) {
            this.startButton.setText(ElanLocale.getString("Button.Pause"));
            this.stopButton.setEnabled(true);
        }
        this.browseButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.browseButton.setEnabled(false);
        this.advancedOptionsButton = new JButton();
        this.advancedOptionsButton.setIcon(this.triangleDown);
        this.advancedOptionsButton.setToolTipText(ElanLocale.getString("ActivityMonitoringDialog.TriangleDown.ToolTip"));
        this.advancedOptionsButton.setMaximumSize(this.advancedOptionsButton.getPreferredSize());
        Insets insets = new Insets(4, 2, 4, 2);
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new GridLayout(1, 2, 0, 0));
        this.buttonsPanel.add(this.startButton);
        this.buttonsPanel.add(this.stopButton);
        this.startButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.advancedOptionsButton.addActionListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 11;
        this.getContentPane().add((Component)this.buttonsPanel, gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        this.getContentPane().add((Component)this.advancedOptionsButton, gbc);
    }

    private JPanel getAdvancedOptionsPanel() {
        String stringPref;
        if (this.advancedOptionsPanel != null) {
            return this.advancedOptionsPanel;
        }
        this.advancedOptionsPanel = new JPanel();
        this.advancedOptionsPanel.setBorder(new TitledBorder(ElanLocale.getString("DisplaySettingsPane.Label.AdvancedOptions")));
        this.advancedOptionsPanel.setLayout(new GridBagLayout());
        this.setLocationCB = new JCheckBox(ElanLocale.getString("ActivityMonitoringDialog.CB.SetLocation"));
        this.setLocationCB.addChangeListener(this);
        this.setLocationCB.addActionListener(this);
        this.pathTextField = new JTextField();
        this.pathTextField.setEnabled(false);
        this.pathTextField.setColumns(5);
        this.browseButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.browseButton.setEnabled(false);
        this.browseButton.addActionListener(this);
        Boolean boolPref = Preferences.getBool("ActivityMonitoring.UseLocation", null);
        if (boolPref != null) {
            this.setLocationCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("ActivityMonitoring.PathLocation", null)) != null) {
            this.pathTextField.setText(stringPref);
        }
        this.filesPerSessionCB = new JCheckBox(ElanLocale.getString("ActivityMonitoringDialog.CB.FilesPerSession"));
        boolPref = Preferences.getBool("ActivityMonitoring.FilesPerSession", null);
        if (boolPref != null) {
            this.filesPerSessionCB.setSelected(boolPref);
        }
        this.filesPerSessionCB.addActionListener(this);
        this.appendToFileCB = new JCheckBox(ElanLocale.getString("ActivityMonitoringDialog.CB.AppendToFile"));
        this.appendToFileCB.setSelected(true);
        boolPref = Preferences.getBool("ActivityMonitoring.AppendToFile", null);
        if (boolPref != null) {
            this.appendToFileCB.setSelected(boolPref);
        }
        this.appendToFileCB.setEnabled(!this.filesPerSessionCB.isSelected());
        this.appendToFileCB.addActionListener(this);
        this.alwaysMonitorCB = new JCheckBox(ElanLocale.getString("ActivityMonitoringDialog.CB.AlwaysMonitor"));
        boolPref = Preferences.getBool("ActivityMonitoring.AlwaysStartMonitoring", null);
        if (boolPref != null) {
            this.alwaysMonitorCB.setSelected(boolPref);
        }
        this.alwaysMonitorCB.addActionListener(this);
        Insets insets = new Insets(2, 4, 2, 4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.advancedOptionsPanel.add((Component)this.setLocationCB, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 0.5;
        this.advancedOptionsPanel.add((Component)this.pathTextField, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        this.advancedOptionsPanel.add((Component)this.browseButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        this.advancedOptionsPanel.add((Component)this.filesPerSessionCB, gbc);
        gbc.gridy = 2;
        this.advancedOptionsPanel.add((Component)this.appendToFileCB, gbc);
        gbc.gridy = 3;
        this.advancedOptionsPanel.add((Component)this.alwaysMonitorCB, gbc);
        return this.advancedOptionsPanel;
    }

    private void getOpenFileName() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("ActivityMonitoringDialog.OpenDialog.Title"), 0, ElanLocale.getString("Button.Select"), null, null, true, "LastUsedEAFDir", 1, null);
        File folder = chooser.getSelectedFile();
        if (folder != null) {
            MonitoringLogger.setDirectory(folder.getPath());
            this.pathTextField.setText(folder.getPath());
            Preferences.set("ActivityMonitoring.PathLocation", this.pathTextField.getText().trim(), null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.startButton) {
            this.stopButton.setEnabled(true);
            if (this.startButton.getText().equals(ElanLocale.getString("Button.Start"))) {
                this.startButton.setText(ElanLocale.getString("Button.Pause"));
                MonitoringLogger.startMonitoring(true);
                MonitoringLogger.logInAllLoggers(MonitoringLogger.MONITORING_STARTED, new String[0]);
            } else {
                this.startButton.setText(ElanLocale.getString("Button.Start"));
                MonitoringLogger.logInAllLoggers(MonitoringLogger.MONITORING_PAUSED, new String[0]);
                MonitoringLogger.startMonitoring(false);
            }
            this.stopButton.setEnabled(true);
        } else if (e.getSource() == this.stopButton) {
            MonitoringLogger.logInAllLoggers(MonitoringLogger.MONITORING_STOPPED, new String[0]);
            MonitoringLogger.startMonitoring(false);
            this.stopButton.setEnabled(false);
            this.startButton.setText(ElanLocale.getString("Button.Start"));
        } else if (e.getSource() == this.advancedOptionsButton) {
            if (this.advancedOptionsButton.getIcon() == this.triangleDown) {
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.insets = new Insets(4, 2, 4, 2);
                gbc.anchor = 18;
                gbc.weightx = 0.5;
                gbc.weighty = 0.5;
                gbc.fill = 2;
                gbc.gridy = 1;
                gbc.gridwidth = 2;
                this.getContentPane().add((Component)this.getAdvancedOptionsPanel(), gbc);
                this.advancedOptionsButton.setIcon(this.triangleUp);
                this.advancedOptionsButton.setToolTipText(ElanLocale.getString("ActivityMonitoringDialog.TriangleUp.ToolTip"));
                this.pack();
            } else {
                this.advancedOptionsButton.setIcon(this.triangleDown);
                this.advancedOptionsButton.setToolTipText(ElanLocale.getString("ActivityMonitoringDialog.TriangleDown.ToolTip"));
                this.getContentPane().remove(this.getAdvancedOptionsPanel());
                this.pack();
                this.setSize(this.getSize().width < 275 ? 275 : this.getSize().width, this.getSize().height < 75 ? 75 : this.getSize().height);
            }
        } else if (e.getSource() == this.browseButton) {
            this.getOpenFileName();
        } else if (e.getSource() == this.alwaysMonitorCB) {
            Preferences.set("ActivityMonitoring.AlwaysStartMonitoring", this.alwaysMonitorCB.isSelected(), null);
        } else if (e.getSource() == this.filesPerSessionCB) {
            Preferences.set("ActivityMonitoring.FilesPerSession", this.filesPerSessionCB.isSelected(), null);
            MonitoringLogger.createNewFilesPerSession(this.filesPerSessionCB.isSelected());
            this.appendToFileCB.setEnabled(!this.filesPerSessionCB.isSelected());
        } else if (e.getSource() == this.appendToFileCB) {
            MonitoringLogger.setAppendFileFlag(this.appendToFileCB.isSelected());
            Preferences.set("ActivityMonitoring.AppendToFile", this.appendToFileCB.isSelected(), null);
        } else if (e.getSource() == this.setLocationCB) {
            Preferences.set("ActivityMonitoring.UseLocation", this.setLocationCB.isSelected(), null);
            if (!this.setLocationCB.isSelected()) {
                MonitoringLogger.setDirectory(null);
            } else if (this.pathTextField.getText() != null && this.pathTextField.getText().length() > 0) {
                MonitoringLogger.setDirectory(this.pathTextField.getText().trim());
            } else {
                MonitoringLogger.setDirectory(null);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.pathTextField.setEnabled(this.setLocationCB.isSelected());
        this.browseButton.setEnabled(this.setLocationCB.isSelected());
    }
}

