/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.AdvancedAttributeSettingOptionDialog;
import mpi.eudico.client.annotator.gui.JFontChooser;
import mpi.eudico.client.util.FavoriteColorPanel;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class AdvancedTierOptionsDialog
extends JDialog
implements ActionListener {
    private Map<String, Object> tierProperties;
    private JPanel colorPreviewPanel;
    private JButton colorButton;
    private JButton resetColorButton;
    private JPanel highlightColorPreviewPanel;
    private JButton highlightColorButton;
    private JButton resetHighlightColorButton;
    private JTextField fontTextField;
    private JButton fontButton;
    private JButton resetFontButton;
    private JButton changeButton;
    private JButton cancelButton;
    private String tierName;
    private Color fontColor;
    private Color highlightColor;
    private Font font;
    private boolean applySettings = false;
    private TranscriptionImpl transcription;

    public AdvancedTierOptionsDialog(Dialog owner, boolean modal, HashMap<String, Object> tierProperties) throws HeadlessException {
        this(owner, "", modal, tierProperties);
    }

    public AdvancedTierOptionsDialog(Dialog owner, String title, boolean modal, HashMap<String, Object> tierProps) throws HeadlessException {
        super(owner, title, modal);
        this.initialize(tierProps);
    }

    public AdvancedTierOptionsDialog(Frame owner, String title, TranscriptionImpl transcription, String tierName) {
        super(owner, title, true);
        this.setTitle(title);
        this.tierName = tierName;
        this.applySettings = true;
        this.transcription = transcription;
        HashMap<String, Object> tierProps = new HashMap<String, Object>();
        tierProps.put("TierName", tierName);
        Map<String, Color> map = Preferences.getMapOfColor("TierColors", transcription);
        if (map != null) {
            tierProps.put("TierColor", map.get(tierName));
        }
        if ((map = Preferences.getMapOfColor("TierHighlightColors", transcription)) != null) {
            tierProps.put("TierHighlightColor", map.get(tierName));
        }
        Map<String, Font> fontMmap = Preferences.getMapOfFont("TierFonts", transcription);
        if (map != null) {
            tierProps.put("TierFont", fontMmap.get(tierName));
        }
        this.initialize(tierProps);
    }

    private void initialize(Map<String, Object> tierProps) {
        if (tierProps == null || tierProps.get("TierName") == null) {
            throw new IllegalArgumentException("Insufficient tier properties.");
        }
        this.tierProperties = new HashMap<String, Object>(tierProps.size());
        this.tierProperties.putAll(tierProps);
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.fontColor = (Color)this.tierProperties.get("TierColor");
        if (this.fontColor == null) {
            this.fontColor = Color.WHITE;
        }
        this.highlightColor = (Color)this.tierProperties.get("TierHighlightColor");
        if (this.highlightColor == null) {
            this.highlightColor = Color.WHITE;
        }
        this.font = (Font)this.tierProperties.get("TierFont");
        this.tierName = (String)this.tierProperties.get("TierName");
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        JPanel prefPanel = new JPanel();
        JLabel titleLabel = new JLabel();
        titleLabel.setText(ElanLocale.getString("EditTierDialog.Label.TierName") + ": " + this.tierName);
        titleLabel.setFont(titleLabel.getFont().deriveFont(16.0f));
        titleLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)titleLabel, gbc);
        prefPanel.setBorder(new TitledBorder(ElanLocale.getString("EditTierDialog.Label.TierPreferences")));
        prefPanel.setLayout(new GridBagLayout());
        JLabel colorLabel = new JLabel(ElanLocale.getString("EditTierDialog.Label.TierColor"));
        this.colorButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.colorButton.addActionListener(this);
        this.resetColorButton = new JButton(ElanLocale.getString("Button.Default"));
        this.resetColorButton.addActionListener(this);
        this.colorPreviewPanel = new JPanel();
        this.colorPreviewPanel.setBorder(new LineBorder(Color.GRAY, 1));
        this.colorPreviewPanel.setBackground(this.fontColor);
        this.colorPreviewPanel.setPreferredSize(new Dimension(this.colorButton.getPreferredSize().height, this.colorButton.getPreferredSize().height));
        this.colorPreviewPanel.setMinimumSize(new Dimension(this.colorButton.getPreferredSize().height, this.colorButton.getPreferredSize().height));
        JLabel highlightColorLabel = new JLabel(ElanLocale.getString("EditTierDialog.Label.TierHighlightColor"));
        this.highlightColorButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.highlightColorButton.addActionListener(this);
        this.resetHighlightColorButton = new JButton(ElanLocale.getString("Button.Default"));
        this.resetHighlightColorButton.addActionListener(this);
        this.highlightColorPreviewPanel = new JPanel();
        this.highlightColorPreviewPanel.setBorder(new LineBorder(Color.GRAY, 1));
        this.highlightColorPreviewPanel.setBackground(this.highlightColor);
        this.highlightColorPreviewPanel.setPreferredSize(new Dimension(this.highlightColorButton.getPreferredSize().height, this.highlightColorButton.getPreferredSize().height));
        this.highlightColorPreviewPanel.setMinimumSize(new Dimension(this.highlightColorButton.getPreferredSize().height, this.highlightColorButton.getPreferredSize().height));
        JLabel fontLabel = new JLabel(ElanLocale.getString("EditTierDialog.Label.TierFont"));
        this.fontTextField = new JTextField(20);
        this.fontTextField.setEditable(false);
        if (this.font != null) {
            this.fontTextField.setText(this.font.getName());
        }
        this.fontButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.fontButton.addActionListener(this);
        this.resetFontButton = new JButton(ElanLocale.getString("Button.Default"));
        this.resetFontButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        prefPanel.add((Component)colorLabel, gbc);
        gbc.gridx = 1;
        prefPanel.add((Component)this.colorPreviewPanel, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        prefPanel.add((Component)this.colorButton, gbc);
        gbc.gridx = 4;
        prefPanel.add((Component)this.resetColorButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        prefPanel.add((Component)highlightColorLabel, gbc);
        gbc.gridx = 1;
        prefPanel.add((Component)this.highlightColorPreviewPanel, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        prefPanel.add((Component)this.highlightColorButton, gbc);
        gbc.gridx = 4;
        prefPanel.add((Component)this.resetHighlightColorButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        prefPanel.add((Component)fontLabel, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        prefPanel.add((Component)this.fontTextField, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        prefPanel.add((Component)this.fontButton, gbc);
        gbc.gridx = 4;
        prefPanel.add((Component)this.resetFontButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)prefPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.changeButton = new JButton();
        this.changeButton.setText(ElanLocale.getString("Button.Apply"));
        this.changeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.changeButton);
        buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                AdvancedTierOptionsDialog.this.doClose();
            }
        });
    }

    private void postInit() {
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    private Color chooseColor(Color oldColor) {
        Color newColor = null;
        final JColorChooser chooser = new JColorChooser(oldColor);
        AbstractColorChooserPanel[] panels = chooser.getChooserPanels();
        AbstractColorChooserPanel[] panels2 = new AbstractColorChooserPanel[panels.length + 1];
        FavoriteColorPanel fcp = new FavoriteColorPanel();
        panels2[0] = fcp;
        for (int i = 0; i < panels.length; ++i) {
            panels2[i + 1] = panels[i];
        }
        chooser.setChooserPanels(panels2);
        Map<String, Color> oldColors = null;
        oldColors = Preferences.getMapOfColor("FavoriteColors", null);
        if (oldColors != null) {
            Color[] favColors = fcp.getColors();
            for (Map.Entry<String, Color> e : oldColors.entrySet()) {
                String key = e.getKey();
                Color val = e.getValue();
                try {
                    int index = Integer.valueOf(key);
                    if (index >= favColors.length) continue;
                    favColors[index] = val;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        AbstractAction aa = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.putValue("Default", chooser.getColor());
            }
        };
        JDialog cd = JColorChooser.createDialog(this, ElanLocale.getString("ColorChooser.Title"), true, chooser, aa, null);
        cd.setVisible(true);
        HashMap<String, Color> colMap = new HashMap<String, Color>();
        Color[] colors = fcp.getColors();
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] == null) continue;
            colMap.put(String.valueOf(i), colors[i]);
        }
        if (colMap.size() > 0 || oldColors != null) {
            Preferences.set("FavoriteColors", colMap, null);
        }
        newColor = (Color)aa.getValue("Default");
        return newColor;
    }

    private void selectTierColor() {
        Color newColor = this.chooseColor(this.fontColor);
        if (newColor != null && !newColor.equals(this.fontColor)) {
            this.fontColor = newColor;
            this.colorPreviewPanel.setBackground(this.fontColor);
        }
    }

    private void selectHighlightColor() {
        Color newColor = this.chooseColor(this.highlightColor);
        if (newColor != null && !newColor.equals(this.highlightColor)) {
            this.highlightColor = newColor;
            this.highlightColorPreviewPanel.setBackground(this.highlightColor);
        }
    }

    private void selectFont() {
        JFontChooser jfc = new JFontChooser();
        Font f = jfc.showDialog(this, true, this.font);
        if (f != null) {
            this.fontTextField.setText(f.getName());
            this.font = f;
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.changeButton) {
            this.tierProperties.put("TierColor", this.fontColor);
            this.tierProperties.put("TierHighlightColor", this.highlightColor);
            this.tierProperties.put("TierFont", this.font);
            if (this.applySettings) {
                this.applySettingsToCurrentTier();
                AdvancedAttributeSettingOptionDialog dialog = new AdvancedAttributeSettingOptionDialog((Dialog)this, this.getTitle(), this.transcription, this.tierName);
                this.doClose();
                dialog.setVisible(true);
            } else {
                AdvancedAttributeSettingOptionDialog dialog = new AdvancedAttributeSettingOptionDialog((Dialog)this, this.getTitle(), this.tierProperties);
                dialog.setVisible(true);
                this.tierProperties = dialog.getTierProperties();
                this.doClose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.tierProperties = null;
            this.doClose();
        } else if (e.getSource() == this.colorButton) {
            this.selectTierColor();
        } else if (e.getSource() == this.resetColorButton) {
            this.fontColor = Color.WHITE;
            this.colorPreviewPanel.setBackground(this.fontColor);
        } else if (e.getSource() == this.highlightColorButton) {
            this.selectHighlightColor();
        } else if (e.getSource() == this.resetHighlightColorButton) {
            this.highlightColor = Color.WHITE;
            this.highlightColorPreviewPanel.setBackground(this.highlightColor);
        } else if (e.getSource() == this.fontButton) {
            this.selectFont();
        } else if (e.getSource() == this.resetFontButton) {
            this.fontTextField.setText("");
            this.font = null;
        }
    }

    private void applySettingsToCurrentTier() {
        Map<String, Font> fonts;
        Map<String, Color> highlightColors;
        Map<String, Color> colors = Preferences.getMapOfColor("TierColors", this.transcription);
        if (colors == null) {
            colors = new HashMap<String, Color>();
            Preferences.set("TierColors", colors, (Transcription)this.transcription);
        }
        if ((highlightColors = Preferences.getMapOfColor("TierHighlightColors", this.transcription)) == null) {
            highlightColors = new HashMap<String, Color>();
            Preferences.set("TierHighlightColors", highlightColors, (Transcription)this.transcription);
        }
        if ((fonts = Preferences.getMapOfFont("TierFonts", this.transcription)) == null) {
            fonts = new HashMap<String, Font>();
            Preferences.set("TierFonts", fonts, (Transcription)this.transcription);
        }
        Color nextColor = (Color)this.tierProperties.get("TierColor");
        Color nextHighlightColor = (Color)this.tierProperties.get("TierHighlightColor");
        Font fo = (Font)this.tierProperties.get("TierFont");
        if (nextColor != null) {
            if (!nextColor.equals(Color.WHITE)) {
                colors.put(this.tierName, nextColor);
            } else {
                colors.remove(this.tierName);
            }
        }
        if (nextHighlightColor != null && !nextHighlightColor.equals(Color.WHITE)) {
            if (!nextHighlightColor.equals(Color.WHITE)) {
                highlightColors.put(this.tierName, nextHighlightColor);
            } else {
                highlightColors.remove(this.tierName);
            }
        }
        if (fo != null) {
            fonts.put(this.tierName, fo);
        } else {
            fonts.remove(this.tierName);
        }
        Preferences.set("TierHighlightColors", highlightColors, (Transcription)this.transcription);
        Preferences.set("TierColors", colors, (Transcription)this.transcription);
        Preferences.set("TierFonts", fonts, this.transcription, true);
    }

    public Map<String, Object> getTierProperties() {
        return this.tierProperties;
    }
}

