/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.gui.AnnotationDensityPanel;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.TranscriptionTierSortAndSelectPanel;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;

public class AnnotationDensityPlotDialog
extends ClosableDialog
implements ActionListener,
ItemListener {
    private Transcription transcription;
    private Selection selection;
    private AnnotationDensityPanel densityPanel;
    private JButton buttonClose;
    private JButton buttonExport;
    private JButton buttonUpdate;
    private JTextField textWidth;
    private JTextField textHeight;
    private JTextField textColumn;
    private JTextField textTier;
    private JTextField textMargin;
    private JCheckBox checkSelection;
    private JCheckBox checkFill;
    private JCheckBox checkOutlines;
    private TranscriptionTierSortAndSelectPanel tiersPanel = null;
    private JScrollPane scrollPane = null;
    private boolean limitSelection = false;
    private int imageWidth = 600;
    private int imageHeight = 400;
    private int columnWidth = 120;
    private int tierHeight = 20;
    private int tierMargin = 2;
    private boolean includeOutlines = true;
    private boolean fillOut = true;
    private int first = 0;
    private int last = 0;
    private Map<String, Color> colorMap = null;

    public AnnotationDensityPlotDialog(Frame owner, Transcription transcription, Selection selection) throws HeadlessException {
        super(owner, true);
        this.transcription = transcription;
        this.selection = selection;
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.add(this.createTitlePanel());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.createTiersPanel());
        panel.add(this.createOptionsPanel());
        this.add(panel);
        this.add(this.createPlotPanel());
        this.add(this.createButtonPanel());
        this.computeFirstTimePoint();
        this.computeLastTimePoint();
        this.colorMap = Preferences.getMapOfColor("TierColors", transcription);
        this.setTitle(ElanLocale.getString("AnnotationDensityPlotDialog.Annotation.Density.Plot"));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.loadPreferences();
        this.readAndUpdate();
        if (selection == null || Math.abs(selection.getEndTime() - selection.getBeginTime()) <= 10L) {
            this.checkSelection.setEnabled(false);
        }
        this.setVisible(true);
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel();
        JLabel titleLabel = new JLabel(ElanLocale.getString("AnnotationDensityPlotDialog.Annotation.Density.Plot"));
        titleLabel.setFont(titleLabel.getFont().deriveFont(16.0f));
        titlePanel.add(titleLabel);
        return titlePanel;
    }

    private JPanel createTiersPanel() {
        this.tiersPanel = new TranscriptionTierSortAndSelectPanel((TranscriptionImpl)this.transcription);
        return this.tiersPanel;
    }

    private JPanel createPlotPanel() {
        this.densityPanel = new AnnotationDensityPanel(this);
        JPanel panelPlot = new JPanel();
        panelPlot.setBorder(new TitledBorder(ElanLocale.getString("AnnotationDensityPlotDialog.Annotation.Density.Plot")));
        panelPlot.setLayout(new BoxLayout(panelPlot, 0));
        this.scrollPane = new JScrollPane(this.densityPanel);
        this.scrollPane.setPreferredSize(new Dimension(600, 400));
        panelPlot.add(this.scrollPane);
        return panelPlot;
    }

    private JPanel createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        this.checkSelection = new JCheckBox(ElanLocale.getString("AnnotationDensityPlotDialog.Limit.Selection"));
        panel.add((Component)this.checkSelection, gc);
        gc.gridx = 0;
        ++gc.gridy;
        panel.add((Component)new JLabel(ElanLocale.getString("AnnotationDensityPlotDialog.Tier.Col.Width")), gc);
        ++gc.gridy;
        gc.gridx = 0;
        JPanel panelColumn = new JPanel();
        JPanel fillColumn = new JPanel();
        fillColumn.setPreferredSize(new Dimension(10, 10));
        panelColumn.add(fillColumn);
        this.textColumn = new JTextField(Integer.toString(this.columnWidth));
        this.textColumn.setPreferredSize(new Dimension(50, 20));
        this.textColumn.setHorizontalAlignment(4);
        panelColumn.add(this.textColumn);
        panel.add((Component)panelColumn, gc);
        gc.gridx = 0;
        ++gc.gridy;
        panel.add((Component)new JLabel(ElanLocale.getString("AnnotationDensityPlotDialog.Image.Width")), gc);
        ++gc.gridy;
        gc.gridx = 0;
        JPanel panelWidth = new JPanel();
        JPanel fillWidth = new JPanel();
        fillWidth.setPreferredSize(new Dimension(10, 10));
        panelWidth.add(fillWidth);
        this.textWidth = new JTextField(Integer.toString(this.columnWidth + this.imageWidth));
        this.textWidth.setPreferredSize(new Dimension(50, 20));
        this.textWidth.setHorizontalAlignment(4);
        panelWidth.add(this.textWidth);
        panel.add((Component)panelWidth, gc);
        gc.gridx = 0;
        ++gc.gridy;
        panel.add((Component)new JLabel(ElanLocale.getString("AnnotationDensityPlotDialog.Image.Height")), gc);
        ++gc.gridy;
        gc.gridx = 0;
        JPanel panelHeight = new JPanel();
        JPanel fillHeight = new JPanel();
        fillHeight.setPreferredSize(new Dimension(10, 10));
        panelHeight.add(fillHeight);
        this.textHeight = new JTextField(Integer.toString(this.imageHeight));
        this.textHeight.setPreferredSize(new Dimension(50, 20));
        this.textHeight.setHorizontalAlignment(4);
        panelHeight.add(this.textHeight);
        panel.add((Component)panelHeight, gc);
        gc.gridx = 0;
        ++gc.gridy;
        panel.add((Component)new JLabel(ElanLocale.getString("AnnotationDensityPlotDialog.Tier.Height")), gc);
        ++gc.gridy;
        gc.gridx = 0;
        JPanel panelTier = new JPanel();
        JPanel fillTier = new JPanel();
        fillTier.setPreferredSize(new Dimension(10, 10));
        panelTier.add(fillTier);
        this.textTier = new JTextField(Integer.toString(this.tierHeight));
        this.textTier.setPreferredSize(new Dimension(50, 20));
        this.textTier.setHorizontalAlignment(4);
        panelTier.add(this.textTier);
        this.checkFill = new JCheckBox(ElanLocale.getString("AnnotationDensityPlotDialog.Fill.Out"));
        this.checkFill.addItemListener(this);
        panelTier.add(this.checkFill);
        panel.add((Component)panelTier, gc);
        gc.gridx = 0;
        ++gc.gridy;
        panel.add((Component)new JLabel(ElanLocale.getString("AnnotationDensityPlotDialog.Margin.Height")), gc);
        ++gc.gridy;
        gc.gridx = 0;
        JPanel panelMargin = new JPanel();
        JPanel fillMargin = new JPanel();
        fillMargin.setPreferredSize(new Dimension(10, 10));
        panelMargin.add(fillMargin);
        this.textMargin = new JTextField(Integer.toString(this.tierMargin));
        this.textMargin.setPreferredSize(new Dimension(50, 20));
        this.textMargin.setHorizontalAlignment(4);
        panelMargin.add(this.textMargin);
        panel.add((Component)panelMargin, gc);
        gc.gridx = 0;
        ++gc.gridy;
        this.checkOutlines = new JCheckBox(ElanLocale.getString("AnnotationDensityPlotDialog.Include.Outlines"));
        panel.add((Component)this.checkOutlines, gc);
        gc.gridx = 0;
        ++gc.gridy;
        gc.fill = 3;
        gc.weighty = 1.0;
        panel.add((Component)new JPanel(), gc);
        panel.setBorder(new TitledBorder(ElanLocale.getString("AnnotationDensityPlotDialog.Options")));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        this.buttonUpdate = new JButton(ElanLocale.getString("AnnotationDensityPlotDialog.Update"));
        this.buttonUpdate.addActionListener(this);
        this.buttonExport = new JButton(ElanLocale.getString("AnnotationDensityPlotDialog.Export"));
        this.buttonExport.addActionListener(this);
        this.buttonClose = new JButton(ElanLocale.getString("AnnotationDensityPlotDialog.Close"));
        this.buttonClose.addActionListener(this);
        panel.add(this.buttonUpdate);
        panel.add(this.buttonExport);
        panel.add(this.buttonClose);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.buttonClose) {
            this.savePreferences();
            this.setVisible(false);
        } else if (evt.getSource() == this.buttonUpdate) {
            this.readAndUpdate();
        } else if (evt.getSource() == this.buttonExport) {
            this.exportImage();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.checkFill) {
            if (evt.getStateChange() == 1) {
                this.textTier.setEnabled(false);
            } else {
                this.textTier.setEnabled(true);
            }
        }
    }

    private void readAndUpdate() {
        int prevColumnWidth = this.columnWidth;
        int prevWidth = this.imageWidth;
        int prevHeight = this.imageHeight;
        int prevTierHeight = this.tierHeight;
        int prevTierMargin = this.tierMargin;
        try {
            this.columnWidth = Integer.parseInt(this.textColumn.getText());
        }
        catch (NumberFormatException e) {
            this.columnWidth = prevColumnWidth;
        }
        try {
            this.imageWidth = Integer.parseInt(this.textWidth.getText());
            this.imageWidth -= this.columnWidth;
        }
        catch (NumberFormatException e) {
            this.imageWidth = prevWidth;
        }
        try {
            this.imageHeight = Integer.parseInt(this.textHeight.getText());
        }
        catch (NumberFormatException e) {
            this.imageHeight = prevHeight;
        }
        try {
            this.tierHeight = Integer.parseInt(this.textTier.getText());
        }
        catch (NumberFormatException e) {
            this.tierHeight = prevTierHeight;
        }
        try {
            this.tierMargin = Integer.parseInt(this.textMargin.getText());
        }
        catch (NumberFormatException e) {
            this.tierMargin = prevTierMargin;
        }
        this.limitSelection = this.checkSelection.isSelected();
        this.includeOutlines = this.checkOutlines.isSelected();
        this.fillOut = this.checkFill.isSelected();
        this.computeFirstTimePoint();
        this.computeLastTimePoint();
        int spWidth = this.scrollPane.getWidth();
        int spHeight = this.scrollPane.getHeight();
        int dpWidth = this.columnWidth + this.imageWidth > spWidth ? this.columnWidth + this.imageWidth : spWidth;
        int dpHeight = this.imageHeight > spHeight ? this.imageHeight : spHeight;
        this.densityPanel.setPreferredSize(new Dimension(dpWidth - 2, dpHeight - 2));
        this.densityPanel.revalidate();
        this.densityPanel.repaint();
    }

    private void exportImage() {
        this.readAndUpdate();
        FileChooser chooser = new FileChooser(this);
        String[] extensions = new String[]{"png"};
        chooser.createAndShowFileDialog(ElanLocale.getString("AnnotationDensityPlotDialog.Export.Location"), 1, extensions, "AnnotationDensityPlotDialog.Current.Directory");
        File file = chooser.getSelectedFile();
        if (file != null) {
            BufferedImage buffimg = new BufferedImage(this.columnWidth + this.imageWidth, this.imageHeight, 1);
            this.drawPlot(buffimg.getGraphics(), true);
            try {
                ImageIO.write((RenderedImage)buffimg, "png", file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean withinSelection(Annotation ann) {
        if (this.selection == null) {
            return false;
        }
        return this.selection.getBeginTime() <= ann.getBeginTimeBoundary() && ann.getEndTimeBoundary() <= this.selection.getEndTime();
    }

    private String cutoffTier(Graphics g, String s) {
        FontMetrics fm = g.getFontMetrics();
        if (fm.stringWidth(s) + 20 <= this.columnWidth) {
            return s;
        }
        Object r = "";
        String d = "...";
        int dw = fm.stringWidth(d);
        for (int i = 0; i < s.length(); ++i) {
            int w = fm.stringWidth(s.substring(0, i + 1));
            if (w >= this.columnWidth - 20 - dw) continue;
            r = (String)r + s.charAt(i);
        }
        return (String)r + d;
    }

    public void drawPlot(Graphics g, boolean image) {
        int i;
        int delta;
        if (this.transcription == null) {
            return;
        }
        if (g instanceof Graphics2D && SystemReporting.antiAliasedText) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int spWidth = this.scrollPane.getWidth();
        int spHeight = this.scrollPane.getHeight();
        int offsetX = 0;
        int offsetY = 0;
        if (!image) {
            offsetX = spWidth <= this.columnWidth + this.imageWidth ? 0 : (spWidth - (this.columnWidth + this.imageWidth)) / 2;
            offsetY = spHeight <= this.imageHeight ? 0 : (spHeight - this.imageHeight) / 2;
        }
        g.setColor(Color.white);
        g.fillRect(offsetX, offsetY, this.columnWidth + this.imageWidth, this.imageHeight);
        g.setColor(Color.black);
        List<? extends Tier> tiers = this.transcription.getTiers();
        List<String> selected = this.tiersPanel.getSelectedTiers();
        if (tiers == null || tiers.size() == 0 || selected == null || selected.size() == 0) {
            g.drawString(ElanLocale.getString("AnnotationDensityPlotDialog.No.Tiers"), offsetX + 10, offsetY + 20);
            return;
        }
        int count = selected.size();
        int n = delta = this.fillOut ? this.imageHeight / count : this.tierHeight;
        if (!this.fillOut && count * delta > this.imageHeight) {
            g.drawString(ElanLocale.getString("AnnotationDensityPlotDialog.No.Fit"), offsetX + 10, offsetY + 20);
            return;
        }
        if (delta < 5) {
            g.drawString(ElanLocale.getString("AnnotationDensityPlotDialog.5px.Tier"), offsetX + 10, offsetY + 20);
            return;
        }
        int fontSize = Math.min(Math.max(12, delta / 4), 16);
        g.setFont(g.getFont().deriveFont((float)fontSize));
        if (this.columnWidth > 0) {
            for (i = 0; i < count; ++i) {
                g.drawString(this.cutoffTier(g, selected.get(i)), offsetX + 10, offsetY + (i + 1) * delta - delta / 2 + fontSize / 2);
            }
        }
        for (i = 0; i < selected.size(); ++i) {
            Tier tier = this.retrieveTier(selected.get(i), tiers);
            if (tier == null) continue;
            List<? extends Annotation> annotations = tier.getAnnotations();
            ControlledVocabulary cv = null;
            String cvName = tier.getLinguisticType().getControlledVocabularyName();
            if (cvName != null) {
                cv = this.transcription.getControlledVocabulary(cvName);
            }
            if (this.colorMap != null && this.colorMap.containsKey(tier.getName())) {
                g.setColor(this.colorMap.get(tier.getName()));
            } else if (this.colorMap != null && tier.hasParentTier() && this.colorMap.containsKey(tier.getParentTier().getName())) {
                g.setColor(this.colorMap.get(tier.getParentTier().getName()));
            } else if (this.colorMap != null && this.colorMap.containsKey(tier.getRootTier().getName())) {
                g.setColor(this.colorMap.get(tier.getRootTier().getName()));
            } else {
                g.setColor(Color.GRAY);
            }
            Color ct = g.getColor();
            for (int j = 0; j < annotations.size(); ++j) {
                Annotation annot = annotations.get(j);
                if (this.limitSelection && !this.withinSelection(annot)) continue;
                int begin = (int)annot.getBeginTimeBoundary();
                begin = this.columnWidth + (int)((double)this.imageWidth * (double)(begin - this.first) / (double)(this.last - this.first));
                int end = (int)annot.getEndTimeBoundary();
                end = this.columnWidth + (int)((double)this.imageWidth * (double)(end - this.first) / (double)(this.last - this.first));
                Color ca = this.getAnnColor(cv, annot);
                if (ca != null) {
                    g.setColor(ca);
                }
                g.fillRect(offsetX + begin, offsetY + i * delta + this.tierMargin, end - begin, delta - 2 * this.tierMargin);
                if (this.includeOutlines && end - begin >= 3) {
                    g.setColor(Color.DARK_GRAY);
                    g.drawLine(offsetX + begin, offsetY + i * delta + this.tierMargin, offsetX + begin, offsetY + i * delta + delta - this.tierMargin - 1);
                    g.drawLine(offsetX + end, offsetY + i * delta + this.tierMargin, offsetX + end, offsetY + i * delta + delta - this.tierMargin - 1);
                    g.setColor(ct);
                }
                g.setColor(ct);
            }
        }
        if (this.includeOutlines) {
            g.setColor(Color.BLACK);
            if (this.columnWidth > 0) {
                g.drawLine(offsetX + this.columnWidth, offsetY, offsetX + this.columnWidth, offsetY + Math.min(this.imageHeight, delta * count));
            }
            for (i = 0; i <= count; ++i) {
                g.drawLine(offsetX, offsetY + i * delta, offsetX + this.columnWidth + this.imageWidth, offsetY + i * delta);
            }
        }
    }

    private void computeFirstTimePoint() {
        List<? extends Tier> tiers = this.transcription.getTiers();
        this.first = 1000000000;
        for (int i = 0; i < tiers.size(); ++i) {
            List<? extends Annotation> annotations = tiers.get(i).getAnnotations();
            for (int j = 0; j < annotations.size(); ++j) {
                Annotation annot = annotations.get(j);
                if (this.limitSelection && !this.withinSelection(annot)) continue;
                this.first = Math.min(this.first, (int)annot.getBeginTimeBoundary());
            }
        }
    }

    private void computeLastTimePoint() {
        List<? extends Tier> tiers = this.transcription.getTiers();
        this.last = 0;
        for (int i = 0; i < tiers.size(); ++i) {
            List<? extends Annotation> annotations = tiers.get(i).getAnnotations();
            for (int j = 0; j < annotations.size(); ++j) {
                Annotation annot = annotations.get(j);
                if (this.limitSelection && !this.withinSelection(annot)) continue;
                this.last = Math.max(this.last, (int)annot.getEndTimeBoundary());
            }
        }
    }

    private Tier retrieveTier(String name, List<? extends Tier> tiers) {
        for (int i = 0; i < tiers.size(); ++i) {
            if (!tiers.get(i).getName().equals(name)) continue;
            return tiers.get(i);
        }
        return null;
    }

    private Color getAnnColor(ControlledVocabulary cv, Annotation annot) {
        CVEntry cve;
        String id;
        if (cv != null && (id = annot.getCVEntryId()) != null && (cve = cv.getEntrybyId(id)) != null) {
            return cve.getPrefColor();
        }
        return null;
    }

    private void loadPreferences() {
        Boolean boolPref = null;
        String strPref = null;
        boolPref = Preferences.getBool("AnnotationDensityPlotDialog.checkSelection", null);
        if (boolPref != null) {
            this.checkSelection.setSelected(boolPref);
        }
        if ((strPref = Preferences.getString("AnnotationDensityPlotDialog.textWidth", null)) != null) {
            this.textWidth.setText(strPref);
        }
        if ((strPref = Preferences.getString("AnnotationDensityPlotDialog.textHeight", null)) != null) {
            this.textHeight.setText(strPref);
        }
        if ((strPref = Preferences.getString("AnnotationDensityPlotDialog.textColumn", null)) != null) {
            this.textColumn.setText(strPref);
        }
        if ((strPref = Preferences.getString("AnnotationDensityPlotDialog.textTier", null)) != null) {
            this.textTier.setText(strPref);
        }
        if ((strPref = Preferences.getString("AnnotationDensityPlotDialog.textMargin", null)) != null) {
            this.textMargin.setText(strPref.toString());
        }
        if ((boolPref = Preferences.getBool("AnnotationDensityPlotDialog.checkOutlines", null)) != null) {
            this.checkOutlines.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("AnnotationDensityPlotDialog.checkFill", null)) != null) {
            this.checkFill.setSelected(boolPref);
        }
    }

    private void savePreferences() {
        Preferences.set("AnnotationDensityPlotDialog.checkSelection", this.checkSelection.isSelected(), null, false, false);
        Preferences.set("AnnotationDensityPlotDialog.textWidth", this.textWidth.getText(), null, false, false);
        Preferences.set("AnnotationDensityPlotDialog.textHeight", this.textHeight.getText(), null, false, false);
        Preferences.set("AnnotationDensityPlotDialog.textColumn", this.textColumn.getText(), null, false, false);
        Preferences.set("AnnotationDensityPlotDialog.textTier", this.textTier.getText(), null, false, false);
        Preferences.set("AnnotationdensityPlotDialog.textMargin", this.textMargin.getText(), null, false, false);
        Preferences.set("AnnotationDensityPlotDialog.checkOutlines", this.checkOutlines.isSelected(), null, false, false);
        Preferences.set("AnnotationDensityPlotDialog.checkFill", this.checkFill.isSelected(), null, false, false);
    }
}

