/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.gui.AudioSpectrogramPanel;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.util.WAVSampler;
import mpi.eudico.client.util.WAVSamplesProvider;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class AudioSpectrogramDialog
extends ClosableDialog
implements ActionListener {
    private Transcription transcription;
    private AudioSpectrogramPanel spectrogram;
    private JButton buttonClose;
    private JButton buttonGenerate;
    private JTextField textBegin;
    private JTextField textEnd;
    private JComboBox comboFile;

    public AudioSpectrogramDialog(Frame owner, Transcription transcription) throws HeadlessException {
        super(owner, true);
        this.transcription = transcription;
        this.spectrogram = new AudioSpectrogramPanel();
        this.spectrogram.setBackground(Color.WHITE);
        this.spectrogram.setPreferredSize(new Dimension(800, 500));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.createTitlePanel());
        this.getContentPane().add(this.createIntervalPanel());
        this.getContentPane().add(this.createSpectrogramPanel());
        this.getContentPane().add(this.createButtonPanel());
        this.setTitle("Audio Spectrogram");
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel();
        JLabel titleLabel = new JLabel("Audio Spectrogram");
        titleLabel.setFont(titleLabel.getFont().deriveFont(16.0f));
        titlePanel.add(titleLabel);
        return titlePanel;
    }

    private String[] getAudioFiles() {
        int i;
        List<MediaDescriptor> media = this.transcription.getMediaDescriptors();
        int c = 0;
        int n = 0;
        String[] files = null;
        for (i = 0; i < media.size(); ++i) {
            if (!media.get((int)i).mimeType.equals("audio/x-wav")) continue;
            ++c;
        }
        if (c == 0) {
            return null;
        }
        files = new String[c];
        for (i = 0; i < c; ++i) {
            if (media.get((int)i).mimeType.equals("audio/x-wav")) {
                files[n] = media.get((int)i).mediaURL.substring(8);
            }
            ++n;
        }
        return files;
    }

    private JPanel createIntervalPanel() {
        JPanel intervalPanel = new JPanel();
        String[] empty = new String[]{"No audio files"};
        String[] files = this.getAudioFiles();
        this.textBegin = new JTextField(10);
        this.textBegin.setHorizontalAlignment(4);
        this.textBegin.setText("0");
        this.textEnd = new JTextField(10);
        this.textEnd.setHorizontalAlignment(4);
        this.textEnd.setText("0");
        this.comboFile = new JComboBox<String>(files == null ? empty : files);
        intervalPanel.setBorder(new TitledBorder("Time Interval"));
        intervalPanel.add(new JLabel("Audio file:"));
        intervalPanel.add(this.comboFile);
        intervalPanel.add(new JLabel("Begin: "));
        intervalPanel.add(this.textBegin);
        intervalPanel.add(new JLabel(" End: "));
        intervalPanel.add(this.textEnd);
        return intervalPanel;
    }

    private JPanel createSpectrogramPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Audio Spectrogram Rendering"));
        panel.add(new JScrollPane(this.spectrogram));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        this.buttonGenerate = new JButton("Generate");
        this.buttonGenerate.addActionListener(this);
        this.buttonClose = new JButton("Close");
        this.buttonClose.addActionListener(this);
        panel.add(this.buttonGenerate);
        panel.add(this.buttonClose);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.buttonClose) {
            this.setVisible(false);
        }
        if (evt.getSource() == this.buttonGenerate) {
            System.out.println("Selected file: " + this.comboFile.getSelectedItem());
            WAVSamplesProvider sampler = null;
            try {
                sampler = new WAVSampler((String)this.comboFile.getSelectedItem());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Audio duration: " + sampler.getDuration());
            System.out.println("Sample frequency: " + sampler.getSampleFrequency());
            sampler.readInterval(1000, 1);
            int[] vals = sampler.getChannelArray(0);
            for (int i = 0; i < vals.length; ++i) {
                System.out.println("vals [" + Integer.toString(i) + "] = " + Integer.toString(vals[i]));
            }
        }
    }

    public static double[] fft(double[] ra, double[] ia) {
        double imag;
        double real;
        int n = ra.length;
        int nu = (int)(Math.log(n) / Math.log(2.0));
        int d = n / 2;
        int m = nu - 1;
        int k = 0;
        int r = 0;
        for (int l = 1; l <= nu; ++l) {
            while (k < n) {
                for (int i = 1; i <= d; ++i) {
                    double p = AudioSpectrogramDialog.revbits(k >> m, nu);
                    double arg = Math.PI * -2 * p / (double)n;
                    double c = Math.cos(arg);
                    double s = Math.sin(arg);
                    real = ra[k + d] * c + ra[k + d] * s;
                    imag = ia[k + d] * c - ia[k + d] * s;
                    ra[k + d] = ra[k] - real;
                    ia[k + d] = ia[k] - imag;
                    ra[k] = ra[k] + real;
                    ia[k] = ia[k] + imag;
                    ++k;
                }
                k += d;
            }
            k = 0;
            --m;
            d /= 2;
        }
        while (k < n) {
            r = AudioSpectrogramDialog.revbits(k, nu);
            if (r > k) {
                real = ra[k];
                imag = ia[k];
                ra[k] = ra[r];
                ia[k] = ia[r];
                ra[r] = real;
                ia[r] = imag;
            }
            ++k;
        }
        double[] newArray = new double[2 * n];
        double rad = 1.0 / Math.sqrt(n);
        for (int i = 0; i < newArray.length; i += 2) {
            int i2 = i / 2;
            newArray[i] = ra[i / 2] * rad;
            newArray[i + 1] = ia[i / 2] * rad;
        }
        return newArray;
    }

    private static int revbits(int j, int nu) {
        int j1 = j;
        int k = 0;
        for (int i = 1; i <= nu; ++i) {
            int j2 = j1 / 2;
            k = 2 * k + j1 - 2 * j2;
            j1 = j2;
        }
        return k;
    }
}

