/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import mpi.eudico.util.CVEntry;

public class CVEntryListCellRenderer
extends DefaultListCellRenderer {
    private CVEIcon icon = new CVEIcon();

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof CVEntry) {
            this.icon.color = ((CVEntry)value).getPrefColor();
            int code = ((CVEntry)value).getShortcutKeyCode();
            this.icon.s = code == -1 ? null : KeyEvent.getKeyText(code);
        } else {
            this.icon.color = null;
            this.icon.s = null;
        }
        this.setIcon(this.icon);
        this.setHorizontalTextPosition(4);
        return this;
    }

    private class CVEIcon
    extends ImageIcon {
        int width = 20;
        Color color;
        String s;

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            if (this.color != null) {
                g.setColor(this.color);
                g.fillRect(x, y, this.width, c.getHeight());
            }
            if (this.s != null) {
                g.setColor(c.getForeground());
                g.setFont(c.getFont());
                int sw = c.getFontMetrics(c.getFont()).stringWidth(this.s);
                g.drawString(this.s, x + (this.width - sw) / 2, c.getHeight() - (c.getHeight() - c.getFont().getSize()) / 2 - 1);
            }
        }

        @Override
        public int getIconHeight() {
            return CVEntryListCellRenderer.this.getHeight() - 4;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }
    }
}

