/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.AdvancedTierOptionsDialog;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.prefs.gui.RecentLanguagesBox;
import mpi.eudico.client.annotator.tier.TierTableModel;
import mpi.eudico.client.im.ImUtil;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.EmptyStringComparator;
import nl.mpi.util.FileExtension;

public class EditTierDialog2
extends ClosableDialog
implements ActionListener,
ItemListener,
ChangeListener,
ListSelectionListener {
    public static final int ADD = 0;
    public static final int CHANGE = 1;
    public static final int DELETE = 2;
    public static final int IMPORT = 3;
    private final String none = "none";
    private TranscriptionImpl transcription;
    private TierImpl tier = null;
    private Tier oldParentTier;
    private String oldTierName;
    private String oldParentTierName;
    private String oldParticipant;
    private String oldAnnotator;
    private LinguisticType oldLingType;
    private Locale oldLocale;
    private Locale[] langs;
    private int mode = 0;
    private boolean singleEditMode = false;
    private List<TierImpl> tiers;
    private JLabel titleLabel;
    private JPanel tablePanel;
    private JTable tierTable;
    private TierTableModel model;
    private JTabbedPane tabPane;
    private JPanel editPanel;
    private JLabel selectTierLabel;
    private JLabel tierNameLabel;
    private JComboBox currentTiersComboBox;
    private JTextField tierNameTextField;
    private JLabel participantLabel;
    private JTextField participantTextField;
    private JLabel annotatorLabel;
    private JTextField annotatorTextField;
    private JLabel lingTypeLabel;
    private JComboBox lingTypeComboBox;
    private JLabel parentLabel;
    private JComboBox parentComboBox;
    private JLabel languageLabel;
    private JComboBox languageComboBox;
    private JLabel mlLanguageLabel;
    private RecentLanguagesBox mlLanguageBox;
    private JButton advancedButton;
    private HashMap<String, Object> currentProps = new HashMap(10);
    private JPanel importPanel;
    private JLabel importSourceLabel;
    private JTextField importSourceTF;
    private JButton importSourceButton;
    private JButton changeButton;
    private JButton cancelButton;
    private JPanel buttonPanel;

    public EditTierDialog2(Frame parentFrame, boolean modal, Transcription theTranscription, int editMode, TierImpl tier) {
        super(parentFrame, modal);
        this.transcription = (TranscriptionImpl)theTranscription;
        if (editMode >= 0 && editMode <= 3) {
            this.mode = editMode;
        }
        this.initComponents();
        this.extractCurrentTiers();
        if (tier != null) {
            this.tier = tier;
            String name = tier.getName();
            this.singleEditMode = true;
            if (this.currentTiersComboBox != null) {
                this.currentTiersComboBox.setSelectedItem(name);
            }
        }
        this.updateLanguageComboBox();
        this.updateLocale();
        this.updateForMode();
        this.updateUIForTier((String)this.currentTiersComboBox.getSelectedItem());
        this.postInit();
        if (editMode == 0) {
            this.tierNameTextField.requestFocus();
        } else if (editMode == 3) {
            this.editPanel.setVisible(false);
            this.importSourceButton.requestFocus();
        } else {
            this.currentTiersComboBox.requestFocus();
        }
    }

    private void initComponents() {
        this.langs = ImUtil.getLanguages(this);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new GridBagLayout());
        this.model = new TierTableModel(this.transcription.getTiers());
        this.tierTable = new JTable(this.model);
        this.tierTable.setSelectionMode(0);
        TableRowSorter<TierTableModel> rowSorter = new TableRowSorter<TierTableModel>(this.model);
        EmptyStringComparator emptyComp = new EmptyStringComparator();
        for (int i = 1; i < this.tierTable.getColumnCount(); ++i) {
            rowSorter.setComparator(i, emptyComp);
        }
        this.tierTable.setRowSorter(rowSorter);
        JScrollPane tableScrollPane = new JScrollPane(this.tierTable);
        Dimension size = new Dimension(300, 120);
        tableScrollPane.setMinimumSize(size);
        tableScrollPane.setPreferredSize(size);
        this.tabPane = new JTabbedPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.titleLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.tablePanel.add((Component)tableScrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.tablePanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 6, 6, 6);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.tabPane, gbc);
        this.editPanel = new JPanel(new GridBagLayout());
        this.selectTierLabel = new JLabel();
        this.currentTiersComboBox = new JComboBox();
        this.currentTiersComboBox.setMaximumRowCount(20);
        this.tierNameLabel = new JLabel();
        this.tierNameTextField = new JTextField();
        this.participantLabel = new JLabel();
        this.participantTextField = new JTextField();
        this.annotatorLabel = new JLabel();
        this.annotatorTextField = new JTextField();
        this.lingTypeLabel = new JLabel();
        this.lingTypeComboBox = new JComboBox();
        this.parentLabel = new JLabel();
        this.parentComboBox = new JComboBox();
        this.languageLabel = new JLabel();
        this.languageComboBox = new JComboBox();
        this.mlLanguageLabel = new JLabel();
        this.mlLanguageBox = new RecentLanguagesBox(null);
        this.mlLanguageBox.addNoLanguageItem();
        this.advancedButton = new JButton();
        GridBagConstraints lgbc = new GridBagConstraints();
        lgbc.anchor = 17;
        lgbc.insets = insets;
        this.editPanel.add((Component)this.selectTierLabel, lgbc);
        GridBagConstraints rgbc = new GridBagConstraints();
        rgbc.gridx = 1;
        rgbc.fill = 2;
        rgbc.anchor = 17;
        rgbc.insets = insets;
        rgbc.weightx = 1.0;
        this.editPanel.add((Component)this.currentTiersComboBox, rgbc);
        lgbc.gridy = 1;
        this.editPanel.add((Component)this.tierNameLabel, lgbc);
        rgbc.gridy = 1;
        this.editPanel.add((Component)this.tierNameTextField, rgbc);
        lgbc.gridy = 2;
        this.editPanel.add((Component)this.participantLabel, lgbc);
        rgbc.gridy = 2;
        this.editPanel.add((Component)this.participantTextField, rgbc);
        lgbc.gridy = 3;
        this.editPanel.add((Component)this.annotatorLabel, lgbc);
        rgbc.gridy = 3;
        this.editPanel.add((Component)this.annotatorTextField, rgbc);
        lgbc.gridy = 4;
        this.editPanel.add((Component)this.parentLabel, lgbc);
        rgbc.gridy = 4;
        this.editPanel.add((Component)this.parentComboBox, rgbc);
        lgbc.gridy = 5;
        this.editPanel.add((Component)this.lingTypeLabel, lgbc);
        rgbc.gridy = 5;
        this.editPanel.add((Component)this.lingTypeComboBox, rgbc);
        lgbc.gridy = 6;
        this.editPanel.add((Component)this.languageLabel, lgbc);
        rgbc.gridy = 6;
        this.editPanel.add((Component)this.languageComboBox, rgbc);
        lgbc.gridy = 7;
        this.editPanel.add((Component)this.mlLanguageLabel, lgbc);
        rgbc.gridy = 7;
        this.editPanel.add((Component)this.mlLanguageBox, rgbc);
        lgbc.gridy = 8;
        this.editPanel.add((Component)this.advancedButton, lgbc);
        this.importPanel = new JPanel(new GridBagLayout());
        this.importSourceLabel = new JLabel();
        this.importSourceTF = new JTextField();
        this.importSourceTF.setEditable(false);
        this.importSourceButton = new JButton();
        this.importSourceButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.importPanel.add((Component)this.importSourceLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.importPanel.add((Component)this.importSourceTF, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = insets;
        this.importPanel.add((Component)this.importSourceButton, gbc);
        this.tabPane.addTab(ElanLocale.getString("Button.Add"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Change"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Delete"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Import"), this.importPanel);
        if (this.mode < 3) {
            this.tabPane.setComponentAt(this.mode, this.editPanel);
        } else {
            this.tabPane.setComponentAt(0, this.editPanel);
        }
        this.tabPane.setSelectedIndex(this.mode);
        this.tabPane.addChangeListener(this);
        this.advancedButton.addActionListener(this);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.changeButton = new JButton();
        this.changeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.changeButton);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
    }

    private void postInit() {
        this.pack();
        int w = 550;
        int h = 400;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateLocale() {
        this.tablePanel.setBorder(new TitledBorder(ElanLocale.getString("EditTierDialog.Label.CurrentTiers")));
        this.tierNameLabel.setText(ElanLocale.getString("EditTierDialog.Label.TierName"));
        this.participantLabel.setText(ElanLocale.getString("EditTierDialog.Label.Participant"));
        this.annotatorLabel.setText(ElanLocale.getString("EditTierDialog.Label.Annotator"));
        this.lingTypeLabel.setText(ElanLocale.getString("EditTierDialog.Label.LinguisticType"));
        this.parentLabel.setText(ElanLocale.getString("EditTierDialog.Label.Parent"));
        this.languageLabel.setText(ElanLocale.getString("EditTierDialog.Label.Language"));
        this.mlLanguageLabel.setText(ElanLocale.getString("EditTierDialog.Label.ContentLanguage"));
        this.cancelButton.setText(ElanLocale.getString("Button.Close"));
        this.importSourceLabel.setText("<html>" + ElanLocale.getString("EditTierDialog.Label.ImportSource") + "</html>");
        this.importSourceButton.setText(ElanLocale.getString("Button.Browse"));
        this.advancedButton.setText(ElanLocale.getString("EditTierDialog.Label.Advanced"));
    }

    private void updateForMode() {
        switch (this.mode) {
            case 0: {
                this.tierTable.setSelectionMode(0);
                this.setTitle(ElanLocale.getString("EditTierDialog.Title.Add"));
                this.selectTierLabel.setText("");
                this.currentTiersComboBox.setEnabled(false);
                this.changeButton.setText(ElanLocale.getString("Button.Add"));
                this.parentComboBox.setEnabled(true);
                this.tierNameTextField.setEditable(true);
                this.participantTextField.setEditable(true);
                this.annotatorTextField.setEditable(true);
                this.lingTypeComboBox.setEnabled(true);
                this.languageComboBox.setEnabled(true);
                this.mlLanguageBox.setEnabled(true);
                this.tierNameTextField.setText("");
                this.participantTextField.setText("");
                this.annotatorTextField.setText("");
                this.advancedButton.setEnabled(true);
                break;
            }
            case 1: {
                this.tierTable.setSelectionMode(0);
                this.setTitle(ElanLocale.getString("EditTierDialog.Title.Change"));
                this.selectTierLabel.setText(ElanLocale.getString("EditTierDialog.Label.ChangeTier"));
                this.selectTierLabel.setVisible(true);
                this.currentTiersComboBox.setEnabled(true);
                this.currentTiersComboBox.setVisible(true);
                this.currentTiersComboBox.requestFocus();
                this.changeButton.setText(ElanLocale.getString("Button.Change"));
                this.parentComboBox.setEnabled(false);
                this.tierNameTextField.setEditable(true);
                this.participantTextField.setEditable(true);
                this.annotatorTextField.setEditable(true);
                this.lingTypeComboBox.setEnabled(true);
                this.languageComboBox.setEnabled(true);
                this.mlLanguageBox.setEnabled(true);
                this.advancedButton.setEnabled(true);
                break;
            }
            case 2: {
                this.tierTable.setSelectionMode(2);
                this.setTitle(ElanLocale.getString("EditTierDialog.Title.Delete"));
                this.selectTierLabel.setText(ElanLocale.getString("EditTierDialog.Label.DeleteTier"));
                this.changeButton.setText(ElanLocale.getString("Button.Delete"));
                this.tierNameTextField.setEditable(false);
                this.participantTextField.setEditable(false);
                this.annotatorTextField.setEditable(false);
                this.parentComboBox.setEnabled(false);
                this.lingTypeComboBox.setEnabled(false);
                this.languageComboBox.setEnabled(false);
                this.mlLanguageBox.setEnabled(false);
                this.selectTierLabel.setVisible(true);
                this.currentTiersComboBox.setEnabled(true);
                this.currentTiersComboBox.setVisible(true);
                this.currentTiersComboBox.requestFocus();
                this.advancedButton.setEnabled(false);
                break;
            }
            case 3: {
                this.tierTable.setSelectionMode(0);
                this.setTitle(ElanLocale.getString("EditTierDialog.Title.Import"));
                this.changeButton.setText(ElanLocale.getString("Button.Import"));
                this.changeButton.requestFocus();
            }
        }
        this.titleLabel.setText(this.getTitle());
    }

    private void extractCurrentTiers() {
        this.currentTiersComboBox.removeItemListener(this);
        this.currentTiersComboBox.removeAllItems();
        this.tiers = this.transcription.getTiers();
        if (this.tiers == null) {
            this.tiers = new ArrayList<TierImpl>();
            return;
        }
        for (TierImpl t : this.tiers) {
            this.currentTiersComboBox.addItem(t.getName());
        }
        if (this.currentTiersComboBox.getItemCount() > 0) {
            this.currentTiersComboBox.setSelectedIndex(0);
            this.tier = this.tiers.get(0);
        }
        this.currentTiersComboBox.addItemListener(this);
    }

    private void reextractTiers() {
        this.extractCurrentTiers();
        if (this.currentTiersComboBox.getItemCount() > 0) {
            this.currentTiersComboBox.setSelectedIndex(0);
            String name = (String)this.currentTiersComboBox.getSelectedItem();
            this.updateUIForTier(name);
        } else {
            this.tierNameTextField.setText("");
            this.participantTextField.setText("");
            this.annotatorTextField.setText("");
        }
        if (this.mode == 0) {
            this.tierNameTextField.setText("");
            this.participantTextField.setText("");
            this.annotatorTextField.setText("");
        }
        if (this.model != null) {
            this.tierTable.getSelectionModel().removeListSelectionListener(this);
            this.model.removeAllRows();
            for (TierImpl t : this.tiers) {
                this.model.addRow(t);
            }
            this.tierTable.getSelectionModel().addListSelectionListener(this);
        }
    }

    private void fillLingTypeMenu() {
        LinguisticType type;
        TierImpl t2;
        this.lingTypeComboBox.removeItemListener(this);
        this.lingTypeComboBox.removeAllItems();
        int curStereoType = -1;
        boolean onlySameStereo = false;
        boolean onlyTimeAlignable = false;
        boolean excludeTimeAlignable = false;
        if (this.mode == 1) {
            int size;
            if (this.tier != null && this.tier.getNumberOfAnnotations() > 0) {
                onlySameStereo = true;
            }
            if (this.tier != null && this.tier.getLinguisticType().getConstraints() != null) {
                curStereoType = this.tier.getLinguisticType().getConstraints().getStereoType();
            }
            if (!onlySameStereo && curStereoType >= 0 && (size = this.tier.getDependentTiers().size()) > 0) {
                for (int i = 0; i < size; ++i) {
                    TierImpl ch = this.tier.getDependentTiers().get(i);
                    if (!ch.isTimeAlignable()) continue;
                    onlyTimeAlignable = true;
                    break;
                }
            }
        }
        TierImpl parentTier = this.transcription.getTierWithId((String)this.parentComboBox.getSelectedItem());
        Constraint parentConstraint = null;
        if (parentTier != null && (parentConstraint = parentTier.getLinguisticType().getConstraints()) != null && (parentConstraint.getStereoType() == 3 || parentConstraint.getStereoType() == 4)) {
            excludeTimeAlignable = true;
        }
        for (LinguisticType lt : this.transcription.getLinguisticTypes()) {
            String ltName = lt.getLinguisticTypeName();
            if (parentTier == null && lt.getConstraints() != null || excludeTimeAlignable && lt.getConstraints() != null && (lt.getConstraints().getStereoType() == 0 || lt.getConstraints().getStereoType() == 1) || parentTier != null && lt.getConstraints() == null || onlySameStereo && lt.getConstraints() != null && lt.getConstraints().getStereoType() != curStereoType || onlyTimeAlignable && lt.getConstraints() != null && lt.getConstraints().getStereoType() != 0 && lt.getConstraints().getStereoType() != 1) continue;
            this.lingTypeComboBox.addItem(ltName);
        }
        String tierName = (String)this.currentTiersComboBox.getSelectedItem();
        if (tierName != null && (t2 = this.transcription.getTierWithId(tierName)) != null && (type = t2.getLinguisticType()) != null) {
            this.lingTypeComboBox.setSelectedItem(type.getLinguisticTypeName());
        }
        this.lingTypeComboBox.addItemListener(this);
        if (this.lingTypeComboBox.getModel().getSize() <= 0) {
            this.changeButton.setEnabled(false);
        } else {
            this.changeButton.setEnabled(true);
        }
    }

    private void fillParentComboBox() {
        this.parentComboBox.removeItemListener(this);
        this.parentComboBox.removeAllItems();
        this.parentComboBox.addItem("none");
        if (this.tier != null && this.mode != 0) {
            List<Tier> candidateParents = this.getCandidateParentTiers(this.tier);
            for (Tier t : candidateParents) {
                this.parentComboBox.addItem(t.getName());
            }
            if (this.tier.hasParentTier()) {
                this.parentComboBox.setSelectedItem(this.tier.getParentTier().getName());
            }
        } else if (this.mode == 0) {
            for (TierImpl t : this.tiers) {
                this.parentComboBox.addItem(t.getName());
            }
            this.parentComboBox.setSelectedItem("none");
        }
        this.parentComboBox.addItemListener(this);
    }

    private List<Tier> getCandidateParentTiers(TierImpl child) {
        ArrayList<Tier> parents;
        block5: {
            int stereoType;
            block4: {
                if (child == null) {
                    return null;
                }
                parents = new ArrayList<Tier>();
                Constraint c = child.getLinguisticType().getConstraints();
                if (c == null) {
                    return parents;
                }
                stereoType = c.getStereoType();
                if (stereoType != 4 && stereoType != 3) break block4;
                for (TierImpl t : this.tiers) {
                    if (t == child) continue;
                    parents.add(t);
                }
                break block5;
            }
            if (stereoType != 0 && stereoType != 1) break block5;
            for (TierImpl t : this.tiers) {
                if (t == child || t.getLinguisticType().getConstraints() != null && t.getLinguisticType().getConstraints().getStereoType() != 0 && t.getLinguisticType().getConstraints().getStereoType() != 1) continue;
                parents.add(t);
            }
        }
        return parents;
    }

    private void updateLanguageComboBox() {
        if (this.languageComboBox.getItemCount() == 0) {
            if (this.langs != null) {
                for (int i = 0; i < this.langs.length; ++i) {
                    if (i == 0 && this.langs[i] == Locale.getDefault()) {
                        this.languageComboBox.addItem(this.langs[i].getDisplayName() + " (System default)");
                        continue;
                    }
                    this.languageComboBox.addItem(this.langs[i].getDisplayName());
                }
            }
            String none = ElanLocale.getString("EditTierDialog.Label.None");
            this.languageComboBox.insertItemAt(none, 0);
            this.languageComboBox.setSelectedIndex(0);
        }
        if (this.tier != null) {
            Locale l = this.tier.getDefaultLocale();
            if (l != null) {
                if (l.equals(Locale.getDefault()) && ((String)this.languageComboBox.getItemAt(1)).startsWith(l.getDisplayName())) {
                    this.languageComboBox.setSelectedIndex(1);
                } else {
                    this.languageComboBox.setSelectedItem(l.getDisplayName());
                }
            } else {
                this.languageComboBox.setSelectedIndex(0);
            }
        }
    }

    void updateMultiLingualComboBox() {
        this.mlLanguageBox.setSelectedItem(this.tier.getLangRef());
    }

    private void updateUIForTier(String name) {
        if (name != null) {
            this.tier = this.transcription.getTierWithId(name);
            if (this.tier != null) {
                if (this.currentTiersComboBox.getSelectedItem() != this.tier.getName()) {
                    this.currentTiersComboBox.setSelectedItem(name);
                }
                this.oldParentTier = this.tier.getParentTier();
                this.oldParentTierName = this.oldParentTier != null ? this.tier.getParentTier().getName() : "none";
                this.oldLingType = this.tier.getLinguisticType();
                this.oldLocale = this.tier.getDefaultLocale();
                this.oldTierName = this.tier.getName();
                this.oldParticipant = this.tier.getParticipant();
                this.oldAnnotator = this.tier.getAnnotator();
                if (this.mode != 0) {
                    this.tierNameTextField.setText(this.oldTierName);
                    this.participantTextField.setText(this.oldParticipant);
                    this.annotatorTextField.setText(this.oldAnnotator);
                    if (this.mode == 1 && this.tier.getNumberOfAnnotations() == 0) {
                        this.parentComboBox.setEnabled(true);
                    }
                }
            }
            this.fillParentComboBox();
            this.fillLingTypeMenu();
            this.updateLanguageComboBox();
            this.updateMultiLingualComboBox();
            if (this.model != null) {
                this.tierTable.getSelectionModel().removeListSelectionListener(this);
                int col = this.model.findColumn("TierName");
                for (int i = 0; i < this.model.getRowCount(); ++i) {
                    if (!name.equals(this.model.getValueAt(i, col))) continue;
                    if (this.tierTable.getSelectionModel().getSelectionMode() == 0) {
                        this.tierTable.getSelectionModel().setLeadSelectionIndex(this.tierTable.convertRowIndexToView(i));
                        break;
                    }
                    this.tierTable.addRowSelectionInterval(this.tierTable.convertRowIndexToView(i), this.tierTable.convertRowIndexToView(i));
                    break;
                }
                this.tierTable.getSelectionModel().addListSelectionListener(this);
            }
        } else {
            this.fillParentComboBox();
            this.fillLingTypeMenu();
        }
    }

    private void doAdd(String tierName, Tier parentTier, String lingType, String participant, String annotator, Locale locale, String langRef) {
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AddNewTier");
        TranscriptionImpl receiver = this.transcription;
        Object[] args = new Object[]{tierName, parentTier, lingType, participant, annotator, locale, langRef};
        c.execute(receiver, args);
        this.applyAttributeSettings();
        this.reextractTiers();
        this.updateUIForTier(null);
    }

    private void doChange(String tierName, Tier parentTier, String lingType, String participant, String annotator, Locale locale, String langRef) {
        this.applyAttributeSettings();
        if (this.tier.getNumberOfAnnotations() > 0) {
            if (parentTier != null && this.oldParentTier == null || parentTier == null && this.oldParentTier != null || parentTier != this.oldParentTier) {
                parentTier = this.oldParentTier;
            }
            if (this.getStereoTypeForTypeName(lingType) != this.getStereoTypeForType(this.oldLingType)) {
                lingType = this.oldLingType.getLinguisticTypeName();
            }
        }
        String oldLangRef = this.tier.getLangRef();
        if (!tierName.equals(this.oldTierName) || parentTier != null && this.oldParentTier != null && parentTier != this.oldParentTier || !lingType.equals(this.oldLingType.getLinguisticTypeName()) || !participant.equals(this.oldParticipant) || !annotator.equals(this.oldAnnotator) || locale == null && this.oldLocale != null || locale != null && locale != this.oldLocale || langRef == null && oldLangRef != null || langRef != null && !langRef.equals(oldLangRef)) {
            Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.ChangeTier");
            TierImpl receiver = this.tier;
            Object[] args = new Object[]{tierName, parentTier, lingType, participant, annotator, locale, langRef};
            c.execute(receiver, args);
            if (this.singleEditMode) {
                this.dispose();
            } else {
                this.reextractTiers();
            }
        }
    }

    private void doDelete() {
        if (this.tier != null) {
            ArrayList<TierImpl> selectedTiers = new ArrayList<TierImpl>();
            int[] selectedRows = this.tierTable.getSelectedRows();
            if (selectedRows.length > 0) {
                for (int i = 0; i < selectedRows.length; ++i) {
                    selectedRows[i] = this.tierTable.convertRowIndexToModel(selectedRows[i]);
                }
                int column = this.model.findColumn("TierName");
                for (int selectedRow : selectedRows) {
                    String tierName = this.model.getValueAt(selectedRow, column);
                    TierImpl tierImpl = this.transcription.getTierWithId(tierName);
                    selectedTiers.add(tierImpl);
                }
            } else {
                selectedTiers.add(this.tier);
            }
            StringBuilder mesBuf = new StringBuilder();
            for (TierImpl selT : selectedTiers) {
                mesBuf.append(selT.getName() + "\n");
                List<TierImpl> depTiers = selT.getDependentTiers();
                if (depTiers == null || depTiers.size() <= 0) continue;
                StringBuilder tmpBuf = new StringBuilder();
                for (Tier tier : depTiers) {
                    if (selectedTiers.contains(tier)) continue;
                    tmpBuf.append("-   ");
                    tmpBuf.append(tier.getName() + "\n");
                }
                if (tmpBuf.length() <= 0) continue;
                mesBuf.append("\n" + ElanLocale.getString("EditTierDialog.Message.AlsoDeleted") + "\n\n");
                mesBuf.append((CharSequence)tmpBuf);
            }
            JPanel panel = new JPanel(new GridBagLayout());
            JTextArea tierList = new JTextArea(mesBuf.toString());
            tierList.setEditable(false);
            tierList.setBackground(panel.getBackground());
            JScrollPane scrollPane = new JScrollPane(tierList);
            JLabel label = new JLabel(ElanLocale.getString("EditTierDialog.Message.ConfirmDelete"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            panel.add((Component)label, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(6, 10, 6, 6);
            panel.add((Component)scrollPane, gridBagConstraints);
            int prefheight = scrollPane.getViewport().getPreferredSize().height;
            int prefwidth = label.getPreferredSize().width;
            if (prefheight > this.getPreferredSize().height / 2) {
                prefheight = this.getPreferredSize().height / 2;
            }
            scrollPane.getViewport().setPreferredSize(new Dimension(prefwidth, prefheight));
            int option = JOptionPane.showConfirmDialog(this, panel, ElanLocale.getString("Message.Warning"), 0);
            if (option == 0) {
                Object[] args = selectedTiers.toArray();
                Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.DeleteTiers");
                c.execute(this.transcription, args);
                if (this.singleEditMode) {
                    this.dispose();
                } else {
                    this.reextractTiers();
                }
            }
        }
    }

    private void doImport() {
        String fileName = this.importSourceTF.getText();
        if (!this.isValidFile(fileName)) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.SelectValid"), ElanLocale.getString("Message.Error"), 0);
            return;
        }
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.ImportTiers");
        c.execute(this.transcription, new Object[]{fileName});
        this.reextractTiers();
        this.updateUIForTier(null);
    }

    private void promptForImportFile() {
        ArrayList<String[]> extensions = new ArrayList<String[]>();
        extensions.add(FileExtension.EAF_EXT);
        extensions.add(FileExtension.TEMPLATE_EXT);
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("EditTierDialog.Title.Select"), 0, ElanLocale.getString("Button.Select"), extensions, FileExtension.EAF_EXT, false, "LastUsedEAFDir", 0, null);
        File eafFile = chooser.getSelectedFile();
        if (eafFile != null) {
            this.importSourceTF.setText(eafFile.getAbsolutePath());
        }
    }

    private void showAdvancedOptionsDialog() {
        Map<String, Font> fonts;
        Map<String, Color> highlightColors;
        this.currentProps.clear();
        Map<String, Color> colors = Preferences.getMapOfColor("TierColors", this.transcription);
        if (colors == null) {
            colors = new HashMap<String, Color>();
            Preferences.set("TierColors", colors, (Transcription)this.transcription);
        }
        if ((highlightColors = Preferences.getMapOfColor("TierHighlightColors", this.transcription)) == null) {
            highlightColors = new HashMap<String, Color>();
            Preferences.set("TierHighlightColors", highlightColors, (Transcription)this.transcription);
        }
        if ((fonts = Preferences.getMapOfFont("TierFonts", this.transcription)) == null) {
            fonts = new HashMap<String, Font>();
            Preferences.set("TierFonts", fonts, (Transcription)this.transcription);
        }
        this.currentProps.put("TierColor", Color.WHITE);
        this.currentProps.put("TierHighlightColor", Color.WHITE);
        this.currentProps.put("TierFont", null);
        if (this.mode == 0) {
            String name = this.tierNameTextField.getText();
            if (name == null || name.length() == 0) {
                this.currentProps.put("TierName", "");
            } else {
                this.currentProps.put("TierName", name);
            }
            if (this.parentComboBox.getSelectedItem() != "none") {
                String pName = (String)this.parentComboBox.getSelectedItem();
                Color col = colors.get(pName);
                if (col != null) {
                    this.currentProps.put("TierColor", col);
                }
                if ((col = highlightColors.get(pName)) != null) {
                    this.currentProps.put("TierHighlightColor", col);
                }
            }
        } else {
            Font fo;
            Color colP;
            String pName;
            this.currentProps.put("TierName", this.currentTiersComboBox.getSelectedItem());
            Color col = colors.get(this.currentTiersComboBox.getSelectedItem());
            if (col != null) {
                this.currentProps.put("TierColor", col);
            } else {
                pName = (String)this.parentComboBox.getSelectedItem();
                colP = colors.get(pName);
                if (colP != null) {
                    this.currentProps.put("TierColor", colP);
                }
            }
            if (highlightColors instanceof Map) {
                col = highlightColors.get(this.currentTiersComboBox.getSelectedItem());
                if (col != null) {
                    this.currentProps.put("TierHighlightColor", col);
                } else {
                    pName = (String)this.parentComboBox.getSelectedItem();
                    colP = highlightColors.get(pName);
                    if (colP != null) {
                        this.currentProps.put("TierHighlightColor", colP);
                    }
                }
            }
            if ((fo = fonts.get(this.currentTiersComboBox.getSelectedItem())) != null) {
                this.currentProps.put("TierFont", fo);
            }
        }
        AdvancedTierOptionsDialog dialog = new AdvancedTierOptionsDialog((Dialog)this, ElanLocale.getString("EditTierDialog.Title.Change"), true, this.currentProps);
        dialog.setVisible(true);
        if (dialog.getTierProperties() != null) {
            this.currentProps.putAll(dialog.getTierProperties());
        }
    }

    private void applyAttributeSettings() {
        String tierName;
        Map<String, Font> fonts;
        Map<String, Color> highlightColors;
        Map<String, Color> colors;
        Boolean samePart;
        Boolean dependingTiers;
        String lingType;
        String annotator;
        String participant;
        if (this.currentProps == null || this.currentProps.size() == 0) {
            return;
        }
        ArrayList<TierImpl> tierList = new ArrayList<TierImpl>();
        if (this.mode != 0) {
            participant = this.tier.getParticipant();
            annotator = this.tier.getAnnotator();
            lingType = this.tier.getLinguisticType().getLinguisticTypeName();
        } else {
            participant = this.participantTextField.getText();
            annotator = this.annotatorTextField.getText();
            lingType = (String)this.lingTypeComboBox.getSelectedItem();
        }
        Boolean sameType = (Boolean)this.currentProps.get("SameType");
        if (sameType == null) {
            sameType = false;
        }
        if (sameType.booleanValue() && this.transcription.getTiersWithLinguisticType(lingType) != null) {
            tierList.addAll(this.transcription.getTiersWithLinguisticType(lingType));
        }
        if ((dependingTiers = (Boolean)this.currentProps.get("DependingTiers")) == null) {
            dependingTiers = false;
        }
        if (dependingTiers.booleanValue() && this.tier != null && this.tier.getDependentTiers() != null) {
            tierList.addAll(this.tier.getDependentTiers());
        }
        if ((samePart = (Boolean)this.currentProps.get("SameParticipants")) == null) {
            samePart = false;
        }
        if (samePart.booleanValue() && participant != null) {
            List<TierImpl> allTiers = this.transcription.getTiers();
            for (int i = 0; i < allTiers.size(); ++i) {
                TierImpl t = allTiers.get(i);
                if (t.getParticipant() == null || !t.getParticipant().equals(participant) || tierList.contains(t)) continue;
                tierList.add(t);
            }
        }
        if ((colors = Preferences.getMapOfColor("TierColors", this.transcription)) == null) {
            colors = new HashMap<String, Color>();
            Preferences.set("TierColors", colors, (Transcription)this.transcription);
        }
        if ((highlightColors = Preferences.getMapOfColor("TierHighlightColors", this.transcription)) == null) {
            highlightColors = new HashMap<String, Color>();
            Preferences.set("TierHighlightColors", highlightColors, (Transcription)this.transcription);
        }
        if ((fonts = Preferences.getMapOfFont("TierFonts", this.transcription)) == null) {
            fonts = new HashMap<String, Font>();
            Preferences.set("TierFonts", fonts, (Transcription)this.transcription);
        }
        Color nextColor = (Color)this.currentProps.get("TierColor");
        Color nextHighlightColor = (Color)this.currentProps.get("TierHighlightColor");
        Font fo = (Font)this.currentProps.get("TierFont");
        if (this.mode == 0) {
            tierName = this.tierNameTextField.getText();
            tierName.replace('\n', ' ');
            tierName.trim();
        } else {
            tierName = this.tier.getName();
        }
        if (nextColor != null) {
            if (!nextColor.equals(Color.WHITE)) {
                colors.put(tierName, nextColor);
            } else {
                colors.remove(tierName);
            }
        }
        if (nextHighlightColor != null) {
            if (!nextHighlightColor.equals(Color.WHITE)) {
                highlightColors.put(tierName, nextHighlightColor);
            } else {
                highlightColors.remove(tierName);
            }
        }
        if (fo != null) {
            fonts.put(tierName, fo);
        } else {
            fonts.remove(tierName);
        }
        boolean applyFont = false;
        boolean applyColor = false;
        boolean applyHighlight = false;
        for (int i = 0; i < tierList.size(); ++i) {
            if (i == 0) {
                applyFont = (Boolean)this.currentProps.get("Font");
                applyColor = (Boolean)this.currentProps.get("Color");
                applyHighlight = (Boolean)this.currentProps.get("HighLightColor");
            }
            TierImpl t = (TierImpl)tierList.get(i);
            if (applyColor && nextColor != null) {
                if (!nextColor.equals(Color.WHITE)) {
                    colors.put(t.getName(), nextColor);
                } else {
                    colors.remove(t.getName());
                }
            }
            if (applyHighlight && nextHighlightColor != null) {
                if (!nextHighlightColor.equals(Color.WHITE)) {
                    highlightColors.put(t.getName(), nextHighlightColor);
                } else {
                    highlightColors.remove(t.getName());
                }
            }
            if (!applyFont) continue;
            if (fo != null) {
                fonts.put(t.getName(), fo);
                continue;
            }
            fonts.remove(t.getName());
        }
        Preferences.set("TierColors", colors, (Transcription)this.transcription);
        Preferences.set("TierHighlightColors", highlightColors, (Transcription)this.transcription);
        Preferences.set("TierFonts", fonts, this.transcription, true);
    }

    private boolean isValidFile(String fileName) {
        String[] exts;
        if (fileName == null) {
            return false;
        }
        File f = new File(fileName);
        if (!f.exists()) {
            return false;
        }
        String lowerPathName = fileName.toLowerCase();
        for (String ext : exts = FileExtension.EAF_EXT) {
            if (!lowerPathName.endsWith("." + ext)) continue;
            return true;
        }
        for (String ext : exts = FileExtension.TEMPLATE_EXT) {
            if (!lowerPathName.endsWith("." + ext)) continue;
            return true;
        }
        return false;
    }

    private int getStereoTypeForTypeName(String name) {
        LinguisticType type = null;
        for (LinguisticType tempType : this.transcription.getLinguisticTypes()) {
            if (!tempType.getLinguisticTypeName().equals(name)) continue;
            type = tempType;
            break;
        }
        return this.getStereoTypeForType(type);
    }

    private int getStereoTypeForType(LinguisticType type) {
        if (type == null || type.getConstraints() == null) {
            return -1;
        }
        return type.getConstraints().getStereoType();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.changeButton) {
            if (this.mode == 2) {
                this.doDelete();
                return;
            }
            if (this.mode == 3) {
                this.doImport();
                return;
            }
            String tierName = this.tierNameTextField.getText();
            tierName = tierName.replace('\n', ' ');
            if ((tierName = tierName.trim()).length() == 0) {
                this.tierNameTextField.requestFocus();
                JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.TierName"), ElanLocale.getString("Message.Error"), 0);
                return;
            }
            if (this.transcription.getTierWithId(tierName) != null && (this.mode == 0 || this.mode == 1 && !tierName.equals(this.oldTierName))) {
                this.tierNameTextField.requestFocus();
                JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.Exists"), ElanLocale.getString("Message.Error"), 0);
                return;
            }
            String participant = this.participantTextField.getText();
            String annotator = this.annotatorTextField.getText();
            String lingType = (String)this.lingTypeComboBox.getSelectedItem();
            TierImpl parentTier = this.transcription.getTierWithId((String)this.parentComboBox.getSelectedItem());
            String localeName = (String)this.languageComboBox.getSelectedItem();
            Locale locale = null;
            if (this.languageComboBox.getSelectedIndex() != 0) {
                if (this.languageComboBox.getSelectedIndex() == 1 && localeName.indexOf("(System default)") > -1) {
                    locale = Locale.getDefault();
                } else if (this.langs != null) {
                    for (Locale lang : this.langs) {
                        if (!lang.getDisplayName().equals(localeName)) continue;
                        locale = lang;
                        break;
                    }
                }
            }
            String mlLanguage = this.mlLanguageBox.getId();
            switch (this.mode) {
                case 0: {
                    this.doAdd(tierName, parentTier, lingType, participant, annotator, locale, mlLanguage);
                    break;
                }
                case 1: {
                    this.doChange(tierName, parentTier, lingType, participant, annotator, locale, mlLanguage);
                }
            }
            this.currentProps.clear();
        } else if (event.getSource() == this.importSourceButton) {
            this.promptForImportFile();
        } else if (event.getSource() == this.advancedButton) {
            this.showAdvancedOptionsDialog();
        } else {
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.currentTiersComboBox) {
                ListSelectionModel selectionModel = this.tierTable.getSelectionModel();
                int oldMode = selectionModel.getSelectionMode();
                String name = (String)this.currentTiersComboBox.getSelectedItem();
                selectionModel.setSelectionMode(0);
                this.updateUIForTier(name);
                selectionModel.setSelectionMode(oldMode);
            } else if (e.getSource() == this.lingTypeComboBox && this.mode == 1) {
                if (this.tier != null && this.tier.getNumberOfAnnotations() > 0) {
                    int oldStereoType;
                    String newTypeName = (String)e.getItem();
                    boolean stereoTypeChanged = false;
                    int newStereoType = this.getStereoTypeForTypeName(newTypeName);
                    if (newStereoType != (oldStereoType = this.getStereoTypeForType(this.oldLingType))) {
                        stereoTypeChanged = true;
                    }
                    if (!this.oldLingType.getLinguisticTypeName().equals(newTypeName) && stereoTypeChanged) {
                        StringBuilder buf = new StringBuilder(ElanLocale.getString("EditTierDialog.Message.RecommendType"));
                        buf.append("\n");
                        buf.append(ElanLocale.getString("EditTierDialog.Message.Corrupt"));
                        JOptionPane.showMessageDialog(this, buf.toString(), ElanLocale.getString("Message.Warning"), 2);
                        this.lingTypeComboBox.setSelectedItem(this.oldLingType.getLinguisticTypeName());
                    }
                }
            } else if (e.getSource() == this.parentComboBox) {
                if (this.mode == 1 && this.tier != null && this.tier.getNumberOfAnnotations() > 0) {
                    if (!this.oldParentTierName.equals(e.getItem())) {
                        StringBuilder buf = new StringBuilder(ElanLocale.getString("EditTierDialog.Message.RecommendParent"));
                        buf.append("\n");
                        buf.append(ElanLocale.getString("EditTierDialog.Message.Corrupt"));
                        JOptionPane.showMessageDialog(this, buf.toString(), ElanLocale.getString("Message.Warning"), 2);
                        this.parentComboBox.setSelectedItem(this.oldParentTierName);
                    }
                } else {
                    TierImpl parent;
                    String partiName = this.participantTextField.getText();
                    if ((partiName == null || partiName.trim().length() == 0) && (parent = this.transcription.getTierWithId((String)e.getItem())) != null) {
                        this.participantTextField.setText(parent.getParticipant());
                    }
                }
                this.fillLingTypeMenu();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.tabPane.removeChangeListener(this);
        this.mode = this.tabPane.getSelectedIndex();
        this.tabPane.removeAll();
        this.tabPane.addTab(ElanLocale.getString("Button.Add"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Change"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Delete"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Import"), this.importPanel);
        if (this.mode < 3) {
            this.tabPane.setComponentAt(this.tabPane.getSelectedIndex(), this.editPanel);
        } else {
            this.tabPane.setComponentAt(1, this.editPanel);
        }
        this.tabPane.setSelectedIndex(this.mode);
        this.updateForMode();
        this.tabPane.revalidate();
        this.tabPane.addChangeListener(this);
        if (this.mode == 1 || this.mode == 2) {
            if (this.currentTiersComboBox.getItemCount() > 0) {
                String name = (String)this.currentTiersComboBox.getSelectedItem();
                this.updateUIForTier(name);
            }
        } else if (this.mode == 0) {
            this.updateUIForTier(null);
            if (this.parentComboBox.getItemCount() > 0) {
                this.parentComboBox.setSelectedIndex(0);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.mode == 0) {
            return;
        }
        int row = this.tierTable.getSelectedRow();
        if (row > -1) {
            row = this.tierTable.convertRowIndexToModel(row);
            int column = this.model.findColumn("TierName");
            this.updateUIForTier(this.model.getValueAt(row, column));
        }
    }
}

