/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.SystemReporting;
import nl.mpi.util.FileExtension;
import nl.mpi.util.FileUtility;

public class FileChooser {
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16 = "UTF-16";
    public static final String ISO_LATIN = "ISO-8859-1";
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final int GENERIC = 0;
    public static final int MEDIA_TEMPLATE = 1;
    public static final int MEDIA = 2;
    public static String[] encodings = new String[]{"UTF-8", "UTF-16", "ISO-8859-1"};
    private static final int ENCODING_DIALOG = 0;
    private static final int CLIPMEDIA_DIALOG = 1;
    private static final int MULTIFILE_DIALOG = 2;
    private static final String OPEN_DIALOG_TITLE = ElanLocale.getString("FileChooser.openTitleText");
    private static final String SAVE_DIALOG_TITLE = ElanLocale.getString("FileChooser.saveTitleText");
    private static Locale locale = null;
    private FileDialog dialog;
    private JFileChooser chooser;
    private Component parent;
    private String prefStringToLoadtheCurrentPath;
    private int mainDialogType = -1;
    private int customizedDialogType = -1;
    private int fileSelectionMode = 0;
    private List<String> extensions;
    private File selectedFile;
    private Object[] selectedFiles;
    private String selectedEncoding;
    private String currentDirectory = null;
    private boolean clipMedia = false;
    private boolean acceptAllFilesTypes = false;
    private int multiFileDialogMode = 0;

    public FileChooser(Component parent) {
        this.parent = parent;
    }

    private void createDialog(String title, int dialogType, String aprroveButtonText, List<String[]> extensionList, String[] mainFilterExt, boolean allFilesFilter, String prefStringToLoadtheCurrentPath, int selectionMode, String selectedFileName) {
        block48: {
            FileFilter ff;
            FileFilter mainFilter;
            block46: {
                int i;
                block49: {
                    String selMainFilter;
                    block52: {
                        block50: {
                            block51: {
                                block47: {
                                    int li;
                                    this.prefStringToLoadtheCurrentPath = prefStringToLoadtheCurrentPath;
                                    this.mainDialogType = dialogType;
                                    this.extensions = new ArrayList<String>();
                                    this.acceptAllFilesTypes = allFilesFilter;
                                    if (extensionList == null && mainFilterExt == null) {
                                        this.acceptAllFilesTypes = true;
                                    }
                                    if (selectionMode == 1 || selectionMode == 2) {
                                        this.fileSelectionMode = selectionMode;
                                    }
                                    if (this.fileSelectionMode == 1) {
                                        this.acceptAllFilesTypes = true;
                                    }
                                    if (this.currentDirectory == null && prefStringToLoadtheCurrentPath != null) {
                                        this.currentDirectory = Preferences.getString(prefStringToLoadtheCurrentPath, null);
                                    }
                                    if (this.currentDirectory == null && mainFilterExt != null && mainFilterExt.equals(FileExtension.EAF_EXT)) {
                                        this.currentDirectory = Preferences.getString("LastUsedEAFDir", null);
                                    }
                                    if (this.currentDirectory == null) {
                                        this.currentDirectory = System.getProperty("user.dir");
                                    }
                                    if (title == null) {
                                        switch (this.mainDialogType) {
                                            case 1: {
                                                title = SAVE_DIALOG_TITLE;
                                                break;
                                            }
                                            case 0: {
                                                title = OPEN_DIALOG_TITLE;
                                            }
                                        }
                                    }
                                    if (mainFilterExt != null) {
                                        for (int i2 = 0; i2 < mainFilterExt.length; ++i2) {
                                            if (this.extensions.contains(mainFilterExt[i2])) continue;
                                            this.extensions.add(mainFilterExt[i2]);
                                        }
                                        if (extensionList != null && extensionList.contains(mainFilterExt)) {
                                            extensionList.remove(mainFilterExt);
                                        }
                                    }
                                    if (!this.acceptAllFilesTypes) {
                                        for (String ext : FileExtension.MEDIA_EXT) {
                                            if (!this.extensions.contains(ext)) continue;
                                            this.acceptAllFilesTypes = true;
                                            break;
                                        }
                                    }
                                    if (extensionList != null) {
                                        for (int i3 = 0; i3 < extensionList.size(); ++i3) {
                                            String[] extArray = extensionList.get(i3);
                                            if (extArray == null) continue;
                                            for (String ext : extArray) {
                                                if (this.extensions.contains(ext)) continue;
                                                this.extensions.add(ext);
                                            }
                                        }
                                    }
                                    selMainFilter = null;
                                    if (this.mainDialogType == 1 && selectedFileName != null && (li = selectedFileName.lastIndexOf(".")) > 0) {
                                        if (li < selectedFileName.length() - 1) {
                                            selMainFilter = selectedFileName.substring(li + 1);
                                        }
                                        selectedFileName = selectedFileName.substring(0, li);
                                    }
                                    boolean macFileDialog = false;
                                    if (SystemReporting.isMacOS()) {
                                        macFileDialog = true;
                                        Boolean val = Preferences.getBool("UseMacFileDialog", null);
                                        if (val != null) {
                                            macFileDialog = val;
                                        }
                                    }
                                    if (!macFileDialog) break block47;
                                    this.dialog = this.parent instanceof Frame ? new FileDialog((Frame)this.parent) : (this.parent instanceof Dialog ? new FileDialog((Dialog)this.parent) : new FileDialog((Frame)null));
                                    this.dialog.setMode(this.mainDialogType);
                                    if (this.customizedDialogType != 2) {
                                        title = this.updateTitleWithExt(title, this.extensions, this.acceptAllFilesTypes);
                                    }
                                    this.dialog.setTitle(title);
                                    this.dialog.setDirectory(this.currentDirectory);
                                    if (!this.acceptAllFilesTypes) {
                                        this.dialog.setFilenameFilter(new FileNameFilterList(this.extensions));
                                    }
                                    if (selectedFileName != null) {
                                        if (selMainFilter != null) {
                                            this.dialog.setFile(selectedFileName + "." + selMainFilter);
                                        } else {
                                            this.dialog.setFile(selectedFileName);
                                        }
                                    }
                                    if (this.fileSelectionMode == 1) {
                                        System.setProperty("apple.awt.fileDialogForDirectories", Boolean.TRUE.toString());
                                    } else {
                                        System.setProperty("apple.awt.fileDialogForDirectories", Boolean.FALSE.toString());
                                    }
                                    break block48;
                                }
                                this.chooser = new JFileChooser();
                                this.setUILanguage();
                                SwingUtilities.updateComponentTreeUI(this.chooser);
                                if (title != null) {
                                    this.chooser.setDialogTitle(title);
                                }
                                this.chooser.setFileSelectionMode(this.fileSelectionMode);
                                this.chooser.setCurrentDirectory(new File(this.currentDirectory));
                                this.chooser.setAcceptAllFileFilterUsed(this.acceptAllFilesTypes);
                                this.chooser.setDialogType(this.mainDialogType);
                                if (selectedFileName != null) {
                                    this.chooser.setSelectedFile(new File(this.currentDirectory, selectedFileName));
                                }
                                if (this.acceptAllFilesTypes) {
                                    this.chooser.addChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
                                }
                                mainFilter = null;
                                ff = null;
                                if (this.mainDialogType != 1) break block49;
                                if (this.extensions.size() != 1) break block50;
                                if (mainFilterExt == null) break block51;
                                mainFilter = ElanFileFilter.createFileFilter(mainFilterExt);
                                this.chooser.addChoosableFileFilter(mainFilter);
                                break block52;
                            }
                            if (extensionList == null) break block52;
                            mainFilter = ElanFileFilter.createFileFilter(extensionList.get(0));
                            this.chooser.addChoosableFileFilter(mainFilter);
                            break block52;
                        }
                        for (i = 0; i < this.extensions.size(); ++i) {
                            if (i == 0) {
                                mainFilter = new ElanFileFilter(this.extensions.get(i));
                                this.chooser.addChoosableFileFilter(mainFilter);
                                continue;
                            }
                            this.chooser.addChoosableFileFilter(new ElanFileFilter(this.extensions.get(i)));
                        }
                    }
                    if (selMainFilter != null) {
                        for (FileFilter cff : this.chooser.getChoosableFileFilters()) {
                            if (!((ElanFileFilter)cff).getFilterExtensions().contains(selMainFilter)) continue;
                            mainFilter = cff;
                            break block46;
                        }
                    }
                    break block46;
                }
                if (mainFilterExt != null) {
                    mainFilter = ElanFileFilter.createFileFilter(mainFilterExt);
                    this.chooser.addChoosableFileFilter(mainFilter);
                }
                if (extensionList != null) {
                    for (i = 0; i < extensionList.size(); ++i) {
                        if (i == 0) {
                            ff = ElanFileFilter.createFileFilter(extensionList.get(i));
                            this.chooser.addChoosableFileFilter(ff);
                            continue;
                        }
                        this.chooser.addChoosableFileFilter(ElanFileFilter.createFileFilter(extensionList.get(i)));
                    }
                }
            }
            if (mainFilterExt != null) {
                this.chooser.setFileFilter(mainFilter);
            } else if (this.acceptAllFilesTypes) {
                this.chooser.setFileFilter(this.chooser.getAcceptAllFileFilter());
            } else {
                this.chooser.setFileFilter(ff);
            }
            if (aprroveButtonText != null) {
                this.chooser.setApproveButtonText(aprroveButtonText);
            }
        }
    }

    private String updateTitleWithExt(String title, List<String> extensions, boolean acceptAllFilesTypes) {
        Object ext = null;
        for (int i = 0; i < extensions.size(); ++i) {
            ext = i == 0 ? extensions.get(i) : (String)ext + extensions.get(i);
            if (i == extensions.size() - 1) continue;
            ext = (String)ext + ", ";
        }
        if (acceptAllFilesTypes) {
            ext = ext != null ? ext + ", *" : "*";
        }
        if (ext != null) {
            title = (String)title + " (" + (String)ext + " )";
        }
        return title;
    }

    public void setUILanguage() {
        if (locale == null || locale != ElanLocale.getLocale()) {
            locale = ElanLocale.getLocale();
        } else if (locale == ElanLocale.getLocale()) {
            return;
        }
        UIManager.put("FileChooser.acceptAllFileFilterText", ElanLocale.getString("FileChooser.acceptAllFileFilterText"));
        UIManager.put("FileChooser.byDateText", ElanLocale.getString("FileChooser.byDateText"));
        UIManager.put("FileChooser.byNameText", ElanLocale.getString("FileChooser.byNameText"));
        UIManager.put("FileChooser.cancelButtonText", ElanLocale.getString("FileChooser.cancelButtonText"));
        UIManager.put("FileChooser.cancelButtonToolTipText", ElanLocale.getString("FileChooser.cancelButtonToolTipText"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", ElanLocale.getString("FileChooser.detailsViewButtonToolTipText"));
        UIManager.put("FileChooser.fileNameLabelText", ElanLocale.getString("FileChooser.fileNameLabelText"));
        UIManager.put("FileChooser.filesOfTypeLabelText", ElanLocale.getString("FileChooser.filesOfTypeLabelText"));
        UIManager.put("FileChooser.lookInLabelText", ElanLocale.getString("FileChooser.lookInLabelText"));
        UIManager.put("FileChooser.listViewButtonToolTipText", ElanLocale.getString("FileChooser.listViewButtonToolTipText"));
        UIManager.put("FileChooser.newFolderButtonText", ElanLocale.getString("FileChooser.newFolderButtonText"));
        UIManager.put("FileChooser.newFolderButtonToolTipText", ElanLocale.getString("FileChooser.newFolderButtonToolTipText"));
        UIManager.put("FileChooser.newFolderToolTipText", ElanLocale.getString("FileChooser.newFolderToolTipText"));
        UIManager.put("FileChooser.openButtonText", ElanLocale.getString("FileChooser.openButtonText"));
        UIManager.put("FileChooser.openButtonToolTipText", ElanLocale.getString("FileChooser.openButtonToolTipText"));
        UIManager.put("FileChooser.openTitleText", ElanLocale.getString("FileChooser.openTitleText"));
        UIManager.put("FileChooser.saveButtonText", ElanLocale.getString("FileChooser.saveButtonText"));
        UIManager.put("FileChooser.saveDialogFileNameLabelText", ElanLocale.getString("FileChooser.saveDialogFileNameLabelText"));
        UIManager.put("FileChooser.saveTitleText", ElanLocale.getString("FileChooser.saveTitleText"));
        UIManager.put("FileChooser.upFolderToolTipText", ElanLocale.getString("FileChooser.upFolderToolTipText"));
    }

    public void createAndShowFileDialog(String title, int dialogType, String[] mainFilterExt, String prefStringToLoadtheCurrentPath) {
        this.createAndShowFileDialog(title, dialogType, null, mainFilterExt, prefStringToLoadtheCurrentPath, null);
    }

    public void createAndShowFileDialog(String title, int dialogType, List<String[]> extensions, String[] mainFilterExt, String prefStringToLoadtheCurrentPath, String selectedFileName) {
        this.createAndShowFileDialog(title, dialogType, null, extensions, mainFilterExt, this.acceptAllFilesTypes, prefStringToLoadtheCurrentPath, 0, selectedFileName);
    }

    public void createAndShowFileDialog(String title, int dialogType, String aprroveButtonText, List<String[]> extensions, String[] mainFilterExt, boolean acceptAllFiles, String prefStringToLoadtheCurrentPath, int fileSelectionMode, String selectedFileName) {
        this.createDialog(title, dialogType, aprroveButtonText, extensions, mainFilterExt, acceptAllFiles, prefStringToLoadtheCurrentPath, fileSelectionMode, selectedFileName);
        this.show();
    }

    public void createAndShowFileAndEncodingDialog(String title, int dialogType, String[] mainFilter, String prefStringToLoadtheCurrentPath, String selectedEncoding) {
        this.createAndShowFileAndEncodingDialog(title, dialogType, null, mainFilter, prefStringToLoadtheCurrentPath, null, selectedEncoding, null);
    }

    public void createAndShowFileAndEncodingDialog(String title, int dialogType, List<String[]> extensions, String[] mainFilter, String prefStringToLoadtheCurrentPath, String[] encodings, String selectedEncoding, String selectedFileName) {
        this.createAndShowFileAndEncodingDialog(title, dialogType, null, extensions, mainFilter, this.acceptAllFilesTypes, prefStringToLoadtheCurrentPath, encodings, selectedEncoding, 0, selectedFileName);
    }

    public void createAndShowFileAndEncodingDialog(String title, int dialogType, String aprroveButtonText, List<String[]> extensions, String[] mainFilter, boolean acceptAllFilesTypes, String prefStringToLoadtheCurrentPath, String[] encodings, String selectedEncoding, int fileSelectionMode, String selectedFileName) {
        this.customizedDialogType = 0;
        this.createDialog(title, dialogType, aprroveButtonText, extensions, mainFilter, acceptAllFilesTypes, prefStringToLoadtheCurrentPath, fileSelectionMode, selectedFileName);
        this.selectedEncoding = selectedEncoding;
        this.setEncodings(encodings);
        if (this.chooser != null) {
            this.chooser.setControlButtonsAreShown(false);
        }
        this.show();
    }

    public void createAndShowFileAndClipMediaDialog(String title, int dialogType, List<String[]> extensions, String[] mainFilter, String prefStringToLoadtheCurrentPath) {
        this.customizedDialogType = 1;
        this.createDialog(title, dialogType, null, extensions, mainFilter, true, prefStringToLoadtheCurrentPath, -1, null);
        if (this.chooser != null) {
            this.chooser.setControlButtonsAreShown(false);
        }
        this.show();
    }

    public void createAndShowMultiFileDialog(String title, int multiFileDialogType) {
        this.createAndShowMultiFileDialog(title, multiFileDialogType, null, null);
    }

    public void createAndShowMultiFileDialog(String title, int multiFileDialogType, String[] mainFilterExt, String prefStringToLoadtheCurrentPath) {
        this.createAndShowMultiFileDialog(title, multiFileDialogType, ElanLocale.getString("Button.OK"), null, mainFilterExt, this.acceptAllFilesTypes, prefStringToLoadtheCurrentPath, 0, null);
    }

    public void createAndShowMultiFileDialog(String title, int multiFileDialogType, String aprroveButtonText, List<String[]> extensions, String[] mainFilter, boolean acceptAllFilesTypes, String prefStringToLoadtheCurrentPath, int fileSelectionMode, File[] files) {
        if (multiFileDialogType >= 0 && multiFileDialogType <= 2) {
            this.multiFileDialogMode = multiFileDialogType;
        }
        if (files != null) {
            this.selectedFiles = files;
        }
        this.customizedDialogType = 2;
        if (this.multiFileDialogMode == 1 || this.multiFileDialogMode == 2) {
            ArrayList<String[]> defaultExtensions = new ArrayList<String[]>();
            defaultExtensions.add(FileExtension.MEDIA_EXT);
            defaultExtensions.add(FileExtension.MPEG_EXT);
            defaultExtensions.add(FileExtension.WAV_EXT);
            defaultExtensions.add(FileExtension.MPEG4_EXT);
            defaultExtensions.add(FileExtension.QT_EXT);
            if (extensions != null) {
                for (String[] e : extensions) {
                    if (defaultExtensions.contains(e)) continue;
                    defaultExtensions.add(e);
                }
            }
            if (mainFilter == null) {
                int type;
                Integer val = Preferences.getInt("Media.LastUsedMediaType", null);
                mainFilter = val != null ? ((type = val.intValue()) == 2 ? FileExtension.MEDIA_EXT : (type == 16 ? FileExtension.MPEG4_EXT : (type == 17 ? FileExtension.QT_EXT : (type == 0 ? FileExtension.MPEG_EXT : (type == 1 ? FileExtension.WAV_EXT : FileExtension.MEDIA_EXT))))) : FileExtension.MEDIA_EXT;
            }
            extensions = defaultExtensions;
            if (prefStringToLoadtheCurrentPath == null) {
                prefStringToLoadtheCurrentPath = "MediaDir";
            }
            acceptAllFilesTypes = true;
        }
        this.createDialog(title, 0, aprroveButtonText, extensions, mainFilter, acceptAllFilesTypes, prefStringToLoadtheCurrentPath, fileSelectionMode, null);
        if (this.chooser != null) {
            this.chooser.setMultiSelectionEnabled(true);
            this.chooser.setControlButtonsAreShown(false);
            this.chooser.setPreferredSize(new Dimension((int)this.chooser.getPreferredSize().getWidth() - 80, (int)this.chooser.getPreferredSize().getHeight()));
        }
        this.show();
    }

    private void show() {
        this.selectedFile = null;
        boolean allFileFilterUsed = false;
        boolean askForOverWrite = false;
        boolean validExt = true;
        String selectedFileExt = null;
        if (this.dialog != null) {
            allFileFilterUsed = this.acceptAllFilesTypes;
            CustomizedDialogForMac cutomizedDialog = null;
            if (this.customizedDialogType == 2) {
                boolean showFileType;
                boolean bl = showFileType = this.mainDialogType == 1;
                cutomizedDialog = this.parent instanceof Frame ? new CustomizedDialogForMac((Frame)this.parent, showFileType) : (this.parent instanceof Dialog ? new CustomizedDialogForMac((Dialog)this.parent, showFileType) : new CustomizedDialogForMac((Frame)null, showFileType));
                this.selectedFiles = cutomizedDialog.getFiles();
                this.currentDirectory = this.dialog.getDirectory();
            } else {
                Window messWindow = this.showSubstituteTitle(this.dialog.getTitle());
                this.dialog.setVisible(true);
                this.hideSubstituteTitle(messWindow);
                String file = this.dialog.getFile();
                this.currentDirectory = this.dialog.getDirectory();
                if (file != null) {
                    this.selectedFile = new File(this.dialog.getDirectory(), file);
                }
                if (this.selectedFile != null) {
                    boolean showFileType = false;
                    validExt = this.isValidExt(allFileFilterUsed);
                    if (!validExt && this.extensions.size() > 1 && this.mainDialogType == 1) {
                        showFileType = true;
                    }
                    if (this.customizedDialogType >= 0 || showFileType) {
                        cutomizedDialog = this.parent instanceof Frame ? new CustomizedDialogForMac((Frame)this.parent, showFileType) : (this.parent instanceof Dialog ? new CustomizedDialogForMac((Dialog)this.parent, showFileType) : new CustomizedDialogForMac((Frame)null, showFileType));
                        selectedFileExt = cutomizedDialog.getSelectedExtension();
                    }
                }
            }
        } else {
            askForOverWrite = true;
            int returnVal = -1;
            if (this.customizedDialogType >= 0) {
                CustomizedFileChooser cutomizedChooser = new CustomizedFileChooser();
                returnVal = cutomizedChooser.showDialog(this.parent);
                if (returnVal == 0) {
                    if (this.customizedDialogType == 2) {
                        this.selectedFiles = cutomizedChooser.getFiles();
                    } else {
                        this.selectedFile = cutomizedChooser.getSelectedFile();
                        this.currentDirectory = this.chooser.getCurrentDirectory().getAbsolutePath();
                    }
                }
            } else {
                returnVal = this.chooser.showDialog(this.parent, null);
                if (returnVal == 0) {
                    this.selectedFile = this.chooser.getSelectedFile();
                    this.currentDirectory = this.chooser.getCurrentDirectory().getAbsolutePath();
                    if (this.chooser.getFileFilter() == this.chooser.getAcceptAllFileFilter()) {
                        allFileFilterUsed = true;
                    }
                }
            }
        }
        if (this.customizedDialogType == 2) {
            int answer;
            if (this.selectedFiles == null) {
                return;
            }
            File file = null;
            ArrayList<Object> validFiles = new ArrayList<Object>();
            boolean allFilesExist = true;
            for (Object selectedFile2 : this.selectedFiles) {
                if (selectedFile2 instanceof File) {
                    file = (File)selectedFile2;
                } else if (selectedFile2 instanceof String) {
                    if (FileUtility.isRemoteFile((String)selectedFile2)) {
                        validFiles.add(selectedFile2);
                        continue;
                    }
                    file = new File((String)selectedFile2);
                }
                if (file.exists()) {
                    validFiles.add(selectedFile2);
                    continue;
                }
                allFilesExist = false;
            }
            if (!allFilesExist && (answer = JOptionPane.showConfirmDialog(this.parent, ElanLocale.getString("OverlapsDialog.Message.NotAllFilesExist"), ElanLocale.getString("OverlapsDialog.Message.NotAllFilesExistTitle"), 0)) != 0) {
                this.selectedFiles = null;
                return;
            }
            this.selectedFiles = validFiles.toArray(new Object[validFiles.size()]);
            if (this.selectedFiles.length > 0 && this.prefStringToLoadtheCurrentPath != null && this.multiFileDialogMode != 1) {
                Preferences.set(this.prefStringToLoadtheCurrentPath, new File(this.selectedFiles[this.selectedFiles.length - 1].toString()).getParent(), null);
            }
        } else {
            if (this.selectedFile == null) {
                return;
            }
            validExt = this.isValidExt(allFileFilterUsed);
            if (!askForOverWrite && !validExt) {
                askForOverWrite = true;
            }
            Object name = this.selectedFile.getAbsolutePath();
            switch (this.mainDialogType) {
                case 0: {
                    try {
                        if (!this.selectedFile.exists()) {
                            Object strMessage = null;
                            String strTitle = null;
                            if (this.fileSelectionMode == 1) {
                                strMessage = ElanLocale.getString("ExportTiersDialog.Message.DirectoryDoesntExist");
                                strTitle = ElanLocale.getString("ExportTiersDialog.Message.DirectoryDoesntExistTitle");
                            } else {
                                strMessage = ElanLocale.getString("Menu.Dialog.Message1");
                                strMessage = (String)strMessage + this.chooser.getSelectedFile().getAbsolutePath();
                                strMessage = (String)strMessage + ElanLocale.getString("Menu.Dialog.Message2");
                                strTitle = ElanLocale.getString("Message.Error");
                            }
                            JOptionPane.showMessageDialog(this.parent, strMessage, strTitle, 0);
                            this.show();
                            return;
                        }
                        if (!this.selectedFile.isDirectory() && !validExt) {
                            Object strMessage = ElanLocale.getString("Menu.Dialog.Message1");
                            strMessage = (String)strMessage + (String)name;
                            strMessage = (String)strMessage + ElanLocale.getString("Menu.Dialog.Message3");
                            String strError = ElanLocale.getString("Message.Error");
                            JOptionPane.showMessageDialog(null, strMessage, strError, 0);
                            this.show();
                            return;
                        }
                    }
                    catch (Exception strMessage) {}
                    break;
                }
                case 1: {
                    try {
                        int answer;
                        if (!validExt) {
                            if (this.chooser != null) {
                                FileFilter filter = this.chooser.getFileFilter();
                                if (filter instanceof ElanFileFilter) {
                                    List<String> exten = ((ElanFileFilter)filter).getFilterExtensions();
                                    name = (String)name + "." + exten.get(0);
                                    validExt = true;
                                }
                            } else if (selectedFileExt != null) {
                                name = (String)name + "." + selectedFileExt;
                                validExt = true;
                            }
                            if (!validExt && this.extensions != null && !this.extensions.isEmpty()) {
                                name = (String)name + "." + this.extensions.get(0);
                            }
                            this.selectedFile = new File((String)name);
                        }
                        if (askForOverWrite && this.selectedFile.exists() && (answer = JOptionPane.showConfirmDialog(null, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0)) == 1) {
                            this.show();
                            return;
                        }
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.prefStringToLoadtheCurrentPath != null) {
                Preferences.set(this.prefStringToLoadtheCurrentPath, new File(this.selectedFile.getAbsolutePath()).getParent(), null);
            }
        }
    }

    private boolean isValidExt(boolean allFileFilterUsed) {
        boolean validExt = true;
        if (!allFileFilterUsed || this.mainDialogType == 1) {
            String fileExt = FileUtility.getExtension(this.selectedFile);
            validExt = false;
            if (fileExt != null) {
                String ext = fileExt.toLowerCase();
                for (int i = 0; i < this.extensions.size(); ++i) {
                    if (!ext.equals(this.extensions.get(i).toLowerCase())) continue;
                    validExt = true;
                }
            }
        }
        return validExt;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public Object[] getSelectedFiles() {
        return this.selectedFiles;
    }

    public void setCurrentDirectory(String currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public String getSelectedEncoding() {
        return this.selectedEncoding;
    }

    public boolean doClipMedia() {
        return this.clipMedia;
    }

    private void getSelectedValueFrom(JComponent component) {
        switch (this.customizedDialogType) {
            case 0: {
                this.selectedEncoding = (String)((JComboBox)component).getSelectedItem();
                if (this.selectedEncoding != null) break;
                this.selectedEncoding = UTF_8;
                break;
            }
            case 1: {
                this.clipMedia = ((JCheckBox)component).isSelected();
            }
        }
    }

    private void setEncodings(String[] encs) {
        if (encs != null && encs.length > 0) {
            encodings = new String[encs.length];
            for (int i = 0; i < encs.length; ++i) {
                FileChooser.encodings[i] = encs[i];
            }
            if (this.selectedEncoding == null) {
                this.selectedEncoding = encodings[0];
            }
        }
    }

    public void addFiles(File dir, List<File> files, List<String> extensions) {
        if (dir == null || files == null || extensions == null) {
            return;
        }
        File[] allSubs = dir.listFiles();
        for (int i = 0; i < allSubs.length; ++i) {
            String ext;
            if (allSubs[i].isDirectory() && allSubs[i].canRead()) {
                this.addFiles(allSubs[i], files, extensions);
                continue;
            }
            if (!allSubs[i].canRead() || (ext = FileUtility.getExtension(allSubs[i])) == null || !extensions.contains(ext.toLowerCase()) || files.contains(allSubs[i])) continue;
            files.add(allSubs[i]);
        }
    }

    private Window showSubstituteTitle(String title) {
        if (!SystemReporting.isMacOSSierraOrHigher()) {
            return null;
        }
        JWindow titleWindow = new JWindow();
        titleWindow.getContentPane().setLayout(new BorderLayout());
        titleWindow.getContentPane().add((Component)new JLabel(title, 0), "Center");
        Rectangle winBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        titleWindow.setSize(672, 46);
        titleWindow.setLocation(winBounds.x + (winBounds.width - 672) / 2, winBounds.y);
        titleWindow.setAlwaysOnTop(false);
        titleWindow.setVisible(true);
        return titleWindow;
    }

    private void hideSubstituteTitle(Window w) {
        if (w != null) {
            w.setVisible(false);
            w.dispose();
        }
    }

    static /* synthetic */ Object[] access$1302(FileChooser x0, Object[] x1) {
        x0.selectedFiles = x1;
        return x1;
    }

    private class FileNameFilterList
    implements FilenameFilter {
        private List<String> fileNameFilters;

        public FileNameFilterList(List<String> fileNameFilters) {
            this.fileNameFilters = fileNameFilters;
        }

        public FileNameFilterList(String[] fileNameFilter) {
            if (fileNameFilter == null) {
                this.fileNameFilters = null;
            } else {
                this.fileNameFilters = new ArrayList<String>();
                for (String ext : fileNameFilter) {
                    this.fileNameFilters.add(ext);
                }
            }
        }

        public FileNameFilterList() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.fileNameFilters == null || this.fileNameFilters.size() == 0) {
                return true;
            }
            for (int i = 0; i < this.fileNameFilters.size(); ++i) {
                if (!name.toLowerCase().endsWith(this.fileNameFilters.get(i).toLowerCase())) continue;
                return true;
            }
            return false;
        }
    }

    private class CustomizedDialogForMac
    extends JDialog
    implements ActionListener {
        private JComponent component;
        private JButton okButton;
        private JButton cancelButton;
        private JButton backButton;
        private JComboBox saveComboBox;
        private JList fileList;
        private DefaultListModel model;
        private boolean showFileTypes;
        private String mediaDlgTitle;
        private String tempDlgTitle;
        private String genericDlgTitle;

        public CustomizedDialogForMac(Frame owner, boolean showFileTypes) {
            super(owner, true);
            this.showFileTypes = showFileTypes;
            this.makeLayout();
            this.pack();
            this.setLocationRelativeTo(owner);
            this.setVisible(true);
        }

        public CustomizedDialogForMac(Dialog owner, boolean showFileTypes) {
            super(owner, true);
            this.showFileTypes = showFileTypes;
            this.makeLayout();
            this.pack();
            this.setLocationRelativeTo(owner);
            this.setVisible(true);
        }

        private JPanel getCustomizedPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            switch (FileChooser.this.customizedDialogType) {
                case 0: {
                    this.setTitle(ElanLocale.getString("FileChooser.Mac.Label.Encoding"));
                    this.component = new JComboBox();
                    for (String encoding : encodings) {
                        ((JComboBox)this.component).addItem(encoding);
                    }
                    if (FileChooser.this.getSelectedEncoding() != null) {
                        ((JComboBox)this.component).setSelectedItem(FileChooser.this.getSelectedEncoding());
                    } else {
                        ((JComboBox)this.component).setSelectedItem(((JComboBox)this.component).getItemAt(0));
                    }
                    gbc = new GridBagConstraints();
                    gbc.anchor = 11;
                    gbc.insets = new Insets(4, 6, 4, 6);
                    gbc.gridx = 0;
                    gbc.gridy = 0;
                    panel.add((Component)new JLabel(ElanLocale.getString("FileChooser.Mac.Label.Encoding")), gbc);
                    gbc.gridx = 1;
                    gbc.weightx = 1.0;
                    gbc.fill = 2;
                    panel.add((Component)this.component, gbc);
                    break;
                }
                case 1: {
                    this.component = new JCheckBox(ElanLocale.getString("ExportSelectionAsEAF.Label.ClipMedia"));
                    gbc = new GridBagConstraints();
                    gbc.anchor = 11;
                    gbc.insets = new Insets(4, 6, 4, 6);
                    gbc.gridx = 0;
                    gbc.gridy = 0;
                    panel.add((Component)this.component, gbc);
                    break;
                }
                case 2: {
                    this.setTitle(FileChooser.this.dialog.getTitle());
                    panel = this.getMultiFilePanel();
                }
            }
            if (this.showFileTypes) {
                this.setTitle(ElanLocale.getString("FileChooser.Mac.Title"));
                this.saveComboBox = new JComboBox();
                for (int i = 0; i < FileChooser.this.extensions.size(); ++i) {
                    this.saveComboBox.addItem(FileChooser.this.extensions.get(i));
                }
                String text = ElanLocale.getString("FileChooser.Mac.Label.InvalidFormat1") + " '" + FileChooser.this.selectedFile.toString() + "' \n" + ElanLocale.getString("FileChooser.Mac.Label.InvalidFormat2");
                gbc.anchor = 18;
                gbc.gridx = 0;
                ++gbc.gridy;
                gbc.gridwidth = 2;
                gbc.weightx = 0.0;
                gbc.insets = new Insets(4, 6, 4, 6);
                panel.add((Component)new JLabel(text), gbc);
                ++gbc.gridy;
                gbc.gridwidth = 1;
                gbc.fill = 0;
                panel.add((Component)new JLabel(ElanLocale.getString("FileChooser.Mac.Label.FileFormat")), gbc);
                gbc.gridx = 1;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                panel.add((Component)this.saveComboBox, gbc);
            }
            return panel;
        }

        private JPanel getMultiFilePanel() {
            this.setPreferredSize(new Dimension(600, 400));
            JPanel panel = new JPanel(new GridBagLayout());
            final JButton addMediaButton = new JButton(ElanLocale.getString("FileChooser.Button.AddMedia"));
            final JButton addTemplateButton = new JButton(ElanLocale.getString("FileChooser.Button.AddTempate"));
            final JButton remoteButton = new JButton(ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteMedia"));
            final JButton removeButton = new JButton(ElanLocale.getString("FileChooser.Button.Remove"));
            removeButton.setEnabled(false);
            final JButton upButton = new JButton();
            final JButton downButton = new JButton();
            this.okButton = new JButton(ElanLocale.getString("Button.OK"));
            this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
            final String title = FileChooser.this.dialog.getTitle();
            if (FileChooser.this.multiFileDialogMode == 1) {
                ArrayList<String[]> defaultExtensions = new ArrayList<String[]>();
                defaultExtensions.add(FileExtension.MEDIA_EXT);
                defaultExtensions.add(FileExtension.MPEG_EXT);
                defaultExtensions.add(FileExtension.WAV_EXT);
                defaultExtensions.add(FileExtension.MPEG4_EXT);
                defaultExtensions.add(FileExtension.QT_EXT);
                ArrayList<String> mediaExtensions = new ArrayList<String>();
                for (String[] e : defaultExtensions) {
                    for (int i = 0; i < e.length; ++i) {
                        if (mediaExtensions.contains(e[i])) continue;
                        mediaExtensions.add(e[i]);
                    }
                }
                this.mediaDlgTitle = FileChooser.this.updateTitleWithExt(title, mediaExtensions, true);
                ArrayList<String> tempExtensions = new ArrayList<String>();
                for (int i = 0; i < FileExtension.TEMPLATE_EXT.length; ++i) {
                    if (tempExtensions.contains(FileExtension.TEMPLATE_EXT[i])) continue;
                    tempExtensions.add(FileExtension.TEMPLATE_EXT[i]);
                }
                this.tempDlgTitle = FileChooser.this.updateTitleWithExt(title, tempExtensions, false);
            }
            if (FileChooser.this.multiFileDialogMode == 0) {
                this.genericDlgTitle = FileChooser.this.updateTitleWithExt(title, FileChooser.this.extensions, FileChooser.this.acceptAllFilesTypes);
            }
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object src = e.getSource();
                    FileChooser.this.dialog.setTitle(title);
                    if (src == addMediaButton) {
                        if (FileChooser.this.multiFileDialogMode == 1) {
                            FileChooser.this.dialog.setTitle(CustomizedDialogForMac.this.mediaDlgTitle);
                            FileChooser.this.dialog.setFilenameFilter(new FileNameFilterList());
                            String templateDir = Preferences.getString("MediaDir", null);
                            FileChooser.this.dialog.setDirectory(templateDir == null ? Constants.USERHOME : templateDir);
                        }
                        if (FileChooser.this.multiFileDialogMode == 0) {
                            FileChooser.this.dialog.setTitle(CustomizedDialogForMac.this.genericDlgTitle);
                        }
                        Window tw = FileChooser.this.showSubstituteTitle(FileChooser.this.dialog.getTitle());
                        FileChooser.this.dialog.setVisible(true);
                        FileChooser.this.hideSubstituteTitle(tw);
                        String file = FileChooser.this.dialog.getFile();
                        if (file != null) {
                            CustomizedDialogForMac.this.addFile(new File(FileChooser.this.dialog.getDirectory(), FileChooser.this.dialog.getFile()));
                        }
                        if (FileChooser.this.multiFileDialogMode == 1 && FileChooser.this.dialog.getDirectory() != null) {
                            Preferences.set("MediaDir", FileChooser.this.dialog.getDirectory(), null);
                        }
                    } else if (src == addTemplateButton) {
                        if (FileChooser.this.multiFileDialogMode == 1) {
                            FileChooser.this.dialog.setTitle(CustomizedDialogForMac.this.tempDlgTitle);
                            FileChooser.this.dialog.setFilenameFilter(new FileNameFilterList(FileExtension.TEMPLATE_EXT));
                            String templateDir = Preferences.getString("TemplateDir", null);
                            FileChooser.this.dialog.setDirectory(templateDir == null ? Constants.USERHOME : templateDir);
                        }
                        if (FileChooser.this.multiFileDialogMode == 0) {
                            System.setProperty("apple.awt.fileDialogForDirectories", Boolean.TRUE.toString());
                            FileChooser.this.dialog.setTitle(CustomizedDialogForMac.this.genericDlgTitle);
                        }
                        Window tw = FileChooser.this.showSubstituteTitle(FileChooser.this.dialog.getTitle());
                        FileChooser.this.dialog.setVisible(true);
                        FileChooser.this.hideSubstituteTitle(tw);
                        String file = FileChooser.this.dialog.getFile();
                        if (file != null) {
                            CustomizedDialogForMac.this.addFile(new File(FileChooser.this.dialog.getDirectory(), FileChooser.this.dialog.getFile()));
                        }
                        if (FileChooser.this.multiFileDialogMode == 1 && FileChooser.this.dialog.getDirectory() != null) {
                            Preferences.set("TemplateDir", FileChooser.this.dialog.getDirectory(), null);
                        }
                        if (FileChooser.this.multiFileDialogMode == 0) {
                            System.setProperty("apple.awt.fileDialogForDirectories", Boolean.FALSE.toString());
                        }
                    } else if (src == removeButton) {
                        CustomizedDialogForMac.this.removeFile();
                    } else if (src == upButton) {
                        CustomizedDialogForMac.this.moveUp();
                    } else if (src == downButton) {
                        CustomizedDialogForMac.this.moveDown();
                    } else if (src == remoteButton) {
                        CustomizedDialogForMac.this.addRemoteFile();
                    } else if (src == CustomizedDialogForMac.this.okButton) {
                        CustomizedDialogForMac.this.doClose();
                    } else if (src == CustomizedDialogForMac.this.cancelButton) {
                        CustomizedDialogForMac.this.model.clear();
                        CustomizedDialogForMac.this.doClose();
                    }
                    if (CustomizedDialogForMac.this.model.size() > 0) {
                        removeButton.setEnabled(true);
                    } else {
                        removeButton.setEnabled(false);
                    }
                }
            };
            removeButton.addActionListener(listener);
            remoteButton.addActionListener(listener);
            upButton.addActionListener(listener);
            downButton.addActionListener(listener);
            addMediaButton.addActionListener(listener);
            addTemplateButton.addActionListener(listener);
            this.okButton.addActionListener(listener);
            this.cancelButton.addActionListener(listener);
            ImageIcon UP_ICON = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Up.gif"));
            ImageIcon DOWN_ICON = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Down.gif"));
            upButton.setIcon(UP_ICON);
            downButton.setIcon(DOWN_ICON);
            Insets insets = new Insets(2, 2, 2, 2);
            JPanel buttonsPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets;
            if (FileChooser.this.multiFileDialogMode == 1) {
                gbc.gridy = 0;
                buttonsPanel.add((Component)addMediaButton, gbc);
                gbc.gridy = 1;
                buttonsPanel.add((Component)addTemplateButton, gbc);
                gbc.gridy = 2;
                buttonsPanel.add((Component)remoteButton, gbc);
                gbc.gridy = 3;
                buttonsPanel.add((Component)removeButton, gbc);
            } else {
                switch (FileChooser.this.fileSelectionMode) {
                    case 0: {
                        gbc.gridy = 0;
                        buttonsPanel.add((Component)addMediaButton, gbc);
                        addMediaButton.setText(ElanLocale.getString("FileChooser.Button.AddFile"));
                        break;
                    }
                    case 1: {
                        gbc.gridy = 0;
                        buttonsPanel.add((Component)addTemplateButton, gbc);
                        addTemplateButton.setText(ElanLocale.getString("FileChooser.Button.AddFolder"));
                        break;
                    }
                    case 2: {
                        gbc.gridy = 0;
                        buttonsPanel.add((Component)addMediaButton, gbc);
                        addMediaButton.setText(ElanLocale.getString("FileChooser.Button.AddFile"));
                        gbc.gridy = 1;
                        buttonsPanel.add((Component)addTemplateButton, gbc);
                        addTemplateButton.setText(ElanLocale.getString("FileChooser.Button.AddFolder"));
                    }
                }
                ++gbc.gridy;
                buttonsPanel.add((Component)removeButton, gbc);
            }
            JPanel controlPanel = new JPanel(new GridLayout(1, 3, 6, 6));
            controlPanel.add(upButton);
            controlPanel.add(downButton);
            JPanel controlButtonPanel = new JPanel(new GridLayout(1, 3, 6, 6));
            controlButtonPanel.add(this.okButton);
            controlButtonPanel.add(this.cancelButton);
            this.model = new DefaultListModel();
            this.fileList = new JList(this.model);
            this.fileList.setSelectionMode(2);
            if (FileChooser.this.selectedFiles != null) {
                this.model.clear();
                for (int i = 0; i < FileChooser.this.selectedFiles.length; ++i) {
                    this.model.insertElementAt(FileChooser.this.selectedFiles[i], i);
                }
                if (this.model.size() > 0) {
                    removeButton.setEnabled(true);
                }
                this.fileList.setSelectedIndex(0);
                this.fileList.ensureIndexIsVisible(0);
                FileChooser.access$1302(FileChooser.this, null);
            }
            JScrollPane jsp = new JScrollPane(this.fileList);
            jsp.setPreferredSize(new Dimension(jsp.getPreferredSize().getSize().width - 30, jsp.getPreferredSize().getSize().height));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 11;
            gbc.insets = insets;
            gbc.fill = 2;
            gbc.weighty = 1.0;
            panel.add(new JLabel(ElanLocale.getString("Frame.ElanFrame.NewDialog.Selected")));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = insets;
            gbc.anchor = 11;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            panel.add((Component)jsp, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = insets;
            gbc.anchor = 11;
            panel.add((Component)controlPanel, gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            panel.add((Component)buttonsPanel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 2;
            gbc.anchor = 13;
            panel.add((Component)controlButtonPanel, gbc);
            return panel;
        }

        private void makeLayout() {
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 6, 4, 6);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.getContentPane().add((Component)this.getCustomizedPanel(), gbc);
            if (FileChooser.this.customizedDialogType != 2) {
                this.okButton = new JButton(ElanLocale.getString("Button.OK"));
                this.okButton.addActionListener(this);
                this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
                this.cancelButton.addActionListener(this);
                this.backButton = new JButton(ElanLocale.getString("Button.Back"));
                this.backButton.addActionListener(this);
                JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
                buttonPanel.add(this.backButton);
                buttonPanel.add(this.okButton);
                buttonPanel.add(this.cancelButton);
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.anchor = 15;
                gbc.fill = 0;
                this.getContentPane().add((Component)buttonPanel, gbc);
            }
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    CustomizedDialogForMac.this.doClose();
                }
            });
        }

        private String getSelectedExtension() {
            if (this.saveComboBox != null) {
                return (String)this.saveComboBox.getSelectedItem();
            }
            return null;
        }

        private void addFile(File file) {
            if (!this.model.contains(file)) {
                int curIndex = this.fileList.getSelectedIndex();
                this.model.add(curIndex + 1, file);
                this.fileList.setSelectedIndex(curIndex + 1);
            }
            if (this.model.size() > 0) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }

        public void removeFile() {
            int[] selIndices = this.fileList.getSelectedIndices();
            if (selIndices.length == 0) {
                return;
            }
            for (int i = selIndices.length - 1; i >= 0; --i) {
                this.model.removeElementAt(selIndices[i]);
            }
            if (this.model.getSize() > 0) {
                this.fileList.setSelectedIndex(this.model.getSize() - 1);
                this.fileList.ensureIndexIsVisible(this.model.getSize() - 1);
            }
            if (this.model.size() > 0) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }

        public void moveUp() {
            int[] selIndices = this.fileList.getSelectedIndices();
            if (selIndices.length == 0) {
                return;
            }
            for (int i = 0; i < selIndices.length; ++i) {
                if (selIndices[i] == i) continue;
                this.model.insertElementAt(this.model.remove(selIndices[i]), selIndices[i] - 1);
            }
            int[] newSels = new int[selIndices.length];
            for (int i = 0; i < selIndices.length; ++i) {
                newSels[i] = selIndices[i] == i ? i : selIndices[i] - 1;
            }
            this.fileList.setSelectedIndices(newSels);
        }

        public void moveDown() {
            int[] selIndices = this.fileList.getSelectedIndices();
            if (selIndices.length == 0) {
                return;
            }
            int unmovableIndex = this.model.getSize() - 1;
            int[] newSels = new int[selIndices.length];
            for (int i = selIndices.length - 1; i >= 0; --i) {
                if (selIndices[i] == unmovableIndex) {
                    --unmovableIndex;
                    newSels[i] = selIndices[i];
                    continue;
                }
                this.model.insertElementAt(this.model.remove(selIndices[i]), selIndices[i] + 1);
                newSels[i] = selIndices[i] + 1;
            }
            this.fileList.setSelectedIndices(newSels);
        }

        public void addRemoteFile() {
            JOptionPane pane = new JOptionPane(ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteLabel"), -1, 2);
            pane.setWantsInput(true);
            Dimension parentDim = this.getSize();
            JDialog d = pane.createDialog(this, ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteMedia"));
            Dimension paneDim = d.getSize();
            d.setMinimumSize(new Dimension(Math.max(paneDim.width, (int)(parentDim.getWidth() * 0.8)), paneDim.height));
            d.setLocationRelativeTo(this);
            d.setVisible(true);
            Object option = pane.getValue();
            if (option == null) {
                return;
            }
            if (option instanceof Integer && 0 != (Integer)option) {
                return;
            }
            Object rf = pane.getInputValue();
            if (rf == null) {
                return;
            }
            String url = (String)rf;
            if (url.isEmpty()) {
                return;
            }
            url.replace('\\', '/');
            boolean valid = FileUtility.isRemoteFile(url);
            if (!valid) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteMessage") + url, ElanLocale.getString("Message.Error"), 0);
                this.addRemoteFile();
            } else {
                int curIndex = this.fileList.getSelectedIndex();
                this.model.add(curIndex + 1, url);
                this.fileList.setSelectedIndex(curIndex + 1);
                if (this.model.size() > 0) {
                    this.okButton.setEnabled(true);
                } else {
                    this.okButton.setEnabled(false);
                }
            }
        }

        public Object[] getFiles() {
            Object[] obj = new Object[this.model.getSize()];
            for (int i = 0; i < obj.length; ++i) {
                obj[i] = this.model.getElementAt(i);
            }
            if (obj.length > 0) {
                return obj;
            }
            return null;
        }

        private void doClose() {
            this.setVisible(false);
            this.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.okButton) {
                FileChooser.this.getSelectedValueFrom(this.component);
                this.doClose();
            } else if (e.getSource() == this.cancelButton) {
                this.doClose();
            } else if (e.getSource() == this.backButton) {
                boolean validExt;
                this.setVisible(false);
                FileChooser.this.dialog.setVisible(true);
                String file = FileChooser.this.dialog.getFile();
                FileChooser.this.currentDirectory = FileChooser.this.dialog.getDirectory();
                if (file != null) {
                    FileChooser.this.selectedFile = new File(FileChooser.this.dialog.getDirectory(), file);
                }
                if (FileChooser.this.selectedFile != null && !(validExt = FileChooser.this.isValidExt(FileChooser.this.acceptAllFilesTypes)) && FileChooser.this.extensions.size() > 1 && FileChooser.this.mainDialogType == 1) {
                    this.showFileTypes = true;
                    this.getContentPane().removeAll();
                    this.makeLayout();
                    this.setVisible(true);
                }
            }
        }
    }

    private class CustomizedFileChooser
    extends JComponent
    implements ActionListener {
        protected JButton okButton;
        protected JButton cancelButton;
        protected JDialog dialog;
        protected int returnValue = -1;
        protected JComponent component;
        private JList fileList;
        private DefaultListModel model;
        private FileFilter mediaFilter;
        private FileFilter templateFilter;
        private FileFilter qtFilter;
        private FileFilter mp4Filter;
        private FileFilter mpgFilter;
        private FileFilter wavFilter;

        private CustomizedFileChooser() {
            this.initComponents();
        }

        private JPanel getCustomizedPanel() {
            JPanel panel = new JPanel();
            switch (FileChooser.this.customizedDialogType) {
                case 0: {
                    this.component = new JComboBox();
                    for (int i = 0; i < encodings.length; ++i) {
                        ((JComboBox)this.component).addItem(encodings[i]);
                        if (i != 0) continue;
                        ((JComboBox)this.component).setSelectedItem(encodings[i]);
                    }
                    if (FileChooser.this.getSelectedEncoding() != null) {
                        ((JComboBox)this.component).setSelectedItem(FileChooser.this.getSelectedEncoding());
                    }
                    panel.add(new JLabel(ElanLocale.getString("FileChooser.Label.Encoding")));
                    panel.add(this.component);
                    break;
                }
                case 1: {
                    this.component = new JCheckBox(ElanLocale.getString("ExportSelectionAsEAF.Label.ClipMedia"));
                    panel.add(this.component);
                    break;
                }
                case 2: {
                    panel = this.getMultiFilePanel();
                }
            }
            return panel;
        }

        private JPanel getMultiFilePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            final JRadioButton mediaRB = new JRadioButton();
            final JRadioButton templateRB = new JRadioButton();
            final JButton remoteButton = new JButton();
            final JButton removeButton = new JButton();
            removeButton.setEnabled(false);
            final JButton upButton = new JButton();
            final JButton downButton = new JButton();
            final JButton copyButton = new JButton();
            if (FileChooser.this.multiFileDialogMode == 1 || FileChooser.this.multiFileDialogMode == 2) {
                this.mediaFilter = ElanFileFilter.createFileFilter(2);
                this.templateFilter = ElanFileFilter.createFileFilter(4);
                this.qtFilter = ElanFileFilter.createFileFilter(17);
                this.mp4Filter = ElanFileFilter.createFileFilter(16);
                this.mpgFilter = ElanFileFilter.createFileFilter(0);
                this.wavFilter = ElanFileFilter.createFileFilter(1);
            }
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object src = e.getSource();
                    if (src == copyButton) {
                        CustomizedFileChooser.this.copyFile();
                    } else if (src == removeButton) {
                        CustomizedFileChooser.this.removeFile();
                    } else if (src == upButton) {
                        CustomizedFileChooser.this.moveUp();
                    } else if (src == downButton) {
                        CustomizedFileChooser.this.moveDown();
                    } else if (src == FileChooser.this.chooser) {
                        CustomizedFileChooser.this.copyFile();
                    } else if (src == mediaRB) {
                        CustomizedFileChooser.this.setMediaFilter();
                    } else if (src == templateRB) {
                        CustomizedFileChooser.this.setTemplateFilter();
                    } else if (src == remoteButton) {
                        CustomizedFileChooser.this.addRemoteFile();
                    }
                    if (CustomizedFileChooser.this.model.size() > 0) {
                        removeButton.setEnabled(true);
                    } else {
                        removeButton.setEnabled(false);
                    }
                }
            };
            FileChooser.this.chooser.addActionListener(listener);
            copyButton.addActionListener(listener);
            removeButton.addActionListener(listener);
            upButton.addActionListener(listener);
            downButton.addActionListener(listener);
            mediaRB.addActionListener(listener);
            templateRB.addActionListener(listener);
            ImageIcon REMOVE_ICON = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Remove.gif"));
            ImageIcon UP_ICON = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Up.gif"));
            ImageIcon DOWN_ICON = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Down.gif"));
            removeButton.setIcon(REMOVE_ICON);
            upButton.setIcon(UP_ICON);
            downButton.setIcon(DOWN_ICON);
            Insets insets = new Insets(2, 2, 2, 2);
            JPanel midPanel = new JPanel(new GridBagLayout());
            copyButton.setText(" >> ");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 6, 4, 6);
            midPanel.add((Component)copyButton, gbc);
            if (FileChooser.this.multiFileDialogMode == 1) {
                JPanel selPanel = new JPanel(new GridBagLayout());
                selPanel.setBorder(new TitledBorder(ElanLocale.getString("Frame.ElanFrame.NewDialog.RadioFileType")));
                ButtonGroup bg = new ButtonGroup();
                mediaRB.setSelected(true);
                mediaRB.setText(ElanLocale.getString("Frame.ElanFrame.NewDialog.RadioButtonMedia"));
                templateRB.setText(ElanLocale.getString("Frame.ElanFrame.NewDialog.RadioButtonTemplate"));
                bg.add(mediaRB);
                bg.add(templateRB);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.anchor = 18;
                gbc.insets = insets;
                selPanel.add((Component)mediaRB, gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.anchor = 18;
                gbc.insets = insets;
                selPanel.add((Component)templateRB, gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.anchor = 15;
                gbc.insets = new Insets(4, 6, 4, 6);
                midPanel.add((Component)selPanel, gbc);
            } else {
                remoteButton.setVisible(false);
            }
            JPanel rightPanel = new JPanel(new GridBagLayout());
            JPanel infoPanel = new JPanel(new GridBagLayout());
            Dimension dim = new Dimension(70, 40);
            infoPanel.setPreferredSize(dim);
            infoPanel.setMinimumSize(dim);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 10;
            gbc.insets = insets;
            gbc.fill = 2;
            gbc.weighty = 1.0;
            infoPanel.add(new JLabel(ElanLocale.getString("Frame.ElanFrame.NewDialog.Selected")));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = insets;
            gbc.anchor = 11;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            rightPanel.add((Component)infoPanel, gbc);
            this.model = new DefaultListModel();
            this.fileList = new JList(this.model);
            this.fileList.setSelectionMode(2);
            if (FileChooser.this.selectedFiles != null) {
                this.model.clear();
                for (int i = 0; i < FileChooser.this.selectedFiles.length; ++i) {
                    this.model.insertElementAt(FileChooser.this.selectedFiles[i], i);
                }
                if (this.model.size() > 0) {
                    removeButton.setEnabled(true);
                }
                this.fileList.setSelectedIndex(0);
                this.fileList.ensureIndexIsVisible(0);
                FileChooser.access$1302(FileChooser.this, null);
            }
            JScrollPane jsp = new JScrollPane(this.fileList);
            jsp.setPreferredSize(new Dimension(jsp.getPreferredSize().getSize().width - 30, jsp.getPreferredSize().getSize().height));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = insets;
            gbc.anchor = 11;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            rightPanel.add((Component)jsp, gbc);
            JPanel controlPanel = new JPanel(new GridLayout(1, 3, 6, 6));
            controlPanel.add(removeButton);
            controlPanel.add(upButton);
            controlPanel.add(downButton);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = insets;
            gbc.anchor = 11;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            rightPanel.add((Component)controlPanel, gbc);
            remoteButton.setText(ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteMedia"));
            remoteButton.addActionListener(listener);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 11;
            gbc.insets = new Insets(7, 2, 3, 2);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            rightPanel.add((Component)remoteButton, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 11;
            gbc.fill = 3;
            gbc.weighty = 1.0;
            panel.add((Component)midPanel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 11;
            gbc.insets = insets;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            panel.add((Component)rightPanel, gbc);
            return panel;
        }

        protected void initComponents() {
            this.okButton = new JButton();
            this.cancelButton = new JButton();
            this.okButton.addActionListener(this);
            this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
            this.cancelButton.addActionListener(this);
            Insets insets = new Insets(0, 6, 6, 6);
            JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 6));
            buttonPanel.add(this.okButton);
            buttonPanel.add(this.cancelButton);
            JPanel butBorderPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            butBorderPanel.add((Component)new JPanel(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 13;
            gbc.insets = insets;
            butBorderPanel.add((Component)buttonPanel, gbc);
            this.setLayout(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.add((Component)FileChooser.this.chooser, gbc);
            switch (FileChooser.this.customizedDialogType) {
                case 2: {
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 0;
                    gbc.anchor = 12;
                    gbc.fill = 1;
                    gbc.insets = insets;
                    this.add((Component)this.getCustomizedPanel(), gbc);
                    String approveButtonText = FileChooser.this.chooser.getApproveButtonText();
                    if (approveButtonText != null) {
                        this.okButton.setText(approveButtonText);
                    } else {
                        this.okButton.setText(ElanLocale.getString("Button.OK"));
                    }
                    if (this.model.size() > 0) {
                        this.okButton.setEnabled(true);
                    } else {
                        this.okButton.setEnabled(false);
                    }
                    butBorderPanel.setBorder(new CompoundBorder(new LineBorder(Color.GRAY, 1), new EmptyBorder(6, 6, 6, 6)));
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 1;
                    gbc.gridwidth = 3;
                    gbc.anchor = 15;
                    gbc.fill = 2;
                    gbc.insets = insets;
                    this.add((Component)butBorderPanel, gbc);
                    break;
                }
                default: {
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 1;
                    gbc.anchor = 10;
                    gbc.fill = 0;
                    gbc.insets = insets;
                    this.add((Component)this.getCustomizedPanel(), gbc);
                    switch (FileChooser.this.chooser.getDialogType()) {
                        case 1: {
                            this.okButton.setText(ElanLocale.getString("Menu.File.Save"));
                            break;
                        }
                        case 0: {
                            this.okButton.setText(ElanLocale.getString("Menu.File.Open"));
                        }
                    }
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 2;
                    gbc.anchor = 15;
                    gbc.fill = 2;
                    gbc.insets = insets;
                    this.add((Component)butBorderPanel, gbc);
                }
            }
        }

        public int showDialog(Component parent) throws HeadlessException {
            this.dialog = this.createDialog(parent);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    CustomizedFileChooser.this.returnValue = 1;
                }
            });
            this.returnValue = -1;
            this.dialog.setVisible(true);
            this.dialog.dispose();
            this.dialog = null;
            return this.returnValue;
        }

        private JDialog createDialog(Component parent) throws HeadlessException {
            Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
            ClosableDialog dialog = new ClosableDialog(frame, FileChooser.this.chooser.getDialogTitle(), true);
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(parent);
            return dialog;
        }

        private boolean isMediaFile(String file) {
            String ext = FileUtility.getExtension(file);
            if (ext == null) {
                return false;
            }
            for (String element : FileExtension.MEDIA_EXT) {
                if (!ext.equalsIgnoreCase(element)) continue;
                return true;
            }
            return false;
        }

        private boolean isTemplateFile(String file) {
            String ext = FileUtility.getExtension(file);
            if (ext == null) {
                return false;
            }
            for (String element : FileExtension.TEMPLATE_EXT) {
                if (!ext.equalsIgnoreCase(element)) continue;
                return true;
            }
            return false;
        }

        private void storeLastUsedMediaTypePref() {
            FileFilter ff = FileChooser.this.chooser.getFileFilter();
            if (ff.getDescription().equals(this.templateFilter.getDescription())) {
                return;
            }
            int type = -1;
            if (this.mediaFilter.getDescription().equals(ff.getDescription())) {
                type = 2;
            } else if (this.mp4Filter.getDescription().equals(ff.getDescription())) {
                type = 16;
            } else if (this.qtFilter.getDescription().equals(ff.getDescription())) {
                type = 17;
            } else if (this.wavFilter.getDescription().equals(ff.getDescription())) {
                type = 1;
            } else if (this.mpgFilter.getDescription().equals(ff.getDescription())) {
                type = 0;
            }
            Preferences.set("Media.LastUsedMediaType", (Object)type, null);
        }

        private void copyFile() {
            String mediaDir = null;
            String templateDir = null;
            if (FileChooser.this.chooser.isMultiSelectionEnabled()) {
                File[] files = FileChooser.this.chooser.getSelectedFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!this.model.contains(files[i])) {
                        int curIndex = this.fileList.getSelectedIndex();
                        this.model.add(curIndex + 1, files[i]);
                        this.fileList.setSelectedIndex(curIndex + 1);
                    }
                    if (mediaDir == null && this.isMediaFile(files[i].getAbsolutePath())) {
                        mediaDir = files[i].getAbsolutePath();
                        mediaDir = new File(mediaDir).getParent();
                        continue;
                    }
                    if (templateDir != null || !this.isTemplateFile(files[i].getAbsolutePath())) continue;
                    templateDir = files[i].getAbsolutePath();
                    templateDir = new File(templateDir).getParent();
                }
            } else {
                File f = FileChooser.this.chooser.getSelectedFile();
                if (f != null) {
                    int curIndex = this.fileList.getSelectedIndex();
                    this.model.add(curIndex + 1, f);
                    this.fileList.setSelectedIndex(curIndex + 1);
                    if (this.isMediaFile(f.getAbsolutePath())) {
                        mediaDir = f.getAbsolutePath();
                        mediaDir = new File(mediaDir).getParent();
                    } else if (this.isTemplateFile(f.getAbsolutePath())) {
                        templateDir = f.getAbsolutePath();
                        templateDir = new File(templateDir).getParent();
                    }
                }
            }
            if (templateDir != null) {
                Preferences.set("TemplateDir", templateDir, null);
            }
            if (mediaDir != null) {
                Preferences.set("MediaDir", mediaDir, null);
                this.storeLastUsedMediaTypePref();
            }
            if (this.model.size() > 0) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }

        private void removeFile() {
            int[] selIndices = this.fileList.getSelectedIndices();
            if (selIndices.length == 0) {
                return;
            }
            for (int i = selIndices.length - 1; i >= 0; --i) {
                this.model.removeElementAt(selIndices[i]);
            }
            if (selIndices[0] < this.model.getSize()) {
                this.fileList.setSelectedIndex(selIndices[0]);
                this.fileList.ensureIndexIsVisible(selIndices[0]);
            }
            if (this.model.size() > 0) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }

        private void moveUp() {
            int[] selIndices = this.fileList.getSelectedIndices();
            if (selIndices.length == 0) {
                return;
            }
            for (int i = 0; i < selIndices.length; ++i) {
                if (selIndices[i] == i) continue;
                this.model.insertElementAt(this.model.remove(selIndices[i]), selIndices[i] - 1);
            }
            int[] newSels = new int[selIndices.length];
            for (int i = 0; i < selIndices.length; ++i) {
                newSels[i] = selIndices[i] == i ? i : selIndices[i] - 1;
            }
            this.fileList.setSelectedIndices(newSels);
        }

        private void moveDown() {
            int[] selIndices = this.fileList.getSelectedIndices();
            if (selIndices.length == 0) {
                return;
            }
            int unmovableIndex = this.model.getSize() - 1;
            int[] newSels = new int[selIndices.length];
            for (int i = selIndices.length - 1; i >= 0; --i) {
                if (selIndices[i] == unmovableIndex) {
                    --unmovableIndex;
                    newSels[i] = selIndices[i];
                    continue;
                }
                this.model.insertElementAt(this.model.remove(selIndices[i]), selIndices[i] + 1);
                newSels[i] = selIndices[i] + 1;
            }
            this.fileList.setSelectedIndices(newSels);
        }

        private void setMediaFilter() {
            FileFilter[] filters;
            boolean isMedia = false;
            for (FileFilter filter : filters = FileChooser.this.chooser.getChoosableFileFilters()) {
                if (filter != this.mediaFilter) continue;
                isMedia = true;
                break;
            }
            if (!isMedia) {
                File selectedFile = FileChooser.this.chooser.getSelectedFile();
                if (selectedFile != null) {
                    String strTemplateDir = selectedFile.getAbsolutePath();
                    strTemplateDir = new File(strTemplateDir).getParent();
                    Preferences.set("TemplateDir", strTemplateDir, null);
                }
                for (FileFilter filter : FileChooser.this.chooser.getChoosableFileFilters()) {
                    if (filter == FileChooser.this.chooser.getAcceptAllFileFilter()) continue;
                    FileChooser.this.chooser.removeChoosableFileFilter(filter);
                }
                FileChooser.this.chooser.addChoosableFileFilter(this.mediaFilter);
                FileChooser.this.chooser.addChoosableFileFilter(this.mp4Filter);
                FileChooser.this.chooser.addChoosableFileFilter(this.qtFilter);
                FileChooser.this.chooser.addChoosableFileFilter(this.mpgFilter);
                FileChooser.this.chooser.addChoosableFileFilter(this.wavFilter);
                Integer val = Preferences.getInt("Media.LastUsedMediaType", null);
                if (val != null) {
                    int type = val;
                    if (type == 2) {
                        FileChooser.this.chooser.setFileFilter(this.mediaFilter);
                    } else if (type == 16) {
                        FileChooser.this.chooser.setFileFilter(this.mp4Filter);
                    } else if (type == 17) {
                        FileChooser.this.chooser.setFileFilter(this.qtFilter);
                    } else if (type == 0) {
                        FileChooser.this.chooser.setFileFilter(this.mpgFilter);
                    } else if (type == 1) {
                        FileChooser.this.chooser.setFileFilter(this.wavFilter);
                    } else {
                        FileChooser.this.chooser.setFileFilter(this.mediaFilter);
                    }
                } else {
                    FileChooser.this.chooser.setFileFilter(this.mediaFilter);
                }
                String mediaDir = Preferences.getString("MediaDir", null);
                FileChooser.this.chooser.setCurrentDirectory(new File(mediaDir == null ? Constants.USERHOME : mediaDir));
            }
        }

        private void setTemplateFilter() {
            FileFilter[] filters;
            boolean isTemplate = false;
            for (FileFilter filter : filters = FileChooser.this.chooser.getChoosableFileFilters()) {
                if (!filter.getDescription().equals(this.templateFilter.getDescription())) continue;
                isTemplate = true;
                FileChooser.this.chooser.setFileFilter(this.templateFilter);
                break;
            }
            if (!isTemplate) {
                File selectedFile = FileChooser.this.chooser.getSelectedFile();
                if (selectedFile != null) {
                    String strMediaDir = selectedFile.getAbsolutePath();
                    strMediaDir = new File(strMediaDir).getParent();
                    Preferences.set("MediaDir", strMediaDir, null);
                }
                this.storeLastUsedMediaTypePref();
                for (FileFilter filter : FileChooser.this.chooser.getChoosableFileFilters()) {
                    if (filter == FileChooser.this.chooser.getAcceptAllFileFilter()) continue;
                    FileChooser.this.chooser.removeChoosableFileFilter(filter);
                }
                FileChooser.this.chooser.addChoosableFileFilter(this.templateFilter);
                String templateDir = Preferences.getString("TemplateDir", null);
                FileChooser.this.chooser.setCurrentDirectory(new File(templateDir == null ? Constants.USERHOME : templateDir));
            }
        }

        private void addRemoteFile() {
            JOptionPane pane = new JOptionPane(ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteLabel"), -1, 2);
            pane.setWantsInput(true);
            Dimension parentDim = this.getSize();
            JDialog d = pane.createDialog(this, ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteMedia"));
            Dimension paneDim = d.getSize();
            d.setMinimumSize(new Dimension(Math.max(paneDim.width, (int)(parentDim.getWidth() * 0.5)), paneDim.height));
            d.setLocationRelativeTo(this);
            d.setVisible(true);
            Object option = pane.getValue();
            if (option == null) {
                return;
            }
            if (option instanceof Integer && 0 != (Integer)option) {
                return;
            }
            Object rf = pane.getInputValue();
            if (rf == null) {
                return;
            }
            String url = (String)rf;
            if (url.isEmpty()) {
                return;
            }
            url.replace('\\', '/');
            boolean valid = FileUtility.isRemoteFile(url);
            if (!valid) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteMessage") + url, ElanLocale.getString("Message.Error"), 0);
                this.addRemoteFile();
            } else {
                int curIndex = this.fileList.getSelectedIndex();
                this.model.add(curIndex + 1, url);
                this.fileList.setSelectedIndex(curIndex + 1);
                if (this.model.size() > 0) {
                    this.okButton.setEnabled(true);
                } else {
                    this.okButton.setEnabled(false);
                }
            }
        }

        public File getSelectedFile() {
            return FileChooser.this.chooser.getSelectedFile();
        }

        public Object[] getFiles() {
            Object[] obj = new Object[this.model.getSize()];
            for (int i = 0; i < obj.length; ++i) {
                obj[i] = this.model.getElementAt(i);
            }
            if (obj.length > 0) {
                return obj;
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.okButton) {
                if (FileChooser.this.customizedDialogType != 2) {
                    Component c = this.getTextField(FileChooser.this.chooser);
                    if (c instanceof JTextField) {
                        String fileName = ((JTextField)c).getText();
                        FileChooser.this.chooser.setSelectedFile(new File(FileChooser.this.chooser.getCurrentDirectory(), fileName));
                    }
                    FileChooser.this.getSelectedValueFrom(this.component);
                }
                this.returnValue = 0;
                this.dialog.setVisible(false);
            } else if (e.getSource() == this.cancelButton) {
                this.returnValue = 1;
                this.dialog.setVisible(false);
            }
        }

        private Component getTextField(Container container) {
            Component c = null;
            if (container != null) {
                Component[] cc;
                for (Component element : cc = container.getComponents()) {
                    c = element;
                    if (c instanceof JTextField) {
                        return c;
                    }
                    if (!(c instanceof Container) || !((c = this.getTextField((Container)c)) instanceof JTextField)) continue;
                    return c;
                }
            }
            return c;
        }
    }
}

