/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.AbstractTwoTierOpDialog;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class FilterTierDialog
extends AbstractTwoTierOpDialog {
    private JPanel extraOptionsPanel;
    private JLabel filterLabel;
    private JTextField filterField;
    private JButton addFilterButton;
    private JButton removeFilterButton;
    private JList<String> filterList;

    public FilterTierDialog(Transcription transcription) {
        super(transcription);
        this.initOptionsPanel();
        this.updateLocale();
        this.loadPreferences();
        this.postInit();
    }

    protected void initOptionsPanel() {
        Insets insets = new Insets(2, 0, 2, 6);
        this.extraOptionsPanel = new JPanel(new GridBagLayout());
        this.filterLabel = new JLabel();
        this.filterField = new JTextField();
        this.addFilterButton = new JButton();
        this.removeFilterButton = new JButton();
        this.filterList = new JList();
        JScrollPane listPane = new JScrollPane(this.filterList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)this.filterLabel, gridBagConstraints);
        this.filterField.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)this.filterField, gridBagConstraints);
        this.addFilterButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        this.extraOptionsPanel.add((Component)this.addFilterButton, gridBagConstraints);
        this.removeFilterButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        this.extraOptionsPanel.add((Component)this.removeFilterButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)listPane, gridBagConstraints);
        this.addOptionsPanel(this.extraOptionsPanel);
        RemoveFiltersAction rfa = new RemoveFiltersAction();
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        if (inputMap instanceof ComponentInputMap && actionMap != null) {
            inputMap.put((KeyStroke)rfa.getValue("AcceleratorKey"), rfa.getValue("Default"));
            actionMap.put(rfa.getValue("Default"), rfa);
        }
        if (this.filterField.getPreferredSize() != null) {
            this.filterField.setMinimumSize(this.filterField.getPreferredSize());
        }
        if (listPane.getPreferredSize() != null) {
            listPane.setMinimumSize(listPane.getPreferredSize());
        }
    }

    @Override
    protected void extractDestinationTiers() {
        this.destTierComboBox.removeAllItems();
        this.destTierComboBox.addItem("-");
        if (this.sourceTierComboBox.getSelectedItem() != null && this.sourceTierComboBox.getSelectedItem() != "-") {
            String name = (String)this.sourceTierComboBox.getSelectedItem();
            TierImpl source = this.transcription.getTierWithId(name);
            for (TierImpl dest : source.getDependentTiers()) {
                LinguisticType lt = dest.getLinguisticType();
                if (dest.getParentTier() != source || lt.getConstraints().getStereoType() != 4) continue;
                this.destTierComboBox.addItem(dest.getName());
            }
            if (this.destTierComboBox.getItemCount() > 1) {
                this.destTierComboBox.removeItem("-");
            }
        }
    }

    @Override
    protected void startOperation() {
        String sourceName = (String)this.sourceTierComboBox.getSelectedItem();
        String destName = (String)this.destTierComboBox.getSelectedItem();
        boolean preserveExisting = this.preserveRB.isSelected();
        boolean createEmptyAnnotations = this.emptyAnnCheckBox.isSelected();
        if (sourceName == "-" || destName == "-") {
            this.showWarningDialog(ElanLocale.getString("TokenizeDialog.Message.InvalidTiers"));
            return;
        }
        String[] filters = null;
        Object[] listObj = ((DefaultListModel)this.filterList.getModel()).toArray();
        if (listObj != null && listObj.length > 0) {
            filters = new String[listObj.length];
            for (int i = 0; i < listObj.length; ++i) {
                filters[i] = (String)listObj[i];
            }
        }
        this.storePreferences();
        Command com = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.FilterTier");
        Object[] args = new Object[]{sourceName, destName, filters, preserveExisting, createEmptyAnnotations};
        com.execute(this.transcription, args);
    }

    protected void addFilter() {
        String text = this.filterField.getText();
        if (text != null && text.length() > 0) {
            int size = this.filterList.getModel().getSize();
            for (int i = 0; i < size; ++i) {
                String item = this.filterList.getModel().getElementAt(i);
                if (!text.equals(item)) continue;
                return;
            }
            ((DefaultListModel)this.filterList.getModel()).addElement(text);
            this.filterField.setText("");
            this.filterField.requestFocus();
        }
    }

    protected void removeFilter() {
        int[] selected = this.filterList.getSelectedIndices();
        if (selected != null && selected.length > 0) {
            for (int i = selected.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.filterList.getModel()).removeElementAt(selected[i]);
            }
        }
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("FilterDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("FilterDialog.Title"));
        this.filterLabel.setText(ElanLocale.getString("FilterDialog.Label.Filter"));
        this.addFilterButton.setText(ElanLocale.getString("FilterDialog.Button.Add"));
        this.removeFilterButton.setText(ElanLocale.getString("FilterDialog.Button.Remove"));
    }

    private void storePreferences() {
        Preferences.set("FilterDialog.Overwrite", this.overwriteRB.isSelected(), null, false, false);
        Preferences.set("FilterDialog.ProcessEmptyAnnotations", this.emptyAnnCheckBox.isSelected(), null, false, false);
    }

    private void loadPreferences() {
        Boolean val = null;
        val = Preferences.getBool("FilterDialog.Overwrite", null);
        if (val != null) {
            boolean overwr = val;
            if (overwr) {
                this.overwriteRB.setSelected(true);
            } else {
                this.preserveRB.setSelected(true);
            }
        }
        if ((val = Preferences.getBool("FilterDialog.ProcessEmptyAnnotations", null)) != null) {
            this.emptyAnnCheckBox.setSelected(val);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.addFilterButton) {
            this.addFilter();
        } else if (source == this.removeFilterButton) {
            this.removeFilter();
        } else {
            super.actionPerformed(ae);
        }
    }

    class RemoveFiltersAction
    extends AbstractAction {
        public RemoveFiltersAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            this.putValue("Default", "RemoveFilter");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FilterTierDialog.this.filterList != null && FilterTierDialog.this.filterList.getSelectedIndices().length > 0) {
                Object[] selObjects;
                for (Object selObject : selObjects = FilterTierDialog.this.filterList.getSelectedValues()) {
                    ((DefaultListModel)FilterTierDialog.this.filterList.getModel()).removeElement(selObject);
                }
            }
        }
    }
}

