/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.WindowLocationAndSizeManager;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.ComboBoxTableCellRenderer;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextReader;

public class ImportCSVDialog
extends ClosableDialog
implements ActionListener,
ChangeListener,
ItemListener {
    private File csvFile;
    private Object value;
    private String[] colTypes;
    private DefaultTableModel selectModel;
    private String detectedDel;
    private int detectedNumCols;
    private int assumedFirstRow = 0;
    private JPanel examplePanel;
    private JPanel optionsPanel;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox delimiterCB;
    private JCheckBox firstRowCB;
    private JCheckBox defaultDurCB;
    private JCheckBox skipEmptyCB;
    private JComboBox delimiterCombo;
    private JSpinner firstRowSpinner;
    private JLabel selectionLabel;
    private JTable sampleTable;
    private SelectionTable selectionTable;
    private JTextField durationTF;
    private final String INTERVAL_PREF = "ShoeboxChatBlockDuration";
    private String curDelimiter;
    private DelimitedTextReader csvReader;

    public ImportCSVDialog(Frame owner, File csvFile) throws HeadlessException {
        super(owner, true);
        this.csvFile = csvFile;
        this.initComponents();
        this.initTables();
    }

    private void initTables() {
        try {
            this.csvReader = new DelimitedTextReader(this.csvFile);
            this.detectedDel = this.csvReader.detectDelimiter();
            this.detectedNumCols = this.csvReader.detectNumColumns();
            List<String[]> rows = this.csvReader.getSamples(8);
            this.createAndApplyModels(rows, this.detectedNumCols);
            this.delimiterCombo.setSelectedItem(this.detectedDel);
            this.curDelimiter = this.detectedDel;
            this.updateSelectionTable(this.detectHeaders(rows));
        }
        catch (FileNotFoundException fnfe) {
            ClientLogger.LOG.warning("File not found: " + this.csvFile.getName());
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Read error: " + ioe.getMessage());
        }
    }

    private void reInitTables(String delimiter) {
        if (this.csvReader != null) {
            try {
                this.csvReader.setDelimiter(delimiter);
                int numColumns = this.csvReader.detectNumColumns();
                List<String[]> rows = this.csvReader.getSamples(8);
                if (numColumns == this.detectedNumCols) {
                    for (int i = 0; i < rows.size(); ++i) {
                        int j;
                        String[] row = rows.get(i);
                        this.sampleTable.setValueAt(i + 1, i, 0);
                        for (j = 0; j < row.length && j < numColumns; ++j) {
                            this.sampleTable.setValueAt(row[j], i, j + 1);
                        }
                        if (row.length >= numColumns) continue;
                        for (j = 0; j < numColumns - row.length; ++j) {
                            this.sampleTable.setValueAt("", i, row.length + j + 1);
                        }
                    }
                    this.updateSelectionTable(this.detectHeaders(rows));
                } else {
                    this.createAndApplyModels(rows, numColumns);
                    this.detectedNumCols = numColumns;
                    this.updateSelectionTable(this.detectHeaders(rows));
                }
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Re-read error: " + ioe.getMessage());
            }
        }
    }

    private void createAndApplyModels(List<String[]> rows, int numberOfColumns) {
        int i;
        if (rows == null) {
            ClientLogger.LOG.severe("The list of rows for the table model is null, cannot update the table");
            return;
        }
        DefaultTableModel csvModel = new DefaultTableModel(rows.size(), numberOfColumns + 1);
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            int j;
            String[] row = rows.get(i2);
            csvModel.setValueAt(i2 + 1, i2, 0);
            for (j = 0; j < row.length && j < numberOfColumns; ++j) {
                csvModel.setValueAt(row[j], i2, j + 1);
            }
            if (row.length >= numberOfColumns) continue;
            for (j = 0; j < numberOfColumns - row.length; ++j) {
                csvModel.setValueAt("", i2, row.length + j + 1);
            }
        }
        Object[] headers = new String[numberOfColumns + 1];
        headers[0] = ElanLocale.getString("Frame.GridFrame.ColumnCount");
        for (i = 0; i < numberOfColumns; ++i) {
            headers[i + 1] = String.valueOf(i + 1);
        }
        csvModel.setColumnIdentifiers(headers);
        this.sampleTable.setModel(csvModel);
        this.sampleTable.getTableHeader().setReorderingAllowed(false);
        this.sampleTable.getColumnModel().getColumn(0).sizeWidthToFit();
        this.selectModel = new SelectionTableModel(2, numberOfColumns + 1);
        headers = new String[numberOfColumns + 1];
        headers[0] = "-";
        for (i = 1; i < numberOfColumns + 1; ++i) {
            headers[i] = String.valueOf(i);
        }
        this.selectModel.setColumnIdentifiers(headers);
        for (i = 1; i < numberOfColumns + 1; ++i) {
            this.selectModel.setValueAt(Boolean.TRUE, 0, i);
            this.selectModel.setValueAt(this.colTypes[0], 1, i);
        }
        this.selectionTable.setModel(this.selectModel);
        this.selectionTable.getTableHeader().setReorderingAllowed(false);
        this.selectionTable.setRowSelectionAllowed(false);
    }

    private Map<Integer, String> detectHeaders(List<String[]> rows) {
        HashMap<Integer, String> headers = new HashMap<Integer, String>();
        boolean headersFound = false;
        for (String[] row : rows) {
            int i;
            if (row[0].startsWith("#") || row[0].startsWith("\"#")) continue;
            for (i = 0; i < row.length; ++i) {
                for (int j = 1; j < this.colTypes.length; ++j) {
                    if (row[i].indexOf(this.colTypes[j]) <= -1) continue;
                    headersFound = true;
                    break;
                }
                if (!headersFound) continue;
                this.assumedFirstRow = rows.indexOf(row) + 1;
                break;
            }
            if (!headersFound) continue;
            for (i = 0; i < row.length; ++i) {
                int curColType = 1;
                for (int j = 1; j < this.colTypes.length; ++j) {
                    if (row[i].indexOf(this.colTypes[j]) <= -1) continue;
                    curColType = j;
                    break;
                }
                if (curColType == 1) {
                    headers.put(i, this.colTypes[curColType]);
                    continue;
                }
                if (!headers.containsValue(this.colTypes[curColType])) {
                    headers.put(i, this.colTypes[curColType]);
                    continue;
                }
                headers.put(i, null);
            }
            return headers;
        }
        return null;
    }

    private void updateSelectionTable(Map<Integer, String> detectedHeaders) {
        if (detectedHeaders == null || detectedHeaders.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, String> entry : detectedHeaders.entrySet()) {
            int col = entry.getKey();
            String cType = entry.getValue();
            if (cType != null) {
                this.selectModel.setValueAt(Boolean.TRUE, 0, col + 1);
                this.selectModel.setValueAt(cType, 1, col + 1);
                continue;
            }
            this.selectModel.setValueAt(Boolean.FALSE, 0, col + 1);
        }
        if (this.assumedFirstRow > 0) {
            this.firstRowCB.setSelected(true);
            this.firstRowSpinner.setValue(this.assumedFirstRow + 1);
        } else {
            this.firstRowCB.setSelected(false);
            this.firstRowSpinner.setValue(1);
        }
    }

    private void initComponents() {
        this.colTypes = new String[6];
        this.colTypes[0] = ElanLocale.getString("Button.Select");
        this.colTypes[1] = ElanLocale.getString("Frame.GridFrame.ColumnAnnotation");
        this.colTypes[2] = ElanLocale.getString("Frame.GridFrame.ColumnTierName");
        this.colTypes[3] = ElanLocale.getString("Frame.GridFrame.ColumnBeginTime");
        this.colTypes[4] = ElanLocale.getString("Frame.GridFrame.ColumnEndTime");
        this.colTypes[5] = ElanLocale.getString("Frame.GridFrame.ColumnDuration");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ImportCSVDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.examplePanel = new JPanel(new GridBagLayout());
        this.sampleTable = new JTable();
        JScrollPane tableScrollPane = new JScrollPane(this.sampleTable);
        Dimension size = new Dimension(500, 120);
        tableScrollPane.setMinimumSize(size);
        tableScrollPane.setPreferredSize(size);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.examplePanel.add((Component)tableScrollPane, gbc);
        this.getContentPane().add((Component)this.examplePanel, gbc);
        this.optionsPanel = new JPanel(new GridBagLayout());
        this.selectionLabel = new JLabel();
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.gridwidth = 2;
        this.optionsPanel.add((Component)this.selectionLabel, gbc);
        this.selectionTable = new SelectionTable();
        JScrollPane tableScrollPane2 = new JScrollPane(this.selectionTable);
        size = new Dimension(500, 80);
        tableScrollPane2.setMinimumSize(size);
        tableScrollPane2.setPreferredSize(size);
        gbc.fill = 1;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        this.optionsPanel.add((Component)tableScrollPane2, gbc);
        this.firstRowCB = new JCheckBox();
        this.firstRowCB.addChangeListener(this);
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        this.optionsPanel.add((Component)this.firstRowCB, gbc);
        this.firstRowSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
        this.firstRowSpinner.setEnabled(false);
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.firstRowSpinner, gbc);
        this.delimiterCB = new JCheckBox();
        this.delimiterCB.addChangeListener(this);
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.optionsPanel.add((Component)this.delimiterCB, gbc);
        this.delimiterCombo = new JComboBox<String>(new String[]{ElanLocale.getString("ImportDialog.CSV.Label.Delimiter.Tab"), ";", ":", ",", "|"});
        this.delimiterCombo.setEnabled(false);
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.delimiterCombo, gbc);
        this.defaultDurCB = new JCheckBox();
        this.defaultDurCB.addChangeListener(this);
        gbc.gridx = 0;
        gbc.gridy = 4;
        this.optionsPanel.add((Component)this.defaultDurCB, gbc);
        this.durationTF = new JTextField(6);
        if (Preferences.getInt("ShoeboxChatBlockDuration", null) != null) {
            Integer val = Preferences.getInt("ShoeboxChatBlockDuration", null);
            this.durationTF.setText("" + val);
        } else {
            this.durationTF.setText("1000");
        }
        this.durationTF.setEnabled(false);
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.durationTF, gbc);
        this.skipEmptyCB = new JCheckBox();
        gbc.gridy = 5;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        this.optionsPanel.add((Component)this.skipEmptyCB, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.optionsPanel, gbc);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 0));
        this.okButton = new JButton();
        this.okButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.updateLocale();
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("Button.Import") + ": " + this.csvFile.getName());
        this.examplePanel.setBorder(new TitledBorder(ElanLocale.getString("ImportDialog.CSV.Label.Sample")));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ImportDialog.Label.Options")));
        this.selectionLabel.setText(ElanLocale.getString("ImportDialog.CSV.Label.Select"));
        this.firstRowCB.setText(ElanLocale.getString("ImportDialog.CSV.Label.FirstRow"));
        this.delimiterCB.setText(ElanLocale.getString("ImportDialog.CSV.Label.Delimiter"));
        this.defaultDurCB.setText(ElanLocale.getString("ImportDialog.CSV.Label.Duration"));
        this.skipEmptyCB.setText(ElanLocale.getString("ImportDialog.CSV.Label.SkipEmpty"));
        this.okButton.setText(ElanLocale.getString("Button.OK"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
    }

    protected void closeDialog(WindowEvent evt) {
        WindowLocationAndSizeManager.storeLocationAndSizePreferences(this, "ImportCSVDialog");
        this.setVisible(false);
        this.dispose();
    }

    public Object showDialog() {
        this.pack();
        WindowLocationAndSizeManager.postInit(this, "ImportCSVDialog", 600, 400);
        this.setVisible(true);
        return this.value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.createValueAndClose();
        } else if (e.getSource() == this.cancelButton) {
            this.value = null;
            this.closeDialog(null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.firstRowCB) {
            this.firstRowSpinner.setEnabled(this.firstRowCB.isSelected());
        } else if (ce.getSource() == this.delimiterCB) {
            boolean selected = this.delimiterCB.isSelected();
            this.delimiterCombo.setEnabled(selected);
            if (selected) {
                this.delimiterCombo.addItemListener(this);
            } else {
                this.delimiterCombo.removeItemListener(this);
            }
        } else if (ce.getSource() == this.defaultDurCB) {
            this.durationTF.setEnabled(this.defaultDurCB.isSelected());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.delimiterCombo && ie.getStateChange() == 1) {
            String selDelimiter = (String)this.delimiterCombo.getSelectedItem();
            if (this.curDelimiter == null || !this.curDelimiter.equals(selDelimiter)) {
                if (selDelimiter.equals(ElanLocale.getString("ImportDialog.CSV.Label.Delimiter.Tab"))) {
                    selDelimiter = "\t";
                }
                this.curDelimiter = selDelimiter;
                this.reInitTables(this.curDelimiter);
            }
        }
    }

    private void createValueAndClose() {
        Object val;
        for (int i = 1; i < this.selectionTable.getColumnCount(); ++i) {
            Object val1 = this.selectionTable.getValueAt(0, i);
            Object val2 = this.selectionTable.getValueAt(1, i);
            if (!(val1 instanceof Boolean) || !((Boolean)val1).booleanValue() || !this.colTypes[0].equals(val2)) continue;
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ImportDialog.CSV.Warning.Select") + " " + (i + 1), ElanLocale.getString("Message.Error"), 0);
            return;
        }
        int duration = 1000;
        if (this.defaultDurCB.isSelected()) {
            String durValue = this.durationTF.getText();
            if (durValue != null) {
                try {
                    duration = Integer.parseInt(durValue);
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("RegularAnnotationDialog.Message.InvalidSize"), ElanLocale.getString("Message.Error"), 0);
                    this.durationTF.requestFocus();
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("RegularAnnotationDialog.Message.InvalidSize"), ElanLocale.getString("Message.Error"), 0);
                this.durationTF.requestFocus();
                return;
            }
        }
        HashMap<Integer, Object> colMap = new HashMap<Integer, Object>(this.selectionTable.getColumnCount());
        int numAnnColumns = 0;
        for (int i = 1; i < this.selectionTable.getColumnCount(); ++i) {
            Object val1 = this.selectionTable.getValueAt(0, i);
            Object val2 = this.selectionTable.getValueAt(1, i);
            if (!(val1 instanceof Boolean) || !((Boolean)val1).booleanValue()) continue;
            colMap.put(i - 1, val2);
            if (!this.colTypes[1].equals(val2)) continue;
            ++numAnnColumns;
        }
        if (numAnnColumns == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ImportDialog.CSV.Warning.NoAnnotation"), ElanLocale.getString("Message.Error"), 0);
            return;
        }
        DelimitedTextDecoderInfo decoInfo = new DelimitedTextDecoderInfo(this.csvFile.getAbsolutePath());
        decoInfo.setDefaultDuration(duration);
        Preferences.set("ShoeboxChatBlockDuration", duration, null);
        decoInfo.setSingleAnnotationPerRow(numAnnColumns == 1);
        if (this.detectedDel != null) {
            decoInfo.setDelimiter(this.detectedDel);
        }
        if (this.delimiterCB.isSelected()) {
            Object delVal = this.delimiterCombo.getSelectedItem();
            if (ElanLocale.getString("ImportDialog.CSV.Label.Delimiter.Tab").equals(delVal)) {
                decoInfo.setDelimiter("\t");
            } else if (delVal != null) {
                decoInfo.setDelimiter((String)delVal);
            }
        }
        ArrayList<Integer> tempList = new ArrayList<Integer>();
        for (int i = 1; i < this.selectionTable.getColumnCount(); ++i) {
            Object val1 = this.selectionTable.getValueAt(0, i);
            if (!(val1 instanceof Boolean) || !((Boolean)val1).booleanValue()) continue;
            tempList.add(i - 1);
        }
        int[] inclCols = new int[tempList.size()];
        for (int i = 0; i < tempList.size(); ++i) {
            inclCols[i] = (Integer)tempList.get(i);
        }
        decoInfo.setIncludedColumns(inclCols);
        int firstRow = 0;
        if (this.firstRowCB.isSelected()) {
            firstRow = (Integer)this.firstRowSpinner.getValue() - 1;
        }
        decoInfo.setFirstRowIndex(firstRow);
        String[] inclColumnNames = null;
        if (firstRow > 0) {
            int i;
            inclColumnNames = new String[tempList.size()];
            int headerRow = 0;
            if (firstRow > 1) {
                for (i = 0; i < firstRow; ++i) {
                    String l;
                    val = this.sampleTable.getValueAt(i, 1);
                    if (!(val instanceof String) || (l = (String)val).isEmpty() || l.startsWith("#") || l.startsWith("\"#")) continue;
                    headerRow = i;
                    break;
                }
            }
            for (i = 0; i < inclCols.length; ++i) {
                val = this.sampleTable.getValueAt(headerRow, inclCols[i] + 1);
                inclColumnNames[i] = val instanceof String && !((String)val).isEmpty() ? (String)val : String.valueOf(i);
            }
            decoInfo.setIncludedColumnsNames(inclColumnNames);
        }
        decoInfo.setSkipEmptyCells(this.skipEmptyCB.isSelected());
        for (Integer keyInt : colMap.keySet()) {
            val = colMap.get(keyInt);
            if (!this.colTypes[3].equals(val)) continue;
            decoInfo.setBeginTimeColumn(keyInt);
            try {
                decoInfo.putTimeFormat(keyInt, this.csvReader.detectTimeFormat(keyInt));
                break;
            }
            catch (Throwable l) {
                // empty catch block
                break;
            }
        }
        for (Integer keyInt : colMap.keySet()) {
            val = colMap.get(keyInt);
            if (!this.colTypes[4].equals(val)) continue;
            decoInfo.setEndTimeColumn(keyInt);
            try {
                decoInfo.putTimeFormat(keyInt, this.csvReader.detectTimeFormat(keyInt));
                break;
            }
            catch (Throwable l) {
                // empty catch block
                break;
            }
        }
        for (Integer keyInt : colMap.keySet()) {
            val = colMap.get(keyInt);
            if (!this.colTypes[5].equals(val)) continue;
            decoInfo.setDurationColumn(keyInt);
            try {
                decoInfo.putTimeFormat(keyInt, this.csvReader.detectTimeFormat(keyInt));
                break;
            }
            catch (Throwable l) {
                // empty catch block
                break;
            }
        }
        for (Integer keyInt : colMap.keySet()) {
            val = colMap.get(keyInt);
            if (!this.colTypes[2].equals(val)) continue;
            decoInfo.setTierColumnIndex(keyInt);
            break;
        }
        ArrayList<Integer> annColumns = new ArrayList<Integer>();
        for (Integer keyInt : colMap.keySet()) {
            val = colMap.get(keyInt);
            if (!this.colTypes[1].equals(val)) continue;
            annColumns.add(keyInt);
        }
        int[] annArray = new int[annColumns.size()];
        for (int j = 0; j < annArray.length; ++j) {
            annArray[j] = (Integer)annColumns.get(j);
        }
        decoInfo.setAnnotationColumns(annArray);
        HashMap<Integer, String> tierColMap = new HashMap<Integer, String>(annArray.length);
        if (inclColumnNames != null) {
            for (int i = 0; i < annArray.length; ++i) {
                for (int j = 0; j < inclCols.length; ++j) {
                    if (annArray[i] != inclCols[j] || j >= inclColumnNames.length) continue;
                    tierColMap.put(annArray[i], inclColumnNames[j]);
                }
            }
        } else if (decoInfo.getTierColumnIndex() < 0) {
            for (int i = 0; i < annArray.length; ++i) {
                tierColMap.put(annArray[i], "Tier-" + i);
            }
        }
        if (!tierColMap.isEmpty()) {
            decoInfo.setColumnsWithTierNames(tierColMap);
        }
        this.value = decoInfo;
        this.setVisible(false);
    }

    private class SelectionTableModel
    extends DefaultTableModel {
        public SelectionTableModel(int rowCount, int columnCount) {
            super(rowCount, columnCount);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 0) {
                return false;
            }
            return super.isCellEditable(row, column);
        }
    }

    private class SelectionTable
    extends JTable {
        private DefaultCellEditor cbEditor;
        private DefaultCellEditor comboEditor;
        private CheckBoxTableCellRenderer cbRenderer;
        private ComboBoxTableCellRenderer comboRenderer;

        public SelectionTable() {
            JCheckBox cb = new JCheckBox();
            cb.setHorizontalAlignment(0);
            this.cbEditor = new DefaultCellEditor(cb);
            this.comboEditor = new DefaultCellEditor(new JComboBox<String>(ImportCSVDialog.this.colTypes));
            this.cbRenderer = new CheckBoxTableCellRenderer();
            this.cbRenderer.setHorizontalAlignment(0);
            this.comboRenderer = new ComboBoxTableCellRenderer(ImportCSVDialog.this.colTypes);
            this.setRowMargin(3);
            this.setRowHeight(this.getRowHeight() + 10);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column != 0) {
                if (row == 0) {
                    return this.cbEditor;
                }
                if (row == 1) {
                    return this.comboEditor;
                }
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column != 0) {
                if (row == 0) {
                    return this.cbRenderer;
                }
                if (row == 1) {
                    return this.comboRenderer;
                }
            }
            return super.getCellRenderer(row, column);
        }
    }
}

