/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.InlineEditBoxListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.mediadisplayer.MediaDisplayerHost;
import mpi.eudico.client.annotator.spellcheck.SpellChecker;
import mpi.eudico.client.annotator.spellcheck.SpellCheckerRegistry;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.StyledHighlightPainter;
import mpi.eudico.client.im.ImUtil;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.Pair;
import mpi.eudico.util.SimpleCVEntry;

public class InlineEditBox
extends JPanel
implements ActionListener,
MouseListener,
MenuListener,
KeyListener,
ElanLocaleListener,
DocumentListener {
    private static final String EDIT_MENU_DET = "Detach Editor";
    private static final String EDIT_MENU_ATT = "Attach Editor";
    private static final String EDIT_MENU_CMT = "Commit Changes";
    private static final String EDIT_MENU_CNL = "Cancel Changes";
    private final JTextArea textArea = new JTextArea("", 2, 1);
    private final JScrollPane textAreaScrollPane = new JScrollPane(this.textArea);
    private final JTextArea exttextArea = new JTextArea("", 2, 1);
    private final JScrollPane exttextAreaScrollPane = new JScrollPane(this.exttextArea);
    private final FocusListener intFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            if (!InlineEditBox.this.isUsingControlledVocabulary) {
                InlineEditBox.this.textArea.requestFocus();
                InlineEditBox.this.textArea.getCaret().setVisible(true);
            } else if (InlineEditBox.this.cvEntryComp != null) {
                InlineEditBox.this.cvEntryComp.grabFocus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!InlineEditBox.this.isEditing) {
                InlineEditBox.this.transferFocusUpCycle();
            }
        }
    };
    private final FocusListener extFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            if (!InlineEditBox.this.isUsingControlledVocabulary) {
                InlineEditBox.this.exttextArea.requestFocus();
                InlineEditBox.this.exttextArea.getCaret().setVisible(true);
            } else if (InlineEditBox.this.cvEntryComp != null) {
                InlineEditBox.this.cvEntryComp.grabFocus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    };
    private JPopupMenu popupMenu = new JPopupMenu("Select Language");
    private static final int EDIT_COMMITTED = 0;
    private static final int EDIT_CANCELED = 1;
    private InlineEditBoxListener listener;
    private JDialog externalDialog = null;
    private Rectangle dialogBounds;
    private Locale[] allLocales;
    private int numberOfLocales;
    private String oldText;
    private boolean attached = true;
    private Annotation annotation;
    private Point position;
    private Locale annotationLocale;
    private boolean attachable;
    private boolean isUsingControlledVocabulary = false;
    private boolean showCVDescription = true;
    private JMenu editMenu;
    private JMenu editorMenu;
    private JMenu selectLanguageMenu;
    private JMenuItem attachMI;
    private JMenuItem commitMI;
    private JMenuItem cancelMI;
    private JMenuItem closeMI;
    private JMenuItem detachPUMI;
    private JMenuItem commitPUMI;
    private JMenuItem cancelPUMI;
    private JMenuItem selectAllPUMI;
    private JMenuItem cutMI;
    private JMenuItem copyMI;
    private JMenuItem pasteMI;
    private JMenuItem cutPUMI;
    private JMenuItem copyPUMI;
    private JMenuItem pastePUMI;
    private JMenuItem selectAllMI;
    private JMenuBar menuBar;
    private JMenuItem toggleSuggestMI;
    private CVEntryComponent cvEntryComp;
    private int minCVWidth = 300;
    private int minCVHeight = 120;
    private int inlineBoxWidth;
    private int firstColPercentage = 30;
    private List<KeyStroke> keyStrokesNotToBeConsumed = new ArrayList<KeyStroke>();
    private List<KeyStroke> defaultRegisteredKeyStrokes = new ArrayList<KeyStroke>();
    private JComponent editorComponent;
    private Font uniFont = Constants.DEFAULTFONT;
    private boolean isEditing = false;
    private boolean enterCommits = true;
    private String oriValue;
    private int cursorPos;
    private boolean restoreOriValue = false;
    private StyledHighlightPainter spellingErrorPainter;
    private ArrayList<Object> spellingErrorHighLightInfos;
    private MediaDisplayerHost mediaDisplayerHost;

    public InlineEditBox(boolean attachable) {
        this.init();
        this.attachable = attachable;
    }

    public InlineEditBox() {
        this.init();
        this.attached = false;
    }

    public void setKeyStrokesNotToBeConsumed(List<KeyStroke> ksList) {
        this.keyStrokesNotToBeConsumed.clear();
        this.keyStrokesNotToBeConsumed.addAll(ksList);
    }

    public void init() {
        KeyStroke[] kss;
        for (KeyStroke ks : kss = this.textArea.getRegisteredKeyStrokes()) {
            ActionListener al = this.textArea.getActionForKeyStroke(ks);
            if (al == null) continue;
            this.defaultRegisteredKeyStrokes.add(ks);
        }
        Boolean val = Preferences.getBool("InlineEdit.EnterCommits", null);
        if (val != null) {
            this.enterCommits = val;
        }
        this.attachable = true;
        this.setLayout(new BorderLayout());
        try {
            this.allLocales = ImUtil.getLanguages();
            this.numberOfLocales = this.allLocales == null ? 0 : this.allLocales.length;
        }
        catch (NoSuchMethodError nsme) {
            String msg = ElanLocale.getString("InlineEditBox.Message.SPI") + "\n" + ElanLocale.getString("InlineEditBox.Message.SPI2");
            JOptionPane.showMessageDialog(null, msg, null, 0);
        }
        catch (Exception exc) {
            ClientLogger.LOG.warning("InlineEditBox::init::ParentIMBug::FIXME");
            ClientLogger.LOG.warning(exc.getMessage());
        }
        this.textArea.addMouseListener(this);
        this.textArea.setLineWrap(false);
        this.textAreaScrollPane.setHorizontalScrollBarPolicy(31);
        this.textAreaScrollPane.setVerticalScrollBarPolicy(21);
        this.add((Component)this.textAreaScrollPane, "Center");
        this.textArea.getCaret().setVisible(true);
        this.textArea.addKeyListener(this);
        this.textArea.getDocument().addDocumentListener(this);
        this.textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (InlineEditBox.this.annotationLocale != null && !InlineEditBox.this.annotationLocale.equals(Locale.getDefault()) && !InlineEditBox.this.annotationLocale.equals(InlineEditBox.this.textArea.getLocale())) {
                    ImUtil.setLanguage(InlineEditBox.this.textArea, InlineEditBox.this.annotationLocale);
                    InlineEditBox.this.textArea.setFont(InlineEditBox.this.uniFont);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!InlineEditBox.this.isEditing) {
                    InlineEditBox.this.transferFocusUpCycle();
                }
            }
        });
        this.exttextArea.setLineWrap(true);
        this.exttextArea.setWrapStyleWord(true);
        this.exttextArea.addKeyListener(this);
        this.exttextArea.getDocument().addDocumentListener(this);
        this.exttextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (InlineEditBox.this.annotationLocale != null && !InlineEditBox.this.annotationLocale.equals(Locale.getDefault()) && !InlineEditBox.this.annotationLocale.equals(InlineEditBox.this.exttextArea.getLocale())) {
                    ImUtil.setLanguage(InlineEditBox.this.exttextArea, InlineEditBox.this.annotationLocale);
                    InlineEditBox.this.exttextArea.setFont(InlineEditBox.this.uniFont.deriveFont(20.0f));
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!InlineEditBox.this.isEditing) {
                    InlineEditBox.this.transferFocusUpCycle();
                }
            }
        });
        this.createPopupMenu();
        this.exttextAreaScrollPane.setHorizontalScrollBarPolicy(31);
        this.exttextAreaScrollPane.setVerticalScrollBarPolicy(20);
        this.textAreaScrollPane.addFocusListener(this.intFocusListener);
        this.addFocusListener(this.intFocusListener);
    }

    public void addInlineEditBoxListener(InlineEditBoxListener inLineListener) {
        this.listener = inLineListener;
    }

    public void removeInlineEditBoxListener(InlineEditBoxListener inLineListener) {
        this.listener = null;
    }

    private void notifyListener(int edit_Type) {
        if (this.listener != null) {
            switch (edit_Type) {
                case 0: {
                    this.listener.editingCommitted();
                    break;
                }
                case 1: {
                    this.listener.editingCancelled();
                }
            }
        }
    }

    public void createExternalDialog() {
        try {
            this.externalDialog = new JDialog(ELANCommandFactory.getRootFrame(this.annotation.getTier().getTranscription()), ElanLocale.getString("InlineEditBox.Title"), true);
            this.externalDialog.setDefaultCloseOperation(0);
            this.externalDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    InlineEditBox.this.cancelEdit();
                }
            });
            if (this.menuBar == null) {
                this.createJMenuBar();
            }
            if (this.isUsingControlledVocabulary) {
                this.toggleSuggestMI.setVisible(true);
            } else {
                this.toggleSuggestMI.setVisible(false);
            }
            this.externalDialog.setJMenuBar(this.menuBar);
            this.externalDialog.addFocusListener(this.extFocusListener);
            this.externalDialog.setSize(300, 300);
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not create external dialog: " + ex.getMessage());
        }
    }

    public void createPopupMenu() {
        this.detachPUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Detach"));
        this.detachPUMI.setAccelerator(KeyStroke.getKeyStroke(10, 1));
        this.detachPUMI.setActionCommand(EDIT_MENU_DET);
        this.detachPUMI.addActionListener(this);
        this.popupMenu.add(this.detachPUMI);
        this.commitPUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Commit"));
        this.commitPUMI.setAccelerator(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.commitPUMI.setActionCommand(EDIT_MENU_CMT);
        this.commitPUMI.addActionListener(this);
        this.popupMenu.add(this.commitPUMI);
        this.cancelPUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Cancel"));
        this.cancelPUMI.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.cancelPUMI.setActionCommand(EDIT_MENU_CNL);
        this.cancelPUMI.addActionListener(this);
        this.popupMenu.add(this.cancelPUMI);
        this.popupMenu.addSeparator();
        this.cutPUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Cut"));
        this.cutPUMI.setActionCommand("cut");
        this.cutPUMI.addActionListener(this);
        this.popupMenu.add(this.cutPUMI);
        this.copyPUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Copy"));
        this.copyPUMI.setActionCommand("copy");
        this.copyPUMI.addActionListener(this);
        this.popupMenu.add(this.copyPUMI);
        this.pastePUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Paste"));
        this.pastePUMI.setActionCommand("paste");
        this.pastePUMI.addActionListener(this);
        this.popupMenu.add(this.pastePUMI);
        this.selectAllPUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.SelectAll"));
        this.selectAllPUMI.setActionCommand("selectAll");
        this.selectAllPUMI.addActionListener(this);
        this.popupMenu.add(this.selectAllPUMI);
        this.popupMenu.addSeparator();
        for (int i = 0; i < this.numberOfLocales; ++i) {
            JMenuItem newItem;
            if (i == 0 && this.allLocales[i] == Locale.getDefault()) {
                newItem = new JMenuItem(this.allLocales[i].getDisplayName() + " (System default)");
                newItem.setActionCommand(this.allLocales[i].getDisplayName());
            } else {
                newItem = new JMenuItem(this.allLocales[i].getDisplayName());
            }
            this.popupMenu.add(newItem);
            newItem.addActionListener(this);
        }
    }

    private JMenuBar createJMenuBar() {
        this.menuBar = new JMenuBar();
        this.editorMenu = new JMenu(ElanLocale.getString("InlineEditBox.Menu.Editor"));
        this.editMenu = new JMenu(ElanLocale.getString("Menu.Edit"));
        this.editMenu.addMenuListener(this);
        this.selectLanguageMenu = new JMenu(ElanLocale.getString("InlineEditBox.Menu.Select"));
        if (this.attachable) {
            this.attachMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Attach"));
            this.attachMI.setAccelerator(KeyStroke.getKeyStroke(10, 1));
            this.attachMI.setActionCommand(EDIT_MENU_ATT);
            this.attachMI.addActionListener(this);
            this.editorMenu.add(this.attachMI);
        }
        this.commitMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Commit"));
        this.commitMI.setAccelerator(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.commitMI.setActionCommand(EDIT_MENU_CMT);
        this.commitMI.addActionListener(this);
        this.editorMenu.add(this.commitMI);
        this.cancelMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Cancel"));
        this.cancelMI.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.cancelMI.setActionCommand(EDIT_MENU_CNL);
        this.cancelMI.addActionListener(this);
        this.editorMenu.add(this.cancelMI);
        this.closeMI = new JMenuItem(ElanLocale.getString("Button.Close"));
        this.closeMI.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.closeMI.setActionCommand("close");
        this.closeMI.addActionListener(this);
        this.editorMenu.add(this.closeMI);
        this.editorMenu.add(new JSeparator());
        this.toggleSuggestMI = new JMenuItem(ElanLocale.getString("InlineEditBox.ToggleSuggestPanel"));
        this.toggleSuggestMI.setAccelerator(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.toggleSuggestMI.setActionCommand("toggleSuggest");
        this.toggleSuggestMI.addActionListener(this);
        this.editorMenu.add(this.toggleSuggestMI);
        this.cutMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Cut"));
        this.cutMI.setActionCommand("cut");
        this.cutMI.addActionListener(this);
        this.editMenu.add(this.cutMI);
        this.copyMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Copy"));
        this.copyMI.setActionCommand("copy");
        this.copyMI.addActionListener(this);
        this.editMenu.add(this.copyMI);
        this.pasteMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Paste"));
        this.pasteMI.setActionCommand("paste");
        this.pasteMI.addActionListener(this);
        this.editMenu.add(this.pasteMI);
        this.selectAllMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.SelectAll"));
        this.selectAllMI.setActionCommand("selectAll");
        this.selectAllMI.addActionListener(this);
        this.editMenu.add(this.selectAllMI);
        for (int i = 0; i < this.numberOfLocales; ++i) {
            JMenuItem newItem = new JMenuItem(this.allLocales[i].getDisplayName());
            this.selectLanguageMenu.add(newItem);
            newItem.addActionListener(this);
        }
        this.menuBar.add(this.editorMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.selectLanguageMenu);
        return this.menuBar;
    }

    public boolean isUsingControlledVocabulary() {
        return this.isUsingControlledVocabulary;
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (this.externalDialog != null) {
            this.externalDialog.setVisible(vis);
        }
        if (!vis) {
            this.setLocation(-10, -10);
        }
    }

    @Override
    public void setSize(Dimension d) {
        if (d.getWidth() < 60.0) {
            d = new Dimension(60, d.height);
        }
        if (d.getHeight() < 38.0) {
            d = new Dimension(d.width, 38);
        }
        super.setSize(d);
        this.setPreferredSize(d);
        this.textAreaScrollPane.setPreferredSize(d);
        this.textAreaScrollPane.setSize(d);
    }

    public void setSizeIgnoreMinimum(Dimension d) {
        super.setSize(d);
        this.setPreferredSize(d);
        this.textAreaScrollPane.setPreferredSize(d);
        this.textAreaScrollPane.setSize(d);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.uniFont = font;
        if (this.textArea != null) {
            this.textArea.setFont(font);
        }
        if (this.exttextArea != null) {
            this.exttextArea.setFont(font);
        }
    }

    private FontMetrics getFontMetrics() {
        if (this.textArea != null) {
            return this.textArea.getFontMetrics(this.textArea.getFont());
        }
        if (this.exttextArea != null) {
            return this.exttextArea.getFontMetrics(this.exttextArea.getFont());
        }
        return super.getFontMetrics(this.uniFont);
    }

    public void setMargin(Insets insets) {
        if (this.textArea != null) {
            this.textArea.setMargin(insets);
        }
        if (this.exttextArea != null) {
            this.exttextArea.setMargin(insets);
        }
    }

    @Override
    public void setBorder(Border border) {
        if (this.textArea != null) {
            this.textArea.setBorder(border);
            this.textAreaScrollPane.setBorder(border);
        }
        if (this.exttextArea != null) {
            this.exttextArea.setBorder(border);
            this.exttextAreaScrollPane.setBorder(border);
        }
    }

    public int getCurrentTextWidth() {
        if (this.attached && !this.isUsingControlledVocabulary && this.textArea != null) {
            return this.textArea.getFontMetrics(this.textArea.getFont()).stringWidth(this.textArea.getText());
        }
        return 60;
    }

    @Override
    public synchronized void addKeyListener(KeyListener kl) {
        if (this.textArea != null) {
            this.textArea.addKeyListener(kl);
        }
        if (this.exttextArea != null) {
            this.exttextArea.addKeyListener(kl);
        }
        super.addKeyListener(kl);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener kl) {
        if (this.textArea != null) {
            this.textArea.removeKeyListener(kl);
        }
        if (this.exttextArea != null) {
            this.exttextArea.removeKeyListener(kl);
        }
        super.removeKeyListener(kl);
    }

    public void setAnnotation(Annotation ann, boolean forceOpenCV) {
        this.annotation = ann;
        this.oldText = ann.getValue();
        this.textArea.setText(this.oldText);
        try {
            this.annotationLocale = ((TierImpl)this.annotation.getTier()).getDefaultLocale();
            this.isUsingControlledVocabulary = forceOpenCV ? false : ((TierImpl)this.annotation.getTier()).getLinguisticType().isUsingControlledVocabulary();
        }
        catch (Exception e) {
            ClientLogger.LOG.warning("Could not establish Default Language of Tier. Using System Default instead.");
            this.annotationLocale = null;
            this.isUsingControlledVocabulary = false;
        }
        if (this.attached) {
            if (!this.isUsingControlledVocabulary) {
                this.textArea.setEditable(true);
                this.textArea.setCaretPosition(this.textArea.getText().length());
            } else {
                this.textArea.setEditable(false);
                if (this.cvEntryComp == null) {
                    this.cvEntryComp = new CVEntryComponent(JScrollPane.class);
                }
                this.cvEntryComp.setAnnotation(this.annotation);
            }
        }
        this.paintSpellErrorUnderline(this.textArea);
    }

    public void setAnnotation(Annotation ann) {
        this.setAnnotation(ann, false);
    }

    public boolean annotationModified() {
        return this.attached ? !this.oldText.equals(this.textArea.getText()) : !this.oldText.equals(this.exttextArea.getText());
    }

    private void paintSpellErrorUnderline(final JTextArea textAreaToCheck) {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                String langRef = ((TierImpl)InlineEditBox.this.annotation.getTier()).getLangRef();
                SpellChecker checker = SpellCheckerRegistry.getInstance().getSpellChecker(langRef);
                String[] textElements = textAreaToCheck.getText().split("\\b");
                Highlighter highlighter = textAreaToCheck.getHighlighter();
                if (InlineEditBox.this.spellingErrorPainter == null) {
                    InlineEditBox.this.spellingErrorPainter = new StyledHighlightPainter(Color.RED, 0, 2);
                    InlineEditBox.this.spellingErrorPainter.setVisible(false);
                }
                if (InlineEditBox.this.spellingErrorHighLightInfos == null) {
                    InlineEditBox.this.spellingErrorHighLightInfos = new ArrayList();
                } else {
                    for (Object obj : InlineEditBox.this.spellingErrorHighLightInfos) {
                        highlighter.removeHighlight(obj);
                    }
                    InlineEditBox.this.spellingErrorHighLightInfos.clear();
                }
                int indexWordBegin = 0;
                for (int elementIndex = 0; elementIndex < textElements.length; ++elementIndex) {
                    int elementLength = textElements[elementIndex].length();
                    if (textElements[elementIndex].matches(".*\\p{L}.*") && !checker.isCorrect(textElements[elementIndex]).booleanValue()) {
                        int start = indexWordBegin;
                        int end = start + elementLength;
                        Object hl = highlighter.addHighlight(start, end, InlineEditBox.this.spellingErrorPainter);
                        InlineEditBox.this.spellingErrorHighLightInfos.add(hl);
                    }
                    indexWordBegin += elementLength;
                }
                InlineEditBox.this.spellingErrorPainter.setVisible(true);
                return null;
            }

            @Override
            public void done() {
                textAreaToCheck.getParent().repaint();
                textAreaToCheck.getParent().validate();
            }
        };
        worker.execute();
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void detachEditor() {
        if (this.attachable && !this.attached) {
            return;
        }
        this.attached = false;
        this.position = this.getLocation();
        this.createExternalDialog();
        if (this.dialogBounds != null) {
            this.externalDialog.setBounds(this.dialogBounds);
        } else {
            Rectangle boundsPref = Preferences.getRect("DetachedEditor.Bounds", this.getCurrentTranscription());
            if (boundsPref != null) {
                this.externalDialog.setBounds(boundsPref);
            } else {
                Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
                Rectangle frameDim = this.externalDialog.getBounds();
                this.externalDialog.setLocation((screenDim.width - frameDim.width) / 2, (screenDim.height - frameDim.height) / 2);
            }
        }
        ImUtil.setLanguage(this.textArea, Locale.getDefault());
        this.setVisible(false);
        if (!this.isUsingControlledVocabulary) {
            this.externalDialog.getContentPane().removeAll();
            this.externalDialog.getContentPane().add(this.exttextAreaScrollPane);
            this.exttextArea.setEditable(true);
            this.exttextArea.setText(this.textArea.getText());
            this.exttextArea.setCaretPosition(this.exttextArea.getText().length());
            this.exttextArea.setFont(this.textArea.getFont().deriveFont(20.0f));
        } else {
            if (this.cvEntryComp == null) {
                this.cvEntryComp = new CVEntryComponent(JScrollPane.class);
                this.cvEntryComp.setAnnotation(this.annotation);
            } else {
                this.cvEntryComp.setAnnotation(this.annotation);
            }
            this.exttextArea.setEditable(false);
            this.cvEntryComp.removePopupListener();
            this.cvEntryComp.setFont(this.getFont());
            this.externalDialog.getContentPane().removeAll();
            this.externalDialog.getContentPane().add(this.cvEntryComp.getEditorComponent());
        }
        this.paintSpellErrorUnderline(this.exttextArea);
        this.externalDialog.setVisible(true);
    }

    protected void attachEditor() {
        this.attached = true;
        this.dialogBounds = this.externalDialog.getBounds();
        Preferences.set("DetachedEditor.Bounds", this.dialogBounds, this.getCurrentTranscription());
        this.externalDialog.dispose();
        this.externalDialog = null;
        this.setLocation(this.position);
        this.setVisible(true);
        if (!this.isUsingControlledVocabulary) {
            this.textArea.setText(this.exttextArea.getText());
            this.textArea.requestFocus();
        } else {
            this.cvEntryComp.addPopupListener();
            if (this.editorComponent == this) {
                this.removeAll();
                this.add((Component)this.cvEntryComp.getEditorComponent(), "Center");
            }
            this.startEdit();
        }
    }

    public void cancelEdit() {
        this.isEditing = false;
        this.closeIM();
        if (this.mediaDisplayerHost != null) {
            this.mediaDisplayerHost.discardMediaDisplayer();
        }
        if (this.attached) {
            this.setVisible(false);
        } else {
            if (this.externalDialog != null) {
                this.dialogBounds = this.externalDialog.getBounds();
                Preferences.set("DetachedEditor.Bounds", this.dialogBounds, this.getCurrentTranscription());
                this.setVisible(false);
                this.externalDialog.dispose();
                this.externalDialog = null;
            }
            this.attached = true;
        }
        this.notifyListener(1);
    }

    public void commitEdit() {
        SimpleCVEntry selectedEntry;
        this.isEditing = false;
        this.closeIM();
        if (this.mediaDisplayerHost != null) {
            this.mediaDisplayerHost.discardMediaDisplayer();
        }
        ExternalReference extRef = null;
        String cveId = null;
        if (this.isUsingControlledVocabulary && this.cvEntryComp != null && (selectedEntry = this.cvEntryComp.getSelectedEntry()) != null) {
            if (this.attached) {
                this.textArea.setText(this.cvEntryComp.getSelectedEntryValue());
            } else {
                this.exttextArea.setText(this.cvEntryComp.getSelectedEntryValue());
            }
            extRef = selectedEntry.getExternalRef();
            cveId = selectedEntry.getId();
        }
        if (extRef == null && ((AbstractAnnotation)this.annotation).getExtRef() != null) {
            extRef = new ExternalReferenceImpl(null, 5);
        }
        Object newText = "";
        boolean modified = this.annotationModified();
        if (this.attached) {
            if (modified) {
                newText = this.textArea.getText();
            }
            this.setVisible(false);
        } else {
            if (modified) {
                newText = this.exttextArea.getText();
            }
            this.dialogBounds = this.externalDialog.getBounds();
            Preferences.set("DetachedEditor.Bounds", this.dialogBounds, this.getCurrentTranscription());
            this.setVisible(false);
            this.externalDialog.dispose();
            this.externalDialog = null;
            this.attached = true;
        }
        if (modified) {
            int codePoint;
            if (((String)newText).length() > 0 && Character.isValidCodePoint(codePoint = ((String)newText).codePointAt(0))) {
                int type = Character.getType(codePoint);
                boolean bad = false;
                if (type == 0) {
                    FontMetrics fm;
                    int width;
                    bad = this.uniFont.canDisplay(codePoint) ? (width = (fm = this.getFontMetrics()).charWidth(codePoint)) <= 0 : true;
                } else {
                    boolean bl = bad = type == 6 || type == 8 || type == 7;
                }
                if (bad) {
                    newText = " " + (String)newText;
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("InlineEditBox.StartWithModifyingCharacter"), null, 1);
                }
            }
            Command c = ELANCommandFactory.createCommand(this.annotation.getTier().getTranscription(), "Menu.Annotation.ModifyAnnotation");
            Object[] args = new Object[]{this.oldText, newText, extRef, cveId};
            c.execute(this.annotation, args);
        }
        this.notifyListener(0);
    }

    private Transcription getCurrentTranscription() {
        if (this.annotation != null) {
            return this.annotation.getTier().getTranscription();
        }
        return null;
    }

    private void closeIM() {
        if (this.annotationLocale != null) {
            if (this.attached) {
                if (!this.textArea.getLocale().equals(Locale.getDefault())) {
                    ImUtil.setLanguage(this.textArea, Locale.getDefault());
                }
            } else if (!this.exttextArea.getLocale().equals(Locale.getDefault())) {
                ImUtil.setLanguage(this.exttextArea, Locale.getDefault());
            }
        }
    }

    private void doCut() {
        if (this.attached) {
            this.textArea.cut();
        } else {
            this.exttextArea.cut();
        }
    }

    private void doCopy() {
        if (this.attached) {
            this.textArea.copy();
        } else {
            this.exttextArea.copy();
        }
    }

    private void doPaste() {
        if (this.attached) {
            this.textArea.paste();
        } else {
            this.exttextArea.paste();
        }
    }

    private void doSelectAll() {
        if (this.attached) {
            this.textArea.selectAll();
        } else {
            this.exttextArea.selectAll();
        }
    }

    private void updatePopup() {
        if (this.textArea.getSelectedText() == null || this.textArea.getSelectedText().length() == 0) {
            this.cutPUMI.setEnabled(false);
            this.copyPUMI.setEnabled(false);
        } else {
            this.cutPUMI.setEnabled(true);
            this.copyPUMI.setEnabled(true);
        }
        if (this.isTextOnClipboard()) {
            this.pastePUMI.setEnabled(true);
        } else {
            this.pastePUMI.setEnabled(false);
        }
        if (this.textArea.getText() == null || this.textArea.getText().length() == 0) {
            this.selectAllPUMI.setEnabled(false);
        } else {
            this.selectAllPUMI.setEnabled(true);
        }
    }

    private void updateMenuBar() {
        if (this.exttextArea.getSelectedText() == null || this.exttextArea.getSelectedText().length() == 0) {
            this.cutMI.setEnabled(false);
            this.copyMI.setEnabled(false);
        } else {
            this.cutMI.setEnabled(true);
            this.copyMI.setEnabled(true);
        }
        if (this.isTextOnClipboard()) {
            this.pasteMI.setEnabled(true);
        } else {
            this.pasteMI.setEnabled(false);
        }
        if (this.exttextArea.getText() == null || this.exttextArea.getText().length() == 0) {
            this.selectAllMI.setEnabled(false);
        } else {
            this.selectAllMI.setEnabled(true);
        }
    }

    private boolean isTextOnClipboard() {
        DataFlavor[] flavors;
        DataFlavor best;
        Transferable contents = null;
        try {
            contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        }
        catch (IllegalStateException ise) {
            ClientLogger.LOG.warning("Could not access the system clipboard.");
        }
        return contents != null && (best = DataFlavor.selectBestTextFlavor(flavors = contents.getTransferDataFlavors())) != null;
    }

    public JComponent getEditorComponent() {
        if (this.editorComponent == null) {
            return this;
        }
        return this.editorComponent;
    }

    private Dimension getCVCompSize(Dimension size) {
        int h;
        int w;
        this.minCVHeight = this.cvEntryComp.getEditorComponent().getFontMetrics(this.cvEntryComp.getEditorComponent().getFont()).getHeight();
        int cvw = this.minCVWidth;
        if (this.inlineBoxWidth > 0) {
            cvw = this.inlineBoxWidth;
            this.minCVWidth = this.showCVDescription ? cvw * this.firstColPercentage / 100 : cvw;
        } else {
            cvw = this.minCVWidth;
            this.inlineBoxWidth = this.minCVWidth;
        }
        if (size == null) {
            w = cvw;
            h = this.minCVHeight;
        } else {
            w = size.width;
            h = size.height;
            if (w < cvw) {
                w = cvw;
            }
            if (h < this.minCVHeight) {
                h = this.minCVHeight;
            }
        }
        h = this.cvEntryComp.entries.length > 10 ? 10 * this.minCVHeight : this.cvEntryComp.entries.length * this.minCVHeight;
        return new Dimension(w, h);
    }

    public void configureEditor(Class preferredComponent, Font font, Dimension size) {
        Dimension calulatedSize;
        if (preferredComponent == JComboBox.class) {
            this.showCVDescription = false;
        } else {
            Boolean boolPref;
            Integer intPref = Preferences.getInt("InlineEditBoxWidth", null);
            if (intPref != null) {
                this.inlineBoxWidth = intPref;
            }
            if ((intPref = Preferences.getInt("InlineEditBoxCvWidthPercentage", null)) != null) {
                this.firstColPercentage = intPref;
            }
            if ((boolPref = Preferences.getBool("InlineEditBox.ShowCVDescription", null)) != null && this.showCVDescription != boolPref) {
                this.cvEntryComp = null;
                this.showCVDescription = boolPref;
            }
        }
        if (preferredComponent == JPanel.class) {
            this.editorComponent = this;
            if (this.isUsingControlledVocabulary) {
                if (this.cvEntryComp == null) {
                    this.cvEntryComp = new CVEntryComponent(JScrollPane.class);
                    this.cvEntryComp.setAnnotation(this.annotation);
                } else if (!(this.cvEntryComp.getEditorComponent() instanceof JScrollPane)) {
                    this.cvEntryComp.setDelegate(preferredComponent);
                }
                if (font != null) {
                    this.cvEntryComp.setFont(font);
                } else if (this.getFont() != null) {
                    this.cvEntryComp.setFont(this.getFont());
                }
                this.cvEntryComp.addPopupListener();
                Dimension compSize = this.getCVCompSize(size);
                this.removeAll();
                this.add((Component)this.cvEntryComp.getEditorComponent(), "Center");
                if (this.showCVDescription) {
                    this.cvEntryComp.updateTableSize(compSize);
                }
                this.setSize(compSize.width, compSize.height + 2 * this.minCVHeight);
                this.validate();
            } else {
                if (font != null) {
                    this.setFont(font);
                }
                this.removeAll();
                this.add((Component)this.textAreaScrollPane, "Center");
                if (size != null) {
                    this.setSize(size);
                }
                this.validate();
            }
        } else if (preferredComponent == JScrollPane.class) {
            if (this.isUsingControlledVocabulary) {
                if (this.cvEntryComp == null) {
                    this.cvEntryComp = new CVEntryComponent(preferredComponent);
                    this.cvEntryComp.setAnnotation(this.annotation);
                } else if (!(this.cvEntryComp.getEditorComponent() instanceof JScrollPane)) {
                    this.cvEntryComp.setDelegate(preferredComponent);
                }
                if (font != null) {
                    this.cvEntryComp.setFont(font);
                } else if (this.getFont() != null) {
                    this.cvEntryComp.setFont(this.getFont());
                }
                this.cvEntryComp.addPopupListener();
                calulatedSize = this.getCVCompSize(size);
                if (calulatedSize != null) {
                    if (this.showCVDescription) {
                        this.cvEntryComp.updateTableSize(calulatedSize);
                    }
                    this.cvEntryComp.getEditorComponent().setSize(calulatedSize);
                }
                this.editorComponent = this.cvEntryComp.getEditorComponent();
            } else {
                if (font != null) {
                    this.setFont(font);
                }
                if (size != null) {
                    this.setSize(size);
                }
                this.editorComponent = this.textAreaScrollPane;
            }
        } else if (preferredComponent == JComboBox.class && this.isUsingControlledVocabulary) {
            if (this.cvEntryComp == null) {
                this.cvEntryComp = new CVEntryComponent(preferredComponent);
                this.cvEntryComp.setAnnotation(this.annotation);
            } else if (!(this.cvEntryComp.getEditorComponent() instanceof JComboBox)) {
                this.cvEntryComp.setDelegate(preferredComponent);
            }
            if (font != null) {
                this.cvEntryComp.setFont(font);
            } else if (this.getFont() != null) {
                this.cvEntryComp.setFont(this.getFont());
            }
            calulatedSize = this.getCVCompSize(size);
            if (calulatedSize != null) {
                if (this.showCVDescription) {
                    this.cvEntryComp.updateTableSize(calulatedSize);
                }
                this.cvEntryComp.getEditorComponent().setSize(calulatedSize);
            }
            this.editorComponent = this.cvEntryComp.getEditorComponent();
        }
    }

    public void startEdit() {
        this.isEditing = true;
        if (this.editorComponent == this) {
            this.setVisible(true);
            this.requestFocus();
        } else if (this.isUsingControlledVocabulary) {
            this.cvEntryComp.grabFocus();
        } else {
            this.editorComponent.requestFocus();
        }
    }

    public void setEnterCommits(boolean enterCommits) {
        this.enterCommits = enterCommits;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block17: {
            String command;
            block18: {
                block16: {
                    command = e.getActionCommand();
                    if (!command.equals(EDIT_MENU_DET)) break block16;
                    this.detachEditor();
                    break block17;
                }
                if (!command.equals(EDIT_MENU_ATT)) break block18;
                if (!this.attachable) break block17;
                this.attachEditor();
                break block17;
            }
            if (command.equals(EDIT_MENU_CNL) || command.equals("close")) {
                this.cancelEdit();
            } else if (command.equals(EDIT_MENU_CMT)) {
                this.commitEdit();
            } else if (command.equals("cut")) {
                this.doCut();
            } else if (command.equals("copy")) {
                this.doCopy();
            } else if (command.equals("paste")) {
                this.doPaste();
            } else if (command.equals("selectAll")) {
                this.doSelectAll();
            } else if (command.equals("toggleSuggest")) {
                this.cvEntryComp.toggleSuggestPanel(this.externalDialog.getContentPane());
            } else {
                for (int i = 0; i < this.numberOfLocales; ++i) {
                    if (!command.equals(this.allLocales[i].getDisplayName())) continue;
                    this.annotationLocale = this.allLocales[i];
                    if (this.attached) {
                        ImUtil.setLanguage(this.textArea, this.annotationLocale);
                        this.textArea.setFont(this.uniFont);
                        break;
                    }
                    ImUtil.setLanguage(this.exttextArea, this.annotationLocale);
                    this.exttextArea.setFont(this.uniFont.deriveFont(20.0f));
                    break;
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            this.updatePopup();
            this.popupMenu.show(this.textArea, e.getX(), e.getY());
            this.popupMenu.setVisible(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
        if (this.keyStrokesNotToBeConsumed.contains(ks)) {
            this.oriValue = ((JTextArea)e.getSource()).getText();
            this.cursorPos = ((JTextArea)e.getSource()).getCaretPosition();
            this.restoreOriValue = false;
            if (e.getKeyCode() == 32 && (e.getModifiers() == 1 || e.getModifiers() == 8 || e.getModifiers() == 0)) {
                this.restoreOriValue = true;
            }
            return;
        }
        if (e.getKeyCode() == 27) {
            this.cancelEdit();
        } else if (e.getKeyCode() == 10 && e.isShiftDown()) {
            if (this.attachable) {
                e.consume();
                if (this.attached) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InlineEditBox.this.detachEditor();
                        }
                    });
                } else {
                    this.attachEditor();
                }
            }
        } else if (e.getKeyCode() == 10 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            e.consume();
            this.commitEdit();
        } else if (e.getKeyCode() == 10 && this.enterCommits) {
            e.consume();
            this.commitEdit();
        } else if (!(this.defaultRegisteredKeyStrokes.contains(ks) || ks.getModifiers() != 128 && ks.getModifiers() != 512 && ks.getModifiers() != 256)) {
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.restoreOriValue) {
            ((JTextArea)e.getSource()).setText(this.oriValue);
            ((JTextArea)e.getSource()).setCaretPosition(this.cursorPos);
            this.restoreOriValue = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.updateMenuBar();
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void updateLocale() {
        this.detachPUMI.setText(ElanLocale.getString("InlineEditBox.Detach"));
        this.commitPUMI.setText(ElanLocale.getString("InlineEditBox.Commit"));
        this.cancelPUMI.setText(ElanLocale.getString("InlineEditBox.Cancel"));
        this.cutPUMI.setText(ElanLocale.getString("InlineEditBox.Edit.Cut"));
        this.copyPUMI.setText(ElanLocale.getString("InlineEditBox.Edit.Copy"));
        this.pastePUMI.setText(ElanLocale.getString("InlineEditBox.Edit.Paste"));
        if (this.menuBar != null) {
            this.editorMenu.setText(ElanLocale.getString("InlineEditBox.Menu.Editor"));
            this.editMenu.setText(ElanLocale.getString("Menu.Edit"));
            this.selectLanguageMenu.setText(ElanLocale.getString("InlineEditBox.Menu.Select"));
            this.attachMI.setText(ElanLocale.getString("InlineEditBox.Attach"));
            this.commitMI.setText(ElanLocale.getString("InlineEditBox.Commit"));
            this.cancelMI.setText(ElanLocale.getString("InlineEditBox.Cancel"));
            this.closeMI.setText(ElanLocale.getString("Button.Close"));
            this.cutMI.setText(ElanLocale.getString("InlineEditBox.Edit.Cut"));
            this.copyMI.setText(ElanLocale.getString("InlineEditBox.Edit.Copy"));
            this.pasteMI.setText(ElanLocale.getString("InlineEditBox.Edit.Paste"));
        }
    }

    protected void showVideoForEntry(String cvEntryId) {
        if (this.mediaDisplayerHost != null) {
            this.mediaDisplayerHost.discardMediaDisplayer();
        }
        if (this.mediaDisplayerHost != null) {
            Rectangle inlineEditBoxBounds = this.getBounds();
            this.mediaDisplayerHost.hostMediaDisplayer(new Object[]{cvEntryId, this.annotation}, inlineEditBoxBounds);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        if (this.attached) {
            this.paintSpellErrorUnderline(this.textArea);
        } else {
            this.paintSpellErrorUnderline(this.exttextArea);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        if (this.attached) {
            this.paintSpellErrorUnderline(this.textArea);
        } else {
            this.paintSpellErrorUnderline(this.exttextArea);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        if (this.attached) {
            this.paintSpellErrorUnderline(this.textArea);
        } else {
            this.paintSpellErrorUnderline(this.exttextArea);
        }
    }

    public void setMediaDisplayerHost(MediaDisplayerHost mediaDisplayerHost) {
        this.mediaDisplayerHost = mediaDisplayerHost;
    }

    class CVEntryComponent
    implements KeyListener,
    ActionListener,
    DocumentListener {
        private JList<SimpleCVEntry> entryList;
        private DefaultListModel<SimpleCVEntry> entryListModel;
        private JScrollPane scrollPane;
        private JTable entryTable;
        private DefaultTableModel entryTableModel;
        private JScrollPane tableScrollPane;
        private MouseListener tablePopupListener;
        private MouseListener tableDoubleClickListener;
        private JPopupMenu popup;
        private MouseListener popupListener;
        private MouseListener doubleClickListener;
        private JMenuItem detachMI;
        private JMenuItem cancelMI;
        private JMenuItem commitMI;
        private JMenuItem toggleSuggestMI;
        private JComboBox<SimpleCVEntry> box;
        private DefaultComboBoxModel<SimpleCVEntry> entryBoxModel;
        private JComponent delegate;
        private SimpleCVEntry[] entries;
        private Annotation annotation;
        private int maxEntryLength = 0;
        private JTextField textField;
        private Document textFieldDoc;
        private JPanel suggestPanel;
        private volatile Thread t;
        private String oldPartial = new String();
        private JList<SimpleCVEntry> suggestEntryList;
        private DefaultListModel<SimpleCVEntry> suggestEntryListModel;
        private JScrollPane suggestScrollPane;
        private MouseAdapter suggestPanelPopupListener;
        private MouseAdapter suggestPanelDoubleClickListener;
        private int oldLangIndex = -1;
        private String oldCVName = "";

        public CVEntryComponent(Class<?> componentClass) {
            this.initComponents(componentClass);
        }

        public JComponent getEditorComponent() {
            return this.delegate;
        }

        void setDelegate(Class compClass) {
            if (InlineEditBox.this.showCVDescription ? (compClass == JPanel.class ? this.delegate == this.suggestPanel : this.delegate == this.tableScrollPane) : this.delegate.getClass() == compClass) {
                return;
            }
            if (InlineEditBox.this.showCVDescription) {
                if (this.entryTable == null) {
                    this.initComponents(compClass);
                }
                if (compClass == JPanel.class) {
                    if (this.suggestPanel == null) {
                        this.initComponents(compClass);
                    } else {
                        this.suggestScrollPane.getViewport().add(this.entryTable);
                        this.entryTable.removeKeyListener(this);
                    }
                    this.delegate = this.suggestPanel;
                } else {
                    this.entryTable.addKeyListener(this);
                    this.tableScrollPane.getViewport().add(this.entryTable);
                    this.delegate = this.tableScrollPane;
                }
                while (this.entryTableModel.getRowCount() > 0) {
                    this.entryTableModel.removeRow(this.entryTable.getRowCount() - 1);
                }
                this.fillModel(true);
                String cveId = null;
                if (this.annotation != null) {
                    cveId = this.annotation.getCVEntryId();
                    for (int i = 0; i < this.entryTable.getRowCount(); ++i) {
                        SimpleCVEntry entry = (SimpleCVEntry)this.entryTableModel.getValueAt(i, 0);
                        String id = entry.getId();
                        if (!cveId.equals(id)) continue;
                        this.entryTable.setRowSelectionInterval(i, i);
                        this.scrollIfNeededAutomatically();
                        break;
                    }
                }
            } else if (compClass == JComboBox.class) {
                if (this.box == null) {
                    this.initComponents(compClass);
                }
                this.delegate = this.box;
                this.entryBoxModel.removeAllElements();
                this.fillModel(true);
                if (this.entryList != null) {
                    this.box.setSelectedItem(this.entryList.getSelectedValue());
                }
            } else if (compClass == JScrollPane.class) {
                if (this.entryList == null) {
                    this.initComponents(compClass);
                }
                this.delegate = this.scrollPane;
                this.entryListModel.clear();
                this.fillModel(true);
                if (this.box != null) {
                    this.entryList.setSelectedValue(this.box.getSelectedItem(), true);
                }
            } else if (compClass == JPanel.class) {
                if (this.suggestEntryList == null) {
                    this.initComponents(compClass);
                }
                this.delegate = this.suggestPanel;
                this.suggestEntryListModel.clear();
                this.fillModel(true);
                if (this.box != null) {
                    this.suggestEntryList.setSelectedValue(this.box.getSelectedItem(), true);
                }
            }
        }

        public void ensureSelectionIsVisible() {
            if (this.delegate instanceof JScrollPane && this.entryList != null) {
                this.entryList.ensureIndexIsVisible(this.entryList.getSelectedIndex());
            } else if (this.delegate instanceof JPanel && this.suggestEntryList != null) {
                this.suggestEntryList.ensureIndexIsVisible(this.suggestEntryList.getSelectedIndex());
            }
        }

        public void removePopupListener() {
            if (this.entryTable != null) {
                this.entryTable.removeMouseListener(this.tablePopupListener);
                if (this.delegate == this.suggestPanel) {
                    this.textField.removeMouseListener(this.tablePopupListener);
                }
            }
            if (this.entryList != null) {
                this.entryList.removeMouseListener(this.popupListener);
            }
            if (this.suggestEntryList != null) {
                this.suggestEntryList.removeMouseListener(this.suggestPanelPopupListener);
                this.textField.removeMouseListener(this.suggestPanelPopupListener);
            }
        }

        public void addPopupListener() {
            MouseListener[] listeners;
            if (this.entryTable != null) {
                for (MouseListener listener2 : listeners = this.entryTable.getMouseListeners()) {
                    if (listener2 != this.tablePopupListener) continue;
                    return;
                }
                this.entryTable.addMouseListener(this.tablePopupListener);
                if (this.delegate == this.suggestPanel) {
                    this.textField.addMouseListener(this.tablePopupListener);
                }
            }
            if (this.entryList != null) {
                for (MouseListener listener2 : listeners = this.entryList.getMouseListeners()) {
                    if (listener2 != this.popupListener) continue;
                    return;
                }
                this.entryList.addMouseListener(this.popupListener);
            }
            if (this.suggestEntryList != null) {
                for (MouseListener listener2 : listeners = this.suggestEntryList.getMouseListeners()) {
                    if (listener2 != this.suggestPanelPopupListener) continue;
                    return;
                }
                this.suggestEntryList.addMouseListener(this.suggestPanelPopupListener);
                this.textField.addMouseListener(this.suggestPanelPopupListener);
            }
            if (this.entryTable != null) {
                for (MouseListener listener2 : listeners = this.entryTable.getMouseListeners()) {
                    if (listener2 != this.tablePopupListener) continue;
                    return;
                }
                this.entryTable.addMouseListener(this.tablePopupListener);
            }
        }

        private void updateTableSize(Dimension size) {
            this.entryTable.getColumn("value").setMinWidth(size.width * InlineEditBox.this.firstColPercentage / 100);
            this.entryTable.getColumn("value").setMaxWidth(size.width * InlineEditBox.this.firstColPercentage / 100);
            this.entryTable.setRowHeight(InlineEditBox.this.minCVHeight);
        }

        public void scrollIfNeededAutomatically() {
            JViewport viewport = (JViewport)this.entryTable.getParent();
            Rectangle rect = this.entryTable.getCellRect(this.entryTable.getSelectedRow(), this.entryTable.getSelectedColumn(), true);
            Rectangle viewRect = viewport.getViewRect();
            rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
            rect.translate(0, 0);
            viewport.scrollRectToVisible(rect);
        }

        private void initComponents(Class<?> component) {
            if (InlineEditBox.this.showCVDescription) {
                if (this.entryTable == null) {
                    this.entryTableModel = new DefaultTableModel(){

                        @Override
                        public boolean isCellEditable(int row, int column) {
                            return false;
                        }
                    };
                    this.entryTableModel.setColumnIdentifiers(new Object[]{"value", "desc"});
                    this.entryTable = new JTable(this.entryTableModel);
                    this.entryTable.setTableHeader(null);
                    this.entryTable.setFont(InlineEditBox.this.getFont());
                    this.entryTable.setSelectionMode(0);
                    this.entryTable.addMouseMotionListener(new MouseMotionListener(){
                        int lastRow = -1;

                        @Override
                        public void mouseMoved(MouseEvent e) {
                            Point p = e.getPoint();
                            int row = CVEntryComponent.this.entryTable.rowAtPoint(p);
                            int col = CVEntryComponent.this.entryTable.columnAtPoint(p);
                            if (row > -1 && row < CVEntryComponent.this.entryTable.getRowCount() && col > -1 && col < CVEntryComponent.this.entryTable.getColumnCount() && row != this.lastRow) {
                                this.lastRow = row;
                                String cvEntryId = ((SimpleCVEntry)CVEntryComponent.this.entryTableModel.getValueAt(row, 0)).getId();
                                InlineEditBox.this.showVideoForEntry(cvEntryId);
                            }
                        }

                        @Override
                        public void mouseDragged(MouseEvent e) {
                        }
                    });
                    this.entryTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            if (value == null) {
                                this.setText("");
                            } else if (value instanceof SimpleCVEntry) {
                                this.setText(((SimpleCVEntry)value).getValue());
                            } else {
                                this.setText(value.toString());
                            }
                            this.setToolTipText(this.getText());
                            if (isSelected) {
                                this.setBackground(table.getSelectionBackground());
                                this.setForeground(table.getSelectionForeground());
                            } else {
                                this.setBackground(table.getBackground());
                                this.setForeground(table.getForeground());
                            }
                            this.setFont(table.getFont());
                            this.setOpaque(true);
                            return this;
                        }
                    });
                    this.tablePopupListener = new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                                CVEntryComponent.this.popup.show(CVEntryComponent.this.entryTable, e.getX(), e.getY());
                                CVEntryComponent.this.popup.setVisible(true);
                            }
                        }
                    };
                    if (this.popup == null) {
                        this.createPopupMenu();
                    }
                    this.tableDoubleClickListener = new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() > 1) {
                                InlineEditBox.this.commitEdit();
                            }
                        }
                    };
                    this.entryTable.addMouseListener(this.tablePopupListener);
                    this.entryTable.addMouseListener(this.tableDoubleClickListener);
                }
                if (component == JPanel.class) {
                    this.suggestScrollPane = new JScrollPane(this.entryTable);
                    this.textField = new JTextField();
                    this.textField.setFont(InlineEditBox.this.getFont());
                    this.textField.addKeyListener(this);
                    this.textFieldDoc = this.textField.getDocument();
                    this.textFieldDoc.addDocumentListener(this);
                    this.suggestPanel = new JPanel(new BorderLayout());
                    this.suggestPanel.add((Component)this.textField, "North");
                    this.suggestPanel.add((Component)this.suggestScrollPane, "Center");
                    this.textField.addMouseListener(this.tablePopupListener);
                    this.delegate = this.suggestPanel;
                    this.entryTable.removeKeyListener(this);
                } else {
                    this.entryTable.addKeyListener(this);
                    this.tableScrollPane = new JScrollPane(this.entryTable);
                    this.tableScrollPane.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseExited(MouseEvent e) {
                            InlineEditBox.this.showVideoForEntry("");
                        }
                    });
                    JScrollBar verticalScrollbar = this.tableScrollPane.getVerticalScrollBar();
                    if (verticalScrollbar != null) {
                        verticalScrollbar.addAdjustmentListener(new AdjustmentListener(){
                            int lastRow = -1;

                            @Override
                            public void adjustmentValueChanged(AdjustmentEvent e) {
                                Point p = CVEntryComponent.this.tableScrollPane.getMousePosition();
                                if (p == null) {
                                    return;
                                }
                                Point vpp = CVEntryComponent.this.tableScrollPane.getViewport().getViewPosition();
                                p.translate(vpp.x, vpp.y);
                                int row = CVEntryComponent.this.entryTable.rowAtPoint(p);
                                int col = CVEntryComponent.this.entryTable.columnAtPoint(p);
                                if (row > -1 && row < CVEntryComponent.this.entryTable.getRowCount() && col > -1 && col < CVEntryComponent.this.entryTable.getColumnCount() && row != this.lastRow) {
                                    this.lastRow = row;
                                    String cvEntryId = ((SimpleCVEntry)CVEntryComponent.this.entryTableModel.getValueAt(row, 0)).getId();
                                    InlineEditBox.this.showVideoForEntry(cvEntryId);
                                }
                            }
                        });
                    }
                    this.delegate = this.tableScrollPane;
                }
            } else {
                this.entryTable = null;
                if (component == JScrollPane.class) {
                    if (this.entryList == null) {
                        this.entryListModel = new DefaultListModel();
                        this.entryList = new JList<SimpleCVEntry>(this.entryListModel);
                        this.entryList.setFont(InlineEditBox.this.getFont());
                        this.entryList.setSelectionMode(0);
                        this.scrollPane = new JScrollPane(this.entryList);
                        if (this.popup == null) {
                            this.createPopupMenu();
                        }
                        this.popupListener = new MouseAdapter(){

                            @Override
                            public void mousePressed(MouseEvent e) {
                                if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                                    CVEntryComponent.this.popup.show(CVEntryComponent.this.entryList, e.getX(), e.getY());
                                    CVEntryComponent.this.popup.setVisible(true);
                                }
                            }
                        };
                        this.doubleClickListener = new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                if (e.getClickCount() > 1) {
                                    InlineEditBox.this.commitEdit();
                                }
                            }
                        };
                        this.entryList.addMouseListener(this.popupListener);
                        this.entryList.addMouseListener(this.doubleClickListener);
                        this.entryList.addKeyListener(this);
                        this.entryList.addListSelectionListener(new ListSelectionListener(){

                            @Override
                            public void valueChanged(ListSelectionEvent lse) {
                                CVEntryComponent.this.ensureSelectionIsVisible();
                            }
                        });
                        this.entryList.addMouseMotionListener(new MouseMotionListener(){
                            int lastRow = -1;

                            @Override
                            public void mouseMoved(MouseEvent e) {
                                Point p = e.getPoint();
                                int row = CVEntryComponent.this.entryList.locationToIndex(p);
                                if (row > -1 && row < CVEntryComponent.this.entryListModel.size() && row != this.lastRow) {
                                    this.lastRow = row;
                                    String cvEntryId = ((SimpleCVEntry)CVEntryComponent.this.entryListModel.getElementAt(row)).getId();
                                    InlineEditBox.this.showVideoForEntry(cvEntryId);
                                }
                            }

                            @Override
                            public void mouseDragged(MouseEvent e) {
                            }
                        });
                        JScrollBar verticalScrollbar = this.scrollPane.getVerticalScrollBar();
                        if (verticalScrollbar != null) {
                            verticalScrollbar.addAdjustmentListener(new AdjustmentListener(){
                                int lastRow = -1;

                                @Override
                                public void adjustmentValueChanged(AdjustmentEvent e) {
                                    Point p = CVEntryComponent.this.scrollPane.getMousePosition();
                                    if (p == null) {
                                        return;
                                    }
                                    Point vpp = CVEntryComponent.this.scrollPane.getViewport().getViewPosition();
                                    p.translate(vpp.x, vpp.y);
                                    int row = CVEntryComponent.this.entryList.locationToIndex(p);
                                    if (row > -1 && row < CVEntryComponent.this.entryListModel.size() && row != this.lastRow) {
                                        this.lastRow = row;
                                        String cvEntryId = ((SimpleCVEntry)CVEntryComponent.this.entryListModel.getElementAt(row)).getId();
                                        InlineEditBox.this.showVideoForEntry(cvEntryId);
                                    }
                                }
                            });
                        }
                        this.delegate = this.scrollPane;
                    }
                } else if (component == JComboBox.class) {
                    if (this.box == null) {
                        this.entryBoxModel = new DefaultComboBoxModel();
                        this.box = new JComboBox<SimpleCVEntry>(this.entryBoxModel);
                        this.box.setFont(InlineEditBox.this.getFont());
                        this.box.addActionListener(this);
                        this.box.addKeyListener(this);
                        this.delegate = this.box;
                    }
                } else if (component == JPanel.class && this.suggestEntryList == null) {
                    this.suggestEntryListModel = new DefaultListModel();
                    this.suggestEntryList = new JList<SimpleCVEntry>(this.suggestEntryListModel);
                    this.suggestEntryList.setFont(InlineEditBox.this.getFont());
                    this.suggestEntryList.setSelectionMode(0);
                    this.suggestScrollPane = new JScrollPane(this.suggestEntryList);
                    this.textField = new JTextField();
                    this.textField.setFont(InlineEditBox.this.getFont());
                    this.textField.addKeyListener(this);
                    this.textFieldDoc = this.textField.getDocument();
                    this.textFieldDoc.addDocumentListener(this);
                    this.suggestPanel = new JPanel(new BorderLayout());
                    this.suggestPanel.add((Component)this.textField, "North");
                    this.suggestPanel.add((Component)this.suggestScrollPane, "Center");
                    if (this.popup == null) {
                        this.createPopupMenu();
                    }
                    this.suggestPanelPopupListener = new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                                CVEntryComponent.this.popup.show(CVEntryComponent.this.suggestEntryList, e.getX(), e.getY());
                                CVEntryComponent.this.popup.setVisible(true);
                            }
                        }
                    };
                    this.suggestPanelDoubleClickListener = new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() > 1) {
                                InlineEditBox.this.commitEdit();
                            }
                        }
                    };
                    this.suggestEntryList.addMouseListener(this.suggestPanelPopupListener);
                    this.textField.addMouseListener(this.suggestPanelPopupListener);
                    this.suggestEntryList.addMouseListener(this.suggestPanelDoubleClickListener);
                    this.suggestEntryList.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent lse) {
                            CVEntryComponent.this.ensureSelectionIsVisible();
                        }
                    });
                    this.delegate = this.suggestPanel;
                }
            }
        }

        public void setFont(Font f) {
            if (this.delegate == this.box) {
                this.box.setFont(f);
            } else if (this.delegate == this.scrollPane) {
                this.entryList.setFont(f);
            } else if (this.delegate == this.suggestPanel) {
                this.textField.setFont(f);
                this.suggestPanel.setFont(f);
                if (InlineEditBox.this.showCVDescription) {
                    this.entryTable.setFont(f);
                } else {
                    this.suggestEntryList.setFont(f);
                }
            } else if (this.delegate == this.tableScrollPane) {
                this.entryTable.setFont(f);
                this.tableScrollPane.setFont(f);
            }
        }

        public void setAnnotation(Annotation annotation) {
            this.annotation = annotation;
            ControlledVocabulary oldCV = null;
            BasicControlledVocabulary cv = null;
            int langIndex = -1;
            if (annotation != null) {
                TierImpl tier = (TierImpl)annotation.getTier();
                oldCV = tier.getTranscription().getControlledVocabulary(this.oldCVName);
                Pair<ControlledVocabulary, Integer> pair = tier.getEffectiveLanguage();
                if (pair != null) {
                    cv = pair.getFirst();
                    langIndex = pair.getSecond();
                }
            }
            if (cv != null) {
                if (langIndex < 0) {
                    langIndex = cv.getDefaultLanguageIndex();
                }
                if (cv != oldCV || !(cv instanceof ExternalCV)) {
                    this.entries = cv.getSimpleEntries(langIndex);
                    if (this.entryListModel != null) {
                        this.entryListModel.clear();
                    }
                    if (this.entryTableModel != null) {
                        while (this.entryTableModel.getRowCount() > 0) {
                            this.entryTableModel.removeRow(this.entryTableModel.getRowCount() - 1);
                        }
                    }
                    if (this.entryBoxModel != null) {
                        this.entryBoxModel.removeAllElements();
                    }
                    this.fillModel(true);
                } else if (langIndex != this.oldLangIndex) {
                    this.entries = cv.getSimpleEntries(langIndex);
                    this.fillModel(true);
                } else {
                    this.fillModel(false);
                }
                this.oldLangIndex = langIndex;
                this.oldCVName = cv.getName();
            } else {
                this.oldCVName = "";
                this.entries = new SimpleCVEntry[0];
                if (this.entryListModel != null) {
                    this.entryListModel.clear();
                }
                if (this.entryTableModel != null) {
                    while (this.entryTableModel.getRowCount() > 0) {
                        this.entryTableModel.removeRow(this.entryTableModel.getRowCount() - 1);
                    }
                }
                if (this.entryBoxModel != null) {
                    this.entryBoxModel.removeAllElements();
                }
                this.fillModel(false);
            }
        }

        private void fillModel(boolean reload) {
            int width;
            String v;
            String cveId = null;
            if (this.annotation != null) {
                cveId = this.annotation.getCVEntryId();
            }
            if (this.delegate == this.scrollPane) {
                boolean selected = false;
                if (reload) {
                    int nAdded = 0;
                    SimpleCVEntry[] simpleCVEntryArray = this.entries;
                    int n = simpleCVEntryArray.length;
                    for (int i = 0; i < n; ++i) {
                        SimpleCVEntry entry = simpleCVEntryArray[i];
                        v = entry.getValue();
                        if (v.isEmpty()) continue;
                        this.entryListModel.addElement(entry);
                        if (cveId != null && cveId.equals(entry.getId())) {
                            this.entryList.setSelectedIndex(nAdded);
                            selected = true;
                        }
                        if (v.length() > this.maxEntryLength) {
                            this.maxEntryLength = v.length();
                        }
                        width = InlineEditBox.this.getFontMetrics(this.getEditorComponent().getFont()).stringWidth(v);
                        if (InlineEditBox.this.minCVWidth < width) {
                            InlineEditBox.this.minCVWidth = width;
                        }
                        ++nAdded;
                    }
                } else if (cveId != null) {
                    for (int i = 0; i < this.entryListModel.size(); ++i) {
                        SimpleCVEntry entry = this.entryListModel.getElementAt(i);
                        String id = entry.getId();
                        if (!cveId.equals(id)) continue;
                        this.entryList.setSelectedIndex(i);
                        selected = true;
                        break;
                    }
                }
                if (!selected) {
                    this.entryList.setSelectedIndex(-1);
                }
            } else if (this.delegate == this.box) {
                boolean selected = false;
                if (reload) {
                    for (SimpleCVEntry entry : this.entries) {
                        String v2 = entry.getValue();
                        if (v2.isEmpty()) continue;
                        this.entryBoxModel.addElement(entry);
                        if (cveId != null && cveId.equals(entry.getId())) {
                            this.entryBoxModel.setSelectedItem(entry);
                            selected = true;
                        }
                        if (v2.length() > this.maxEntryLength) {
                            this.maxEntryLength = v2.length();
                        }
                        int width2 = InlineEditBox.this.getFontMetrics(this.getEditorComponent().getFont()).stringWidth(v2);
                        if (InlineEditBox.this.minCVWidth < width2) {
                            InlineEditBox.this.minCVWidth = width2;
                        }
                        selected = true;
                    }
                } else if (cveId != null) {
                    for (int i = 0; i < this.entryBoxModel.getSize(); ++i) {
                        SimpleCVEntry entry = this.entryBoxModel.getElementAt(i);
                        if (!cveId.equals(entry.getId())) continue;
                        this.box.setSelectedIndex(i);
                        selected = true;
                        break;
                    }
                }
                if (!selected) {
                    this.box.setSelectedIndex(-1);
                }
            } else if (this.delegate == this.suggestPanel) {
                String value = null;
                if (this.annotation != null) {
                    value = this.annotation.getValue();
                }
                this.textField.setText(value);
            }
            if (this.delegate == this.tableScrollPane) {
                boolean selected = false;
                if (reload) {
                    this.entryTableModel.setRowCount(0);
                    int nAdded = 0;
                    for (SimpleCVEntry entry : this.entries) {
                        v = entry.getValue();
                        if (v.isEmpty()) continue;
                        this.entryTableModel.addRow(new Object[]{entry, entry.getDescription()});
                        if (cveId != null && cveId.equals(entry.getId())) {
                            this.entryTable.setRowSelectionInterval(nAdded, nAdded);
                            selected = true;
                        }
                        if (v.length() > this.maxEntryLength) {
                            this.maxEntryLength = v.length();
                        }
                        width = InlineEditBox.this.getFontMetrics(this.getEditorComponent().getFont()).stringWidth(v);
                        if (InlineEditBox.this.minCVWidth < width) {
                            InlineEditBox.this.minCVWidth = width;
                        }
                        ++nAdded;
                    }
                    this.scrollIfNeededAutomatically();
                } else if (cveId != null) {
                    for (int i = 0; i < this.entryTable.getRowCount(); ++i) {
                        SimpleCVEntry entry = (SimpleCVEntry)this.entryTableModel.getValueAt(i, 0);
                        String id = entry.getId();
                        if (!cveId.equals(id)) continue;
                        this.entryTable.setRowSelectionInterval(i, i);
                        this.scrollIfNeededAutomatically();
                        selected = true;
                        break;
                    }
                }
                if (!selected) {
                    this.entryTable.clearSelection();
                }
            }
        }

        public void grabFocus() {
            if (this.delegate == this.box) {
                this.box.requestFocus();
            } else if (this.delegate == this.scrollPane) {
                this.entryList.requestFocus();
                this.entryList.ensureIndexIsVisible(this.entryList.getSelectedIndex());
            } else if (this.delegate == this.suggestPanel) {
                this.textField.requestFocus();
            } else if (this.delegate == this.tableScrollPane) {
                this.entryTable.requestFocus();
            }
        }

        public String getSelectedEntryValue() {
            SimpleCVEntry e = this.getSelectedEntry();
            if (e != null) {
                return e.getValue();
            }
            return null;
        }

        public SimpleCVEntry getSelectedEntry() {
            SimpleCVEntry value = null;
            if (this.delegate == this.scrollPane) {
                if (this.entryList.getSelectedValue() != null) {
                    value = this.entryList.getSelectedValue();
                }
            } else if (this.delegate == this.box) {
                if (this.box.getSelectedItem() != null) {
                    value = (SimpleCVEntry)this.box.getSelectedItem();
                }
            } else if (this.delegate == this.suggestPanel) {
                if (InlineEditBox.this.showCVDescription) {
                    if (this.entryTable.getSelectedRow() > -1) {
                        value = (SimpleCVEntry)this.entryTable.getValueAt(this.entryTable.getSelectedRow(), 0);
                    }
                } else if (this.suggestEntryList.getSelectedValue() != null) {
                    value = this.suggestEntryList.getSelectedValue();
                }
            } else if (this.delegate == this.tableScrollPane && this.entryTable.getSelectedRow() > -1) {
                value = (SimpleCVEntry)this.entryTable.getValueAt(this.entryTable.getSelectedRow(), 0);
            }
            return value;
        }

        public int getMaxEntryLength() {
            return this.maxEntryLength;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            block23: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block22: {
                                    if (e.getKeyCode() != 10) break block22;
                                    if (this.delegate == this.box) break block23;
                                    if (e.isShiftDown()) {
                                        InlineEditBox.this.detachEditor();
                                    } else if (this.getSelectedEntry() != null) {
                                        InlineEditBox.this.commitEdit();
                                    } else {
                                        InlineEditBox.this.cancelEdit();
                                    }
                                    break block23;
                                }
                                if (e.getKeyCode() != 27) break block24;
                                InlineEditBox.this.cancelEdit();
                                break block23;
                            }
                            if (e.getKeyCode() != 40 || e.getSource() != this.textField) break block25;
                            if (InlineEditBox.this.showCVDescription) {
                                if (this.entryTable.getSelectedRow() == this.entryTable.getRowCount() - 1) {
                                    this.entryTable.clearSelection();
                                } else {
                                    this.entryTable.setRowSelectionInterval(this.entryTable.getSelectedRow() + 1, this.entryTable.getSelectedRow() + 1);
                                    this.scrollIfNeededAutomatically();
                                }
                            } else {
                                this.suggestEntryList.setSelectedIndex(this.suggestEntryList.getSelectedIndex() + 1);
                                this.suggestEntryList.ensureIndexIsVisible(this.suggestEntryList.getSelectedIndex());
                            }
                            break block23;
                        }
                        if (e.getKeyCode() != 38 || e.getSource() != this.textField) break block26;
                        if (InlineEditBox.this.showCVDescription) {
                            if (this.entryTable.getSelectedRow() <= 0) {
                                this.entryTable.clearSelection();
                            } else {
                                this.entryTable.setRowSelectionInterval(this.entryTable.getSelectedRow() - 1, this.entryTable.getSelectedRow() - 1);
                                this.scrollIfNeededAutomatically();
                            }
                        } else if (this.suggestEntryList.getSelectedIndex() <= 0) {
                            this.suggestEntryList.clearSelection();
                        } else {
                            this.suggestEntryList.setSelectedIndex(this.suggestEntryList.getSelectedIndex() - 1);
                            this.suggestEntryList.ensureIndexIsVisible(this.suggestEntryList.getSelectedIndex());
                        }
                        break block23;
                    }
                    if (e.getKeyCode() != 85 || (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0) break block27;
                    if (!InlineEditBox.this.isAttached()) break block23;
                    this.toggleSuggestPanel(InlineEditBox.this);
                    break block23;
                }
                if (this.entries != null) {
                    int code = e.getKeyCode();
                    for (SimpleCVEntry cve : this.entries) {
                        if (cve.getShortcutKeyCode() != code) continue;
                        if (this.delegate == this.scrollPane) {
                            this.entryList.setSelectedValue(cve, false);
                        } else if (this.delegate == this.box) {
                            this.box.setSelectedItem(cve);
                        } else if (this.delegate == this.tableScrollPane) {
                            for (int i = 0; i < this.entryTable.getRowCount(); ++i) {
                                if (cve != this.entryTable.getValueAt(i, 0)) continue;
                                this.entryTable.setRowSelectionInterval(i, i);
                                break;
                            }
                        }
                        InlineEditBox.this.commitEdit();
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == this.detachMI) {
                if (InlineEditBox.this.attachable) {
                    if (InlineEditBox.this.attached) {
                        InlineEditBox.this.detachEditor();
                    } else {
                        InlineEditBox.this.attachEditor();
                    }
                }
            } else if (ae.getSource() == this.commitMI) {
                InlineEditBox.this.commitEdit();
            } else if (ae.getSource() == this.cancelMI) {
                InlineEditBox.this.cancelEdit();
            } else if (ae.getSource() == this.box) {
                if (ae.getID() == 1001 && ae.getModifiers() == 16 && this.box.isPopupVisible()) {
                    InlineEditBox.this.commitEdit();
                }
            } else if (ae.getSource() == this.toggleSuggestMI) {
                this.toggleSuggestPanel(InlineEditBox.this);
            }
        }

        private void toggleSuggestPanel(Container container) {
            container.removeAll();
            if (this.delegate == this.scrollPane || this.delegate == this.tableScrollPane) {
                this.setDelegate(JPanel.class);
                container.add((Component)this.getEditorComponent(), "Center");
            } else if (this.delegate == this.suggestPanel) {
                this.setDelegate(JScrollPane.class);
                container.add((Component)this.getEditorComponent(), "Center");
            }
            this.grabFocus();
            container.repaint();
            container.validate();
        }

        private void createPopupMenu() {
            this.popup = new JPopupMenu();
            this.detachMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Detach"));
            this.detachMI.addActionListener(this);
            this.detachMI.setAccelerator(KeyStroke.getKeyStroke(10, 1));
            this.popup.add(this.detachMI);
            this.commitMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Commit"));
            this.commitMI.addActionListener(this);
            this.commitMI.setAccelerator(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.popup.add(this.commitMI);
            this.cancelMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Cancel"));
            this.cancelMI.addActionListener(this);
            this.cancelMI.setAccelerator(KeyStroke.getKeyStroke(27, 0));
            this.popup.add(this.cancelMI);
            this.popup.add(new JSeparator());
            this.toggleSuggestMI = new JMenuItem(ElanLocale.getString("InlineEditBox.ToggleSuggestPanel"));
            this.toggleSuggestMI.setAccelerator(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.toggleSuggestMI.addActionListener(this);
            this.popup.add(this.toggleSuggestMI);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (e.getDocument() == this.textFieldDoc && !this.oldPartial.equals(this.textField.getText())) {
                this.findSuggestions();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (e.getDocument() == this.textFieldDoc && !this.oldPartial.equals(this.textField.getText())) {
                this.findSuggestions();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void findSuggestions() {
            this.oldPartial = this.textField.getText();
            if (this.t != null && this.t.isAlive()) {
                Thread tmpT = this.t;
                this.t = null;
                if (tmpT != null) {
                    tmpT.interrupt();
                }
                try {
                    tmpT.join();
                }
                catch (Exception ie) {
                    System.out.println(ie);
                }
            }
            this.t = new Thread(new SuggestionsFinder(this.oldPartial));
            this.t.start();
        }

        private String getDescription(SimpleCVEntry next) {
            String d = next.getDescription();
            if (d == null) {
                return "";
            }
            return d.toLowerCase();
        }

        private class SuggestionsFinder
        implements Runnable {
            private String part;

            public SuggestionsFinder(String part) {
                this.part = part;
            }

            @Override
            public void run() {
                ArrayList<SimpleCVEntry> suggestions = new ArrayList<SimpleCVEntry>();
                Boolean suggestSearchMethodFlag = false;
                Boolean suggestSearchInDescFlag = false;
                Boolean suggestIgnoreCaseFlag = false;
                Boolean boolPref = Preferences.getBool("SuggestPanel.EntryContains", null);
                if (boolPref != null) {
                    suggestSearchMethodFlag = (boolean)boolPref;
                }
                if ((boolPref = Preferences.getBool("SuggestPanel.SearchDescription", null)) != null) {
                    suggestSearchInDescFlag = (boolean)boolPref;
                }
                if ((boolPref = Preferences.getBool("SuggestPanel.IgnoreCase", null)) != null) {
                    suggestIgnoreCaseFlag = (boolean)boolPref;
                }
                if (this.part != null && !this.part.equals("")) {
                    int entriesIndex = 0;
                    if (suggestIgnoreCaseFlag.booleanValue()) {
                        this.part = this.part.toLowerCase();
                    }
                    while (entriesIndex < CVEntryComponent.this.entries.length && !Thread.currentThread().isInterrupted()) {
                        SimpleCVEntry next = CVEntryComponent.this.entries[entriesIndex];
                        String entryValue = next.getValue();
                        if (suggestIgnoreCaseFlag.booleanValue()) {
                            entryValue = entryValue.toLowerCase();
                        }
                        if (suggestSearchMethodFlag.booleanValue()) {
                            if (entryValue.contains(this.part)) {
                                suggestions.add(next);
                            } else if (suggestSearchInDescFlag.booleanValue() && CVEntryComponent.this.getDescription(next).contains(this.part)) {
                                suggestions.add(next);
                            }
                        } else if (entryValue.startsWith(this.part)) {
                            suggestions.add(next);
                        } else if (suggestSearchInDescFlag.booleanValue() && CVEntryComponent.this.getDescription(next).contains(this.part)) {
                            suggestions.add(next);
                        }
                        ++entriesIndex;
                    }
                    if (!Thread.currentThread().isInterrupted()) {
                        SwingUtilities.invokeLater(new SuggestionsDisplayer(suggestions));
                    }
                } else if (!Thread.currentThread().isInterrupted()) {
                    SwingUtilities.invokeLater(new SuggestionsDisplayer(new ArrayList<SimpleCVEntry>()));
                }
            }
        }

        private class SuggestionsDisplayer
        implements Runnable {
            ArrayList<SimpleCVEntry> suggestions;

            public SuggestionsDisplayer(ArrayList<SimpleCVEntry> suggestions) {
                this.suggestions = suggestions;
                if (InlineEditBox.this.showCVDescription) {
                    while (CVEntryComponent.this.entryTableModel.getRowCount() > 0) {
                        CVEntryComponent.this.entryTableModel.removeRow(CVEntryComponent.this.entryTableModel.getRowCount() - 1);
                    }
                } else {
                    CVEntryComponent.this.suggestEntryListModel.clear();
                }
            }

            @Override
            public void run() {
                Iterator<SimpleCVEntry> suggestionIterator = this.suggestions.iterator();
                int suggestionIndex = 0;
                while (suggestionIterator.hasNext()) {
                    SimpleCVEntry nextSuggestion = suggestionIterator.next();
                    if (InlineEditBox.this.showCVDescription) {
                        CVEntryComponent.this.entryTableModel.addRow(new Object[]{nextSuggestion, nextSuggestion.getDescription()});
                        if (nextSuggestion.getValue().equals(CVEntryComponent.this.oldPartial)) {
                            CVEntryComponent.this.entryTable.setRowSelectionInterval(suggestionIndex, suggestionIndex);
                        }
                    } else {
                        CVEntryComponent.this.suggestEntryListModel.addElement(nextSuggestion);
                        if (nextSuggestion.getValue().equals(CVEntryComponent.this.oldPartial)) {
                            CVEntryComponent.this.suggestEntryList.setSelectedIndex(suggestionIndex);
                            CVEntryComponent.this.suggestEntryList.ensureIndexIsVisible(suggestionIndex);
                        }
                    }
                    ++suggestionIndex;
                }
                if (InlineEditBox.this.showCVDescription) {
                    CVEntryComponent.this.scrollIfNeededAutomatically();
                }
            }
        }
    }
}

