/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.TierExportTable;
import mpi.eudico.client.annotator.tier.TierExportTableModel;

public class TierSelectionDialog
extends ClosableDialog
implements ActionListener {
    private List<String> allTier;
    private List<String> selectedTier;
    private List<String> returnedTiers = null;
    private TierExportTableModel model;
    private TierExportTable tierTable;
    private JButton selAllButton;
    private JButton deselAllButton;
    private JButton okButton;
    private JButton cancelButton;
    protected final String EXPORT_COLUMN = "export";
    protected final String TIER_NAME_COLUMN = "tier";

    public TierSelectionDialog(Dialog owner, List<String> allTier, List<String> selectedTier) throws HeadlessException {
        super(owner, true);
        this.allTier = allTier;
        this.selectedTier = selectedTier;
        this.returnedTiers = selectedTier;
        this.initComponents();
    }

    public TierSelectionDialog(Frame owner, List<String> allTier, List<String> selectedTier) throws HeadlessException {
        super(owner, true);
        this.allTier = allTier;
        this.selectedTier = selectedTier;
        this.returnedTiers = selectedTier;
        this.initComponents();
    }

    private void initComponents() {
        JPanel cp = new JPanel(new GridBagLayout());
        cp.setBorder(new TitledBorder(ElanLocale.getString("ExportDialog.Label.SelectTiers")));
        this.model = new TierExportTableModel();
        this.model.setColumnIdentifiers(new String[]{"export", "tier"});
        this.tierTable = new TierExportTable(this.model);
        if (this.allTier != null) {
            for (String name : this.allTier) {
                if (this.selectedTier != null) {
                    if (this.selectedTier.contains(name)) {
                        this.model.addRow(Boolean.TRUE, name);
                        continue;
                    }
                    this.model.addRow(Boolean.FALSE, name);
                    continue;
                }
                this.model.addRow(Boolean.TRUE, name);
            }
        }
        Insets insets = new Insets(4, 6, 4, 6);
        Dimension tableDim = new Dimension(120, 200);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        tierScrollPane.setPreferredSize(tableDim);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        cp.add((Component)tierScrollPane, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(2, 2, 6, 4));
        this.selAllButton = new JButton(ElanLocale.getString("ExportDialog.Label.SelectAll"));
        this.selAllButton.addActionListener(this);
        buttonPanel.add(this.selAllButton);
        this.deselAllButton = new JButton(ElanLocale.getString("ExportDialog.Label.DeselectAll"));
        this.deselAllButton.addActionListener(this);
        buttonPanel.add(this.deselAllButton);
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        cp.add((Component)buttonPanel, gbc);
        this.getContentPane().add(cp);
        this.pack();
        if (this.getParent() != null) {
            this.setLocationRelativeTo(this.getParent());
        }
    }

    private List<String> getSelectedTiers() {
        return this.model.getSelectedTiers();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.selAllButton) {
            if (this.model != null) {
                for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
                    this.model.setValueAt(Boolean.TRUE, i, 0);
                }
            }
        } else if (ae.getSource() == this.deselAllButton) {
            if (this.model != null) {
                for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
                    this.model.setValueAt(Boolean.FALSE, i, 0);
                }
            }
        } else if (ae.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        } else if (ae.getSource() == this.okButton) {
            this.returnedTiers = this.getSelectedTiers();
            this.setVisible(false);
            this.dispose();
        }
    }

    public List<String> getValue() {
        return this.returnedTiers;
    }
}

