/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.MaskFormatter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.TimeFormatter;

public class TimeIntervalEditDialog
extends ClosableDialog
implements ActionListener {
    private JLabel messageLabel;
    private JLabel limitsLabel;
    private JButton okButton;
    private JButton cancelButton;
    private JFormattedTextField btTextField;
    private JFormattedTextField etTextField;
    private long beginTime = -1L;
    private long endTime = -1L;
    private long minBeginTime = 0L;
    private long maxEndTime = Long.MAX_VALUE;

    public TimeIntervalEditDialog() throws HeadlessException {
        this((Frame)null, true);
    }

    public TimeIntervalEditDialog(Frame owner) throws HeadlessException {
        this(owner, null, true);
    }

    public TimeIntervalEditDialog(Frame owner, boolean modal) throws HeadlessException {
        this(owner, null, modal);
    }

    public TimeIntervalEditDialog(Frame owner, String title) throws HeadlessException {
        this(owner, title, true);
    }

    public TimeIntervalEditDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        this(owner, title, modal, null);
    }

    public TimeIntervalEditDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.initComponents();
    }

    public TimeIntervalEditDialog(Dialog owner) throws HeadlessException {
        this(owner, null, true);
    }

    public TimeIntervalEditDialog(Dialog owner, boolean modal) throws HeadlessException {
        this(owner, null, modal);
    }

    public TimeIntervalEditDialog(Dialog owner, String title) throws HeadlessException {
        this(owner, title, true, null);
    }

    public TimeIntervalEditDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
        this(owner, title, modal, null);
    }

    public TimeIntervalEditDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) throws HeadlessException {
        super(owner, title, modal, gc);
        this.initComponents();
    }

    public void setInterval(long begin, long end) {
        this.beginTime = begin;
        this.endTime = end;
        this.btTextField.setValue(TimeFormatter.toString(this.beginTime));
        this.etTextField.setValue(TimeFormatter.toString(this.endTime));
    }

    public void setLimits(long minBT, long maxET) {
        this.minBeginTime = minBT;
        this.maxEndTime = maxET;
        this.limitsLabel.setText(String.format(ElanLocale.getString("ModifyTimesDialog.EnterTimes.Range"), TimeFormatter.toString(this.minBeginTime), TimeFormatter.toString(this.maxEndTime)));
        this.pack();
    }

    public long[] getValue() {
        return new long[]{this.beginTime, this.endTime};
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.messageLabel = new JLabel(ElanLocale.getString("ModifyTimesDialog.EnterTimes"), 0);
        this.limitsLabel = new JLabel("", 0);
        JLabel btLabel = new JLabel(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime"), 11);
        JLabel etLabel = new JLabel(ElanLocale.getString("Frame.GridFrame.ColumnEndTime"), 11);
        HhMmSsMssMaskFormatter timeFormatter = new HhMmSsMssMaskFormatter();
        this.btTextField = new JFormattedTextField(timeFormatter);
        this.etTextField = new JFormattedTextField(timeFormatter);
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.okButton.addActionListener(null);
        this.cancelButton.addActionListener(null);
        Container cp = this.getContentPane();
        ((JComponent)cp).setBorder(new EmptyBorder(6, 8, 2, 8));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        cp.add((Component)this.messageLabel, gbc);
        gbc.gridy = 1;
        cp.add((Component)this.limitsLabel, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        cp.add((Component)btLabel, gbc);
        gbc.gridy = 3;
        cp.add((Component)etLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        cp.add((Component)this.btTextField, gbc);
        gbc.gridy = 3;
        cp.add((Component)this.etTextField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = new Insets(12, 4, 4, 4);
        gbc.anchor = 13;
        cp.add((Component)this.okButton, gbc);
        gbc.gridx = 1;
        gbc.anchor = 17;
        cp.add((Component)this.cancelButton, gbc);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.okButton) {
            this.beginTime = TimeFormatter.toMilliSeconds((String)this.btTextField.getValue());
            this.endTime = TimeFormatter.toMilliSeconds((String)this.etTextField.getValue());
            if (this.beginTime >= this.endTime && ClientLogger.LOG.isLoggable(Level.INFO)) {
                ClientLogger.LOG.info(String.format("The entered begin time (%d) is >= the end time (%d).", this.beginTime, this.endTime));
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    private class HhMmSsMssMaskFormatter
    extends MaskFormatter {
        private DecimalFormat twoDigits = new DecimalFormat("00");

        public HhMmSsMssMaskFormatter() {
            try {
                this.setMask("##:##:##.###");
                this.setPlaceholderCharacter('0');
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        private boolean isValidMSChar(char ch) {
            return ch == '0' || ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5';
        }

        @Override
        public Object stringToValue(String value) throws ParseException {
            Object temp = super.stringToValue(value);
            if (temp instanceof String) {
                Object s = (String)temp;
                if (!this.isValidMSChar(((String)s).charAt(6))) {
                    try {
                        int isec = Integer.valueOf(((String)s).substring(6, 7));
                        int m = Integer.valueOf(((String)s).substring(3, 5));
                        s = ((String)s).substring(0, 3) + this.twoDigits.format(++m) + ((String)s).substring(5, 6) + String.valueOf(isec -= 6) + ((String)s).substring(7);
                    }
                    catch (NumberFormatException nfe) {
                        throw new ParseException("Invalid seconds value", 6);
                    }
                }
                if (!this.isValidMSChar(((String)s).charAt(3))) {
                    try {
                        int imin = Integer.valueOf(((String)s).substring(3, 4));
                        int h = Integer.valueOf(((String)s).substring(0, 2));
                        s = this.twoDigits.format(++h) + ((String)s).substring(2, 3) + String.valueOf(imin -= 6) + ((String)s).substring(4);
                    }
                    catch (NumberFormatException nfe) {
                        throw new ParseException("Invalid minute value", 3);
                    }
                }
                temp = s;
            }
            return temp;
        }
    }
}

