/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.imports.TranscriptionMerger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import nl.mpi.util.FileExtension;

public class MergeTranscriptions
extends ClosableDialog
implements ActionListener,
ProgressListener {
    private static boolean exitOnClose = false;
    private TranscriptionImpl transcription;
    private JButton browseSource1;
    private JButton browseSource2;
    private JButton browseDest;
    private JLabel select1Label;
    private JLabel select2Label;
    private JLabel selectDestLabel;
    private JTextField source1Field;
    private JTextField source2Field;
    private JTextField destField;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JPanel transPanel;
    private JPanel progressPanel;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private JPanel buttonPanel;
    private JButton startButton;
    private JButton closeButton;

    public MergeTranscriptions(Transcription transcription) {
        super((Frame)new JFrame(), true);
        this.transcription = (TranscriptionImpl)transcription;
        this.initComponents();
        this.postInit();
    }

    protected void initComponents() {
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.transPanel = new JPanel();
        this.browseSource1 = new JButton();
        this.browseSource2 = new JButton();
        this.browseDest = new JButton();
        this.source1Field = new JTextField();
        this.source2Field = new JTextField();
        this.destField = new JTextField();
        this.select1Label = new JLabel();
        this.select2Label = new JLabel();
        this.selectDestLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.startButton = new JButton();
        this.closeButton = new JButton();
        this.progressPanel = new JPanel();
        this.progressLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MergeTranscriptions.this.closeDialog(evt);
            }
        });
        Insets insets = new Insets(2, 6, 2, 6);
        this.titlePanel.setLayout(new BorderLayout(0, 4));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        JPanel titleLabelPanel = new JPanel();
        titleLabelPanel.add(this.titleLabel);
        this.titlePanel.add((Component)titleLabelPanel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        this.transPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.transPanel.add((Component)this.select1Label, gridBagConstraints);
        if (this.transcription != null) {
            this.source1Field.setEnabled(false);
            this.source1Field.setText(this.transcription.getFullPath());
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.transPanel.add((Component)this.source1Field, gridBagConstraints);
        if (this.transcription != null) {
            this.browseSource1.setEnabled(false);
        } else {
            this.browseSource1.addActionListener(this);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.transPanel.add((Component)this.browseSource1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.transPanel.add((Component)this.select2Label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.transPanel.add((Component)this.source2Field, gridBagConstraints);
        this.browseSource2.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.transPanel.add((Component)this.browseSource2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.transPanel.add((Component)this.selectDestLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.transPanel.add((Component)this.destField, gridBagConstraints);
        this.browseDest.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.transPanel.add((Component)this.browseDest, gridBagConstraints);
        JPanel filler = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weighty = 1.0;
        this.transPanel.add((Component)filler, gridBagConstraints);
        this.progressPanel.setLayout(new GridBagLayout());
        this.progressPanel.setPreferredSize(new Dimension(50, 80));
        this.progressLabel.setFont(Constants.deriveSmallFont(this.progressLabel.getFont()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        this.progressPanel.add((Component)this.progressLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        this.progressPanel.add((Component)this.progressBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        this.transPanel.add((Component)this.progressPanel, gridBagConstraints);
        this.progressPanel.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.transPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.startButton.addActionListener(this);
        this.buttonPanel.add(this.startButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.updateLocale();
    }

    private void activateUI(boolean enable) {
        this.startButton.setEnabled(enable);
        this.closeButton.setEnabled(enable);
        if (this.transcription == null) {
            this.browseSource1.setEnabled(enable);
            this.source1Field.setEnabled(enable);
        }
        this.browseSource2.setEnabled(enable);
        this.browseDest.setEnabled(enable);
        this.source2Field.setEnabled(enable);
        this.destField.setEnabled(enable);
    }

    protected void updateLocale() {
        this.setTitle(ElanLocale.getString("MergeTranscriptionDialog.Title"));
        this.transPanel.setBorder(new TitledBorder(ElanLocale.getString("MergeTranscriptionDialog.Title")));
        this.titleLabel.setText(ElanLocale.getString("MergeTranscriptionDialog.Title"));
        this.select1Label.setText(ElanLocale.getString("MergeTranscriptionDialog.Label.Source1"));
        this.select2Label.setText(ElanLocale.getString("MergeTranscriptionDialog.Label.Source2"));
        this.selectDestLabel.setText(ElanLocale.getString("MergeTranscriptionDialog.Label.Destination"));
        this.browseSource1.setText(ElanLocale.getString("Button.Browse"));
        this.browseSource2.setText(ElanLocale.getString("Button.Browse"));
        this.browseDest.setText(ElanLocale.getString("Button.Browse"));
        this.startButton.setText(ElanLocale.getString("MergeTranscriptionDialog.Button.Merge"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
    }

    protected void postInit() {
        this.pack();
        int w = 550;
        int h = 400;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
    }

    protected void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
        if (exitOnClose) {
            System.exit(0);
        }
    }

    private void startMerge() {
        int answer;
        if (this.transcription == null && !this.checkValidEAFFile(this.source1Field.getText())) {
            this.showWarningDialog(ElanLocale.getString("MergeTranscriptionDialog.Warning.Source1"));
            return;
        }
        if (!this.checkValidEAFFile(this.source2Field.getText())) {
            this.showWarningDialog(ElanLocale.getString("MergeTranscriptionDialog.Warning.Source2"));
            return;
        }
        String dest = this.destField.getText();
        if (dest == null || dest.length() < 4) {
            this.showWarningDialog(ElanLocale.getString("MergeTranscriptionDialog.Warning.NoDestination"));
            return;
        }
        if (this.checkValidEAFFile(this.destField.getText()) && (answer = JOptionPane.showConfirmDialog(null, ElanLocale.getString("MergeTranscriptionDialog.Warning.DestinationExists"), ElanLocale.getString("Message.Warning"), 0)) == 1) {
            return;
        }
        TranscriptionMerger merger = null;
        try {
            merger = this.transcription != null ? new TranscriptionMerger(this.transcription, this.source2Field.getText(), this.destField.getText()) : new TranscriptionMerger(this.source1Field.getText(), this.source2Field.getText(), this.destField.getText());
        }
        catch (IOException ioe) {
            this.showWarningDialog(ioe.getMessage());
            return;
        }
        catch (Exception e) {
            this.showWarningDialog(e.getMessage());
            return;
        }
        if (merger != null) {
            this.activateUI(false);
            this.progressPanel.setVisible(true);
            merger.addProgressListener(this);
            merger.startMerge();
        }
    }

    private void browseFirstSource() {
        String name = this.promptForFileName("MergeFirstEafDir");
        if (name != null) {
            this.source1Field.setText(name);
            if (this.progressPanel.isVisible()) {
                this.progressLabel.setText("");
                this.progressBar.setValue(0);
            }
        }
    }

    private void browseSecondSource() {
        String name = this.promptForFileName("MergeSecondEafDir");
        if (name != null) {
            this.source2Field.setText(name);
            if (this.progressPanel.isVisible()) {
                this.progressLabel.setText("");
                this.progressBar.setValue(0);
            }
        }
    }

    private void browseDestination() {
        String name = this.getSaveFileName("MergeDestEafDir");
        if (name != null) {
            this.destField.setText(name);
            if (this.progressPanel.isVisible()) {
                this.progressLabel.setText("");
                this.progressBar.setValue(0);
            }
        }
    }

    private String promptForFileName(String prefLoc) {
        FileChooser chooser = new FileChooser(null);
        chooser.createAndShowFileDialog(ElanLocale.getString("MergeTranscriptionDialog.SelectEAF"), 0, ElanLocale.getString("Button.Select"), null, FileExtension.EAF_EXT, false, prefLoc, 0, null);
        File eafFile = chooser.getSelectedFile();
        if (eafFile != null) {
            return eafFile.getAbsolutePath();
        }
        return null;
    }

    private String getSaveFileName(String locPrefString) {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("MergeTranscriptionDialog.SelectEAF"), 1, FileExtension.EAF_EXT, locPrefString);
        File eafFile = chooser.getSelectedFile();
        if (eafFile != null) {
            return eafFile.getAbsolutePath();
        }
        return null;
    }

    private boolean checkValidEAFFile(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (new File(path).exists()) {
            String lowerPathName = path.toLowerCase();
            String[] exts = FileExtension.EAF_EXT;
            boolean validExt = false;
            for (int i = 0; i < exts.length; ++i) {
                if (!lowerPathName.endsWith("." + exts[i])) continue;
                validExt = true;
                break;
            }
            if (validExt) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.startButton) {
            this.startMerge();
        } else if (source == this.closeButton) {
            this.closeDialog(null);
        } else if (source == this.browseSource1) {
            this.browseFirstSource();
        } else if (source == this.browseSource2) {
            this.browseSecondSource();
        } else if (source == this.browseDest) {
            this.browseDestination();
        }
    }

    public static void main(String[] args) {
        exitOnClose = true;
        new MergeTranscriptions(null).setVisible(true);
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    @Override
    public void progressUpdated(Object source, int percent, String message) {
        if (this.progressPanel.isVisible()) {
            this.progressLabel.setText(message);
            if (percent < 0) {
                percent = 0;
            } else if (percent > 100) {
                percent = 100;
            }
            this.progressBar.setValue(percent);
        }
        if (percent >= 100) {
            this.activateUI(true);
        }
    }

    @Override
    public void progressCompleted(Object source, String message) {
        if (this.progressPanel.isVisible()) {
            this.progressLabel.setText(message);
            this.progressBar.setValue(100);
        }
        this.activateUI(true);
    }

    @Override
    public void progressInterrupted(Object source, String message) {
        if (this.progressPanel.isVisible()) {
            this.progressLabel.setText(message);
        }
        this.activateUI(true);
    }
}

