/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexicalEntryFieldIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.multilangcv.LangInfo;

public class MergeUtil {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public List<TierImpl> getAddableTiers(TranscriptionImpl srcTrans, TranscriptionImpl destTrans, List<String> selTiers) {
        if (srcTrans == null || destTrans == null) {
            ClientLogger.LOG.warning("A Transcription is null");
            return new ArrayList<TierImpl>(0);
        }
        if (selTiers == null) {
            selTiers = new ArrayList<String>(srcTrans.getTiers().size());
            for (Tier tier : srcTrans.getTiers()) {
                selTiers.add(tier.getName());
            }
        }
        ArrayList<TierImpl> validTiers = new ArrayList<TierImpl>(selTiers.size());
        boolean bl = false;
        while (true) {
            TierImpl t;
            String name;
            void var5_7;
            block13: {
                TierImpl loopTier;
                String parentName;
                TierImpl parent;
                block14: {
                    block10: {
                        TierImpl t2;
                        block11: {
                            block12: {
                                if (var5_7 >= selTiers.size()) {
                                    return validTiers;
                                }
                                name = selTiers.get((int)var5_7);
                                t = srcTrans.getTierWithId(name);
                                if (t == null) break block10;
                                t2 = destTrans.getTierWithId(name);
                                if (t2 != null) break block11;
                                if (t.getParentTier() != null) break block12;
                                validTiers.add(t);
                                break block13;
                            }
                            parent = null;
                            parentName = null;
                            loopTier = t;
                            break block14;
                        }
                        if (!this.lingTypeCompatible(t, t2)) break block13;
                        validTiers.add(t);
                        break block13;
                    }
                    ClientLogger.LOG.warning("Tier " + name + " does not exist.");
                    break block13;
                }
                while (loopTier.getParentTier() != null) {
                    parent = loopTier.getParentTier();
                    parentName = parent.getName();
                    if (selTiers.contains(parentName)) {
                        if (parent.getParentTier() == null) {
                            validTiers.add(t);
                            break;
                        }
                        if (destTrans.getTierWithId(parentName) != null) {
                            if (!this.lingTypeCompatible(parent, destTrans.getTierWithId(parentName))) break;
                            validTiers.add(t);
                            break;
                        }
                        loopTier = parent;
                        continue;
                    }
                    if (destTrans.getTierWithId(parentName) == null || !this.lingTypeCompatible(parent, destTrans.getTierWithId(parentName))) break;
                    validTiers.add(t);
                    break;
                }
            }
            if (!validTiers.contains(t)) {
                ClientLogger.LOG.warning("Cannot add tier " + name);
            }
            ++var5_7;
        }
    }

    public boolean lingTypeCompatible(TierImpl t, TierImpl t2) {
        if (t == null || t2 == null) {
            return false;
        }
        LinguisticType lt = t.getLinguisticType();
        LinguisticType lt2 = t2.getLinguisticType();
        if (lt.hasConstraints() == lt2.hasConstraints()) {
            if (lt.getConstraints() != null) {
                if (lt.getConstraints().getStereoType() == lt2.getConstraints().getStereoType()) {
                    return true;
                }
                ClientLogger.LOG.warning("Incompatible tier types in source and destination: " + t.getName());
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean lingTypeCompatible(LinguisticType lType1, LinguisticType lType2) {
        if (lType1 == null) {
            return false;
        }
        if (lType2 == null) {
            return false;
        }
        return this.constraintsCompatible(lType1.getConstraints(), lType2.getConstraints());
    }

    public boolean constraintsCompatible(Constraint c1, Constraint c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.getStereoType() == c2.getStereoType();
    }

    public boolean parentChildTypeCompatible(LinguisticType parentType, LinguisticType childType) {
        if (parentType == null || childType == null) {
            return false;
        }
        if (!parentType.isTimeAlignable() && childType.isTimeAlignable()) {
            return false;
        }
        if (!childType.hasConstraints()) {
            return false;
        }
        if (!parentType.hasConstraints()) {
            return childType.hasConstraints();
        }
        ConstraintImpl parentCon = (ConstraintImpl)parentType.getConstraints();
        ConstraintImpl childCon = (ConstraintImpl)childType.getConstraints();
        boolean compatible = false;
        switch (parentCon.getStereoType()) {
            case 0: {
                switch (childCon.getStereoType()) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: {
                        compatible = true;
                    }
                }
                break;
            }
            case 1: {
                switch (childCon.getStereoType()) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: {
                        compatible = true;
                    }
                }
                break;
            }
            case 3: {
                switch (childCon.getStereoType()) {
                    case 3: 
                    case 4: {
                        compatible = true;
                    }
                }
                break;
            }
            case 4: {
                switch (childCon.getStereoType()) {
                    case 3: 
                    case 4: {
                        compatible = true;
                    }
                }
            }
        }
        return compatible;
    }

    public <T extends Tier> List<T> sortTiers(List<T> tiersToSort) {
        DefaultMutableTreeNode node;
        Tier t;
        int i;
        if (tiersToSort == null || tiersToSort.size() == 0) {
            return null;
        }
        DefaultMutableTreeNode sortedRootNode = new DefaultMutableTreeNode("sortRoot");
        HashMap<Tier, DefaultMutableTreeNode> nodes = new HashMap<Tier, DefaultMutableTreeNode>();
        for (i = 0; i < tiersToSort.size(); ++i) {
            t = (Tier)tiersToSort.get(i);
            node = new DefaultMutableTreeNode(t);
            nodes.put(t, node);
        }
        for (i = 0; i < tiersToSort.size(); ++i) {
            t = (Tier)tiersToSort.get(i);
            if (t.getParentTier() == null || !tiersToSort.contains(t.getParentTier())) {
                sortedRootNode.add((MutableTreeNode)nodes.get(t));
                continue;
            }
            ((DefaultMutableTreeNode)nodes.get(t.getParentTier())).add((MutableTreeNode)nodes.get(t));
        }
        ArrayList<Tier> sorted = new ArrayList<Tier>(tiersToSort.size());
        Enumeration<TreeNode> en = sortedRootNode.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            node = (DefaultMutableTreeNode)en.nextElement();
            if (!(node.getUserObject() instanceof Tier)) continue;
            sorted.add((Tier)node.getUserObject());
        }
        return sorted;
    }

    public List<String> sortTiers(TranscriptionImpl transcription, List<String> tierNames) {
        if (transcription == null || tierNames == null || tierNames.size() == 0) {
            return null;
        }
        List<TierImpl> tierList = new ArrayList(tierNames.size());
        for (String name : tierNames) {
            TierImpl tierImpl = transcription.getTierWithId(name);
            if (tierImpl == null) continue;
            tierList.add(tierImpl);
        }
        if ((tierList = this.sortTiers(tierList)) != null) {
            ArrayList<String> sortedNames = new ArrayList<String>(tierList.size());
            for (Tier tier : tierList) {
                sortedNames.add(tier.getName());
            }
            return sortedNames;
        }
        return null;
    }

    public List<TierImpl> getSortedTiers(TranscriptionImpl transcription, List<String> tiersToSort) {
        if (transcription == null || tiersToSort == null || tiersToSort.size() == 0) {
            return null;
        }
        ArrayList<TierImpl> tierList = new ArrayList<TierImpl>(tiersToSort.size());
        for (String name : tiersToSort) {
            TierImpl t = transcription.getTierWithId(name);
            if (t == null) continue;
            tierList.add(t);
        }
        return this.sortTiers(tierList);
    }

    public List<String> getTiersWithoutParentInGroup(TranscriptionImpl transcription, List<String> tiersToInspect) {
        if (transcription == null || tiersToInspect == null) {
            return null;
        }
        ArrayList<String> rootAndSubRoots = new ArrayList<String>(tiersToInspect.size());
        block0: for (int i = 0; i < tiersToInspect.size(); ++i) {
            TierImpl t1 = transcription.getTierWithId(tiersToInspect.get(i));
            if (t1 == null) continue;
            for (int j = 0; j < tiersToInspect.size(); ++j) {
                if (j == i && j != tiersToInspect.size() - 1) continue;
                TierImpl t2 = transcription.getTierWithId(tiersToInspect.get(j));
                if (t2 != null && t1.hasAncestor(t2)) continue block0;
                if (j != tiersToInspect.size() - 1) continue;
                rootAndSubRoots.add(tiersToInspect.get(i));
            }
        }
        return rootAndSubRoots;
    }

    public void addTiersTypesAndCVs(TranscriptionImpl srcTrans, TranscriptionImpl destTrans, List<TierImpl> tiersToAdd) {
        ControlledVocabulary cv;
        int c;
        String typeName;
        LinguisticType lt;
        TierImpl t;
        int i;
        if (srcTrans == null) {
            ClientLogger.LOG.warning("Source transcription is null.");
            return;
        }
        if (destTrans == null) {
            ClientLogger.LOG.warning("Destination transcription is null");
            return;
        }
        if (tiersToAdd == null || tiersToAdd.size() == 0) {
            ClientLogger.LOG.warning("No tiers to add");
            return;
        }
        HashMap<String, ControlledVocabulary> renamedCVS = new HashMap<String, ControlledVocabulary>(5);
        HashMap<String, CallSite> renamedTypes = new HashMap<String, CallSite>(5);
        ArrayList<LinguisticType> typesToAdd = new ArrayList<LinguisticType>(5);
        ArrayList<ControlledVocabulary> cvsToAdd = new ArrayList<ControlledVocabulary>(5);
        LinguisticType lt2 = null;
        ControlledVocabulary cv2 = null;
        for (i = 0; i < tiersToAdd.size(); ++i) {
            t = tiersToAdd.get(i);
            if (t == null || destTrans.getTierWithId(t.getName()) != null || typesToAdd.contains(lt = t.getLinguisticType())) continue;
            typeName = lt.getLinguisticTypeName();
            lt2 = destTrans.getLinguisticTypeByName(typeName);
            if (lt2 != null) {
                if (lt.getConstraints() == null && lt2.getConstraints() == null || lt.getConstraints() != null && lt2.getConstraints() != null && lt.getConstraints().getStereoType() == lt.getConstraints().getStereoType()) continue;
                String nname = typeName + "-cp";
                c = 1;
                while (destTrans.getLinguisticTypeByName(nname + c) != null) {
                    ++c;
                }
                nname = nname + c;
                if (!renamedTypes.containsKey(typeName)) {
                    renamedTypes.put(typeName, (CallSite)((Object)nname));
                }
            }
            typesToAdd.add(lt);
            if (!lt.isUsingControlledVocabulary() || cvsToAdd.contains(cv = srcTrans.getControlledVocabulary(lt.getControlledVocabularyName()))) continue;
            cvsToAdd.add(cv);
        }
        for (i = 0; i < cvsToAdd.size(); ++i) {
            cv = (ControlledVocabulary)cvsToAdd.get(i);
            cv2 = destTrans.getControlledVocabulary(cv.getName());
            if (cv2 == null) {
                destTrans.addControlledVocabulary(cv);
                ClientLogger.LOG.info("Added Controlled Vocabulary: " + cv.getName());
                continue;
            }
            if (cv.equals(cv2)) continue;
            String newCVName = cv.getName() + "-cp";
            c = 1;
            while (destTrans.getControlledVocabulary(newCVName + c) != null) {
                ++c;
            }
            newCVName = newCVName + c;
            ClientLogger.LOG.info("Renamed Controlled Vocabulary: " + cv.getName() + " to " + newCVName);
            renamedCVS.put(cv.getName(), cv);
            cv.setName(newCVName);
            destTrans.addControlledVocabulary(cv);
            ClientLogger.LOG.info("Added Controlled Vocabulary: " + cv.getName());
        }
        for (i = 0; i < typesToAdd.size(); ++i) {
            lt = (LinguisticType)typesToAdd.get(i);
            typeName = lt.getLinguisticTypeName();
            if (lt.isUsingControlledVocabulary() && renamedCVS.containsKey(lt.getControlledVocabularyName())) {
                cv2 = (ControlledVocabulary)renamedCVS.get(lt.getControlledVocabularyName());
                lt.setControlledVocabularyName(cv2.getName());
            }
            if (renamedTypes.containsKey(lt.getLinguisticTypeName())) {
                String newLTName = (String)renamedTypes.get(lt.getLinguisticTypeName());
                ClientLogger.LOG.info("Renamed Linguistic Type: " + lt.getLinguisticTypeName() + " to " + newLTName);
                lt.setLinguisticTypeName(newLTName);
            }
            destTrans.addLinguisticType(lt);
            ClientLogger.LOG.info("Added Linguistic Type: " + lt.getLinguisticTypeName());
        }
        for (i = 0; i < tiersToAdd.size(); ++i) {
            t = tiersToAdd.get(i);
            if (destTrans.getTierWithId(t.getName()) != null) continue;
            TierImpl t2 = t.getParentTier();
            String parentTierName = null;
            if (t2 != null) {
                parentTierName = t2.getName();
            }
            TierImpl newTier = null;
            if (parentTierName == null) {
                newTier = new TierImpl(t.getName(), t.getParticipant(), destTrans, null);
            } else {
                t2 = destTrans.getTierWithId(parentTierName);
                if (t2 != null) {
                    newTier = new TierImpl(t2, t.getName(), t.getParticipant(), destTrans, null);
                } else {
                    ClientLogger.LOG.warning("The parent tier: " + parentTierName + " for tier: " + t.getName() + " was not found in the destination transcription");
                }
            }
            if (newTier == null) continue;
            lt = t.getLinguisticType();
            lt2 = destTrans.getLinguisticTypeByName(lt.getLinguisticTypeName());
            if (lt2 != null) {
                newTier.setLinguisticType(lt2);
                destTrans.addTier(newTier);
                ClientLogger.LOG.info("Created and added tier to destination: " + newTier.getName());
            } else {
                ClientLogger.LOG.warning("Could not add tier: " + newTier.getName() + " because the Linguistic Type was not found in the destination transcription.");
            }
            newTier.setDefaultLocale(t.getDefaultLocale());
            newTier.setAnnotator(t.getAnnotator());
            newTier.setLangRef(t.getLangRef());
        }
    }

    public Map<String, String> getRenamingTierMap(TranscriptionImpl srcTrans, TranscriptionImpl destTrans, List<String> selTiers) {
        if (srcTrans == null || destTrans == null) {
            ClientLogger.LOG.warning("A Transcription is null");
            return new HashMap<String, String>(0);
        }
        if (selTiers == null) {
            selTiers = new ArrayList<String>(srcTrans.getTiers().size());
            for (Tier tier : srcTrans.getTiers()) {
                selTiers.add(tier.getName());
            }
        }
        HashMap<String, String> nameMap = new HashMap<String, String>();
        String string = "-";
        String END_PAT = ".+-[0-9]+$";
        block3: for (String tName : selTiers) {
            if (nameMap.containsKey(tName)) continue;
            if (srcTrans.getTierWithId(tName) != null) {
                if (destTrans.getTierWithId(tName) != null) {
                    int count = 1;
                    String bareName = tName;
                    if (tName.matches(".+-[0-9]+$")) {
                        String curNum = tName.substring(tName.lastIndexOf("-") + 1);
                        try {
                            count = Integer.parseInt(curNum);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        bareName = tName.substring(0, tName.lastIndexOf("-"));
                    }
                    while (count <= 100) {
                        String nextTName = bareName + "-" + count;
                        if (destTrans.getTierWithId(nextTName) == null && !nameMap.containsValue(nextTName)) {
                            nameMap.put(tName, nextTName);
                            TierImpl t = destTrans.getTierWithId(tName);
                            List<TierImpl> depTiers = t.getDependentTiers();
                            block5: for (TierImpl ti : depTiers) {
                                String nextDepTierName;
                                if (!selTiers.contains(ti.getName())) continue;
                                String bareDepName = ti.getName();
                                if (bareDepName.matches(".+-[0-9]+$")) {
                                    bareDepName = bareDepName.substring(0, bareDepName.lastIndexOf("-"));
                                }
                                if (destTrans.getTierWithId(nextDepTierName = bareDepName + "-" + count) == null && !nameMap.containsValue(nextDepTierName)) {
                                    nameMap.put(ti.getName(), nextDepTierName);
                                    continue;
                                }
                                for (int ncount = count + 1; ncount <= 100; ++ncount) {
                                    nextDepTierName = bareDepName + "-" + ncount;
                                    if (destTrans.getTierWithId(nextDepTierName) != null || nameMap.containsValue(nextDepTierName)) continue;
                                    nameMap.put(ti.getName(), nextDepTierName);
                                    continue block5;
                                }
                            }
                            continue block3;
                        }
                        ++count;
                    }
                    continue;
                }
                nameMap.put(tName, tName);
                continue;
            }
            nameMap.put(tName, tName);
        }
        return nameMap;
    }

    public void renameTiersWithTierMap(TranscriptionImpl trans, Map<String, String> tierNameMap) {
        for (Map.Entry<String, String> entry : tierNameMap.entrySet()) {
            TierImpl t;
            if (entry.getKey().equals(entry.getValue()) || (t = trans.getTierWithId(entry.getKey())) == null) continue;
            t.setName(entry.getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateControlledVocabulary(TranscriptionImpl srcTrans, TranscriptionImpl targetTrans, String cvName, boolean forceReplace, ProcessReport report) {
        int index2;
        String lid;
        int i;
        int numTargetLanguages;
        if (srcTrans == null) {
            ClientLogger.LOG.warning("The source Transcription is null");
            return;
        }
        if (targetTrans == null) {
            ClientLogger.LOG.warning("The target Transcription is null");
            return;
        }
        ControlledVocabulary srcCV = srcTrans.getControlledVocabulary(cvName);
        if (srcCV == null) {
            ClientLogger.LOG.info(String.format("The source transcription does not contain a CV with name: \"%s\"", cvName));
            if (report == null) return;
            report.append(String.format("The source does not contain a CV with name: \"%s\"", cvName));
            return;
        }
        ControlledVocabulary targetCV = targetTrans.getControlledVocabulary(cvName);
        if (forceReplace) {
            ControlledVocabulary nextCV = srcCV.clone();
            if (targetCV != null) {
                targetTrans.replaceControlledVocabulary(nextCV);
                if (report == null) return;
                report.append(String.format("Performed a forced replace of target CV: \"%s\"", nextCV.getName()));
                return;
            } else {
                targetTrans.addControlledVocabulary(nextCV);
                if (report == null) return;
                report.append(String.format("Added new CV: \"%s\"", nextCV.getName()));
            }
            return;
        }
        if (srcCV instanceof ExternalCV) {
            ExternalCV srcECV = (ExternalCV)srcCV;
            if (targetCV instanceof ExternalCV) {
                ExternalCV targetECV = (ExternalCV)targetCV;
                if (srcECV.getExternalRef() == null) return;
                if (targetECV.getExternalRef() != null) {
                    if (srcECV.getExternalRef().getReferenceType() != targetECV.getExternalRef().getReferenceType() || srcECV.getExternalRef().getValue() == null || srcECV.getExternalRef().getValue().equals(targetECV.getExternalRef().getValue())) return;
                    targetECV.getExternalRef().setValue(srcECV.getExternalRef().getValue());
                    targetTrans.setChanged();
                    if (report == null) return;
                    report.append(String.format("Updated external URL of target CV \"%s\" to: \"%s\"", targetCV.getName(), targetECV.getExternalRef().getValue()));
                    return;
                } else {
                    try {
                        ExternalReference erf = srcECV.getExternalRef().clone();
                        targetECV.setExternalRef(erf);
                        targetTrans.setChanged();
                        if (report == null) return;
                        report.append(String.format("Added external URL: \"%s\" to target CV: \"%s\"", targetECV.getExternalRef().getValue(), targetCV.getName()));
                        return;
                    }
                    catch (CloneNotSupportedException cnse) {
                        if (report == null) return;
                        report.append(String.format("Cannot clone external reference of CV: \"%s\"", targetCV.getName()));
                    }
                }
                return;
            } else if (targetCV != null) {
                ExternalCV convertCV = new ExternalCV(srcECV);
                targetTrans.replaceControlledVocabulary(convertCV);
                if (report == null) return;
                report.append(String.format("Replaced internal CV by external CV: \"%s\"", srcECV.getName()));
                return;
            } else {
                targetTrans.addControlledVocabulary(new ExternalCV(srcECV));
                if (report == null) return;
                report.append(String.format("Added external CV: \"%s\"", srcECV.getName()));
            }
            return;
        }
        if (targetCV == null) {
            targetTrans.addControlledVocabulary(srcCV.clone());
            if (report == null) return;
            report.append(String.format("Added internal CV: \"%s\"", srcCV.getName()));
            return;
        }
        if (targetCV instanceof ExternalCV) {
            ControlledVocabulary convertCV = new ControlledVocabulary(srcCV.getName());
            convertCV.clone(srcCV);
            targetTrans.replaceControlledVocabulary(convertCV);
            targetCV = convertCV;
            if (report == null) return;
            report.append(String.format("Replaced external CV by internal CV: \"%s\"", srcCV.getName()));
            return;
        }
        int numSrcLanguages = srcCV.getNumberOfLanguages();
        if (numSrcLanguages == (numTargetLanguages = targetCV.getNumberOfLanguages())) {
            for (i = 0; i < numSrcLanguages; ++i) {
                lid = srcCV.getLanguageId(i);
                index2 = targetCV.getIndexOfLanguage(lid);
                if (index2 < 0) {
                    String curLid = targetCV.getLanguageId(i);
                    if (srcCV.getIndexOfLanguage(curLid) >= 0) continue;
                    LangInfo lInfo = srcCV.getLangInfo(i);
                    targetCV.setLanguageIds(i, lInfo.getId(), lInfo.getLongId(), lInfo.getLabel());
                    if (report != null) {
                        report.append(String.format("Changed Language of target CV: \"%s\", at index %d from \"%s\" to \"%s\"", targetCV.getName(), i, curLid, lid));
                    }
                    if (srcCV.getDescription(i) == null || srcCV.getDescription(i).equals(targetCV.getDescription(i))) continue;
                    targetCV.setDescription(i, srcCV.getDescription(i));
                    if (report == null) continue;
                    report.append(String.format("Updated Description of target CV: \"%s\" at index %d to \"%s\"", targetCV.getName(), i, targetCV.getDescription(i)));
                    continue;
                }
                if (i == index2) {
                    if (srcCV.getDescription(i) == null || srcCV.getDescription(i).equals(targetCV.getDescription(i))) continue;
                    targetCV.setDescription(i, srcCV.getDescription(i));
                    if (report == null) continue;
                    report.append(String.format("Updated Description of target CV: \"%s\" at index %d to \"%s\"", targetCV.getName(), i, targetCV.getDescription(index2)));
                    continue;
                }
                if (srcCV.getDescription(i) == null || srcCV.getDescription(i).equals(targetCV.getDescription(index2))) continue;
                targetCV.setDescription(index2, srcCV.getDescription(i));
                if (report == null) continue;
                report.append(String.format("Updated Description of target CV: \"%s\" at index %d to \"%s\"", targetCV.getName(), index2, targetCV.getDescription(index2)));
            }
        } else {
            for (i = 0; i < numSrcLanguages; ++i) {
                lid = srcCV.getLanguageId(i);
                index2 = targetCV.getIndexOfLanguage(lid);
                if (index2 < 0) {
                    LangInfo langInfo = srcCV.getLangInfo(i);
                    int ni = targetCV.addLanguage(langInfo);
                    if (ni < 0) {
                        if (report == null) continue;
                        report.append(String.format("Failed to add Language: \"%s\" to target CV: \"%s\"", lid, targetCV.getName()));
                        continue;
                    }
                    index2 = ni;
                    if (report != null) {
                        report.append(String.format("Added Language: \"%s\" to target CV: \"%s\"", lid, targetCV.getName()));
                    }
                }
                if (index2 < 0 || srcCV.getDescription(i) == null || srcCV.getDescription(i).equals(targetCV.getDescription(index2))) continue;
                targetCV.setDescription(index2, srcCV.getDescription(i));
                if (report == null) continue;
                report.append(String.format("Updated Description of target CV: \"%s\"  at index %d to \"%s\"", targetCV.getName(), index2, targetCV.getDescription(index2)));
            }
        }
        if (srcCV.equals(targetCV)) return;
        Iterator<CVEntry> entryIt = srcCV.iterator();
        int numAdded = 0;
        int numLangValueAdded = 0;
        while (entryIt.hasNext()) {
            CVEntry entry = entryIt.next();
            CVEntry tarEntry = targetCV.getEntrybyId(entry.getId());
            if (tarEntry == null) {
                targetCV.addEntry(new CVEntry(targetCV, entry));
                ++numAdded;
                continue;
            }
            for (int i2 = 0; i2 < numSrcLanguages; ++i2) {
                String tv;
                String sv = entry.getValue(i2);
                int index22 = targetCV.getIndexOfLanguage(srcCV.getLanguageId(i2));
                if (index22 < 0 || (tv = tarEntry.getValue(index22)) != null && sv.equals(tv)) continue;
                tarEntry.setValue(index22, sv);
                targetTrans.setChanged();
                ++numLangValueAdded;
                String srcDesc = entry.getDescription(i2);
                if (srcDesc != null && !srcDesc.equals(tarEntry.getDescription(index22))) {
                    tarEntry.setDescription(index22, srcDesc);
                }
                if (entry.getExternalRef() == null || entry.getExternalRef().equals(tarEntry.getExternalRef())) continue;
                try {
                    tarEntry.setExternalRef(entry.getExternalRef().clone());
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
        }
        if (report == null) return;
        if (numAdded > 0) {
            report.append(String.format("Added %d entries to target CV: \"%s\"", numAdded, targetCV.getName()));
        }
        if (numLangValueAdded <= 0) return;
        report.append(String.format("Added or updated %d entry values to target CV: \"%s\"", numLangValueAdded, targetCV.getName()));
    }

    public void updateTierType(TranscriptionImpl srcTrans, TranscriptionImpl targetTrans, String typeName, ProcessReport report) {
        if (srcTrans == null) {
            ClientLogger.LOG.warning("The source Transcription is null");
            return;
        }
        if (targetTrans == null) {
            ClientLogger.LOG.warning("The target Transcription is null");
            return;
        }
        LinguisticType srcType = srcTrans.getLinguisticTypeByName(typeName);
        if (srcType == null) {
            ClientLogger.LOG.info("The source transcription does not contain a Tier Type with name: " + typeName);
            return;
        }
        boolean changed = false;
        LinguisticType targetType = targetTrans.getLinguisticTypeByName(typeName);
        if (targetType != null) {
            int tarStereo;
            int srcStereo = srcType.getConstraints() == null ? -1 : srcType.getConstraints().getStereoType();
            int n = tarStereo = targetType.getConstraints() == null ? -1 : targetType.getConstraints().getStereoType();
            if (srcStereo != tarStereo) {
                ClientLogger.LOG.info(String.format("Incompatible stereotypes of Tier Type: \"%s\", cannot update the stereotype", typeName));
                if (report != null) {
                    report.append(String.format("Incompatible stereotypes of Tier Type: \"%s\", cannot update the stereotype", typeName));
                }
            }
            if (srcType.isUsingControlledVocabulary()) {
                if (!srcType.getControlledVocabularyName().equals(targetType.getControlledVocabularyName())) {
                    if (targetTrans.getControlledVocabulary(srcType.getControlledVocabularyName()) != null) {
                        targetType.setControlledVocabularyName(srcType.getControlledVocabularyName());
                        changed = true;
                        if (report != null) {
                            report.append(String.format("Changed the CV of Type \"%s\" to: \"%s\"", typeName, srcType.getControlledVocabularyName()));
                        }
                    } else if (report != null) {
                        report.append(String.format("Cannot change the CV of Type \"%s\" to: \"%s\"; the CV does not exist in target", typeName, srcType.getControlledVocabularyName()));
                    }
                }
            } else if (targetType.isUsingControlledVocabulary()) {
                String oldCV = targetType.getControlledVocabularyName();
                targetType.setControlledVocabularyName(null);
                changed = true;
                if (report != null) {
                    report.append(String.format("Removed the CV from Type \"%s\" (was: \"%s\")", typeName, oldCV));
                }
            }
            if (srcType.getDataCategory() != null) {
                if (!srcType.getDataCategory().equals(targetType.getDataCategory())) {
                    targetType.setDataCategory(srcType.getDataCategory());
                    changed = true;
                    if (report != null) {
                        report.append(String.format("Changed the Data Category of Type \"%s\" to: \"%s\"", typeName, srcType.getDataCategory()));
                    }
                }
            } else if (targetType.getDataCategory() != null) {
                String oldDC = targetType.getDataCategory();
                targetType.setDataCategory(null);
                changed = true;
                if (report != null) {
                    report.append(String.format("Removed the Data Category of Type \"%s\" (was: \"%s\")", typeName, oldDC));
                }
            }
            if (srcType.getLexiconQueryBundle() != null) {
                LexiconQueryBundle2 srcBundle = srcType.getLexiconQueryBundle();
                if (targetType.getLexiconQueryBundle() == null) {
                    targetType.setLexiconQueryBundle(new LexiconQueryBundle2(srcBundle));
                    changed = true;
                    if (report != null) {
                        report.append(String.format("Added a Lexicon Link to Type \"%s\": \"%s\"", typeName, srcBundle.getLinkName()));
                    }
                } else {
                    boolean bundleChange = false;
                    boolean copySrcLEFI = false;
                    boolean copySrcLL = false;
                    LexiconQueryBundle2 targetBundle = targetType.getLexiconQueryBundle();
                    LexicalEntryFieldIdentification srcLefi = srcBundle.getFldId();
                    LexicalEntryFieldIdentification tarLefi = targetBundle.getFldId();
                    if (srcLefi != null) {
                        if (tarLefi != null) {
                            if (srcLefi.getId() != null && !srcLefi.getId().equals(tarLefi.getId())) {
                                tarLefi.setId(srcLefi.getId());
                                bundleChange = true;
                            }
                            if (srcLefi.getName() != null && !srcLefi.getName().equals(tarLefi.getName())) {
                                tarLefi.setName(srcLefi.getName());
                                bundleChange = true;
                            }
                            if (srcLefi.getDescription() == null && tarLefi.getDescription() != null || srcLefi.getDescription() != null && !srcLefi.getDescription().equals(tarLefi.getDescription())) {
                                tarLefi.setDescription(srcLefi.getDescription());
                                bundleChange = true;
                            }
                        } else {
                            copySrcLEFI = true;
                        }
                    } else if (tarLefi != null) {
                        copySrcLEFI = true;
                    }
                    LexiconLink srcLL = srcBundle.getLink();
                    LexiconLink tarLL = targetBundle.getLink();
                    if (srcLL != null) {
                        if (tarLL != null) {
                            LexiconIdentification srcLI = srcLL.getLexId();
                            LexiconIdentification tarLI = tarLL.getLexId();
                            if (srcLI != null && tarLI != null) {
                                if (srcLI.getId() != null && !srcLI.getId().equals(tarLI.getId())) {
                                    tarLI.setId(srcLI.getId());
                                    bundleChange = true;
                                }
                                if (srcLI.getName() != null && !srcLI.getName().equals(tarLI.getName())) {
                                    tarLI.setName(srcLI.getName());
                                    bundleChange = true;
                                }
                                if (srcLI.getDescription() == null && tarLI.getDescription() != null || srcLI.getDescription() != null && !srcLI.getDescription().equals(tarLI.getDescription())) {
                                    tarLI.setDescription(srcLI.getDescription());
                                    bundleChange = true;
                                }
                            }
                            if (srcLL.getName() != null && !srcLL.getName().equals(tarLL.getName())) {
                                tarLL.setName(srcLL.getName());
                                bundleChange = true;
                            }
                            if (srcLL.getUrl() != null && !srcLL.getUrl().equals(tarLL.getUrl())) {
                                tarLL.setUrl(srcLL.getUrl());
                                bundleChange = true;
                            }
                        } else {
                            copySrcLL = true;
                        }
                    } else if (tarLL != null) {
                        copySrcLL = true;
                    }
                    if (copySrcLEFI || copySrcLL) {
                        LexicalEntryFieldIdentification nextLefi = null;
                        LexiconLink nextLL = null;
                        if (copySrcLEFI && srcLefi != null) {
                            nextLefi = new LexicalEntryFieldIdentification(srcLefi.getId(), srcLefi.getName());
                            nextLefi.setDescription(srcLefi.getDescription());
                        }
                        if (copySrcLL && srcLL != null) {
                            nextLL = new LexiconLink(srcLL.getName(), srcLL.getLexSrvcClntType(), srcLL.getUrl(), null, srcLL.getLexId() == null ? null : new LexiconIdentification(srcLL.getLexId()));
                        }
                        LexiconQueryBundle2 nextBundle = new LexiconQueryBundle2(nextLL, nextLefi);
                        targetType.setLexiconQueryBundle(nextBundle);
                        bundleChange = true;
                    }
                    if (bundleChange) {
                        changed = true;
                        if (report != null) {
                            report.append(String.format("Changed the Lexicon Link of Type \"%s\"", typeName));
                        }
                    }
                }
            } else if (targetType.getLexiconQueryBundle() != null) {
                String oldName = targetType.getLexiconQueryBundle().getLinkName();
                targetType.setLexiconQueryBundle(null);
                changed = true;
                if (report != null) {
                    report.append(String.format("Removed the Lexicon Link of Type \"%s\" (was: \"%s\")", typeName, oldName));
                }
            }
        } else {
            LinguisticType nextLt = new LinguisticType(typeName, srcType);
            targetTrans.addLinguisticType(nextLt);
            changed = true;
            if (report != null) {
                report.append(String.format("Added Type \"%s\" to target", typeName));
            }
        }
        if (changed) {
            targetTrans.setChanged();
        }
    }

    public void updateTier(TranscriptionImpl srcTrans, TranscriptionImpl targetTrans, String tierName, ProcessReport report) {
        if (srcTrans == null) {
            ClientLogger.LOG.warning("The source Transcription is null");
            return;
        }
        if (targetTrans == null) {
            ClientLogger.LOG.warning("The target Transcription is null");
            return;
        }
        TierImpl srcTier = srcTrans.getTierWithId(tierName);
        if (srcTier == null) {
            ClientLogger.LOG.info("The source transcription does not contain a Tier with name: " + tierName);
            return;
        }
        TierImpl targetTier = targetTrans.getTierWithId(tierName);
        if (targetTier == null) {
            ClientLogger.LOG.info("The target transcription does not contain a Tier with name: " + tierName);
            return;
        }
        TierImpl srcParTier = srcTier.getParentTier();
        TierImpl tarParTier = targetTier.getParentTier();
        if ((srcParTier == null && tarParTier != null || srcParTier != null && (tarParTier == null || !srcParTier.getName().equals(tarParTier.getName()))) && report != null) {
            report.append(String.format("Incompatible Tier hierarchy of source (parent = \"%s\") and target (parent = \"%s\"), cannot update", srcParTier == null ? "none" : srcParTier.getName(), tarParTier == null ? "none" : tarParTier.getName()));
        }
        LinguisticType srcType = srcTier.getLinguisticType();
        LinguisticType tarType = targetTier.getLinguisticType();
        if (!srcType.getLinguisticTypeName().equals(tarType.getLinguisticTypeName())) {
            if (this.constraintsCompatible(srcType.getConstraints(), tarType.getConstraints())) {
                LinguisticType nextType = targetTrans.getLinguisticTypeByName(srcType.getLinguisticTypeName());
                if (nextType != null) {
                    targetTier.setLinguisticType(nextType);
                    if (report != null) {
                        report.append(String.format("Changed the Type of Tier \"%s\" to \"%s\"", tierName, nextType.getLinguisticTypeName()));
                    }
                } else if (report != null) {
                    report.append(String.format("Cannot change the Type of Tier \"%s\" to \"%s\", the Tier Type is not in the target", tierName, srcType.getLinguisticTypeName()));
                }
            } else if (report != null) {
                report.append(String.format("Incompatible Type of source (\"%s\") and target (\"%s\") Tier, cannot change the Type", ConstraintImpl.getStereoTypeName(srcType.getConstraints() == null ? -1 : srcType.getConstraints().getStereoType()), ConstraintImpl.getStereoTypeName(tarType.getConstraints() == null ? -1 : tarType.getConstraints().getStereoType())));
            }
        }
        if (srcTier.getParticipant() != null && !srcTier.getParticipant().equals(targetTier.getParticipant())) {
            targetTier.setParticipant(srcTier.getParticipant());
            if (report != null) {
                report.append(String.format("Changed the Participant of Tier \"%s\" to \"%s\"", tierName, srcTier.getParticipant()));
            }
        }
        if (srcTier.getAnnotator() != null && !srcTier.getAnnotator().equals(targetTier.getAnnotator())) {
            targetTier.setAnnotator(srcTier.getAnnotator());
            if (report != null) {
                report.append(String.format("Changed the Annotator of Tier \"%s\" to \"%s\"", tierName, srcTier.getAnnotator()));
            }
        }
        if (srcTier.getLangRef() != null && !srcTier.getLangRef().equals(targetTier.getLangRef())) {
            targetTier.setLangRef(srcTier.getLangRef());
            if (report != null) {
                report.append(String.format("Changed the Content Language of Tier \"%s\" to \"%s\"", tierName, srcTier.getLangRef()));
            }
        }
        if (srcTier.getDefaultLocale() != null && !srcTier.getDefaultLocale().equals(targetTier.getDefaultLocale())) {
            targetTier.setDefaultLocale(srcTier.getDefaultLocale());
            if (report != null) {
                report.append(String.format("Changed the Locale (Input Method) of Tier \"%s\" to \"%s\"", tierName, srcTier.getDefaultLocale().toString()));
            }
        } else if (srcTier.getDefaultLocale() == null && targetTier.getDefaultLocale() != null) {
            Locale oldLoc = targetTier.getDefaultLocale();
            targetTier.setDefaultLocale(null);
            if (report != null) {
                report.append(String.format("Removed the Locale (Input Method) of Tier \"%s\" (was \"%s\")", tierName, oldLoc.toString()));
            }
        }
    }

    public void updateWithNewTiers(TranscriptionImpl srcTrans, TranscriptionImpl targetTrans, List<String> newTiersNames, ProcessReport report) {
        if (srcTrans == null) {
            ClientLogger.LOG.warning("The source Transcription is null");
            return;
        }
        if (targetTrans == null) {
            ClientLogger.LOG.warning("The target Transcription is null");
            return;
        }
        if (newTiersNames == null || newTiersNames.isEmpty()) {
            ClientLogger.LOG.warning("The list of tiers to add is null or empty");
            return;
        }
        List<TierImpl> tiersToAdd = new ArrayList(newTiersNames.size());
        for (String s : newTiersNames) {
            TierImpl tta = srcTrans.getTierWithId(s);
            if (tta == null) continue;
            tiersToAdd.add(tta);
        }
        tiersToAdd = this.sortTiers(tiersToAdd);
        for (TierImpl t : tiersToAdd) {
            TierImpl tarTier = targetTrans.getTierWithId(t.getName());
            if (tarTier != null) {
                if (report == null) continue;
                report.append(String.format("Cannot add Tier \"%s\" to target, it is already there", t.getName()));
                continue;
            }
            if (t.hasParentTier()) {
                TierImpl tarParent = targetTrans.getTierWithId(t.getParentTier().getName());
                if (tarParent == null) {
                    if (report == null) continue;
                    report.append(String.format("Cannot add Tier \"%s\" to target, the target Parent Tier \"%s\" is not there", t.getName(), t.getParentTier().getName()));
                    continue;
                }
                LinguisticType type = targetTrans.getLinguisticTypeByName(t.getLinguisticType().getLinguisticTypeName());
                if (type == null) {
                    if (report == null) continue;
                    report.append(String.format("Cannot add Tier \"%s\" to target, the Tier Type \"%s\" is not there", t.getName(), t.getLinguisticType().getLinguisticTypeName()));
                    continue;
                }
                if (!this.parentChildTypeCompatible(tarParent.getLinguisticType(), type)) {
                    if (report == null) continue;
                    report.append(String.format("Cannot add Tier \"%s\" to target, the Tier Type \"%s\" is not compatible with the Type of the Parent Tier", t.getName(), type.getLinguisticTypeName()));
                    continue;
                }
                tarTier = new TierImpl(tarParent, t.getName(), t.getParticipant(), targetTrans, type);
                tarTier.setAnnotator(t.getAnnotator());
                tarTier.setDefaultLocale(t.getDefaultLocale());
                tarTier.setLangRef(t.getLangRef());
                tarTier.setExtRef(t.getExtRef());
                targetTrans.addTier(tarTier);
            } else {
                LinguisticType type = targetTrans.getLinguisticTypeByName(t.getLinguisticType().getLinguisticTypeName());
                if (type == null) {
                    if (report == null) continue;
                    report.append(String.format("Cannot add Tier \"%s\" to target, the Tier Type \"%s\"is not there", t.getName(), t.getLinguisticType().getLinguisticTypeName()));
                    continue;
                }
                if (type.hasConstraints()) {
                    if (report == null) continue;
                    report.append(String.format("Cannot add Tier \"%s\" to target, the Tier Type \"%s\" has constraints and cannot be used for a Tier without a Parent", t.getName(), type.getLinguisticTypeName()));
                    continue;
                }
                tarTier = new TierImpl(t.getName(), t.getParticipant(), targetTrans, type);
                tarTier.setAnnotator(t.getAnnotator());
                tarTier.setDefaultLocale(t.getDefaultLocale());
                tarTier.setLangRef(t.getLangRef());
                tarTier.setExtRef(t.getExtRef());
                targetTrans.addTier(tarTier);
            }
            if (report == null) continue;
            report.append(String.format("Added Tier \"%s\" to target", tarTier.getName()));
        }
    }

    public void updatePreferences(TranscriptionImpl srcTrans, TranscriptionImpl targetTrans, String ... prefKeys) {
        if (srcTrans == null) {
            ClientLogger.LOG.warning("The source Transcription is null");
            return;
        }
        if (targetTrans == null) {
            ClientLogger.LOG.warning("The target Transcription is null");
            return;
        }
        Map<String, Object> srcPrefs = Preferences.getPreferencesFor(srcTrans);
        if (srcPrefs == null || !srcPrefs.isEmpty()) {
            ClientLogger.LOG.info("There are no source preferences");
            return;
        }
        this.updatePreferences(targetTrans, srcPrefs, prefKeys);
    }

    public void updatePreferences(TranscriptionImpl targetTrans, Map<String, Object> srcPrefs, String ... prefKeys) {
        if (targetTrans == null) {
            ClientLogger.LOG.warning("The target Transcription is null");
            return;
        }
        if (srcPrefs == null || srcPrefs.isEmpty()) {
            ClientLogger.LOG.info("There are no source preferences");
            return;
        }
        Map<String, Object> targetPrefs = Preferences.getPreferencesFor(targetTrans);
        if (targetPrefs == null) {
            targetPrefs = new HashMap<String, Object>();
        }
        if (prefKeys == null) {
            targetPrefs.putAll(srcPrefs);
        } else {
            for (String s : prefKeys) {
                targetPrefs.put(s, srcPrefs.get(s));
            }
        }
        Preferences.importPreferences((Transcription)targetTrans, targetPrefs);
    }
}

