/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.multiplefiles;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;

public abstract class AbstractMFImportStep3
extends StepPane
implements ActionListener {
    protected String saveWithOriginalNames;
    protected String saveInOriginalFolder;
    protected String saveInRelativeFolder;
    protected String saveInRelativeFolderName;
    protected String saveInSameFolderName;
    protected JButton browseBtn;
    protected JRadioButton originalDirRB;
    protected JRadioButton togetherInSameDirRB;
    protected JRadioButton newDirectoryRB;
    protected JRadioButton originalFileNameRB;
    protected JRadioButton addSuffixRB;
    protected JTextField sameDirectoryTextField;
    protected JTextField localDirectoryTextField;
    protected JPanel fileNameOptionsPanel;
    protected JPanel directoryOptionsPanel;
    protected Insets insets = new Insets(2, 4, 2, 4);
    protected JScrollPane outerScrollPane;
    protected String browseDirText = ElanLocale.getString("MultiFileImport.Step3.DefaultLocalDirName");

    public AbstractMFImportStep3(MultiStepPane multiStepPane) {
        super(multiStepPane);
        this.setPreferenceStrings();
        this.initComponents();
    }

    protected abstract void setPreferenceStrings();

    @Override
    protected void initComponents() {
        this.initFileNameOptionsPanel();
        this.initDirectoryOptionsPanel();
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new GridBagLayout());
        this.outerScrollPane = new JScrollPane(outerPanel);
        this.outerScrollPane.setBorder(null);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.insets;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        outerPanel.add((Component)this.fileNameOptionsPanel, gbc);
        gbc.gridy = 1;
        outerPanel.add((Component)this.directoryOptionsPanel, gbc);
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weighty = 1.0;
        outerPanel.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.outerScrollPane, gbc);
        TextFieldHandler keyListener = new TextFieldHandler();
        this.originalDirRB.addActionListener(this);
        this.newDirectoryRB.addActionListener(this);
        this.togetherInSameDirRB.addActionListener(this);
        this.originalFileNameRB.addActionListener(this);
        this.addSuffixRB.addActionListener(this);
        this.browseBtn.addActionListener(this);
        this.localDirectoryTextField.addKeyListener(keyListener);
        this.loadPreferences();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MultiFileExportToolbox.Title.Step3Title");
    }

    @Override
    public boolean doFinish() {
        this.savePreferences();
        this.multiPane.nextStep();
        return false;
    }

    @Override
    public void enterStepForward() {
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        this.multiPane.putStepProperty("UseOriginalDir", this.originalDirRB.isSelected());
        this.multiPane.putStepProperty("NewDirectory", this.newDirectoryRB.isSelected());
        this.multiPane.putStepProperty("NewDirName", this.localDirectoryTextField.getText().trim());
        this.multiPane.putStepProperty("TogetherInSameDir", this.togetherInSameDirRB.isSelected());
        this.multiPane.putStepProperty("SameDirectoryName", this.sameDirectoryTextField.getText());
        this.multiPane.putStepProperty("UseOriginalFileName", this.originalFileNameRB.isSelected());
        this.multiPane.putStepProperty("UseOriginalFileNameWithSuffix", this.addSuffixRB.isSelected());
        return true;
    }

    public void updateButtonStates() {
        this.multiPane.setButtonEnabled(2, true);
        this.multiPane.setButtonEnabled(1, false);
        this.multiPane.setButtonEnabled(3, true);
        if (this.togetherInSameDirRB.isSelected() && this.sameDirectoryTextField.getText().equals(this.browseDirText)) {
            this.multiPane.setButtonEnabled(3, false);
            return;
        }
        if (this.newDirectoryRB.isSelected() && this.localDirectoryTextField.getText().length() <= 0) {
            this.multiPane.setButtonEnabled(3, false);
            return;
        }
    }

    protected void initFileNameOptionsPanel() {
        this.fileNameOptionsPanel = new JPanel(new GridBagLayout());
        this.fileNameOptionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportTiersDialog.Label.FileNameOptions")));
        this.originalFileNameRB = new JRadioButton(ElanLocale.getString("MultiFileExport.SaveSettingsPane.RB.OriginalFileName"), true);
        this.addSuffixRB = new JRadioButton(ElanLocale.getString("MultiFileExport.SaveSettingsPane.RB.OriginalFileNameWithSuffix"));
        ButtonGroup fileNameBtnGroup = new ButtonGroup();
        fileNameBtnGroup.add(this.originalFileNameRB);
        fileNameBtnGroup.add(this.addSuffixRB);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = this.insets;
        gbc.weightx = 1.0;
        this.fileNameOptionsPanel.add((Component)this.originalFileNameRB, gbc);
        gbc.gridy = 1;
        this.fileNameOptionsPanel.add((Component)this.addSuffixRB, gbc);
    }

    protected void initDirectoryOptionsPanel() {
        this.directoryOptionsPanel = new JPanel(new GridBagLayout());
        this.directoryOptionsPanel.setBorder(new TitledBorder(ElanLocale.getString("MultiFileExportToolbox.Label.SaveDirOptions")));
        this.originalDirRB = new JRadioButton(ElanLocale.getString("ExportTiersDialog.RadioButton.OriginalDirectory"), true);
        this.newDirectoryRB = new JRadioButton(ElanLocale.getString("ExportTiersDialog.RadioButton.NewDirectory"));
        this.togetherInSameDirRB = new JRadioButton(ElanLocale.getString("ExportTiersDialog.RadioButton.TogetherInSameDirectory"));
        ButtonGroup saveTierBtnGroup = new ButtonGroup();
        saveTierBtnGroup.add(this.originalDirRB);
        saveTierBtnGroup.add(this.togetherInSameDirRB);
        saveTierBtnGroup.add(this.newDirectoryRB);
        this.localDirectoryTextField = new JTextField(this.browseDirText);
        this.localDirectoryTextField.setEnabled(false);
        this.sameDirectoryTextField = new JTextField(ElanLocale.getString("ExportTiersDialog.TextField.DirectoryNameField"));
        this.sameDirectoryTextField.setEnabled(false);
        this.sameDirectoryTextField.setEditable(false);
        this.sameDirectoryTextField.setMinimumSize(new Dimension(194, this.sameDirectoryTextField.getMinimumSize().height));
        this.browseBtn = new JButton(ElanLocale.getString("ExportTiersDialog.Button.Browse"));
        this.browseBtn.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = this.insets;
        this.directoryOptionsPanel.add((Component)this.originalDirRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.directoryOptionsPanel.add((Component)this.newDirectoryRB, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.directoryOptionsPanel.add((Component)this.localDirectoryTextField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.directoryOptionsPanel.add((Component)this.togetherInSameDirRB, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.directoryOptionsPanel.add((Component)this.sameDirectoryTextField, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.directoryOptionsPanel.add((Component)this.browseBtn, gbc);
    }

    protected void updateButtonsAndFields() {
        this.sameDirectoryTextField.setEnabled(this.togetherInSameDirRB.isSelected());
        this.browseBtn.setEnabled(this.togetherInSameDirRB.isSelected());
        this.localDirectoryTextField.setEnabled(this.newDirectoryRB.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String directoryStr;
        Object source = ae.getSource();
        if (source == this.browseBtn && (directoryStr = this.showDirectoryChooser()) != null) {
            this.sameDirectoryTextField.setText(directoryStr);
        }
        this.updateButtonsAndFields();
        this.updateButtonStates();
    }

    protected String showDirectoryChooser() {
        FileChooser dirChooser = new FileChooser(this);
        dirChooser.createAndShowFileDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, ElanLocale.getString("Button.OK"), null, null, false, null, 1, null);
        File selectedDir = dirChooser.getSelectedFile();
        if (selectedDir != null) {
            return selectedDir.getAbsolutePath();
        }
        return null;
    }

    protected void savePreferences() {
        if (this.saveWithOriginalNames != null) {
            Preferences.set(this.saveWithOriginalNames, this.originalFileNameRB.isSelected(), null);
        }
        if (this.saveInOriginalFolder != null) {
            Preferences.set(this.saveInOriginalFolder, this.originalDirRB.isSelected(), null);
        }
        if (this.saveInRelativeFolder != null) {
            Preferences.set(this.saveInRelativeFolder, this.newDirectoryRB.isSelected(), null);
        }
        if (this.saveInRelativeFolderName != null) {
            String relFolderName = this.localDirectoryTextField.getText();
            if (!ElanLocale.getString("ExportTiersDialog.TextField.DefaultLocalDirectoryName").equals(relFolderName)) {
                Preferences.set(this.saveInRelativeFolderName, relFolderName, null);
            }
        }
        if (this.saveInSameFolderName != null) {
            String sameFolder = this.sameDirectoryTextField.getText();
            if (!ElanLocale.getString("ExportTiersDialog.TextField.DirectoryNameField").equals(sameFolder)) {
                Preferences.set(this.saveInSameFolderName, sameFolder, null);
            }
        }
    }

    protected void loadPreferences() {
        String stringPref;
        boolean origFolder;
        Boolean boolPref;
        if (this.saveWithOriginalNames != null && (boolPref = Preferences.getBool(this.saveWithOriginalNames, null)) != null) {
            this.originalFileNameRB.setSelected(boolPref);
            this.addSuffixRB.setSelected(boolPref == false);
        }
        if (this.saveInOriginalFolder != null && (boolPref = Preferences.getBool(this.saveInOriginalFolder, null)) != null && !(origFolder = boolPref.booleanValue()) && (boolPref = Preferences.getBool(this.saveInRelativeFolder, null)) != null) {
            boolean relFolder = boolPref;
            if (relFolder) {
                this.newDirectoryRB.setSelected(true);
            } else {
                this.togetherInSameDirRB.setSelected(true);
            }
        }
        if (this.saveInRelativeFolderName != null && (stringPref = Preferences.getString(this.saveInRelativeFolderName, null)) != null) {
            this.localDirectoryTextField.setText(stringPref);
        }
        if (this.saveInSameFolderName != null && (stringPref = Preferences.getString(this.saveInSameFolderName, null)) != null) {
            this.sameDirectoryTextField.setText(stringPref);
        }
        this.updateButtonsAndFields();
    }

    protected class TextFieldHandler
    implements KeyListener {
        protected TextFieldHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            AbstractMFImportStep3.this.updateButtonStates();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

