/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.multiplefiles;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.imports.multiplefiles.AbstractMFImportStep2;
import mpi.eudico.server.corpora.clomimpl.flex.FlexDecoderInfo;

public class MFFlexImportStep2
extends AbstractMFImportStep2
implements ChangeListener {
    private JCheckBox includeITCB;
    private JCheckBox includeParagrCB;
    private JCheckBox importParticipantInfoCB;
    private JComboBox unitsCombo;
    private JTextField unitTextField;
    private JRadioButton typesPerElementRB;
    private JRadioButton typesPerTypeRB;
    private JCheckBox typesPerLanguageCB;
    private final String[] elements = new String[]{"phrase", "word"};
    private FlexDecoderInfo decoderInfo = null;

    public MFFlexImportStep2(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.includeITCB = new JCheckBox(ElanLocale.getString("ImportDialog.Flex.IncludeIT"));
        this.includeITCB.setSelected(true);
        this.includeParagrCB = new JCheckBox(ElanLocale.getString("ImportDialog.Flex.IncludePara"));
        this.includeParagrCB.setSelected(true);
        this.importParticipantInfoCB = new JCheckBox(ElanLocale.getString("ImportDialog.Flex.ImportParticipantInfo"));
        this.typesPerElementRB = new JRadioButton(ElanLocale.getString("ImportDialog.Flex.LinTypeForBasicElement"), true);
        this.typesPerElementRB.addChangeListener(this);
        this.typesPerTypeRB = new JRadioButton(ElanLocale.getString("ImportDialog.Flex.LinTypeForTypes"));
        this.typesPerTypeRB.addChangeListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.typesPerElementRB);
        group.add(this.typesPerTypeRB);
        this.typesPerLanguageCB = new JCheckBox(ElanLocale.getString("ImportDialog.Flex.LinTypeForLang"));
        this.typesPerLanguageCB.setEnabled(false);
        this.unitsCombo = new JComboBox<String>(this.elements);
        this.unitsCombo.setSelectedItem("phrase");
        this.unitTextField = new JTextField("", 8);
        Insets insets = new Insets(6, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.gridwidth = 2;
        this.add((Component)this.includeITCB, gbc);
        ++gbc.gridy;
        this.add((Component)this.includeParagrCB, gbc);
        ++gbc.gridy;
        this.add((Component)this.importParticipantInfoCB, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Flex.SmallestTimeAlignable")), gbc);
        gbc.gridx = 1;
        this.add((Component)this.unitsCombo, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.add((Component)new JLabel(ElanLocale.getString("ExportTiersDialog.Tab2")), gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(2, 10, 2, 6);
        this.add((Component)this.typesPerElementRB, gbc);
        ++gbc.gridy;
        this.add((Component)this.typesPerTypeRB, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(2, 26, 2, 6);
        this.add((Component)this.typesPerLanguageCB, gbc);
        ++gbc.gridy;
        gbc.insets = insets;
        gbc.gridwidth = 1;
        this.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Flex.UnitDuration")), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.unitTextField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)new JPanel(), gbc);
        this.loadPreferences();
    }

    private void loadPreferences() {
        String stringPref;
        Boolean boolPref = Preferences.getBool("ImportFLExDialog.IncludeInterlinearText", null);
        if (boolPref != null) {
            this.includeITCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ImportFLExDialog.IncludeParagraph", null)) != null) {
            this.includeParagrCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ImportFLExDialog.ImportParticipantInfo", null)) != null) {
            this.importParticipantInfoCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("ImportFLExDialog.SmallestAlignableElement", null)) != null) {
            this.unitsCombo.setSelectedItem(stringPref);
        }
        if ((boolPref = Preferences.getBool("ImportFLExDialog.TypesPerElement", null)) != null) {
            this.typesPerElementRB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ImportFLExDialog.TypesPerType", null)) != null) {
            this.typesPerTypeRB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ImportFLExDialog.TypesPerLanguage", null)) != null) {
            this.typesPerLanguageCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("ImportFLExDialog.DurationPerPhrase", null)) != null) {
            this.unitTextField.setText(stringPref);
        }
    }

    private void savePreferences() {
        Preferences.set("ImportFLExDialog.IncludeInterlinearText", this.includeITCB.isSelected(), null);
        Preferences.set("ImportFLExDialog.IncludeParagraph", this.includeParagrCB.isSelected(), null);
        Preferences.set("ImportFLExDialog.ImportParticipantInfo", this.importParticipantInfoCB.isSelected(), null);
        Preferences.set("ImportFLExDialog.SmallestAlignableElement", this.unitsCombo.getSelectedItem(), null);
        Preferences.set("ImportFLExDialog.TypesPerElement", this.typesPerElementRB.isSelected(), null);
        Preferences.set("ImportFLExDialog.TypesPerType", this.typesPerTypeRB.isSelected(), null);
        Preferences.set("ImportFLExDialog.TypesPerLanguage", this.typesPerLanguageCB.isSelected(), null);
        Preferences.set("ImportFLExDialog.DurationPerPhrase", this.unitTextField.getText(), null);
    }

    @Override
    public boolean leaveStepForward() {
        long durationVal = -1L;
        try {
            durationVal = Long.parseLong(this.unitTextField.getText());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ImportDialog.Flex.Message.DurElement"), ElanLocale.getString("Message.Error"), 0);
            return false;
        }
        this.decoderInfo = new FlexDecoderInfo();
        this.decoderInfo.smallestWithTimeAlignment = (String)this.unitsCombo.getSelectedItem();
        this.decoderInfo.inclITElement = this.includeITCB.isSelected();
        this.decoderInfo.inclParagraphElement = this.includeParagrCB.isSelected();
        this.decoderInfo.importParticipantInfo = this.importParticipantInfoCB.isSelected();
        this.decoderInfo.perPhraseDuration = durationVal;
        if (this.typesPerTypeRB.isSelected()) {
            this.decoderInfo.createLingForNewType = this.typesPerTypeRB.isSelected();
            this.decoderInfo.createLingForNewLang = this.typesPerLanguageCB.isSelected();
        }
        this.savePreferences();
        this.multiPane.putStepProperty("FlexDecoderInfo", this.decoderInfo);
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.typesPerLanguageCB.setEnabled(this.typesPerTypeRB.isSelected());
    }
}

