/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.multiplefiles;

import java.io.File;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.imports.multiplefiles.AbstractMFImportStep4;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.flex.FlexDecoderInfo;

public class MFFlexImportStep4
extends AbstractMFImportStep4 {
    private FlexDecoderInfo decoderInfo;

    public MFFlexImportStep4(MultiStepPane multiPane) {
        super(multiPane);
    }

    @Override
    public void enterStepForward() {
        this.decoderInfo = (FlexDecoderInfo)this.multiPane.getStepProperty("FlexDecoderInfo");
        super.enterStepForward();
    }

    @Override
    protected boolean doImport(File sourceFile) {
        File impFile = sourceFile;
        if (impFile == null || !impFile.exists()) {
            ClientLogger.LOG.severe("Flex file not found :" + impFile.getAbsolutePath());
            this.report(ElanLocale.getString("MultiFileImport.Report.NoFile"));
            return false;
        }
        if (this.decoderInfo == null) {
            return false;
        }
        this.decoderInfo.setSourceFilePath(impFile.getAbsolutePath());
        try {
            this.transImpl = new TranscriptionImpl(impFile.getAbsolutePath(), this.decoderInfo);
        }
        catch (Exception e) {
            ClientLogger.LOG.warning(ElanLocale.getString("MultiFileImport.Report.ExceptionOccured : ") + e.getMessage());
            this.report(ElanLocale.getString("MultiFileImport.Report.ExceptionOccured : ") + e.getMessage());
            return false;
        }
        return true;
    }
}

