/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class AnnotatorCompareTable {
    private float defOverlapThreshold = 0.6f;
    private final String NCS = "n.c.s.";

    public TableModel getComparisonTable(TranscriptionImpl transcription, String tier1, String tier2, float overlapThreshold) {
        String value;
        int i;
        if (transcription == null || tier1 == null || tier2 == null) {
            return null;
        }
        if (overlapThreshold > 0.5f && overlapThreshold <= 1.0f) {
            this.defOverlapThreshold = overlapThreshold;
        }
        TierImpl t1 = transcription.getTierWithId(tier1);
        TierImpl t2 = transcription.getTierWithId(tier2);
        if (!t1.isTimeAlignable()) {
            throw new IllegalArgumentException("First tier is not time alignable: " + tier1);
        }
        if (!t2.isTimeAlignable()) {
            throw new IllegalArgumentException("Second tier is not time alignable: " + tier2);
        }
        ArrayList<AbstractAnnotation> annList1 = new ArrayList<AbstractAnnotation>(t1.getAnnotations());
        ArrayList<AbstractAnnotation> annList2 = new ArrayList<AbstractAnnotation>(t2.getAnnotations());
        int numAnn1 = annList1.size();
        int numAnn2 = annList2.size();
        ArrayList<String> annValues = new ArrayList<String>(20);
        AbstractAnnotation aa1 = null;
        AlignableAnnotation aa2 = null;
        for (i = 0; i < numAnn1; ++i) {
            aa1 = (AbstractAnnotation)annList1.get(i);
            value = aa1.getValue();
            if (value == null || value.length() == 0 || annValues.contains(value)) continue;
            annValues.add(value);
        }
        for (i = 0; i < numAnn2; ++i) {
            aa1 = (AbstractAnnotation)annList2.get(i);
            value = aa1.getValue();
            if (value == null || value.length() == 0 || annValues.contains(value)) continue;
            annValues.add(value);
        }
        annValues.add("n.c.s.");
        int numCols = annValues.size();
        DefaultTableModel model = new DefaultTableModel(numCols, numCols + 1);
        int[][] combiArray = new int[numCols][numCols];
        int lastInserted2 = -1;
        ArrayList<AlignableAnnotation> overlapList = new ArrayList<AlignableAnnotation>(5);
        ArrayList<AlignableAnnotation> addedList2 = new ArrayList<AlignableAnnotation>(numAnn2);
        for (int i2 = 0; i2 < numAnn1; ++i2) {
            int col;
            int col2;
            long et2;
            long bt2;
            overlapList.clear();
            aa1 = (AlignableAnnotation)annList1.get(i2);
            long bt1 = aa1.getBeginTimeBoundary();
            long et1 = aa1.getEndTimeBoundary();
            for (int j = lastInserted2 + 1; j < numAnn2; ++j) {
                aa2 = (AlignableAnnotation)annList2.get(j);
                bt2 = ((AbstractAnnotation)aa2).getBeginTimeBoundary();
                if (this.overlaps(bt1, et1, bt2, et2 = ((AbstractAnnotation)aa2).getEndTimeBoundary()) && !addedList2.contains(aa2)) {
                    overlapList.add(aa2);
                }
                if (bt2 <= et1) continue;
                lastInserted2 = j - 1 - overlapList.size();
                break;
            }
            if (overlapList.size() == 0) {
                col2 = annValues.indexOf(aa1.getValue());
                if (col2 <= -1) continue;
                int[] nArray = combiArray[numCols - 1];
                int n = col2;
                nArray[n] = nArray[n] + 1;
                continue;
            }
            if (overlapList.size() == 1) {
                aa2 = (AlignableAnnotation)overlapList.get(0);
                if (this.overlapGTThreshold(bt1, et1, ((AbstractAnnotation)aa2).getBeginTimeBoundary(), ((AbstractAnnotation)aa2).getEndTimeBoundary())) {
                    col2 = annValues.indexOf(aa1.getValue());
                    int row = annValues.indexOf(aa2.getValue());
                    if (col2 > -1 && row > -1) {
                        int[] nArray = combiArray[row];
                        int n = col2;
                        nArray[n] = nArray[n] + 1;
                    }
                    addedList2.add(aa2);
                    continue;
                }
                col2 = annValues.indexOf(aa1.getValue());
                if (col2 <= -1) continue;
                int[] nArray = combiArray[numCols - 1];
                int n = col2;
                nArray[n] = nArray[n] + 1;
                continue;
            }
            long lov = 0L;
            int indexLov = 0;
            for (int j = 0; j < overlapList.size(); ++j) {
                aa2 = (AlignableAnnotation)overlapList.get(j);
                long ov = this.calcOverlap(bt1, et1, ((AbstractAnnotation)aa2).getBeginTimeBoundary(), ((AbstractAnnotation)aa2).getEndTimeBoundary());
                if (ov <= lov) continue;
                lov = ov;
                indexLov = j;
            }
            aa2 = (AlignableAnnotation)overlapList.get(indexLov);
            bt2 = ((AbstractAnnotation)aa2).getBeginTimeBoundary();
            if (this.overlapGTThreshold(bt1, et1, bt2, et2 = ((AbstractAnnotation)aa2).getEndTimeBoundary())) {
                col = annValues.indexOf(aa1.getValue());
                int row = annValues.indexOf(aa2.getValue());
                if (col > -1 && row > -1) {
                    int[] nArray = combiArray[row];
                    int n = col;
                    nArray[n] = nArray[n] + 1;
                }
                addedList2.add(aa2);
                continue;
            }
            col = annValues.indexOf(aa1.getValue());
            if (col <= -1) continue;
            int[] nArray = combiArray[numCols - 1];
            int n = col;
            nArray[n] = nArray[n] + 1;
        }
        for (int j = 0; j < numAnn2; ++j) {
            String val;
            int row;
            aa2 = (AlignableAnnotation)annList2.get(j);
            if (addedList2.contains(aa2) || (row = annValues.indexOf(val = aa2.getValue())) <= -1) continue;
            int[] nArray = combiArray[row];
            int n = numCols - 1;
            nArray[n] = nArray[n] + 1;
        }
        ArrayList<String> headersList = new ArrayList<String>(numCols + 1);
        headersList.add("R1/R2");
        headersList.addAll(annValues);
        model.setColumnIdentifiers(headersList.toArray(new String[0]));
        for (int k = 0; k < numCols; ++k) {
            model.setValueAt(annValues.get(k), k, 0);
            for (int n = 0; n < numCols; ++n) {
                model.setValueAt(String.valueOf(combiArray[k][n]), k, n + 1);
            }
        }
        return model;
    }

    private boolean overlaps(long bt1, long et1, long bt2, long et2) {
        return bt1 < et2 && et1 > bt2;
    }

    private boolean overlapGTThreshold(long bt1, long et1, long bt2, long et2) {
        long dur1 = et1 - bt1;
        long dur2 = et2 - bt2;
        if (dur1 == 0L || dur2 == 0L) {
            return false;
        }
        if (dur1 >= dur2) {
            return (float)dur2 / (float)dur1 >= this.defOverlapThreshold;
        }
        return (float)dur1 / (float)dur2 >= this.defOverlapThreshold;
    }

    private long calcOverlap(long bt1, long et1, long bt2, long et2) {
        return Math.min(et1, et2) - Math.max(bt1, bt2);
    }

    private long calcExtent(long bt1, long et1, long bt2, long et2) {
        return Math.max(et1, et2) - Math.min(bt1, bt2);
    }
}

