/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator.multi;

import mpi.eudico.server.corpora.clom.AnnotationCore;

public class MatchCluster {
    long overlapDuration;
    long[] overlapInterval;
    int numberOfAnnos;
    AnnotationCore[] matchingAnnos;
    double sumOverlapRatios;

    public MatchCluster(int numRaters) {
        this.matchingAnnos = new AnnotationCore[numRaters];
        this.overlapInterval = new long[2];
    }

    public long[] getOverlapInterval() {
        return this.overlapInterval;
    }

    public AnnotationCore[] getAnnotationArray() {
        return this.matchingAnnos;
    }

    public double getSumOfOverlapRatios() {
        return this.sumOverlapRatios;
    }

    public long getOverallBeginTime() {
        long bt = Long.MAX_VALUE;
        for (AnnotationCore ac : this.matchingAnnos) {
            bt = ac.getBeginTimeBoundary() < bt ? ac.getBeginTimeBoundary() : bt;
        }
        return bt;
    }

    public long getOverallEndTime() {
        long et = 0L;
        for (AnnotationCore ac : this.matchingAnnos) {
            et = ac.getEndTimeBoundary() > et ? ac.getEndTimeBoundary() : et;
        }
        return et;
    }

    public String toString() {
        return String.format("Overlap duration %d, overlap interval [%d-%d], number of annotations %d, sum of overlap ratios %f", this.overlapDuration, this.overlapInterval[0], this.overlapInterval[1], this.numberOfAnnos, this.sumOverlapRatios);
    }
}

