/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.interlinear.PreviewPanelTimeAlignedInterlinear;
import mpi.eudico.client.annotator.tier.TierExportSetting;
import mpi.eudico.client.annotator.tier.TierExportTable5Columns;
import mpi.eudico.client.annotator.tier.TierExportTableModel5Columns;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.html.HTMLRendererTimeAlignedInterlinear;
import mpi.eudico.server.corpora.clomimpl.html.TAIEncoderInfo;
import mpi.eudico.server.corpora.clomimpl.html.TAITierSetting;
import mpi.eudico.util.TimeFormatter;
import nl.mpi.util.FileExtension;

public class ExportTimeAlignedInterlinear
extends ClosableDialog
implements ItemListener,
ActionListener {
    private TranscriptionImpl transcription;
    private Selection selection;
    private List<TAITierSetting> tierSettings;
    private int timeUnit;
    private int blockSpace;
    private int leftMargin;
    private int fontSize;
    private String refTier;
    private boolean selectionOnly;
    private boolean wrapWithinBlock;
    private TAIEncoderInfo encoderInfo;
    private final int DEFAULT_TIME_UNIT = 30;
    private final int DEFAULT_BLOCK_SPACE = 55;
    private final int DEFAULT_LEFT_MARGIN = 15;
    private final int DEFAULT_FONT_SIZE = 8;
    private PreviewPanelTimeAlignedInterlinear previewPanel;
    private JPanel optionsPanel;
    private JPanel tierSelectionPanel;
    private JPanel howPanel;
    private JPanel buttonPanel;
    private JTable tierTable;
    private TierExportTableModel5Columns model;
    private JButton upButton;
    private JButton downButton;
    private JLabel timeUnitLabel;
    private JTextField timeUnitTextField;
    private JLabel blockSpaceLabel;
    private JTextField blockSpaceTextField;
    private JLabel leftMarginLabel;
    private JTextField leftMarginTextField;
    private JLabel fontSizeLabel;
    private JTextField fontSizeTextField;
    private JCheckBox selectionCheckBox;
    private JCheckBox useReferenceTierCheckBox;
    private JCheckBox wrapWithinBlockCheckBox;
    private JComboBox<String> refTierComboBox;
    private JCheckBox showTimeLineCheckBox;
    private JComboBox<String> timeFormatComboBox;
    private JCheckBox showAnnotationBoundsCheckBox;
    private JCheckBox alignLeftCheckBox;
    private String tcStyleHhMmSsMs;
    private String tcStyleSsMs;
    private String tcStyleMs;
    private JButton applyChangesButton;
    private JButton printButton;
    private JButton restoreDefaultsButton;
    private JButton closeButton;
    private final String PRINT_COLUMN = "Export";
    private final String TIER_NAME_COLUMN = "Tier";
    private final String UNDERLINED_COLUMN = "Underlined";
    private final String BOLD_COLUMN = "Bold";
    private final String ITALIC_COLUMN = "Italic";

    public ExportTimeAlignedInterlinear(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        super(parent, modal);
        this.transcription = transcription;
        this.selection = selection;
        this.encoderInfo = new TAIEncoderInfo();
        this.initComponents();
        this.extractTiers();
        this.updateLocale();
        this.setDefaultValues();
        this.loadPreferences();
        this.doApplyChanges();
        this.postInit();
    }

    protected void initComponents() {
        this.optionsPanel = new JPanel();
        this.tierSelectionPanel = new JPanel();
        this.howPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.previewPanel = new PreviewPanelTimeAlignedInterlinear();
        this.timeUnitLabel = new JLabel();
        this.timeUnitTextField = new JTextField(4);
        this.blockSpaceLabel = new JLabel();
        this.blockSpaceTextField = new JTextField(4);
        this.leftMarginLabel = new JLabel();
        this.leftMarginTextField = new JTextField(4);
        this.fontSizeLabel = new JLabel();
        this.fontSizeTextField = new JTextField(4);
        this.selectionCheckBox = new JCheckBox();
        this.useReferenceTierCheckBox = new JCheckBox();
        this.useReferenceTierCheckBox.addItemListener(this);
        this.wrapWithinBlockCheckBox = new JCheckBox();
        this.refTierComboBox = new JComboBox();
        this.showTimeLineCheckBox = new JCheckBox();
        this.showTimeLineCheckBox.addItemListener(this);
        this.showAnnotationBoundsCheckBox = new JCheckBox();
        this.timeFormatComboBox = new JComboBox();
        this.alignLeftCheckBox = new JCheckBox();
        this.applyChangesButton = new JButton();
        this.printButton = new JButton();
        this.restoreDefaultsButton = new JButton();
        this.closeButton = new JButton();
        if (this.useReferenceTierCheckBox.isSelected()) {
            this.wrapWithinBlockCheckBox.setEnabled(true);
            this.refTierComboBox.setEnabled(true);
        } else {
            this.wrapWithinBlockCheckBox.setEnabled(false);
            this.refTierComboBox.setEnabled(false);
        }
        try {
            ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
            ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
            this.upButton.setIcon(upIcon);
            this.downButton.setIcon(downIcon);
        }
        catch (Exception ex) {
            this.upButton.setText("Up");
            this.downButton.setText("Down");
        }
        this.model = new TierExportTableModel5Columns();
        this.model.setColumnIdentifiers(new String[]{"Export", "Tier", "Underlined", "Bold", "Italic"});
        this.tierTable = new TierExportTable5Columns((DefaultTableModel)this.model, true);
        Dimension tableDim = new Dimension(50, 100);
        this.tierTable.getColumn("Export").setMaxWidth(70);
        this.tierTable.getColumn("Export").setPreferredWidth(50);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        tierScrollPane.setPreferredSize(tableDim);
        this.getContentPane().setLayout(new GridBagLayout());
        this.optionsPanel.setLayout(new GridBagLayout());
        this.tierSelectionPanel.setLayout(new GridBagLayout());
        this.howPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 2;
        this.getContentPane().add((Component)this.previewPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.tierSelectionPanel.add((Component)tierScrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.tierSelectionPanel.add((Component)this.upButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.tierSelectionPanel.add((Component)this.downButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.optionsPanel.add((Component)this.tierSelectionPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.howPanel.add((Component)this.timeUnitLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.howPanel.add((Component)this.timeUnitTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.howPanel.add((Component)this.blockSpaceLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.howPanel.add((Component)this.blockSpaceTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.howPanel.add((Component)this.leftMarginLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.howPanel.add((Component)this.leftMarginTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.howPanel.add((Component)this.fontSizeLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.howPanel.add((Component)this.fontSizeTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(20, 2, 2, 2);
        gbc.anchor = 18;
        gbc.fill = 2;
        this.howPanel.add((Component)this.selectionCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.howPanel.add((Component)this.useReferenceTierCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.howPanel.add(this.refTierComboBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(2, 15, 2, 2);
        gbc.anchor = 18;
        gbc.fill = 2;
        this.howPanel.add((Component)this.wrapWithinBlockCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.howPanel.add((Component)this.alignLeftCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.howPanel.add((Component)this.showAnnotationBoundsCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.howPanel.add((Component)this.showTimeLineCheckBox, gbc);
        gbc.gridx = 1;
        this.howPanel.add(this.timeFormatComboBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.optionsPanel.add((Component)this.howPanel, gbc);
        JScrollPane optionsScroll = new JScrollPane(this.optionsPanel);
        optionsScroll.setBorder(null);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.buttonPanel.add((Component)this.applyChangesButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.buttonPanel.add((Component)this.printButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.buttonPanel.add((Component)this.restoreDefaultsButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.buttonPanel.add((Component)this.closeButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 0.05;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)optionsScroll, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.applyChangesButton.addActionListener(this);
        this.restoreDefaultsButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.printButton.addActionListener(this);
    }

    protected void extractTiers() {
        if (this.model != null) {
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                List<TierImpl> tiers = this.transcription.getTiers();
                for (TierImpl t : tiers) {
                    String tierName = t.getName();
                    this.model.addRow(true, tierName, false, false, false);
                }
            }
            if (this.model.getRowCount() > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
        this.tierSettings = this.convertSettings(this.model.getSelectedTiersWithSettings());
    }

    protected void updateLocale() {
        this.setTitle(ElanLocale.getString("InterlinearizerOptionsDlg.Title"));
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("InterlinearizerOptionsDlg.Tiers")));
        this.howPanel.setBorder(new TitledBorder(ElanLocale.getString("InterlinearizerOptionsDlg.How")));
        this.timeUnitLabel.setText(ElanLocale.getString("ExportTimeAlignedInterlinear.Label.TimeUnit"));
        this.blockSpaceLabel.setText(ElanLocale.getString("ExportTimeAlignedInterlinear.Label.BlockSpace"));
        this.wrapWithinBlockCheckBox.setText(ElanLocale.getString("ExportTimeAlignedInterlinear.CheckBox.WrapWithinBlock"));
        this.leftMarginLabel.setText(ElanLocale.getString("ExportTimeAlignedInterlinear.Label.LeftMargin"));
        this.fontSizeLabel.setText(ElanLocale.getString("ExportTimeAlignedInterlinear.Label.FontSize"));
        this.selectionCheckBox.setText(ElanLocale.getString("ExportTimeAlignedInterlinear.CheckBox.Selection"));
        this.useReferenceTierCheckBox.setText(ElanLocale.getString("ExportTimeAlignedInterlinear.CheckBox.UseReferenceTier"));
        this.showTimeLineCheckBox.setText(ElanLocale.getString("ExportTimeAlignedInterlinear.CheckBox.ShowTimeline"));
        this.showAnnotationBoundsCheckBox.setText(ElanLocale.getString("ExportTimeAlignedInterlinear.CheckBox.ShowBounds"));
        this.alignLeftCheckBox.setText(ElanLocale.getString("ExportTimeAlignedInterlinear.CheckBox.TextAlignment"));
        this.tcStyleHhMmSsMs = ElanLocale.getString("TimeCodeFormat.TimeCode");
        this.tcStyleSsMs = ElanLocale.getString("TimeCodeFormat.Seconds");
        this.tcStyleMs = ElanLocale.getString("TimeCodeFormat.MilliSec");
        this.timeFormatComboBox.removeAllItems();
        this.timeFormatComboBox.addItem(this.tcStyleHhMmSsMs);
        this.timeFormatComboBox.addItem(this.tcStyleSsMs);
        this.timeFormatComboBox.addItem(this.tcStyleMs);
        for (TAITierSetting ts : this.tierSettings) {
            this.refTierComboBox.addItem(ts.getTierName());
        }
        this.printButton.setText(ElanLocale.getString("Menu.File.SaveAs"));
        this.applyChangesButton.setText(ElanLocale.getString("InterlinearizerOptionsDlg.ApplyChanges"));
        this.restoreDefaultsButton.setText(ElanLocale.getString("ExportTimeAlignedInterlinear.Button.RestoreDefaults"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
    }

    protected void setDefaultValues() {
        this.refTierComboBox.setSelectedIndex(0);
        this.timeUnitTextField.setText(Integer.toString(30));
        this.blockSpaceTextField.setText(Integer.toString(55));
        this.leftMarginTextField.setText(Integer.toString(15));
        this.fontSizeTextField.setText(Integer.toString(8));
        this.wrapWithinBlockCheckBox.setSelected(true);
        this.selectionCheckBox.setSelected(false);
        this.selectionCheckBox.setEnabled(this.selection != null && this.selection.getBeginTime() != this.selection.getEndTime());
        this.useReferenceTierCheckBox.setSelected(false);
        this.showTimeLineCheckBox.setSelected(false);
        this.showAnnotationBoundsCheckBox.setSelected(false);
        this.alignLeftCheckBox.setSelected(false);
        this.timeFormatComboBox.setSelectedIndex(0);
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.model.setValueAt(true, i, 0);
            this.model.setValueAt(true, i, 2);
            this.model.setValueAt(false, i, 3);
            this.model.setValueAt(false, i, 4);
        }
    }

    private void doApplyChanges() {
        this.tierSettings = this.convertSettings(this.model.getSelectedTiersWithSettings());
        this.selectionOnly = this.selectionCheckBox.isSelected() && this.selectionCheckBox.isEnabled();
        this.wrapWithinBlock = this.wrapWithinBlockCheckBox.isSelected();
        this.refTier = (String)this.refTierComboBox.getSelectedItem();
        TAITierSetting ts = this.getTierSettingById(this.refTier);
        if (!this.useReferenceTierCheckBox.isSelected()) {
            this.setReference(null);
            this.refTier = null;
        } else if (ts != null) {
            TierImpl t = this.transcription.getTierWithId(this.refTier);
            if (t == null || t.getAnnotations().isEmpty()) {
                JOptionPane.showMessageDialog(null, ElanLocale.getString("ExportTimeAlignedInterlinear.Message.NoRefAnns"), ElanLocale.getString("Message.Warning"), 2);
            }
            this.setReference(this.refTier);
        } else {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTimeAlignedInterlinear.Message.WrongTier"), ElanLocale.getString("Message.Warning"), 2);
            String defaultTier = this.tierSettings.get(0).getTierName();
            this.setReference(defaultTier);
            this.refTierComboBox.setSelectedItem(defaultTier);
            this.refTier = defaultTier;
        }
        try {
            this.timeUnit = Integer.parseUnsignedInt(this.timeUnitTextField.getText());
        }
        catch (NumberFormatException e) {
            this.timeUnitTextField.setText(Integer.toString(30));
            this.timeUnit = 30;
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTimeAlignedInterlinear.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
            this.timeUnitTextField.requestFocus();
            return;
        }
        try {
            this.blockSpace = Integer.parseUnsignedInt(this.blockSpaceTextField.getText());
        }
        catch (NumberFormatException e) {
            this.blockSpaceTextField.setText(Integer.toString(55));
            this.blockSpace = 55;
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTimeAlignedInterlinear.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
            this.blockSpaceTextField.requestFocus();
            return;
        }
        try {
            this.leftMargin = Integer.parseUnsignedInt(this.leftMarginTextField.getText());
        }
        catch (NumberFormatException e) {
            this.leftMarginTextField.setText(Integer.toString(15));
            this.leftMargin = 15;
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTimeAlignedInterlinear.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
            this.leftMarginTextField.requestFocus();
            return;
        }
        try {
            this.fontSize = Integer.parseUnsignedInt(this.fontSizeTextField.getText());
        }
        catch (NumberFormatException e) {
            this.fontSizeTextField.setText(Integer.toString(8));
            this.fontSize = 15;
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTimeAlignedInterlinear.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
            this.fontSizeTextField.requestFocus();
            return;
        }
        this.encoderInfo.setTimeUnit(this.timeUnit);
        this.encoderInfo.setBlockSpace(this.blockSpace);
        this.encoderInfo.setLeftMargin(this.leftMargin);
        this.encoderInfo.setFontSize(this.fontSize);
        this.encoderInfo.setTierSettings(this.tierSettings);
        if (this.selectionOnly) {
            this.encoderInfo.setBeginTime(this.selection.getBeginTime());
            this.encoderInfo.setEndTime(this.selection.getEndTime());
        } else {
            this.encoderInfo.setBeginTime(0L);
            this.encoderInfo.setEndTime(Long.MAX_VALUE);
        }
        this.encoderInfo.setWrapWithinBlock(this.wrapWithinBlock);
        this.encoderInfo.setShowAnnotationBoundaries(this.showAnnotationBoundsCheckBox.isSelected());
        this.encoderInfo.setTextAlignment(this.alignLeftCheckBox.isSelected() ? 2 : 4);
        this.encoderInfo.setShowTimeLine(this.showTimeLineCheckBox.isSelected());
        if (this.showTimeLineCheckBox.isSelected()) {
            if (this.timeFormatComboBox.getSelectedIndex() == 0) {
                this.encoderInfo.setTimeFormat(TimeFormatter.TIME_FORMAT.HHMMSSMS);
            } else if (this.timeFormatComboBox.getSelectedIndex() == 1) {
                this.encoderInfo.setTimeFormat(TimeFormatter.TIME_FORMAT.SSMS);
            } else if (this.timeFormatComboBox.getSelectedIndex() == 2) {
                this.encoderInfo.setTimeFormat(TimeFormatter.TIME_FORMAT.MS);
            }
        }
        this.encoderInfo.setRefTierName(this.refTier);
        HTMLRendererTimeAlignedInterlinear render = new HTMLRendererTimeAlignedInterlinear(this.transcription, this.encoderInfo);
        this.previewPanel.setHtmlText(render.renderToText());
        this.previewPanel.updateView();
    }

    protected void postInit() {
        GraphicsConfiguration gc;
        this.pack();
        int w = 550;
        int h = 400;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        Container parent = this.getParent();
        if (parent != null && (gc = parent.getGraphicsConfiguration()) != null) {
            Rectangle rect = gc.getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            w = this.getSize().width;
            h = this.getSize().height;
            int nw = rect.width - insets.left - insets.right;
            int nh = rect.height - insets.left - insets.right;
            if (w > nw || h > nh) {
                this.setSize(w > nw ? nw : w, h > nh ? nh : h);
            }
        }
        this.setLocationRelativeTo(parent);
    }

    protected void startExport() {
        this.doApplyChanges();
        this.savePreferences();
        this.doSaveHTML(this.tierSettings);
    }

    private void doSaveHTML(List<TAITierSetting> tierSettings) {
        String fileName = this.promptForHTMLFileName();
        if (fileName != null) {
            try {
                File exportFile = new File(fileName);
                this.validateTierSettings();
                if (this.encoderInfo == null) {
                    this.doApplyChanges();
                }
                this.encoderInfo.setTierSettings(tierSettings);
                HTMLRendererTimeAlignedInterlinear render = new HTMLRendererTimeAlignedInterlinear(this.transcription, this.encoderInfo);
                render.renderToFile(exportFile);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("InterlinearizerOptionsDlg.Error.TextOut") + " \n(" + e.getMessage() + ")", ElanLocale.getString("Message.Error"), 2);
            }
        }
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private void loadPreferences() {
        Object objPref;
        Integer intPref;
        String stringPref;
        Boolean boolPref = Preferences.getBool("ExportTimeAlignedInterlinear.selection", null);
        if (boolPref != null) {
            this.selectionCheckBox.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTimeAlignedInterlinear.useReferenceTier", null)) != null) {
            this.useReferenceTierCheckBox.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTimeAlignedInterlinear.wrapWithinBlock", null)) != null) {
            this.wrapWithinBlockCheckBox.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTimeAlignedInterlinear.showTimeLine", null)) != null) {
            this.showTimeLineCheckBox.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("ExportTimeAlignedInterlinear.timeFormat", null)) != null) {
            if (TimeFormatter.TIME_FORMAT.SSMS.toString().equals(stringPref)) {
                this.timeFormatComboBox.setSelectedIndex(1);
            } else if (TimeFormatter.TIME_FORMAT.MS.toString().equals(stringPref)) {
                this.timeFormatComboBox.setSelectedIndex(0);
            }
        }
        if ((boolPref = Preferences.getBool("ExportTimeAlignedInterlinear.alignLeft", null)) != null) {
            this.alignLeftCheckBox.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("ExportTimeAlignedInterlinear.showAnnotationBounds", null)) != null) {
            this.showAnnotationBoundsCheckBox.setSelected(boolPref);
        }
        if ((intPref = Preferences.getInt("ExportTimeAlignedInterlinear.timeUnit", null)) != null) {
            this.timeUnitTextField.setText(String.valueOf(intPref));
        }
        if ((intPref = Preferences.getInt("ExportTimeAlignedInterlinear.blockSpace", null)) != null) {
            this.blockSpaceTextField.setText(String.valueOf(intPref));
        }
        if ((intPref = Preferences.getInt("ExportTimeAlignedInterlinear.leftMargin", null)) != null) {
            this.leftMarginTextField.setText(String.valueOf(intPref));
        }
        if ((intPref = Preferences.getInt("ExportTimeAlignedInterlinear.fontSize", null)) != null) {
            this.fontSizeTextField.setText(String.valueOf(intPref));
        }
        if ((objPref = Preferences.get("ExportTimeAlignedInterlinear.refTier", null)) != null) {
            this.refTierComboBox.setSelectedItem(objPref);
        }
        if ((objPref = Preferences.get("ExportTimeAlignedInterlinear.tierSettings", this.transcription)) != null) {
            Map modelMap = (Map)objPref;
            List tierOrder = (List)modelMap.get("TierOrder");
            if (tierOrder != null) {
                block0: for (String tName : tierOrder) {
                    List tierSet = (List)modelMap.get(tName);
                    int index = tierOrder.indexOf(tName);
                    for (int i = 0; i < this.model.getRowCount(); ++i) {
                        if (!tName.equals(this.model.getValueAt(i, 1))) continue;
                        this.model.setValueAt(tierSet.contains("check"), i, 0);
                        this.model.setValueAt(tierSet.contains("ul"), i, 2);
                        this.model.setValueAt(tierSet.contains("b"), i, 3);
                        this.model.setValueAt(tierSet.contains("i"), i, 4);
                        if (i <= index) continue block0;
                        this.model.moveRow(i, i, index);
                        continue block0;
                    }
                }
            }
            this.tierSettings = this.convertSettings(this.model.getSelectedTiersWithSettings());
        }
    }

    private void savePreferences() {
        Preferences.set("ExportTimeAlignedInterlinear.selection", this.selectionCheckBox.isSelected(), null, false, false);
        Preferences.set("ExportTimeAlignedInterlinear.useReferenceTier", this.useReferenceTierCheckBox.isSelected(), null, false, false);
        Preferences.set("ExportTimeAlignedInterlinear.wrapWithinBlock", this.wrapWithinBlockCheckBox.isSelected(), null, false, false);
        Preferences.set("ExportTimeAlignedInterlinear.showTimeLine", this.showTimeLineCheckBox.isSelected(), null, false, false);
        String format = TimeFormatter.TIME_FORMAT.HHMMSSMS.toString();
        if (this.timeFormatComboBox.getSelectedIndex() == 1) {
            format = TimeFormatter.TIME_FORMAT.SSMS.toString();
        } else if (this.timeFormatComboBox.getSelectedIndex() == 2) {
            format = TimeFormatter.TIME_FORMAT.MS.toString();
        }
        Preferences.set("ExportTimeAlignedInterlinear.timeFormat", format, null, false, false);
        Preferences.set("ExportTimeAlignedInterlinear.alignLeft", this.alignLeftCheckBox.isSelected(), null, false, false);
        Preferences.set("ExportTimeAlignedInterlinear.showAnnotationBounds", this.showAnnotationBoundsCheckBox.isSelected(), null, false, false);
        Preferences.set("ExportTimeAlignedInterlinear.timeUnit", this.timeUnit, null, false, false);
        Preferences.set("ExportTimeAlignedInterlinear.blockSpace", this.blockSpace, null, false, false);
        Preferences.set("ExportTimeAlignedInterlinear.leftMargin", this.leftMargin, null, false, false);
        Preferences.set("ExportTimeAlignedInterlinear.fontSize", this.fontSize, null, false, false);
        Preferences.set("ExportTimeAlignedInterlinear.refTier", this.refTierComboBox.getSelectedItem(), null, false, false);
        if (this.model.getRowCount() > 0) {
            HashMap modelMap = new HashMap(this.model.getRowCount() + 1);
            ArrayList<String> tierOrder = new ArrayList<String>(this.model.getRowCount());
            modelMap.put("TierOrder", tierOrder);
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                tierOrder.add((String)this.model.getValueAt(i, 1));
                ArrayList<String> tsList = new ArrayList<String>(4);
                if (((Boolean)this.model.getValueAt(i, 0)).booleanValue()) {
                    tsList.add("check");
                }
                if (((Boolean)this.model.getValueAt(i, 2)).booleanValue()) {
                    tsList.add("ul");
                }
                if (((Boolean)this.model.getValueAt(i, 3)).booleanValue()) {
                    tsList.add("b");
                }
                if (((Boolean)this.model.getValueAt(i, 4)).booleanValue()) {
                    tsList.add("i");
                }
                modelMap.put((String)this.model.getValueAt(i, 1), tsList);
            }
            Preferences.set("ExportTimeAlignedInterlinear.tierSettings", modelMap, this.transcription, false, false);
        }
    }

    private void setReference(String refTier) {
        for (TAITierSetting ts : this.tierSettings) {
            if (ts.getTierName().equals(refTier)) {
                ts.setReference(true);
                continue;
            }
            ts.setReference(false);
        }
    }

    private TAITierSetting getTierSettingById(String tierName) {
        for (TAITierSetting ts : this.tierSettings) {
            if (!ts.getTierName().equals(tierName)) continue;
            return ts;
        }
        return null;
    }

    private void validateTierSettings() {
        int numberOfRefTiers = 0;
        for (TAITierSetting ts : this.tierSettings) {
            if (!ts.isReference()) continue;
            ++numberOfRefTiers;
        }
        if (numberOfRefTiers > 1) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTimeAlignedInterlinear.Message.refError"), ElanLocale.getString("Message.Warning"), 2);
            String defaultTier = this.tierSettings.get(0).getTierName();
            this.setReference(defaultTier);
            this.refTierComboBox.setSelectedItem(defaultTier);
        }
    }

    private void moveUp() {
        int[] selected;
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        for (int element : selected = this.tierTable.getSelectedRows()) {
            int row = element;
            if (row <= 0 || this.tierTable.isRowSelected(row - 1)) continue;
            this.model.moveRow(row, row, row - 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row - 1, 0, true, false);
        }
    }

    private void moveDown() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierTable.getSelectedRows();
        for (int i = selected.length - 1; i >= 0; --i) {
            int row = selected[i];
            if (row >= this.model.getRowCount() - 1 || this.tierTable.isRowSelected(row + 1)) continue;
            this.model.moveRow(row, row, row + 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row + 1, 0, true, false);
        }
    }

    private String promptForHTMLFileName() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("ExportDialog.ExportToFile"), 1, FileExtension.HTML_ONLY_EXT, "LastUsedExportDir");
        File exportFile = chooser.getSelectedFile();
        if (exportFile != null) {
            return exportFile.getAbsolutePath();
        }
        return null;
    }

    private List<TAITierSetting> convertSettings(List<TierExportSetting> settings) {
        ArrayList<TAITierSetting> tsList = new ArrayList<TAITierSetting>(settings.size());
        for (TierExportSetting tes : settings) {
            tsList.add(new TAITierSetting(tes.tierName, tes.c2, tes.c3, tes.c4));
        }
        return tsList;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.applyChangesButton) {
            this.doApplyChanges();
            this.savePreferences();
        } else if (source == this.restoreDefaultsButton) {
            this.setDefaultValues();
            this.doApplyChanges();
            this.savePreferences();
        } else if (source == this.printButton) {
            this.startExport();
        } else if (source == this.upButton) {
            this.moveUp();
        } else if (source == this.downButton) {
            this.moveDown();
        } else if (source == this.closeButton) {
            this.doApplyChanges();
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getSource();
        if (source == this.useReferenceTierCheckBox) {
            if (this.useReferenceTierCheckBox.isSelected()) {
                this.wrapWithinBlockCheckBox.setEnabled(true);
                this.refTierComboBox.setEnabled(true);
            } else {
                this.wrapWithinBlockCheckBox.setEnabled(false);
                this.refTierComboBox.setEnabled(false);
            }
        } else if (source == this.showTimeLineCheckBox) {
            this.timeFormatComboBox.setEnabled(this.showTimeLineCheckBox.isSelected());
        }
    }
}

